/*
 * Decompiled with CFR 0.152.
 */
package figtree.application;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.TreeSet;
import jebl.evolution.graphs.Node;
import jebl.evolution.io.TreeExporter;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.evolution.trees.Utils;
import jebl.util.Attributable;

public class JSONTreeExporter
implements TreeExporter {
    public static final String treeNameAttributeKey = "name";
    public static final Set<String> ATTRIBUTE_NAMES = new TreeSet<String>(Arrays.asList("location", "host", "Hx", "Nx", "posterior", "country", "region"));
    public static final String ORIGIN = "2013.34520547945";
    private final String nameRegex = "^(\\w|-)+$";
    private Set<Taxon> taxa = null;
    protected final PrintWriter writer;
    private boolean writeMetaComments;

    public JSONTreeExporter(Writer writer) {
        this(writer, true);
    }

    public JSONTreeExporter(Writer writer, boolean bl) {
        this.writeMetaComments = bl;
        this.writer = new PrintWriter(writer);
    }

    @Override
    public void exportTree(Tree tree) throws IOException {
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        arrayList.add(tree);
        this.exportTrees(arrayList);
    }

    private void writeTrees(Collection<? extends Tree> collection) throws IOException {
        Object object;
        int n = 0;
        int n2 = 0;
        this.writer.println("{");
        if (collection.size() > 1) {
            this.writer.println("\t\"trees\": [");
            ++n;
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Tree object2 : collection) {
            boolean string = object2 instanceof RootedTree;
            object = string ? (RootedTree)object2 : Utils.rootTheTree(object2);
            for (Node node : object.getNodes()) {
                for (String string2 : node.getAttributeNames()) {
                    String string3;
                    Object object3;
                    if (!ATTRIBUTE_NAMES.contains(string2) || !((object3 = node.getAttribute(string2)) instanceof String)) continue;
                    TreeSet<String> treeSet = (TreeSet<String>)linkedHashMap.get(string2);
                    if (treeSet == null) {
                        treeSet = new TreeSet<String>();
                        linkedHashMap.put(string2, treeSet);
                    }
                    if ((string3 = (String)object3).contains("+")) {
                        treeSet.add(string3.split("\\+")[0]);
                        continue;
                    }
                    treeSet.add(object3.toString());
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (collection.size() > 1) {
                this.appendIndent(stringBuilder, n);
                stringBuilder.append("\"tree\": {\n");
            }
            this.appendIndent(stringBuilder, n + 1);
            stringBuilder.append("\"root\": ");
            this.appendTree((RootedTree)object, object.getRootNode(), stringBuilder, n + 1);
            this.appendAttributes((Attributable)object, stringBuilder, n + 1);
            stringBuilder.append(collection.size() == 1 || n2 < collection.size() - 1 ? ",\n" : "\n");
            if (collection.size() > 1) {
                this.appendIndent(stringBuilder, n);
                stringBuilder.append(n2 < collection.size() - 1 ? "},\n" : "}\n");
            }
            this.writer.println(stringBuilder);
            ++n2;
        }
        if (collection.size() > 1) {
            this.writer.println("\t],");
        }
        this.writer.println("\t\"origin\":\"2013.34520547945\",");
        int n3 = 0;
        for (String string : linkedHashMap.keySet()) {
            object = (Set)linkedHashMap.get(string);
            this.writer.println("\t\"" + string + ".fullSet\": [");
            int n4 = 0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                this.writer.println("\t\t\"" + (String)string4 + "\"" + (n4 < object.size() - 1 ? "," : ""));
                ++n4;
            }
            this.writer.println("\t]" + (n3 < linkedHashMap.keySet().size() - 1 ? "," : ""));
            ++n3;
        }
        this.writer.println("}");
    }

    private void appendIndent(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('\t');
        }
    }

    @Override
    public void exportTrees(Collection<? extends Tree> collection) throws IOException {
        this.writeTrees(collection);
    }

    private StringBuilder appendTaxonName(Taxon taxon, StringBuilder stringBuilder) {
        String string = taxon.getName();
        if (string.contains("\"")) {
            string = string.replace("\"", "\\\"");
        }
        return stringBuilder.append("\"name\": \"").append(string).append("\"");
    }

    private void appendTree(RootedTree rootedTree, Node node, StringBuilder stringBuilder, int n) {
        Object object;
        stringBuilder.append("{\n");
        if (rootedTree.isExternal(node)) {
            this.appendIndent(stringBuilder, n + 1);
            this.appendTaxonName(rootedTree.getTaxon(node), stringBuilder);
        } else {
            this.appendIndent(stringBuilder, n + 1);
            stringBuilder.append("\"children\": [\n");
            object = rootedTree.getChildren(node);
            int n2 = object.size() - 1;
            for (int i = 0; i < object.size(); ++i) {
                this.appendIndent(stringBuilder, n + 2);
                this.appendTree(rootedTree, (Node)object.get(i), stringBuilder, n + 2);
                stringBuilder.append(i == n2 ? "\n" : ",\n");
            }
            this.appendIndent(stringBuilder, n + 1);
            stringBuilder.append("]");
        }
        object = rootedTree.getParent(node);
        if (object != null && rootedTree.hasLengths()) {
            stringBuilder.append(",\n");
            this.appendIndent(stringBuilder, n + 1);
            stringBuilder.append("\"length\": ").append(rootedTree.getLength(node));
        }
        stringBuilder.append(",\n");
        this.appendIndent(stringBuilder, n + 1);
        stringBuilder.append("\"height\": ").append(rootedTree.getHeight(node));
        this.appendAttributes(node, stringBuilder, n + 1);
        stringBuilder.append("\n");
        this.appendIndent(stringBuilder, n);
        stringBuilder.append("}");
    }

    public static double roundDouble(double d, int n) {
        double d2 = 1.0;
        while (n-- > 0) {
            d2 *= 10.0;
        }
        return (double)Math.round(d * d2) / d2;
    }

    private StringBuilder appendAttributes(Attributable attributable, StringBuilder stringBuilder, int n) {
        for (String string : attributable.getAttributeNames()) {
            if (string.startsWith("&") || !ATTRIBUTE_NAMES.contains(string)) continue;
            stringBuilder.append(",\n");
            this.appendIndent(stringBuilder, n);
            stringBuilder.append("\"").append(string).append("\": ");
            Object object = attributable.getAttribute(string);
            this.appendAttributeValue(object, stringBuilder);
        }
        return stringBuilder;
    }

    private StringBuilder appendAttributeValue(Object object, StringBuilder stringBuilder) {
        if (object instanceof Object[]) {
            stringBuilder.append("[");
            Object[] objectArray = (Object[])object;
            if (objectArray.length > 0) {
                this.appendAttributeValue(objectArray[0], stringBuilder);
                for (int i = 1; i < objectArray.length; ++i) {
                    stringBuilder.append(",");
                    this.appendAttributeValue(objectArray[i], stringBuilder);
                }
            }
            return stringBuilder.append("]");
        }
        if (object instanceof Color) {
            return stringBuilder.append("#").append(((Color)object).getRGB());
        }
        if (object instanceof String) {
            if (((String)object).contains("+")) {
                return stringBuilder.append("\"").append(((String)object).split("\\+")[0]).append("\"");
            }
            return stringBuilder.append("\"").append(object).append("\"");
        }
        return stringBuilder.append(object);
    }
}

