/*
 * Decompiled with CFR 0.152.
 */
package figtree.panel;

import figtree.treeviewer.painters.ScaleBarPainter;
import figtree.ui.components.RealNumberField;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScaleBarPainterController
extends AbstractController {
    private static final String SCALE_BAR_KEY = "scaleBar";
    private static final String FONT_NAME_KEY = "fontName";
    private static final String FONT_SIZE_KEY = "fontSize";
    private static final String FONT_STYLE_KEY = "fontStyle";
    private static final String NUMBER_FORMATTING_KEY = "numberFormatting";
    private static final String AUTOMATIC_SCALE_KEY = "automaticScale";
    private static final String SCALE_RANGE_KEY = "scaleRange";
    private static final String LINE_WIDTH_KEY = "lineWidth";
    private static final String SIGNIFICANT_DIGITS_KEY = "significantDigits";
    private static String DEFAULT_FONT_NAME = "sansserif";
    private static int DEFAULT_FONT_SIZE = 6;
    private static int DEFAULT_FONT_STYLE = 0;
    private static String DEFAULT_NUMBER_FORMATTING = "#.####";
    private static float DEFAULT_LINE_WIDTH = 1.0f;
    private final JCheckBox titleCheckBox;
    private final OptionsPanel optionsPanel;
    private final JCheckBox autoScaleCheck;
    private final RealNumberField scaleRangeText;
    private final JSpinner fontSizeSpinner;
    private final JSpinner digitsSpinner;
    private final JSpinner lineWeightSpinner;
    private final ScaleBarPainter scaleBarPainter;

    public ScaleBarPainterController(final ScaleBarPainter scaleBarPainter) {
        this.scaleBarPainter = scaleBarPainter;
        String string = DEFAULT_FONT_NAME;
        int n = DEFAULT_FONT_STYLE;
        int n2 = DEFAULT_FONT_SIZE;
        String string2 = DEFAULT_NUMBER_FORMATTING;
        float f = DEFAULT_LINE_WIDTH;
        scaleBarPainter.setFont(new Font(string, n, n2));
        scaleBarPainter.setNumberFormat(new DecimalFormat(string2));
        scaleBarPainter.setScaleBarStroke(new BasicStroke(f, 1, 1));
        this.optionsPanel = new OptionsPanel();
        this.titleCheckBox = new JCheckBox(this.getTitle());
        this.titleCheckBox.setSelected(scaleBarPainter.isVisible());
        this.autoScaleCheck = new JCheckBox("Automatic scale");
        this.autoScaleCheck.setSelected(true);
        this.optionsPanel.addComponent(this.autoScaleCheck, true);
        this.scaleRangeText = new RealNumberField(0.0, Double.MAX_VALUE);
        this.scaleRangeText.setValue(0.0);
        final JLabel jLabel = this.optionsPanel.addComponentWithLabel("Scale Range:", this.scaleRangeText, true);
        jLabel.setEnabled(false);
        this.scaleRangeText.setEnabled(false);
        Font font = scaleBarPainter.getFont();
        this.fontSizeSpinner = new JSpinner(new SpinnerNumberModel((double)font.getSize(), 0.01, 48.0, 1.0));
        final JLabel jLabel2 = this.optionsPanel.addComponentWithLabel("Font Size:", this.fontSizeSpinner);
        this.fontSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)ScaleBarPainterController.this.fontSizeSpinner.getValue()).floatValue();
                Font font = scaleBarPainter.getFont().deriveFont(f);
                scaleBarPainter.setFont(font);
            }
        });
        NumberFormat numberFormat = this.scaleBarPainter.getNumberFormat();
        int n3 = numberFormat.getMaximumFractionDigits();
        this.digitsSpinner = new JSpinner(new SpinnerNumberModel(n3, 2, 14, 1));
        final JLabel jLabel3 = this.optionsPanel.addComponentWithLabel("Significant Digits:", this.digitsSpinner);
        this.digitsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = (Integer)ScaleBarPainterController.this.digitsSpinner.getValue();
                NumberFormat numberFormat = scaleBarPainter.getNumberFormat();
                numberFormat.setMaximumFractionDigits(n);
                scaleBarPainter.setNumberFormat(numberFormat);
            }
        });
        this.lineWeightSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.01, 48.0, 1.0));
        this.lineWeightSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)ScaleBarPainterController.this.lineWeightSpinner.getValue()).floatValue();
                scaleBarPainter.setScaleBarStroke(new BasicStroke(f, 0, 2));
            }
        });
        final JLabel jLabel4 = this.optionsPanel.addComponentWithLabel("Line Weight:", this.lineWeightSpinner);
        boolean bl = this.titleCheckBox.isSelected();
        boolean bl2 = this.autoScaleCheck.isSelected();
        jLabel.setEnabled(bl && !bl2);
        this.scaleRangeText.setEnabled(bl && !bl2);
        jLabel2.setEnabled(bl);
        this.fontSizeSpinner.setEnabled(bl);
        jLabel3.setEnabled(bl);
        this.digitsSpinner.setEnabled(bl);
        jLabel4.setEnabled(bl);
        this.lineWeightSpinner.setEnabled(bl);
        this.titleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ScaleBarPainterController.this.titleCheckBox.isSelected();
                boolean bl2 = ScaleBarPainterController.this.autoScaleCheck.isSelected();
                ScaleBarPainterController.this.autoScaleCheck.setEnabled(bl);
                jLabel.setEnabled(bl && !bl2);
                ScaleBarPainterController.this.scaleRangeText.setEnabled(bl && !bl2);
                jLabel2.setEnabled(bl);
                ScaleBarPainterController.this.fontSizeSpinner.setEnabled(bl);
                jLabel3.setEnabled(bl);
                ScaleBarPainterController.this.digitsSpinner.setEnabled(bl);
                jLabel4.setEnabled(bl);
                ScaleBarPainterController.this.lineWeightSpinner.setEnabled(bl);
                scaleBarPainter.setVisible(bl);
            }
        });
        this.autoScaleCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ScaleBarPainterController.this.autoScaleCheck.isSelected()) {
                    scaleBarPainter.setAutomaticScale(true);
                    double d = scaleBarPainter.getScaleRange();
                    ScaleBarPainterController.this.scaleRangeText.setValue(d);
                    jLabel.setEnabled(false);
                    ScaleBarPainterController.this.scaleRangeText.setEnabled(false);
                } else {
                    jLabel.setEnabled(true);
                    ScaleBarPainterController.this.scaleRangeText.setEnabled(true);
                    scaleBarPainter.setAutomaticScale(false);
                }
            }
        });
        this.scaleRangeText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Double d = ScaleBarPainterController.this.scaleRangeText.getValue();
                if (d != null) {
                    scaleBarPainter.setScaleRange(d);
                }
            }
        });
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleCheckBox;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
        this.autoScaleCheck.setSelected(false);
        this.autoScaleCheck.setSelected(true);
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.autoScaleCheck.setSelected((Boolean)map.get("scaleBar.automaticScale"));
        this.scaleRangeText.setValue((Double)map.get("scaleBar.scaleRange"));
        this.fontSizeSpinner.setValue((Double)map.get("scaleBar.fontSize"));
        this.digitsSpinner.setValue((Integer)map.get("scaleBar.significantDigits"));
        this.lineWeightSpinner.setValue((Double)map.get("scaleBar.lineWidth"));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put("scaleBar.automaticScale", this.autoScaleCheck.isSelected());
        map.put("scaleBar.scaleRange", this.scaleRangeText.getValue());
        map.put("scaleBar.fontSize", this.fontSizeSpinner.getValue());
        map.put("scaleBar.significantDigits", this.digitsSpinner.getValue());
        map.put("scaleBar.lineWidth", this.lineWeightSpinner.getValue());
    }

    public String getTitle() {
        return "Scale Bar";
    }
}

