/*
 * Decompiled with CFR 0.152.
 */
package figtree.panel;

import figtree.treeviewer.TreePane;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.painters.Painter;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.util.Attributable;

public class SimpleLabelPainter
extends LabelPainter<Node> {
    public static final String NAMES = "Names";
    public static final String NODE_AGES = "Node ages";
    public static final String BRANCH_LENGTHS = "Branch lengths";
    private double preferredWidth;
    private double preferredHeight;
    private float yOffset;
    protected String displayAttribute;
    protected String[] attributes;
    protected TreePane treePane;
    private Decorator textDecorator = null;
    private Decorator borderDecorator = null;

    public SimpleLabelPainter(LabelPainter.PainterIntent painterIntent) {
        super(painterIntent);
        this.setupAttributes(null);
        this.displayAttribute = this.displayAttribute == null ? this.attributes[0] : "";
    }

    public void setupAttributes(Collection<? extends Tree> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (this.getIntent()) {
            case TIP: {
                arrayList.add(NAMES);
                arrayList.add(NODE_AGES);
                arrayList.add(BRANCH_LENGTHS);
                break;
            }
            case NODE: {
                arrayList.add(NODE_AGES);
                arrayList.add(BRANCH_LENGTHS);
                break;
            }
            case BRANCH: {
                arrayList.add(BRANCH_LENGTHS);
                arrayList.add(NODE_AGES);
            }
        }
        if (collection != null) {
            for (Tree tree : collection) {
                TreeSet<String> treeSet = new TreeSet<String>();
                if (this.getIntent() == LabelPainter.PainterIntent.TIP) {
                    for (Node node : tree.getExternalNodes()) {
                        treeSet.addAll(node.getAttributeNames());
                    }
                } else if (this.getIntent() == LabelPainter.PainterIntent.NODE) {
                    for (Node node : tree.getInternalNodes()) {
                        treeSet.addAll(node.getAttributeNames());
                    }
                } else {
                    for (Node node : tree.getNodes()) {
                        treeSet.addAll(node.getAttributeNames());
                    }
                }
                for (String string : treeSet) {
                    if (string.startsWith("!")) continue;
                    arrayList.add(string);
                }
            }
        }
        this.attributes = new String[arrayList.size()];
        arrayList.toArray(this.attributes);
        this.firePainterSettingsChanged();
    }

    @Override
    public void setTreePane(TreePane treePane) {
        this.treePane = treePane;
    }

    public Decorator getBorderDecorator() {
        return this.borderDecorator;
    }

    public void setBorderDecorator(Decorator decorator) {
        this.borderDecorator = decorator;
    }

    public Decorator getTextDecorator() {
        return this.textDecorator;
    }

    @Override
    public void setTextDecorator(Decorator decorator) {
        this.textDecorator = decorator;
    }

    public Set<Attributable> getAttributableItems() {
        return null;
    }

    public Tree getTree() {
        return this.treePane.getTree();
    }

    protected String getLabel(Tree tree, Node node) {
        if (this.displayAttribute.equalsIgnoreCase(NAMES)) {
            Taxon taxon = tree.getTaxon(node);
            if (taxon != null) {
                if (this.textDecorator != null) {
                    this.textDecorator.setItem(taxon);
                }
                return taxon.getName();
            }
            String string = (String)node.getAttribute("name");
            if (string != null) {
                return string;
            }
            return "unlabelled";
        }
        if (tree instanceof RootedTree) {
            RootedTree rootedTree = (RootedTree)tree;
            if (this.textDecorator != null) {
                this.textDecorator.setItem(node);
            }
            if (this.displayAttribute.equalsIgnoreCase(NODE_AGES)) {
                return this.getNumberFormat().format(rootedTree.getHeight(node));
            }
            if (this.displayAttribute.equalsIgnoreCase(BRANCH_LENGTHS)) {
                return this.getNumberFormat().format(rootedTree.getLength(node));
            }
        }
        return this.formatValue(node.getAttribute(this.displayAttribute));
    }

    private String formatValue(Object object) {
        if (object != null) {
            if (object instanceof Double) {
                return this.getNumberFormat().format(object);
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                if (objectArray.length == 0) {
                    return null;
                }
                if (objectArray.length == 1) {
                    return this.formatValue(objectArray[0]);
                }
                StringBuilder stringBuilder = new StringBuilder("[");
                stringBuilder.append(this.formatValue(objectArray[0]));
                for (int i = 1; i < objectArray.length; ++i) {
                    stringBuilder.append(",");
                    stringBuilder.append(this.formatValue(objectArray[i]));
                }
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
            return object.toString();
        }
        return null;
    }

    @Override
    public Rectangle2D calibrate(Graphics2D graphics2D, Node node) {
        RootedTree rootedTree = this.treePane.getTree();
        String string = this.getLabel(rootedTree, node);
        Font font = graphics2D.getFont();
        if (this.textDecorator != null) {
            graphics2D.setFont(this.textDecorator.getFont(this.getFont()));
        } else {
            graphics2D.setFont(this.getFont());
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.preferredHeight = fontMetrics.getHeight();
        this.preferredWidth = 0.0;
        if (string != null) {
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
            this.preferredWidth = rectangle2D.getWidth();
        }
        this.yOffset = fontMetrics.getAscent();
        graphics2D.setFont(font);
        return new Rectangle2D.Double(0.0, 0.0, this.preferredWidth, this.preferredHeight);
    }

    @Override
    public double getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public double getPreferredHeight() {
        return this.preferredHeight;
    }

    @Override
    public double getHeightBound() {
        return this.preferredHeight + (double)this.yOffset;
    }

    @Override
    public void paint(Graphics2D graphics2D, Node node, Painter.Justification justification, Rectangle2D rectangle2D) {
        RootedTree rootedTree = this.treePane.getTree();
        String string = this.getLabel(rootedTree, node);
        Font font = graphics2D.getFont();
        Paint paint = this.getBackground();
        Paint paint2 = this.getBorderPaint();
        Stroke stroke = this.getBorderStroke();
        if (this.borderDecorator != null) {
            paint = this.borderDecorator.getPaint(paint);
            paint2 = this.borderDecorator.getPaint(paint2);
            stroke = this.borderDecorator.getStroke(stroke);
        }
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(rectangle2D);
        }
        if (paint2 != null && stroke != null) {
            graphics2D.setPaint(paint2);
            graphics2D.setStroke(stroke);
            graphics2D.draw(rectangle2D);
        }
        if (this.textDecorator != null) {
            graphics2D.setPaint(this.textDecorator.getPaint(this.getForeground()));
            graphics2D.setFont(this.textDecorator.getFont(this.getFont()));
        } else {
            graphics2D.setPaint(this.getForeground());
            graphics2D.setFont(this.getFont());
        }
        if (string != null) {
            float f;
            Rectangle2D rectangle2D2 = null;
            if (justification == Painter.Justification.CENTER || justification == Painter.Justification.RIGHT) {
                rectangle2D2 = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            }
            float f2 = this.yOffset + (float)rectangle2D.getY();
            switch (justification) {
                case CENTER: {
                    f = (float)(-rectangle2D2.getWidth() / 2.0);
                    f2 = this.yOffset + (float)rectangle2D2.getY();
                    break;
                }
                case FLUSH: 
                case LEFT: {
                    f = (float)rectangle2D.getX();
                    break;
                }
                case RIGHT: {
                    f = (float)(rectangle2D.getX() + rectangle2D.getWidth() - rectangle2D2.getWidth());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized alignment enum option");
                }
            }
            graphics2D.drawString(string, f, f2);
        }
        graphics2D.setFont(font);
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    @Override
    public String getDisplayAttribute() {
        return this.displayAttribute;
    }

    @Override
    public void setDisplayAttribute(String string) {
        this.displayAttribute = string;
        this.firePainterChanged();
    }
}

