/*
 * Decompiled with CFR 0.152.
 */
package figtree.panel;

import figtree.panel.TreeLayoutController;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.treelayouts.RectilinearTreeLayout;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TreeViewerController
extends AbstractController {
    private static final String CONTROLLER_TITLE = "Layout";
    private static final String CONTROLLER_KEY = "layout";
    private static final String ZOOM_KEY = "zoom";
    private static final String EXPANSION_KEY = "expansion";
    private static final int MAX_ZOOM_SLIDER = 10000;
    private static final int DELTA_ZOOM_SLIDER = 200;
    private Action resetZoomAction = new AbstractAction("Reset Zoom"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreeViewerController.this.zoomSlider.setValue(0);
            TreeViewerController.this.verticalExpansionSlider.setValue(0);
        }
    };
    private Action increaseZoomAction = new AbstractAction("Zoom In"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreeViewerController.this.zoomSlider.setValue(TreeViewerController.this.zoomSlider.getValue() + 200);
        }
    };
    private Action decreaseZoomAction = new AbstractAction("Zoom In"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreeViewerController.this.zoomSlider.setValue(TreeViewerController.this.zoomSlider.getValue() - 200);
        }
    };
    private Action increaseVerticalExpansionAction = new AbstractAction("Expand Vertically"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreeViewerController.this.verticalExpansionSlider.setValue(TreeViewerController.this.verticalExpansionSlider.getValue() + 200);
        }
    };
    private Action decreaseVerticalExpansionAction = new AbstractAction("Unexpand Vertically"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TreeViewerController.this.verticalExpansionSlider.getValue();
            if (n > 0) {
                TreeViewerController.this.verticalExpansionSlider.setValue(n - 200);
            } else {
                TreeViewerController.this.zoomSlider.setValue(TreeViewerController.this.zoomSlider.getValue() - 200);
            }
        }
    };
    private JSlider zoomSlider;
    private JSlider verticalExpansionSlider;
    private JLabel verticalExpansionLabel;
    private final JPanel layoutPanel;
    private final JLabel titleLabel;
    private final OptionsPanel optionsPanel;
    private final RectilinearTreeLayout rectilinearTreeLayout;
    private final TreeLayoutController treeLayoutController;
    private final TreeViewer treeViewer;
    private final boolean hideZoom;

    public TreeViewerController(TreeViewer treeViewer) {
        this(treeViewer, false);
    }

    public TreeViewerController(final TreeViewer treeViewer, boolean bl) {
        this.treeViewer = treeViewer;
        this.hideZoom = bl;
        this.titleLabel = new JLabel(CONTROLLER_TITLE);
        this.optionsPanel = new OptionsPanel();
        this.rectilinearTreeLayout = new RectilinearTreeLayout();
        this.treeLayoutController = new TreeLayoutController(this.rectilinearTreeLayout);
        if (!bl) {
            this.zoomSlider = new JSlider(0, 0, 10000, 0);
            this.zoomSlider.setOpaque(false);
            this.zoomSlider.setAlignmentX(0.0f);
            this.zoomSlider.setValue(0);
            this.zoomSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    int n = TreeViewerController.this.zoomSlider.getValue();
                    treeViewer.setZoom((double)n / 10000.0);
                }
            });
            this.optionsPanel.addComponentWithLabel("Zoom:", this.zoomSlider, true);
        }
        this.verticalExpansionSlider = new JSlider(0, 0, 10000, 0);
        this.verticalExpansionSlider.setOpaque(false);
        this.verticalExpansionSlider.setValue(0);
        this.verticalExpansionSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = TreeViewerController.this.verticalExpansionSlider.getValue();
                treeViewer.setVerticalExpansion((double)n / 10000.0);
            }
        });
        this.verticalExpansionLabel = new JLabel("Expansion:");
        this.optionsPanel.addComponents(this.verticalExpansionLabel, false, this.verticalExpansionSlider, true);
        this.layoutPanel = new JPanel(new BorderLayout());
        this.layoutPanel.setOpaque(false);
        this.setTreeLayout();
        this.setExpansion();
        this.optionsPanel.addSpanningComponent(this.layoutPanel);
        this.optionsPanel.getInputMap(2).put(KeyStroke.getKeyStroke("meta 0"), "resetZoom");
        this.optionsPanel.getInputMap(2).put(KeyStroke.getKeyStroke("meta EQUALS"), "increasePrimaryZoom");
        this.optionsPanel.getInputMap(2).put(KeyStroke.getKeyStroke("meta MINUS"), "decreasePrimaryZoom");
        this.optionsPanel.getInputMap(2).put(KeyStroke.getKeyStroke("meta alt EQUALS"), "increaseSecondaryZoom");
        this.optionsPanel.getInputMap(2).put(KeyStroke.getKeyStroke("meta alt MINUS"), "decreaseSecondaryZoom");
        this.optionsPanel.getActionMap().put("resetZoom", this.resetZoomAction);
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleLabel;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return true;
    }

    public void setColouringAttributeName(String string) {
        this.rectilinearTreeLayout.setBranchColouringAttributeName(string);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        if (!this.hideZoom) {
            this.zoomSlider.setValue((Integer)map.get("layout.zoom"));
        }
        this.verticalExpansionSlider.setValue((Integer)map.get("layout.expansion"));
        this.treeLayoutController.setSettings(map);
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        if (!this.hideZoom) {
            map.put("layout.zoom", this.zoomSlider.getValue());
        }
        map.put("layout.expansion", this.verticalExpansionSlider.getValue());
        this.treeLayoutController.getSettings(map);
    }

    private void setTreeLayout() {
        this.treeViewer.setTreeLayout(this.rectilinearTreeLayout);
        this.setExpansion();
        this.layoutPanel.removeAll();
        this.layoutPanel.add((Component)this.treeLayoutController.getPanel(), "Center");
        this.fireControllerChanged();
    }

    private void setExpansion() {
        if (this.treeViewer.verticalExpansionAllowed()) {
            this.verticalExpansionLabel.setEnabled(true);
            this.verticalExpansionSlider.setEnabled(true);
            this.optionsPanel.getActionMap().put("increasePrimaryZoom", this.increaseVerticalExpansionAction);
            this.optionsPanel.getActionMap().put("decreasePrimaryZoom", this.decreaseVerticalExpansionAction);
            this.optionsPanel.getActionMap().put("increaseSecondaryZoom", this.increaseZoomAction);
            this.optionsPanel.getActionMap().put("decreaseSecondaryZoom", this.decreaseZoomAction);
        } else {
            this.verticalExpansionLabel.setEnabled(false);
            this.verticalExpansionSlider.setEnabled(false);
            this.optionsPanel.getActionMap().put("increasePrimaryZoom", this.increaseZoomAction);
            this.optionsPanel.getActionMap().put("decreasePrimaryZoom", this.decreaseZoomAction);
            this.optionsPanel.getActionMap().put("increaseSecondaryZoom", this.increaseZoomAction);
            this.optionsPanel.getActionMap().put("decreaseSecondaryZoom", this.decreaseZoomAction);
        }
    }
}

