/*
 * Decompiled with CFR 0.152.
 */
package figtree.panel;

import figtree.treeviewer.TreePane;
import figtree.treeviewer.TreeViewer;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jebl.evolution.trees.SortedRootedTree;
import jebl.evolution.trees.TransformedRootedTree;

public class TreesController
extends AbstractController {
    private static final String CONTROLLER_TITLE = "Trees";
    private static final String CONTROLLER_KEY = "trees";
    private static final String TRANSFORM_KEY = "transform";
    private static final String TRANSFORM_TYPE_KEY = "transformType";
    private static final String ORDER_KEY = "order";
    private static final String ORDER_TYPE_KEY = "orderType";
    private static final String ROOTING_KEY = "rooting";
    private static final String ROOTING_TYPE_KEY = "rootingType";
    private final JLabel titleLabel;
    private final OptionsPanel optionsPanel;
    private final JComboBox transformCombo;
    private final JComboBox orderCombo;
    private final JCheckBox rootingCheck;
    private final TreeViewer treeViewer;

    public TreesController(TreeViewer treeViewer) {
        this(treeViewer, true, true, true);
    }

    public TreesController(final TreeViewer treeViewer, boolean bl, boolean bl2, boolean bl3) {
        this.treeViewer = treeViewer;
        this.titleLabel = new JLabel(CONTROLLER_TITLE);
        this.optionsPanel = new OptionsPanel();
        if (bl) {
            this.rootingCheck = new JCheckBox("Midpoint root");
            this.rootingCheck.setOpaque(false);
            this.optionsPanel.addComponent(this.rootingCheck);
            this.rootingCheck.setSelected(treeViewer.isRootingOn());
            this.rootingCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (TreesController.this.rootingCheck.isSelected()) {
                        treeViewer.setRootingOn(true);
                        treeViewer.setRootingType(TreePane.RootingType.MID_POINT);
                    } else {
                        treeViewer.setRootingOn(false);
                        treeViewer.setRootingType(TreePane.RootingType.USER_ROOTING);
                    }
                }
            });
        } else {
            this.rootingCheck = null;
        }
        if (bl2) {
            this.orderCombo = new JComboBox<String>(new String[]{"Off", SortedRootedTree.BranchOrdering.INCREASING_NODE_DENSITY.toString(), SortedRootedTree.BranchOrdering.DECREASING_NODE_DENSITY.toString()});
            this.orderCombo.setOpaque(false);
            this.orderCombo.setSelectedItem(treeViewer.isOrderBranchesOn() ? treeViewer.getBranchOrdering().ordinal() + 1 : 0);
            this.orderCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (TreesController.this.orderCombo.getSelectedIndex() == 0) {
                        treeViewer.setOrderBranchesOn(false);
                    } else {
                        treeViewer.setOrderBranchesOn(true);
                        treeViewer.setBranchOrdering(SortedRootedTree.BranchOrdering.values()[TreesController.this.orderCombo.getSelectedIndex() - 1]);
                    }
                }
            });
            this.optionsPanel.addComponentWithLabel("Order:", this.orderCombo);
        } else {
            this.orderCombo = null;
        }
        if (bl3) {
            this.transformCombo = new JComboBox<String>(new String[]{"Off", TransformedRootedTree.Transform.CLADOGRAM.toString(), TransformedRootedTree.Transform.PROPORTIONAL.toString(), TransformedRootedTree.Transform.EQUAL_LENGTHS.toString()});
            this.transformCombo.setOpaque(false);
            this.transformCombo.setSelectedItem(treeViewer.isOrderBranchesOn() ? treeViewer.getBranchTransform().ordinal() + 1 : 0);
            this.transformCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (TreesController.this.transformCombo.getSelectedIndex() == 0) {
                        treeViewer.setTransformBranchesOn(false);
                    } else {
                        treeViewer.setTransformBranchesOn(true);
                        treeViewer.setBranchTransform(TransformedRootedTree.Transform.values()[TreesController.this.transformCombo.getSelectedIndex() - 1]);
                    }
                }
            });
            this.optionsPanel.addComponentWithLabel("Transform:", this.transformCombo);
        } else {
            this.transformCombo = null;
        }
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleLabel;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        int n;
        String string;
        if (((Boolean)map.get("trees.transform")).booleanValue()) {
            string = (String)map.get("trees.transformType");
            n = 0;
            for (TransformedRootedTree.Transform enum_ : TransformedRootedTree.Transform.values()) {
                if (enum_.toString().equalsIgnoreCase(string)) {
                    this.transformCombo.setSelectedIndex(n);
                }
                ++n;
            }
        } else {
            this.transformCombo.setSelectedIndex(0);
        }
        if (((Boolean)map.get("trees.order")).booleanValue()) {
            string = (String)map.get("trees.orderType");
            n = 0;
            for (Enum enum_ : SortedRootedTree.BranchOrdering.values()) {
                if (((SortedRootedTree.BranchOrdering)enum_).toString().equalsIgnoreCase(string)) {
                    this.orderCombo.setSelectedIndex(n);
                }
                ++n;
            }
        } else {
            this.orderCombo.setSelectedIndex(0);
        }
        this.rootingCheck.setSelected((Boolean)map.get("trees.rooting"));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put("trees.transform", false);
        map.put("trees.transformType", this.transformCombo.getSelectedItem().toString());
        map.put("trees.order", false);
        map.put("trees.orderType", this.orderCombo.getSelectedItem().toString());
        map.put("trees.rooting", this.rootingCheck.isSelected());
        map.put("trees.rootingType", TreePane.RootingType.MID_POINT.toString());
    }
}

