/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.TimeScale;
import figtree.treeviewer.TreePane;
import figtree.treeviewer.TreePaneListener;
import figtree.treeviewer.TreePaneRollOver;
import figtree.treeviewer.TreePaneSelector;
import figtree.treeviewer.TreeSelectionListener;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.TreeViewerListener;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.painters.LegendPainter;
import figtree.treeviewer.painters.NodeBarPainter;
import figtree.treeviewer.painters.NodeShapePainter;
import figtree.treeviewer.painters.ScaleGridPainter;
import figtree.treeviewer.painters.ScalePainter;
import figtree.treeviewer.treelayouts.TreeLayout;
import jam.panels.StatusProvider;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.SortedRootedTree;
import jebl.evolution.trees.TransformedRootedTree;
import jebl.evolution.trees.Tree;
import jebl.evolution.trees.Utils;

public class DefaultTreeViewer
extends TreeViewer {
    private static final double ZOOM_SCALE = 0.02;
    private static final double VERTICAL_EXPANSION_SCALE = 0.02;
    private static final double ZOOM_POWER = 1.2;
    private boolean zoomPending = false;
    private double zoom = 0.0;
    private double verticalExpansion = 0.0;
    private List<TreeViewerListener> listeners = new ArrayList<TreeViewerListener>();
    private List<Tree> trees = new ArrayList<Tree>();
    private int currentTreeIndex = 0;
    protected TreePane treePane;
    protected TreePaneSelector treePaneSelector;
    protected TreePaneRollOver treePaneRollOver;
    protected JViewport viewport;
    private final JFrame frame;

    public DefaultTreeViewer() {
        this((JFrame)null);
    }

    public DefaultTreeViewer(JFrame jFrame) {
        this.frame = jFrame;
        this.setLayout(new BorderLayout());
        this.treePane = new TreePane();
        this.treePane.setAutoscrolls(true);
        this.treePane.addTreePaneListener(new TreePaneListener(){

            @Override
            public void treePaneSettingsChanged() {
                DefaultTreeViewer.this.fireTreeSettingsChanged();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.treePane, 22, 32);
        jScrollPane.setMinimumSize(new Dimension(150, 150));
        jScrollPane.setBorder(null);
        this.viewport = jScrollPane.getViewport();
        this.add((Component)jScrollPane, "Center");
        this.treePaneSelector = new TreePaneSelector(this.treePane);
        this.treePaneRollOver = new TreePaneRollOver(this.treePane);
        this.setFocusable(true);
    }

    public void setTree(Tree tree) {
        this.trees.clear();
        this.addTree(tree);
        this.showTree(0);
    }

    @Override
    public void setTrees(Collection<? extends Tree> collection) {
        this.trees.clear();
        for (Tree tree : collection) {
            this.addTree(tree);
        }
        this.showTree(0);
    }

    public void addTree(Tree tree) {
        this.trees.add(tree);
    }

    public void addTrees(Collection<? extends Tree> collection) {
        int n = this.getTreeCount();
        for (Tree tree : collection) {
            this.addTree(tree);
        }
        this.showTree(n);
    }

    @Override
    public List<Tree> getTrees() {
        return this.trees;
    }

    @Override
    public Tree getCurrentTree() {
        return this.treePane.getTree();
    }

    public List<Tree> getTreesAsViewed() {
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        for (Tree tree : this.trees) {
            arrayList.add(this.treePane.constructTransformedTree((RootedTree)tree));
        }
        return arrayList;
    }

    public RootedTree getSelectedSubtree() {
        return this.treePane.getSelectedSubtree();
    }

    @Override
    public int getCurrentTreeIndex() {
        return this.currentTreeIndex;
    }

    @Override
    public int getTreeCount() {
        if (this.trees == null) {
            return 0;
        }
        return this.trees.size();
    }

    @Override
    public StatusProvider getStatusProvider() {
        return this.treePaneRollOver;
    }

    @Override
    public void showTree(int n) {
        if (this.isRootingOn() && this.getRootingType() == TreePane.RootingType.USER_ROOTING) {
            JOptionPane.showMessageDialog(this.frame, "Cannot switch trees when user rooting option is on.\nTurn this option off to switch trees", "Unable to switch trees", 0);
            return;
        }
        Tree tree = this.trees.get(n);
        if (tree instanceof RootedTree) {
            this.treePane.setTree((RootedTree)tree);
        } else {
            this.treePane.setTree(Utils.rootTheTree(tree));
        }
        this.currentTreeIndex = n;
        this.fireTreeChanged();
    }

    public void showNextTree() {
        if (this.currentTreeIndex < this.trees.size() - 1) {
            this.showTree(this.currentTreeIndex + 1);
        }
    }

    public void showPreviousTree() {
        if (this.currentTreeIndex > 0) {
            this.showTree(this.currentTreeIndex - 1);
        }
    }

    @Override
    public void setTreeLayout(TreeLayout treeLayout) {
        this.treePane.setTreeLayout(treeLayout);
        this.fireTreeSettingsChanged();
    }

    @Override
    public void setZoom(double d) {
        double d2 = Math.max(this.treePane.getTree().getTaxa().size(), 50);
        this.zoom = Math.pow(d * d2 * 0.02, 1.2);
        this.refreshZoom();
    }

    @Override
    public void setVerticalExpansion(double d) {
        double d2 = Math.max(this.treePane.getTree().getTaxa().size(), 50);
        this.verticalExpansion = Math.pow(d * d2 * 0.02, 1.2);
        this.refreshZoom();
    }

    @Override
    public boolean verticalExpansionAllowed() {
        return !this.treePane.maintainAspectRatio();
    }

    @Override
    public void setTimeScale(TimeScale timeScale) {
        this.treePane.setTimeScale(timeScale);
    }

    private void refreshZoom() {
        this.setZoom(this.zoom, this.zoom + this.verticalExpansion);
    }

    private void setZoom(double d, double d2) {
        Dimension dimension = this.viewport.getViewSize();
        Point point = this.viewport.getViewPosition();
        Dimension dimension2 = this.viewport.getExtentSize();
        double d3 = dimension2.getWidth() * (1.0 + d);
        double d4 = dimension2.getHeight() * (1.0 + d2);
        Dimension dimension3 = new Dimension((int)d3, (int)d4);
        this.treePane.setPreferredSize(dimension3);
        double d5 = point.getX() + 0.5 * dimension2.getWidth();
        double d6 = point.getY() + 0.5 * dimension2.getHeight();
        double d7 = dimension3.getWidth() / dimension.getWidth();
        double d8 = dimension3.getHeight() / dimension.getHeight();
        double d9 = d5 * d7 - dimension2.getWidth() / 2.0;
        double d10 = d6 * d8 - dimension2.getHeight() / 2.0;
        Point point2 = new Point((int)d9, (int)d10);
        this.viewport.setViewPosition(point2);
        this.treePane.revalidate();
    }

    @Override
    public boolean hasSelection() {
        return this.treePane.hasSelection();
    }

    @Override
    public Set<Node> getSelectedNodes() {
        return this.treePane.getSelectedNodes();
    }

    @Override
    public Set<Node> getSelectedTips() {
        return this.treePane.getSelectedTips();
    }

    public Set<Taxon> getSelectedTaxa() {
        return this.treePane.getSelectedTaxa();
    }

    public void selectTaxa(TreeViewer.TextSearchType textSearchType, String string, boolean bl) {
        String string2 = "!name";
        LabelPainter<Node> labelPainter = this.treePane.getTipLabelPainter();
        if (labelPainter != null && labelPainter.isVisible() && labelPainter.getDisplayAttribute() != null) {
            string2 = labelPainter.getDisplayAttribute();
        }
        this.selectTaxa(string2, textSearchType, string, bl);
        this.scrollToSelectedTips();
    }

    @Override
    public void selectTaxa(String string, TreeViewer.TextSearchType textSearchType, String string2, boolean bl) {
        if (this.treePane.getTree() == null) {
            return;
        }
        this.treePane.clearSelection();
        String string3 = string2;
        if (textSearchType != TreeViewer.TextSearchType.REG_EX) {
            string3 = bl ? string2 : string2.toUpperCase();
            string3 = string3.trim();
        }
        RootedTree rootedTree = this.treePane.getTree();
        block0: for (Node node : rootedTree.getExternalNodes()) {
            Object object;
            Taxon taxon = rootedTree.getTaxon(node);
            if (string == null) {
                object = taxon.getName();
                if (this.matchesItem(textSearchType, object, string3, bl)) {
                    this.treePane.addSelectedTip(node);
                    break;
                }
                for (String string4 : taxon.getAttributeNames()) {
                    object = taxon.getAttribute(string4);
                    if (!this.matchesItem(textSearchType, object, string3, bl)) continue;
                    this.treePane.addSelectedTip(node);
                    continue block0;
                }
                continue;
            }
            if (string.equals("!name")) {
                object = taxon.getName();
            } else {
                object = taxon.getAttribute(string);
                if (object == null) {
                    object = node.getAttribute(string);
                }
            }
            if (!this.matchesItem(textSearchType, object, string3, bl)) continue;
            this.treePane.addSelectedTip(node);
        }
    }

    @Override
    public void selectNodes(String string, TreeViewer.TextSearchType textSearchType, String string2, boolean bl) {
        this.treePane.clearSelection();
        String string3 = string2;
        if (textSearchType != TreeViewer.TextSearchType.REG_EX) {
            string3 = bl ? string2 : string2.toUpperCase();
            string3 = string3.trim();
        }
        RootedTree rootedTree = this.treePane.getTree();
        block0: for (Node node : rootedTree.getNodes()) {
            if (string == null) {
                for (String string4 : node.getAttributeNames()) {
                    Object object = node.getAttribute(string4);
                    if (!this.matchesItem(textSearchType, object, string3, bl)) continue;
                    this.treePane.addSelectedNode(node);
                    continue block0;
                }
                continue;
            }
            Object object = node.getAttribute(string);
            if (!this.matchesItem(textSearchType, object, string3, bl)) continue;
            this.treePane.addSelectedNode(node);
        }
    }

    private boolean matchesItem(TreeViewer.TextSearchType textSearchType, Object object, String string, boolean bl) {
        if (object != null) {
            String string2 = bl ? object.toString() : object.toString().toUpperCase();
            switch (textSearchType) {
                case CONTAINS: {
                    if (!string2.contains(string)) break;
                    return true;
                }
                case STARTS_WITH: {
                    if (!string2.startsWith(string)) break;
                    return true;
                }
                case ENDS_WITH: {
                    if (!string2.endsWith(string)) break;
                    return true;
                }
                case MATCHES: {
                    if (!string2.equals(string)) break;
                    return true;
                }
                case REG_EX: {
                    try {
                        if (string2.matches(string)) {
                            return true;
                        }
                        break;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void selectTaxa(String string, TreeViewer.NumberSearchType numberSearchType, Number number) {
        this.treePane.clearSelection();
        RootedTree rootedTree = this.treePane.getTree();
        for (Node node : rootedTree.getExternalNodes()) {
            Object object = null;
            if (string.equals("!length")) {
                object = rootedTree.getLength(node);
            } else if (string.equals("!height")) {
                object = rootedTree.getHeight(node);
            } else {
                Taxon taxon = rootedTree.getTaxon(node);
                object = taxon.getAttribute(string);
            }
            if (!this.matchesItem(object, numberSearchType, number)) continue;
            this.treePane.addSelectedTip(node);
        }
    }

    @Override
    public void selectNodes(String string, TreeViewer.NumberSearchType numberSearchType, Number number) {
        this.treePane.clearSelection();
        RootedTree rootedTree = this.treePane.getTree();
        for (Node node : rootedTree.getNodes()) {
            Object object = null;
            object = string.equals("!length") ? Double.valueOf(rootedTree.getLength(node)) : (string.equals("!height") ? Double.valueOf(rootedTree.getHeight(node)) : node.getAttribute(string));
            if (!this.matchesItem(object, numberSearchType, number)) continue;
            this.treePane.addSelectedNode(node);
        }
    }

    @Override
    public void selectTaxa(Collection<String> collection) {
        this.treePane.clearSelection();
        RootedTree rootedTree = this.treePane.getTree();
        for (Node node : rootedTree.getExternalNodes()) {
            Object var5_5 = null;
            if (!collection.contains(rootedTree.getTaxon(node).getName())) continue;
            this.treePane.addSelectedTip(node);
        }
    }

    private boolean matchesItem(Object object, TreeViewer.NumberSearchType numberSearchType, Number number) {
        if (object != null && object instanceof Number) {
            Number number2 = (Number)object;
            switch (numberSearchType) {
                case EQUALS: {
                    if (!number2.equals(number)) break;
                    return true;
                }
                case EQUALS_OR_GREATER_THAN: {
                    if (!(number2.doubleValue() >= number.doubleValue())) break;
                    return true;
                }
                case EQUALS_OR_LESS_THAN: {
                    if (!(number2.doubleValue() <= number.doubleValue())) break;
                    return true;
                }
                case GREATER_THAN: {
                    if (!(number2.doubleValue() > number.doubleValue())) break;
                    return true;
                }
                case LESS_THAN: {
                    if (!(number2.doubleValue() < number.doubleValue())) break;
                    return true;
                }
                case NOT_EQUALS: {
                    if (number.equals(number2)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public void scrollToSelectedTips() {
        Set<Node> set = this.treePane.getSelectedTips();
        if (set.size() > 0) {
            Point point = this.treePane.getLocationOfTip(set.iterator().next());
            this.treePane.scrollPointToVisible(point);
        }
    }

    public void cartoonSelectedNodes() {
        this.treePane.cartoonSelectedNodes();
        this.fireTreeSettingsChanged();
    }

    @Override
    public void collapseSelectedNodes() {
        this.treePane.collapseSelectedNodes();
        this.fireTreeSettingsChanged();
    }

    public void clearCollapsedNodes() {
        this.treePane.clearCollapsedNodes();
        this.fireTreeSettingsChanged();
    }

    public void hilightSelectedNodes(Color color) {
        this.treePane.hilightSelectedNodes(color);
        this.fireTreeSettingsChanged();
    }

    public void clearHilighting() {
        this.treePane.clearHilightedNodes();
        this.fireTreeSettingsChanged();
    }

    public void rerootOnSelectedBranch() {
        this.treePane.rerootOnSelectedBranch();
        this.fireTreeSettingsChanged();
    }

    public void clearRooting() {
        this.treePane.clearRooting();
        this.fireTreeSettingsChanged();
    }

    public void rotateSelectedNode() {
        this.treePane.rotateSelectedNode();
        this.fireTreeSettingsChanged();
    }

    public void clearRotations() {
        this.treePane.clearSelectedNodeRotations();
        this.fireTreeSettingsChanged();
    }

    @Override
    public void annotateSelectedNodes(String string, Object object) {
        this.treePane.annotateSelectedNodes(string, object);
        this.fireTreeSettingsChanged();
    }

    @Override
    public void annotateSelectedTips(String string, Object object) {
        this.treePane.annotateSelectedTips(string, object);
        this.fireTreeSettingsChanged();
    }

    public void clearAnnotation(String string) {
        this.treePane.clearSelectedNodeAnnotation(string);
        this.treePane.clearSelectedTipAnnotation(string);
        this.fireTreeSettingsChanged();
    }

    public void clearColouring() {
        this.treePane.clearSelectedNodeAnnotation("!color");
        this.treePane.clearSelectedTipAnnotation("!color");
        this.fireTreeSettingsChanged();
    }

    @Override
    public void selectAll() {
        if (this.treePaneSelector.getSelectionMode() == TreePaneSelector.SelectionMode.TAXA) {
            this.treePane.selectAllTaxa();
        } else {
            this.treePane.selectAllNodes();
        }
    }

    @Override
    public void clearSelectedTaxa() {
        this.treePane.clearSelection();
    }

    @Override
    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.treePane.addTreeSelectionListener(treeSelectionListener);
    }

    @Override
    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.treePane.removeTreeSelectionListener(treeSelectionListener);
    }

    public TreePaneSelector.SelectionMode getSelectionMode() {
        return this.treePaneSelector.getSelectionMode();
    }

    @Override
    public void setSelectionMode(TreePaneSelector.SelectionMode selectionMode) {
        TreePaneSelector.SelectionMode selectionMode2 = this.treePaneSelector.getSelectionMode();
        if (selectionMode == selectionMode2) {
            return;
        }
        if (selectionMode2 == TreePaneSelector.SelectionMode.TAXA) {
            this.treePane.selectNodesFromSelectedTips();
        } else if (selectionMode == TreePaneSelector.SelectionMode.TAXA) {
            this.treePane.selectTipsFromSelectedNodes();
        } else if (selectionMode == TreePaneSelector.SelectionMode.CLADE) {
            this.treePane.selectCladesFromSelectedNodes();
        }
        this.treePaneSelector.setSelectionMode(selectionMode);
    }

    @Override
    public void setDragMode(TreePaneSelector.DragMode dragMode) {
        this.treePaneSelector.setDragMode(dragMode);
    }

    @Override
    public void setTipLabelPainter(LabelPainter<Node> labelPainter) {
        this.treePane.setTipLabelPainter(labelPainter);
    }

    @Override
    public void setNodeLabelPainter(LabelPainter<Node> labelPainter) {
        this.treePane.setNodeLabelPainter(labelPainter);
    }

    @Override
    public void setNodeBarPainter(NodeBarPainter nodeBarPainter) {
        this.treePane.setNodeBarPainter(nodeBarPainter);
    }

    public void setTipShapePainter(NodeShapePainter nodeShapePainter) {
        this.treePane.setTipShapePainter(nodeShapePainter);
    }

    @Override
    public void setNodeShapePainter(NodeShapePainter nodeShapePainter) {
        this.treePane.setNodeShapePainter(nodeShapePainter);
    }

    @Override
    public void setBranchLabelPainter(LabelPainter<Node> labelPainter) {
        this.treePane.setBranchLabelPainter(labelPainter);
    }

    @Override
    public void addScalePainter(ScalePainter scalePainter) {
        this.treePane.addScalePainter(scalePainter);
    }

    @Override
    public void removeScalePainter(ScalePainter scalePainter) {
        this.treePane.removeScalePainter(scalePainter);
    }

    @Override
    public void setScaleGridPainter(ScaleGridPainter scaleGridPainter) {
        this.treePane.setScaleGridPainter(scaleGridPainter);
    }

    @Override
    public void setLegendPainter(LegendPainter legendPainter) {
        this.treePane.setLegendPainter(legendPainter);
    }

    @Override
    public void setBranchDecorator(Decorator decorator, boolean bl) {
        this.treePane.setBranchDecorator(decorator, bl);
    }

    @Override
    public void setBranchColouringDecorator(String string, Decorator decorator) {
        this.treePane.setBranchColouringDecorator(string, decorator);
    }

    @Override
    public void setNodeBackgroundDecorator(Decorator decorator) {
        this.treePane.setNodeBackgroundDecorator(decorator);
    }

    @Override
    public void setHilightingGradient(boolean bl) {
        this.treePane.setHilightingGradient(bl);
    }

    @Override
    public void setSelectionColor(Color color) {
        this.treePane.setSelectionColor(color);
    }

    @Override
    public Paint getSelectionPaint() {
        return this.treePane.getSelectionPaint();
    }

    @Override
    public void setBranchStroke(BasicStroke basicStroke) {
        this.treePane.setBranchStroke(basicStroke);
    }

    @Override
    public boolean isTransformBranchesOn() {
        return this.treePane.isTransformBranchesOn();
    }

    @Override
    public TransformedRootedTree.Transform getBranchTransform() {
        return this.treePane.getBranchTransform();
    }

    @Override
    public void setTransformBranchesOn(boolean bl) {
        this.treePane.setTransformBranchesOn(bl);
    }

    @Override
    public void setBranchTransform(TransformedRootedTree.Transform transform) {
        this.treePane.setBranchTransform(transform);
    }

    @Override
    public boolean isOrderBranchesOn() {
        return this.treePane.isOrderBranchesOn();
    }

    @Override
    public SortedRootedTree.BranchOrdering getBranchOrdering() {
        return this.treePane.getBranchOrdering();
    }

    @Override
    public void setOrderBranchesOn(boolean bl) {
        this.treePane.setOrderBranchesOn(bl);
    }

    @Override
    public void setBranchOrdering(SortedRootedTree.BranchOrdering branchOrdering) {
        this.treePane.setBranchOrdering(branchOrdering);
    }

    @Override
    public boolean isRootingOn() {
        return this.treePane.isRootingOn();
    }

    @Override
    public TreePane.RootingType getRootingType() {
        return this.treePane.getRootingType();
    }

    @Override
    public void setRootingOn(boolean bl) {
        this.treePane.setRootingOn(bl);
    }

    @Override
    public void setRootingType(TreePane.RootingType rootingType) {
        this.treePane.setRootingType(rootingType);
    }

    public void setToolMode(TreePaneSelector.ToolMode toolMode) {
        this.treePaneSelector.setToolMode(toolMode);
    }

    @Override
    public JComponent getContentPane() {
        return this.treePane;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.zoomPending) {
            this.refreshZoom();
            this.zoomPending = false;
        }
        super.paint(graphics);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return this.treePane.print(graphics, pageFormat, n);
    }

    @Override
    public void addTreeViewerListener(TreeViewerListener treeViewerListener) {
        this.listeners.add(treeViewerListener);
    }

    @Override
    public void removeTreeViewerListener(TreeViewerListener treeViewerListener) {
        this.listeners.remove(treeViewerListener);
    }

    public void fireTreeChanged() {
        for (TreeViewerListener treeViewerListener : this.listeners) {
            treeViewerListener.treeChanged();
        }
    }

    public void fireTreeSettingsChanged() {
        for (TreeViewerListener treeViewerListener : this.listeners) {
            treeViewerListener.treeSettingsChanged();
        }
    }
}

