/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.TimeScale;
import figtree.treeviewer.TreePane;
import figtree.treeviewer.TreePaneSelector;
import figtree.treeviewer.TreeSelectionListener;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.TreeViewerListener;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.painters.LegendPainter;
import figtree.treeviewer.painters.NodeBarPainter;
import figtree.treeviewer.painters.NodeShapePainter;
import figtree.treeviewer.painters.ScaleGridPainter;
import figtree.treeviewer.painters.ScalePainter;
import figtree.treeviewer.treelayouts.TreeLayout;
import jam.panels.StatusProvider;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.SortedRootedTree;
import jebl.evolution.trees.TransformedRootedTree;
import jebl.evolution.trees.Tree;
import jebl.evolution.trees.Utils;

public class MultiPaneTreeViewer
extends TreeViewer {
    private static final double MAX_ZOOM = 20.0;
    private static final double MAX_VERTICAL_EXPANSION = 20.0;
    private boolean zoomPending = false;
    private double zoom = 0.0;
    private double verticalExpansion = 0.0;
    private List<TreeViewerListener> listeners = new ArrayList<TreeViewerListener>();
    private List<Tree> trees = new ArrayList<Tree>();
    private List<TreePane> treePanes = new ArrayList<TreePane>();
    private int currentTreeIndex = 0;
    private int treesPerPage = 1;
    private MultiPaneTreePanel treePanePanel;
    protected TreePaneSelector treePaneSelector;
    protected JViewport viewport;

    public MultiPaneTreeViewer() {
        this.treePanes.add(new TreePane());
        this.setLayout(new BorderLayout());
        this.treePanePanel = new MultiPaneTreePanel();
        this.treePanePanel.setLayout(new BoxLayout(this.treePanePanel, 3));
        JScrollPane jScrollPane = new JScrollPane(this.treePanePanel, 22, 32);
        jScrollPane.setMinimumSize(new Dimension(150, 150));
        jScrollPane.setBorder(null);
        this.viewport = jScrollPane.getViewport();
        this.add((Component)jScrollPane, "Center");
    }

    public void setTree(Tree tree) {
        this.trees.clear();
        this.addTree(tree);
        this.showTree(0);
    }

    @Override
    public void setTrees(Collection<? extends Tree> collection) {
        this.trees.clear();
        for (Tree tree : collection) {
            this.addTree(tree);
        }
        this.showTree(0);
    }

    protected void addTree(Tree tree) {
        this.trees.add(tree);
        this.showTree(this.trees.size() - 1);
    }

    public void addTrees(Collection<? extends Tree> collection) {
        int n = this.getTreeCount();
        for (Tree tree : collection) {
            this.addTree(tree);
        }
        this.showTree(n);
    }

    public Tree getTree() {
        return this.trees.get(0);
    }

    @Override
    public List<Tree> getTrees() {
        return this.trees;
    }

    public int getTreesPerPage() {
        return this.treesPerPage;
    }

    public void setTreesPerPage(int n) {
        this.treesPerPage = n;
        if (this.treePanes.size() < n) {
            while (this.treePanes.size() < n) {
                this.treePanes.add(new TreePane());
            }
        } else if (this.treePanes.size() > n) {
            while (this.treePanes.size() > n) {
                this.treePanes.remove(this.treePanes.size() - 1);
            }
        }
        this.showTree(this.currentTreeIndex);
    }

    private void setupTreePane(TreePane treePane) {
        treePane.setAutoscrolls(true);
        this.treePaneSelector = new TreePaneSelector(treePane);
    }

    @Override
    public Tree getCurrentTree() {
        return this.trees.get(this.currentTreeIndex);
    }

    @Override
    public int getCurrentTreeIndex() {
        return this.currentTreeIndex;
    }

    @Override
    public int getTreeCount() {
        if (this.trees == null) {
            return 0;
        }
        return this.trees.size();
    }

    @Override
    public StatusProvider getStatusProvider() {
        return null;
    }

    @Override
    public void showTree(int n) {
        int n2 = n;
        for (TreePane treePane : this.treePanes) {
            if (n2 < this.trees.size()) {
                Tree tree = this.trees.get(n2);
                if (tree instanceof RootedTree) {
                    treePane.setTree((RootedTree)tree);
                } else {
                    treePane.setTree(Utils.rootTheTree(tree));
                }
            } else {
                treePane.setTree(null);
            }
            ++n2;
        }
        this.currentTreeIndex = n;
        this.treePanePanel.removeAll();
        this.setLayout(new BoxLayout(this, 3));
        for (TreePane treePane : this.treePanes) {
            this.treePanePanel.add(treePane);
            this.setupTreePane(treePane);
        }
        this.fireTreeChanged();
    }

    public void showNextTree() {
        if (this.currentTreeIndex < this.trees.size() - 1) {
            this.showTree(this.currentTreeIndex + 1);
        }
    }

    public void showPreviousTree() {
        if (this.currentTreeIndex > 0) {
            this.showTree(this.currentTreeIndex - 1);
        }
    }

    @Override
    public void setTreeLayout(TreeLayout treeLayout) {
        for (TreePane treePane : this.treePanes) {
            treePane.setTreeLayout(treeLayout);
        }
    }

    @Override
    public void setZoom(double d) {
        this.zoom = d * 20.0;
        this.refreshZoom();
    }

    @Override
    public void setVerticalExpansion(double d) {
        this.verticalExpansion = d * 20.0;
        this.refreshZoom();
    }

    @Override
    public boolean verticalExpansionAllowed() {
        return !this.treePanes.get(0).maintainAspectRatio();
    }

    @Override
    public void setTimeScale(TimeScale timeScale) {
        for (TreePane treePane : this.treePanes) {
            treePane.setTimeScale(timeScale);
        }
    }

    private void refreshZoom() {
        this.setZoom(this.zoom, this.zoom + this.verticalExpansion);
    }

    private void setZoom(double d, double d2) {
        Dimension dimension = this.viewport.getViewSize();
        Point point = this.viewport.getViewPosition();
        Dimension dimension2 = this.viewport.getExtentSize();
        double d3 = dimension2.getWidth() * (1.0 + d);
        double d4 = dimension2.getHeight() * (1.0 + d2);
        Dimension dimension3 = new Dimension((int)d3, (int)d4 / this.treesPerPage);
        for (TreePane treePane : this.treePanes) {
            treePane.setPreferredSize(dimension3);
            treePane.revalidate();
        }
        double d5 = point.getX() + 0.5 * dimension2.getWidth();
        double d6 = point.getY() + 0.5 * dimension2.getHeight();
        double d7 = dimension3.getWidth() / dimension.getWidth();
        double d8 = dimension3.getHeight() / dimension.getHeight();
        double d9 = d5 * d7 - dimension2.getWidth() / 2.0;
        double d10 = d6 * d8 - dimension2.getHeight() / 2.0;
        Point point2 = new Point((int)d9, (int)d10);
        this.viewport.setViewPosition(point2);
    }

    @Override
    public boolean hasSelection() {
        for (TreePane treePane : this.treePanes) {
            if (!treePane.hasSelection()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Node> getSelectedNodes() {
        for (TreePane treePane : this.treePanes) {
            if (!treePane.hasSelection()) continue;
            return treePane.getSelectedNodes();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Node> getSelectedTips() {
        for (TreePane treePane : this.treePanes) {
            if (!treePane.hasSelection()) continue;
            return treePane.getSelectedTips();
        }
        return Collections.emptySet();
    }

    @Override
    public void selectTaxa(String string, TreeViewer.TextSearchType textSearchType, String string2, boolean bl) {
    }

    @Override
    public void selectNodes(String string, TreeViewer.TextSearchType textSearchType, String string2, boolean bl) {
    }

    @Override
    public void selectTaxa(String string, TreeViewer.NumberSearchType numberSearchType, Number number) {
    }

    @Override
    public void selectNodes(String string, TreeViewer.NumberSearchType numberSearchType, Number number) {
    }

    @Override
    public void selectTaxa(Collection<String> collection) {
    }

    @Override
    public void collapseSelectedNodes() {
    }

    @Override
    public void annotateSelectedNodes(String string, Object object) {
        this.fireTreeSettingsChanged();
    }

    @Override
    public void annotateSelectedTips(String string, Object object) {
        this.fireTreeSettingsChanged();
    }

    @Override
    public void selectAll() {
    }

    @Override
    public void clearSelectedTaxa() {
    }

    @Override
    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        for (TreePane treePane : this.treePanes) {
            treePane.addTreeSelectionListener(treeSelectionListener);
        }
    }

    @Override
    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        for (TreePane treePane : this.treePanes) {
            treePane.removeTreeSelectionListener(treeSelectionListener);
        }
    }

    @Override
    public void setSelectionMode(TreePaneSelector.SelectionMode selectionMode) {
    }

    @Override
    public void setDragMode(TreePaneSelector.DragMode dragMode) {
        this.treePaneSelector.setDragMode(dragMode);
    }

    @Override
    public void setTipLabelPainter(LabelPainter<Node> labelPainter) {
        for (TreePane treePane : this.treePanes) {
            treePane.setTipLabelPainter(labelPainter);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public void setNodeLabelPainter(LabelPainter<Node> labelPainter) {
        for (TreePane treePane : this.treePanes) {
            treePane.setNodeLabelPainter(labelPainter);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public void setNodeBarPainter(NodeBarPainter nodeBarPainter) {
        for (TreePane treePane : this.treePanes) {
            treePane.setNodeBarPainter(nodeBarPainter);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public void setNodeShapePainter(NodeShapePainter nodeShapePainter) {
        for (TreePane treePane : this.treePanes) {
            treePane.setNodeShapePainter(nodeShapePainter);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public void setBranchLabelPainter(LabelPainter<Node> labelPainter) {
        for (TreePane treePane : this.treePanes) {
            treePane.setBranchLabelPainter(labelPainter);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public void addScalePainter(ScalePainter scalePainter) {
        for (TreePane treePane : this.treePanes) {
            treePane.addScalePainter(scalePainter);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public void removeScalePainter(ScalePainter scalePainter) {
        for (TreePane treePane : this.treePanes) {
            treePane.removeScalePainter(scalePainter);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public void setScaleGridPainter(ScaleGridPainter scaleGridPainter) {
        for (TreePane treePane : this.treePanes) {
            treePane.setScaleGridPainter(scaleGridPainter);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public void setLegendPainter(LegendPainter legendPainter) {
        for (TreePane treePane : this.treePanes) {
            treePane.setLegendPainter(legendPainter);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public void setBranchDecorator(Decorator decorator, boolean bl) {
        for (TreePane treePane : this.treePanes) {
            treePane.setBranchDecorator(decorator, bl);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public void setBranchColouringDecorator(String string, Decorator decorator) {
        for (TreePane treePane : this.treePanes) {
            treePane.setBranchColouringDecorator(string, decorator);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public void setNodeBackgroundDecorator(Decorator decorator) {
        for (TreePane treePane : this.treePanes) {
            treePane.setNodeBackgroundDecorator(decorator);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public void setHilightingGradient(boolean bl) {
        for (TreePane treePane : this.treePanes) {
            treePane.setHilightingGradient(bl);
        }
    }

    @Override
    public void setSelectionColor(Color color) {
        for (TreePane treePane : this.treePanes) {
            treePane.setSelectionColor(color);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public Paint getSelectionPaint() {
        return this.treePanes.get(0).getSelectionPaint();
    }

    @Override
    public void setBranchStroke(BasicStroke basicStroke) {
        for (TreePane treePane : this.treePanes) {
            treePane.setBranchStroke(basicStroke);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public boolean isTransformBranchesOn() {
        return this.treePanes.get(0).isTransformBranchesOn();
    }

    @Override
    public TransformedRootedTree.Transform getBranchTransform() {
        return this.treePanes.get(0).getBranchTransform();
    }

    @Override
    public void setTransformBranchesOn(boolean bl) {
        for (TreePane treePane : this.treePanes) {
            treePane.setTransformBranchesOn(bl);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public void setBranchTransform(TransformedRootedTree.Transform transform) {
        for (TreePane treePane : this.treePanes) {
            treePane.setBranchTransform(transform);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public boolean isOrderBranchesOn() {
        return this.treePanes.get(0).isOrderBranchesOn();
    }

    @Override
    public SortedRootedTree.BranchOrdering getBranchOrdering() {
        return this.treePanes.get(0).getBranchOrdering();
    }

    @Override
    public void setOrderBranchesOn(boolean bl) {
        for (TreePane treePane : this.treePanes) {
            treePane.setOrderBranchesOn(bl);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public void setBranchOrdering(SortedRootedTree.BranchOrdering branchOrdering) {
        for (TreePane treePane : this.treePanes) {
            treePane.setBranchOrdering(branchOrdering);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public boolean isRootingOn() {
        return this.treePanes.get(0).isOrderBranchesOn();
    }

    @Override
    public TreePane.RootingType getRootingType() {
        return this.treePanes.get(0).getRootingType();
    }

    @Override
    public void setRootingOn(boolean bl) {
        for (TreePane treePane : this.treePanes) {
            treePane.setRootingOn(bl);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public void setRootingType(TreePane.RootingType rootingType) {
        for (TreePane treePane : this.treePanes) {
            treePane.setRootingType(rootingType);
        }
        this.fireTreeSettingsChanged();
    }

    @Override
    public JComponent getContentPane() {
        return this.treePanePanel;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.zoomPending) {
            this.refreshZoom();
            this.zoomPending = false;
        }
        super.paint(graphics);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return this.treePanePanel.print(graphics, pageFormat, n);
    }

    @Override
    public void addTreeViewerListener(TreeViewerListener treeViewerListener) {
        this.listeners.add(treeViewerListener);
    }

    @Override
    public void removeTreeViewerListener(TreeViewerListener treeViewerListener) {
        this.listeners.remove(treeViewerListener);
    }

    public void fireTreeChanged() {
        for (TreeViewerListener treeViewerListener : this.listeners) {
            treeViewerListener.treeChanged();
        }
    }

    public void fireTreeSettingsChanged() {
        for (TreeViewerListener treeViewerListener : this.listeners) {
            treeViewerListener.treeSettingsChanged();
        }
    }

    class MultiPaneTreePanel
    extends JPanel
    implements Printable {
        MultiPaneTreePanel() {
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            return 0;
        }
    }
}

