/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.TreeViewerListener;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jebl.evolution.trees.Tree;

public class MultipleTreesController
extends AbstractController {
    private final JLabel titleLabel = new JLabel("Current Tree");
    private final OptionsPanel optionsPanel = new ControllerOptionsPanel(2, 2);

    public MultipleTreesController(final TreeViewer treeViewer) {
        final JLabel jLabel = new JLabel("Tree 1");
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 1, 100000, 1);
        JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        jSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                treeViewer.showTree((Integer)spinnerNumberModel.getValue() - 1);
            }
        });
        treeViewer.addTreeViewerListener(new TreeViewerListener(){

            @Override
            public void treeChanged() {
                int n = treeViewer.getCurrentTreeIndex() + 1;
                int n2 = treeViewer.getTrees().size();
                if (n2 > 0) {
                    Tree tree = treeViewer.getCurrentTree();
                    spinnerNumberModel.setValue(n);
                    spinnerNumberModel.setMaximum(Integer.valueOf(n2));
                    String string = (String)tree.getAttribute("name");
                    if (string != null) {
                        jLabel.setText(string);
                    } else {
                        jLabel.setText("Tree " + n);
                    }
                    MultipleTreesController.this.titleLabel.setText("Current Tree: " + n + " / " + n2);
                } else {
                    MultipleTreesController.this.titleLabel.setText("No trees");
                }
            }

            @Override
            public void treeSettingsChanged() {
            }
        });
        this.optionsPanel.addComponentWithLabel("Name:", jLabel);
        this.optionsPanel.addComponentWithLabel("Tree:", jSpinner);
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleLabel;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
    }

    @Override
    public void getSettings(Map<String, Object> map) {
    }
}

