/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.evolution.trees.Utils;

public class Parsimony {
    private final int stateCount;
    private final Map<Taxon, Integer> stateMap;
    private Map<Node, boolean[]> stateSets = new HashMap<Node, boolean[]>();
    private Map<Node, Integer> states = new HashMap<Node, Integer>();
    private RootedTree tree = null;
    private List<Taxon> taxa;
    private boolean hasCalculatedSteps = false;
    private boolean hasRecontructedStates = false;

    public Parsimony(int n, Map<Taxon, Integer> map) {
        this.stateCount = n;
        this.stateMap = map;
    }

    public Integer getState(Tree tree, Node node) {
        if (tree == null) {
            throw new IllegalArgumentException("The tree cannot be null");
        }
        if (!(tree instanceof RootedTree)) {
            throw new IllegalArgumentException("The tree must be an instance of rooted tree");
        }
        if (this.tree == null || this.tree != tree) {
            this.tree = (RootedTree)tree;
            if (!Utils.isBinary(this.tree)) {
                throw new IllegalArgumentException("The Fitch algorithm can only reconstruct ancestral states on binary trees");
            }
            this.initialize();
        }
        if (!this.hasCalculatedSteps) {
            this.calculateSteps(this.tree);
            this.hasCalculatedSteps = true;
        }
        if (!this.hasRecontructedStates) {
            this.reconstructStates2(this.tree.getRootNode(), null);
            this.hasRecontructedStates = true;
        }
        return this.states.get(node);
    }

    private void initialize() {
        this.hasCalculatedSteps = false;
        this.hasRecontructedStates = false;
        for (Node node : this.tree.getNodes()) {
            boolean[] blArray = new boolean[this.stateCount];
            this.stateSets.put(node, blArray);
        }
    }

    private void calculateSteps(RootedTree rootedTree) {
        List<Node> list = Utils.getNodes(rootedTree, rootedTree.getRootNode());
        boolean[] blArray = new boolean[this.stateCount];
        boolean[] blArray2 = new boolean[this.stateCount];
        for (int i = list.size() - 1; i >= 0; --i) {
            Node node = list.get(i);
            boolean[] blArray3 = this.stateSets.get(node);
            if (rootedTree.isExternal(node)) {
                boolean[] blArray4 = this.stateSets.get(node);
                Taxon taxon = rootedTree.getTaxon(node);
                int n = this.stateMap.get(taxon);
                blArray4[n] = true;
                continue;
            }
            boolean bl = true;
            for (Node node2 : rootedTree.getChildren(node)) {
                boolean[] blArray5 = this.stateSets.get(node2);
                if (bl) {
                    Parsimony.copyOf(blArray5, blArray);
                    Parsimony.copyOf(blArray5, blArray2);
                    bl = false;
                    continue;
                }
                Parsimony.unionOf(blArray, blArray5, blArray);
                Parsimony.intersectionOf(blArray2, blArray5, blArray2);
            }
            if (Parsimony.sizeOf(blArray2) > 0) {
                Parsimony.copyOf(blArray2, blArray3);
                continue;
            }
            Parsimony.copyOf(blArray, blArray3);
        }
    }

    private void reconstructStates(Node node, int n) {
        if (!this.tree.isExternal(node)) {
            boolean[] blArray = this.stateSets.get(node);
            Integer n2 = null;
            n2 = n != -1 && blArray[n] ? Integer.valueOf(n) : Integer.valueOf(Parsimony.firstIndexOf(blArray));
            for (Node node2 : this.tree.getChildren(node)) {
                this.reconstructStates(node2, n2);
            }
            this.states.put(node, n2);
        }
    }

    private boolean[] reconstructStates2(Node node, boolean[] blArray) {
        Object object = this.stateSets.get(node);
        if (!this.tree.isExternal(node)) {
            boolean[] blArray2 = new boolean[this.stateCount];
            boolean bl = true;
            for (Node node2 : this.tree.getChildren(node)) {
                boolean[] blArray3 = this.reconstructStates2(node2, (boolean[])object);
                if (bl) {
                    Parsimony.copyOf(blArray3, blArray2);
                    bl = false;
                    continue;
                }
                Parsimony.unionOf(blArray2, blArray3, blArray2);
            }
            if (blArray != null) {
                Object object2 = new boolean[this.stateCount];
                Parsimony.intersectionOf(blArray, blArray2, (boolean[])object2);
                if (Parsimony.sizeOf((boolean[])object2) > 0) {
                    object = object2;
                }
            }
            if (Parsimony.sizeOf(object) == 1) {
                this.states.put(node, Parsimony.firstIndexOf(object));
            }
        }
        return object;
    }

    private static void copyOf(boolean[] blArray, boolean[] blArray2) {
        for (int i = 0; i < blArray2.length; ++i) {
            blArray2[i] = blArray[i];
        }
    }

    private static void unionOf(boolean[] blArray, boolean[] blArray2, boolean[] blArray3) {
        for (int i = 0; i < blArray3.length; ++i) {
            blArray3[i] = blArray[i] || blArray2[i];
        }
    }

    private static void intersectionOf(boolean[] blArray, boolean[] blArray2, boolean[] blArray3) {
        for (int i = 0; i < blArray3.length; ++i) {
            blArray3[i] = blArray[i] && blArray2[i];
        }
    }

    private static int firstIndexOf(boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            return i;
        }
        return -1;
    }

    private static int sizeOf(boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        return n;
    }
}

