/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jebl.evolution.graphs.Edge;
import jebl.evolution.graphs.Graph;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.BaseEdge;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.util.AttributableHelper;
import jebl.util.HashPair;

public final class ReRootedTree
implements RootedTree {
    private RootedTree source = null;
    private ReRootedNode rootNode = null;
    private final Set<Node> internalNodes = new LinkedHashSet<Node>();
    private final Map<Taxon, Node> externalNodes = new LinkedHashMap<Taxon, Node>();
    private boolean heightsKnown = false;
    private boolean lengthsKnown = false;
    private boolean hasHeights = false;
    private boolean hasLengths = false;

    public ReRootedTree(RootedTree rootedTree, Node node, Node node2, double d) throws Graph.NoEdgeException {
        this.source = rootedTree;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Node node3 = this.createNodes(rootedTree, node2, node);
        this.setLength(node3, d);
        arrayList.add(node3);
        Node node4 = this.createNodes(rootedTree, node, node2);
        double d2 = rootedTree.getEdgeLength(node, node2);
        if (node2 == rootedTree.getRootNode()) {
            for (Node node5 : rootedTree.getAdjacencies(node2)) {
                if (node5 == node) continue;
                d2 += rootedTree.getEdgeLength(node2, node5);
            }
        }
        this.setLength(node4, Math.max(d2 - d, 0.0));
        arrayList.add(node4);
        this.createInternalNode(null, arrayList);
    }

    public Node createNodes(RootedTree rootedTree, Node node, Node node2) throws Graph.NoEdgeException {
        double d;
        Node node3 = null;
        if (rootedTree.isExternal(node2)) {
            node3 = this.createExternalNode(node2, rootedTree.getTaxon(node2));
            d = rootedTree.getEdgeLength(node, node2);
        } else {
            List<Node> list = rootedTree.getAdjacencies(node2);
            if (list.size() == 2) {
                node3 = list.get(0) == node ? this.createNodes(rootedTree, node2, list.get(1)) : this.createNodes(rootedTree, node2, list.get(0));
                d = rootedTree.getEdgeLength(list.get(0), node2) + rootedTree.getEdgeLength(list.get(1), node2);
            } else {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (Node node4 : list) {
                    if (node4 == node) continue;
                    arrayList.add(this.createNodes(rootedTree, node2, node4));
                }
                node3 = rootedTree.getParent(node) == node2 ? this.createInternalNode(node, arrayList) : this.createInternalNode(node2, arrayList);
                d = rootedTree.getEdgeLength(node, node2);
            }
        }
        this.setLength(node3, d);
        return node3;
    }

    private Node createExternalNode(Node node, Taxon taxon) {
        ReRootedNode reRootedNode = new ReRootedNode(node, taxon);
        this.externalNodes.put(taxon, reRootedNode);
        return reRootedNode;
    }

    private ReRootedNode createInternalNode(Node node, List<? extends Node> list) {
        ReRootedNode reRootedNode = new ReRootedNode(node, list);
        for (Node node2 : list) {
            ((ReRootedNode)node2).setParent(reRootedNode);
        }
        this.internalNodes.add(reRootedNode);
        this.rootNode = reRootedNode;
        return reRootedNode;
    }

    public Node getSourceNode(Node node) {
        return ((ReRootedNode)node).source;
    }

    public void setHeight(Node node, double d) {
        this.lengthsKnown = false;
        this.heightsKnown = true;
        this.hasLengths = true;
        this.hasHeights = true;
        ((ReRootedNode)node).setHeight(d);
    }

    public void setLength(Node node, double d) {
        this.heightsKnown = false;
        this.lengthsKnown = true;
        this.hasLengths = true;
        this.hasHeights = true;
        ((ReRootedNode)node).setLength(d);
    }

    @Override
    public List<Node> getChildren(Node node) {
        return new ArrayList<Node>(((ReRootedNode)node).getChildren());
    }

    @Override
    public boolean hasHeights() {
        return this.hasHeights;
    }

    @Override
    public double getHeight(Node node) {
        if (!this.hasHeights) {
            throw new IllegalArgumentException("This tree has no node heights");
        }
        if (!this.heightsKnown) {
            this.calculateNodeHeights();
        }
        return ((ReRootedNode)node).getHeight();
    }

    @Override
    public boolean hasLengths() {
        return this.hasLengths;
    }

    @Override
    public double getLength(Node node) {
        if (!this.hasLengths) {
            throw new IllegalArgumentException("This tree has no branch lengths");
        }
        if (!this.lengthsKnown) {
            this.calculateBranchLengths();
        }
        return ((ReRootedNode)node).getLength();
    }

    @Override
    public Node getParent(Node node) {
        if (!(node instanceof ReRootedNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of SimpleRootedNode");
        }
        return ((ReRootedNode)node).getParent();
    }

    public Edge getParentEdge(Node node) {
        if (!(node instanceof ReRootedNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of SimpleRootedNode");
        }
        return ((ReRootedNode)node).getEdge();
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    @Override
    public Set<Node> getExternalNodes() {
        return new LinkedHashSet<Node>(this.externalNodes.values());
    }

    @Override
    public Set<Node> getInternalNodes() {
        return new LinkedHashSet<Node>(this.internalNodes);
    }

    @Override
    public Set<Taxon> getTaxa() {
        return new LinkedHashSet<Taxon>(this.externalNodes.keySet());
    }

    @Override
    public Taxon getTaxon(Node node) {
        if (!(node instanceof ReRootedNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of SimpleRootedNode.  It is an instance of " + node.getClass().getName());
        }
        return ((ReRootedNode)node).getTaxon();
    }

    @Override
    public boolean isExternal(Node node) {
        if (!(node instanceof ReRootedNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of SimpleRootedNode.  It is an instance of " + node.getClass().getName());
        }
        return ((ReRootedNode)node).getChildren().size() == 0;
    }

    @Override
    public Node getNode(Taxon taxon) {
        return this.externalNodes.get(taxon);
    }

    @Override
    public void renameTaxa(Taxon taxon, Taxon taxon2) {
        ReRootedNode reRootedNode = (ReRootedNode)this.externalNodes.get(taxon);
        if (reRootedNode == null) {
            throw new IllegalArgumentException("Unknown taxon " + taxon + "; can't rename to " + taxon2);
        }
        reRootedNode.setTaxon(taxon2);
        this.externalNodes.remove(taxon);
        this.externalNodes.put(taxon2, reRootedNode);
    }

    @Override
    public List<Edge> getEdges(Node node) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (Node node2 : this.getAdjacencies(node)) {
            arrayList.add(((ReRootedNode)node2).getEdge());
        }
        return arrayList;
    }

    @Override
    public List<Node> getAdjacencies(Node node) {
        return ((ReRootedNode)node).getAdjacencies();
    }

    @Override
    public Edge getEdge(Node node, Node node2) throws Graph.NoEdgeException {
        if (((ReRootedNode)node).getParent() == node2) {
            return ((ReRootedNode)node).getEdge();
        }
        if (((ReRootedNode)node2).getParent() == node) {
            return ((ReRootedNode)node2).getEdge();
        }
        throw new Graph.NoEdgeException();
    }

    @Override
    public double getEdgeLength(Node node, Node node2) throws Graph.NoEdgeException {
        if (((ReRootedNode)node).getParent() == node2) {
            if (this.heightsKnown) {
                return ((ReRootedNode)node2).getHeight() - ((ReRootedNode)node).getHeight();
            }
            return ((ReRootedNode)node).getLength();
        }
        if (((ReRootedNode)node2).getParent() == node) {
            if (this.heightsKnown) {
                return ((ReRootedNode)node).getHeight() - ((ReRootedNode)node2).getHeight();
            }
            return ((ReRootedNode)node2).getLength();
        }
        throw new Graph.NoEdgeException();
    }

    @Override
    public Node[] getNodes(Edge edge) {
        for (Node node : this.getNodes()) {
            if (((ReRootedNode)node).getEdge() != edge) continue;
            return new Node[]{node, ((ReRootedNode)node).getParent()};
        }
        return null;
    }

    @Override
    public Set<Node> getNodes() {
        LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>(this.internalNodes);
        linkedHashSet.addAll(this.externalNodes.values());
        return linkedHashSet;
    }

    @Override
    public Set<Edge> getEdges() {
        LinkedHashSet<Edge> linkedHashSet = new LinkedHashSet<Edge>();
        for (Node node : this.getNodes()) {
            if (node == this.getRootNode()) continue;
            linkedHashSet.add(((ReRootedNode)node).getEdge());
        }
        return linkedHashSet;
    }

    @Override
    public Set<Edge> getExternalEdges() {
        LinkedHashSet<Edge> linkedHashSet = new LinkedHashSet<Edge>();
        for (Node node : this.getExternalNodes()) {
            linkedHashSet.add(((ReRootedNode)node).getEdge());
        }
        return linkedHashSet;
    }

    @Override
    public Set<Edge> getInternalEdges() {
        LinkedHashSet<Edge> linkedHashSet = new LinkedHashSet<Edge>();
        for (Node node : this.getInternalNodes()) {
            if (node == this.getRootNode()) continue;
            linkedHashSet.add(((ReRootedNode)node).getEdge());
        }
        return linkedHashSet;
    }

    @Override
    public Set<Node> getNodes(int n) {
        LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
        for (Node node : this.getNodes()) {
            int n2 = node.getDegree();
            if (n2 != n) continue;
            linkedHashSet.add(node);
        }
        return linkedHashSet;
    }

    private void calculateNodeHeights() {
        if (!this.lengthsKnown) {
            throw new IllegalArgumentException("Can't calculate node heights because branch lengths not known");
        }
        this.nodeLengthsToHeights(this.rootNode, 0.0);
        double d = 0.0;
        for (Node node : this.getExternalNodes()) {
            if (!(((ReRootedNode)node).getHeight() > d)) continue;
            d = ((ReRootedNode)node).getHeight();
        }
        for (Node node : this.getNodes()) {
            ((ReRootedNode)node).setHeight(d - ((ReRootedNode)node).getHeight());
        }
        this.heightsKnown = true;
    }

    private void nodeLengthsToHeights(ReRootedNode reRootedNode, double d) {
        double d2 = d;
        if (reRootedNode.getLength() > 0.0) {
            d2 += reRootedNode.getLength();
        }
        reRootedNode.setHeight(d2);
        for (Node node : reRootedNode.getChildren()) {
            this.nodeLengthsToHeights((ReRootedNode)node, d2);
        }
    }

    protected void calculateBranchLengths() {
        if (!this.hasLengths) {
            throw new IllegalArgumentException("Can't calculate branch lengths because node heights not known");
        }
        this.nodeHeightsToLengths(this.rootNode, this.getHeight(this.rootNode));
        this.lengthsKnown = true;
    }

    private void nodeHeightsToLengths(ReRootedNode reRootedNode, double d) {
        double d2 = reRootedNode.getHeight();
        reRootedNode.setLength(d2 >= 0.0 ? d - d2 : 1.0);
        for (Node node : reRootedNode.getChildren()) {
            this.nodeHeightsToLengths((ReRootedNode)node, reRootedNode.getHeight());
        }
    }

    @Override
    public boolean conceptuallyUnrooted() {
        return false;
    }

    @Override
    public boolean isRoot(Node node) {
        return node == this.rootNode;
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.source.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        return this.source.getAttribute(string);
    }

    @Override
    public void removeAttribute(String string) {
        this.source.removeAttribute(string);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.source.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        return this.source.getAttributeMap();
    }

    public static RootedTree rootTreeAtCenter(RootedTree rootedTree) {
        LinkedHashMap<HashPair<Node>, Double> linkedHashMap = new LinkedHashMap<HashPair<Node>, Double>();
        try {
            double d = -1.7976931348623157E308;
            Node node = null;
            Node node2 = null;
            for (Node node3 : rootedTree.getExternalNodes()) {
                for (Node node4 : rootedTree.getAdjacencies(node3)) {
                    double d2 = ReRootedTree.dist(rootedTree, node3, node4, linkedHashMap);
                    if (!(d2 > d)) continue;
                    d = d2;
                    node = node3;
                    node2 = node4;
                }
            }
            double d3 = d / 2.0;
            while (true) {
                double d4;
                if (d3 <= (d4 = rootedTree.getEdgeLength(node, node2))) {
                    return new ReRootedTree(rootedTree, node, node2, d3);
                }
                d3 -= d4;
                d = -1.7976931348623157E308;
                Node node5 = null;
                for (Node node6 : rootedTree.getAdjacencies(node2)) {
                    double d5;
                    if (node6 == node || !((d5 = ReRootedTree.dist(rootedTree, node2, node6, linkedHashMap)) > d)) continue;
                    d = d5;
                    node5 = node6;
                }
                node = node2;
                node2 = node5;
            }
        }
        catch (Graph.NoEdgeException noEdgeException) {
            return null;
        }
    }

    private static double dist(Tree tree, Node node, Node node2, Map<HashPair<Node>, Double> map) throws Graph.NoEdgeException {
        HashPair<Node> hashPair = new HashPair<Node>(node, node2);
        if (map.containsKey(hashPair)) {
            return map.get(hashPair);
        }
        double d = 0.0;
        for (Node node3 : tree.getAdjacencies(node2)) {
            if (node3 == node) continue;
            double d2 = ReRootedTree.dist(tree, node2, node3, map);
            d = Math.max(d, d2);
        }
        double d3 = tree.getEdgeLength(node2, node) + d;
        map.put(hashPair, d3);
        return d3;
    }

    private class ReRootedNode
    implements Node {
        private final Node source;
        private List<Node> children;
        private Taxon taxon;
        private Node parent;
        private double height;
        private double length;
        private Edge edge = null;
        private AttributableHelper helper = null;

        public ReRootedNode(Node node, Taxon taxon) {
            this.source = node;
            this.children = Collections.unmodifiableList(new ArrayList());
            this.taxon = taxon;
        }

        public ReRootedNode(Node node, List<? extends Node> list) {
            this.source = node;
            this.children = Collections.unmodifiableList(new ArrayList<Node>(list));
            this.taxon = null;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node node) {
            this.parent = node;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double d) {
            this.height = d;
        }

        public double getLength() {
            return this.length;
        }

        public void setLength(double d) {
            this.length = d;
        }

        @Override
        public int getDegree() {
            return this.children.size() + (this == ReRootedTree.this.rootNode ? 0 : 1);
        }

        public void setTaxon(Taxon taxon) {
            this.taxon = taxon;
        }

        public Edge getEdge() {
            if (this.edge == null) {
                this.edge = new BaseEdge(){

                    @Override
                    public double getLength() {
                        return ReRootedNode.this.length;
                    }
                };
            }
            return this.edge;
        }

        public List<Node> getAdjacencies() {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            if (this.children != null) {
                arrayList.addAll(this.children);
            }
            if (this.parent != null) {
                arrayList.add(this.parent);
            }
            return arrayList;
        }

        public Taxon getTaxon() {
            return this.taxon;
        }

        @Override
        public void setAttribute(String string, Object object) {
            if (this.source == null) {
                if (this.helper == null) {
                    this.helper = new AttributableHelper();
                }
                this.helper.setAttribute(string, object);
            } else {
                this.source.setAttribute(string, object);
            }
        }

        @Override
        public Object getAttribute(String string) {
            if (this.source == null) {
                if (this.helper == null) {
                    return null;
                }
                return this.helper.getAttribute(string);
            }
            return this.source.getAttribute(string);
        }

        @Override
        public void removeAttribute(String string) {
            if (this.source == null) {
                if (this.helper != null) {
                    this.helper.removeAttribute(string);
                }
            } else {
                this.source.removeAttribute(string);
            }
        }

        @Override
        public Set<String> getAttributeNames() {
            if (this.source == null) {
                if (this.helper == null) {
                    return Collections.emptySet();
                }
                return this.helper.getAttributeNames();
            }
            return this.source.getAttributeNames();
        }

        @Override
        public Map<String, Object> getAttributeMap() {
            if (this.source == null) {
                if (this.helper == null) {
                    return Collections.emptyMap();
                }
                return this.helper.getAttributeMap();
            }
            return this.source.getAttributeMap();
        }
    }
}

