/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.TimeScale;
import figtree.treeviewer.TreeViewer;
import figtree.ui.components.RealNumberField;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimeScaleController
extends AbstractController {
    private static final String CONTROLLER_TITLE = "Time Scale";
    private static Preferences PREFS = Preferences.userNodeForPackage(TreeViewer.class);
    private static final String CONTROLLER_KEY = "scale";
    private static final String SCALE_ROOT_KEY = "scaleRoot";
    private static final String ROOT_AGE_KEY = "rootAge";
    private static final String OFFSET_AGE_KEY = "offsetAge";
    private static final String SCALE_FACTOR_KEY = "scaleFactor";
    private static boolean DEFAULT_SCALE_ROOT = false;
    private static double DEFAULT_ROOT_AGE = 1.0;
    private static double DEFAULT_OFFSET_AGE = 0.0;
    private static double DEFAULT_SCALE_FACTOR = 1.0;
    private JRadioButton scaleFactorRadio;
    private final RealNumberField offsetAgeText;
    private final RealNumberField scaleFactorText;
    private JRadioButton scaleRootRadio;
    private final RealNumberField rootAgeText;
    private final JLabel titleLabel;
    private final OptionsPanel optionsPanel;
    private final TreeViewer treeViewer;

    public TimeScaleController(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.titleLabel = new JLabel(CONTROLLER_TITLE);
        boolean bl = PREFS.getBoolean("scale.scaleRoot", DEFAULT_SCALE_ROOT);
        double d = PREFS.getDouble("scale.offsetAge", DEFAULT_OFFSET_AGE);
        double d2 = PREFS.getDouble("scale.scaleFactor", DEFAULT_SCALE_FACTOR);
        double d3 = PREFS.getDouble("scale.rootAge", DEFAULT_ROOT_AGE);
        this.optionsPanel = new ControllerOptionsPanel(2, 2);
        this.scaleFactorRadio = new JRadioButton("Scale by factor:");
        this.scaleFactorRadio.setSelected(!bl);
        this.optionsPanel.addSpanningComponent(this.scaleFactorRadio);
        this.offsetAgeText = new RealNumberField(-1.7976931348623157E308, Double.MAX_VALUE);
        this.offsetAgeText.setValue(d);
        final JLabel jLabel = this.optionsPanel.addComponentWithLabel("Offset by:", this.offsetAgeText, true);
        this.scaleFactorText = new RealNumberField(-1.7976931348623157E308, Double.MAX_VALUE);
        this.scaleFactorText.setValue(d2);
        final JLabel jLabel2 = this.optionsPanel.addComponentWithLabel("Scale factor:", this.scaleFactorText, true);
        this.scaleRootRadio = new JRadioButton("Scale root to:");
        this.scaleRootRadio.setSelected(bl);
        this.optionsPanel.addSpanningComponent(this.scaleRootRadio);
        this.rootAgeText = new RealNumberField(0.0, Double.MAX_VALUE);
        this.rootAgeText.setValue(d3);
        final JLabel jLabel3 = this.optionsPanel.addComponentWithLabel("Root age:", this.rootAgeText, true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.scaleFactorRadio);
        buttonGroup.add(this.scaleRootRadio);
        this.scaleFactorRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = TimeScaleController.this.scaleFactorRadio.isSelected();
                jLabel.setEnabled(bl);
                TimeScaleController.this.offsetAgeText.setEnabled(bl);
                jLabel2.setEnabled(bl);
                TimeScaleController.this.scaleFactorText.setEnabled(bl);
                jLabel3.setEnabled(!bl);
                TimeScaleController.this.rootAgeText.setEnabled(!bl);
                TimeScaleController.this.setTimeScale();
            }
        });
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TimeScaleController.this.setTimeScale();
            }
        };
        this.offsetAgeText.addChangeListener(changeListener);
        this.scaleFactorText.addChangeListener(changeListener);
        this.rootAgeText.addChangeListener(changeListener);
    }

    private void setTimeScale() {
        TimeScale timeScale;
        if (this.scaleFactorRadio.isSelected()) {
            double d = this.getValue(this.offsetAgeText, 0.0);
            double d2 = this.getValue(this.scaleFactorText, 1.0);
            timeScale = new TimeScale(d2, d);
        } else {
            double d = this.getValue(this.rootAgeText, 0.0);
            timeScale = new TimeScale(d);
        }
        this.treeViewer.setTimeScale(timeScale);
    }

    private double getValue(RealNumberField realNumberField, double d) {
        Double d2 = realNumberField.getValue();
        return d2 != null ? d2 : d;
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleLabel;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.scaleFactorRadio.setSelected((Boolean)map.get("scale.scaleRoot") == false);
        this.scaleRootRadio.setSelected((Boolean)map.get("scale.scaleRoot"));
        this.offsetAgeText.setValue((Double)map.get("scale.offsetAge"));
        this.scaleFactorText.setValue((Double)map.get("scale.scaleFactor"));
        this.rootAgeText.setValue((Double)map.get("scale.rootAge"));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put("scale.scaleRoot", new Boolean(this.scaleRootRadio.isSelected()));
        map.put("scale.offsetAge", this.offsetAgeText.getValue());
        map.put("scale.scaleFactor", this.scaleFactorText.getValue());
        map.put("scale.rootAge", this.rootAgeText.getValue());
    }
}

