/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.ReRootedTree;
import figtree.treeviewer.ScaleAxis;
import figtree.treeviewer.TimeScale;
import figtree.treeviewer.TreePaneListener;
import figtree.treeviewer.TreeSelectionListener;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.painters.LegendPainter;
import figtree.treeviewer.painters.NodeBarPainter;
import figtree.treeviewer.painters.NodeShapePainter;
import figtree.treeviewer.painters.Painter;
import figtree.treeviewer.painters.PainterListener;
import figtree.treeviewer.painters.ScaleGridPainter;
import figtree.treeviewer.painters.ScalePainter;
import figtree.treeviewer.treelayouts.TreeLayout;
import figtree.treeviewer.treelayouts.TreeLayoutCache;
import figtree.treeviewer.treelayouts.TreeLayoutListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import jebl.evolution.graphs.Graph;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.FilteredRootedTree;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.RootedTreeUtils;
import jebl.evolution.trees.SimpleRootedTree;
import jebl.evolution.trees.SortedRootedTree;
import jebl.evolution.trees.TransformedRootedTree;

public class TreePane
extends JComponent
implements PainterListener,
Printable {
    public static final boolean DEBUG_OUTLINE = false;
    public final String CARTOON_ATTRIBUTE_NAME = "!cartoon";
    public final String COLLAPSE_ATTRIBUTE_NAME = "!collapse";
    public final String HILIGHT_ATTRIBUTE_NAME = "!hilight";
    private final Set<TreeSelectionListener> treeSelectionListeners = new HashSet<TreeSelectionListener>();
    private final Set<TreePaneListener> treePaneListeners = new HashSet<TreePaneListener>();
    private GeneralPath branchSelection = null;
    private GeneralPath labelSelection = null;
    private RootedTree originalTree = null;
    private RootedTree tree = null;
    private TreeLayout treeLayout = null;
    private TreeLayoutCache treeLayoutCache = new TreeLayoutCache();
    private boolean orderBranchesOn = false;
    private SortedRootedTree.BranchOrdering branchOrdering = SortedRootedTree.BranchOrdering.INCREASING_NODE_DENSITY;
    private boolean transformBranchesOn = false;
    private TransformedRootedTree.Transform branchTransform = TransformedRootedTree.Transform.CLADOGRAM;
    private boolean isRootingOn = false;
    private RootingType rootingType = RootingType.USER_ROOTING;
    private Node rootingNode = null;
    private double rootingLength = 0.01;
    private Rectangle2D treeBounds = new Rectangle2D.Double();
    private double treeScale;
    private double maxTreeHeight;
    private double rootHeightOffset;
    private ScaleAxis scaleAxis = new ScaleAxis(4, 4);
    private double axisOrigin = 0.0;
    private TimeScale timeScale = new TimeScale(1.0, 0.0);
    private boolean isAxisReversed = false;
    private Insets insets = new Insets(6, 6, 6, 6);
    private Set<Node> selectedNodes = new HashSet<Node>();
    private Set<Node> selectedTips = new LinkedHashSet<Node>();
    private double rulerHeight = -1.0;
    private Rectangle2D dragRectangle = null;
    private Point2D cursorPosition = null;
    private boolean isCrosshairShown = true;
    private Decorator branchDecorator = null;
    private Decorator branchColouringDecorator = null;
    private boolean branchDecoratorGradient = false;
    private String branchColouringAttribute = null;
    private boolean hilightingGradient = false;
    private Decorator nodeBackgroundDecorator = null;
    private float labelXOffset = 10.0f;
    private LabelPainter<Node> tipLabelPainter = null;
    private LabelPainter<Node> nodeLabelPainter = null;
    private LabelPainter<Node> branchLabelPainter = null;
    private NodeBarPainter nodeBarPainter = null;
    private NodeShapePainter nodeShapePainter = null;
    private NodeShapePainter tipShapePainter = null;
    private List<ScalePainter> scalePainters = new ArrayList<ScalePainter>();
    private Map<ScalePainter, Rectangle2D> scaleBounds = new HashMap<ScalePainter, Rectangle2D>();
    private ScaleGridPainter scaleGridPainter = null;
    private LegendPainter legendPainter = null;
    private Rectangle2D legendBounds = new Rectangle2D.Double();
    private Rectangle2D topPanelBounds = new Rectangle2D.Double();
    private Rectangle2D leftPanelBounds = new Rectangle2D.Double();
    private Rectangle2D bottomPanelBounds = new Rectangle2D.Double();
    private Rectangle2D rightPanelBounds = new Rectangle2D.Double();
    private BasicStroke branchLineStroke = new BasicStroke(1.0f, 0, 0);
    private BasicStroke calloutStroke = new BasicStroke(0.5f, 1, 1, 1.0f, new float[]{0.5f, 2.0f}, 0.0f);
    private Stroke selectionStroke = new BasicStroke(6.0f, 1, 1);
    private Paint selectionPaint;
    private Stroke cursorStroke = new BasicStroke(0.5f, 0, 0);
    private Paint cursorPaint = Color.DARK_GRAY;
    private boolean calibrated = false;
    private AffineTransform transform = null;
    private boolean showingTipCallouts = true;
    private Map<Node, AffineTransform> tipLabelTransforms = new HashMap<Node, AffineTransform>();
    private Map<Node, Shape> tipLabelBounds = new HashMap<Node, Shape>();
    private Map<Node, Double> tipLabelWidths = new HashMap<Node, Double>();
    private Map<Node, Painter.Justification> tipLabelJustifications = new HashMap<Node, Painter.Justification>();
    private Map<Node, AffineTransform> nodeLabelTransforms = new HashMap<Node, AffineTransform>();
    private Map<Node, Shape> nodeLabelBounds = new HashMap<Node, Shape>();
    private Map<Node, Painter.Justification> nodeLabelJustifications = new HashMap<Node, Painter.Justification>();
    private Map<Node, AffineTransform> branchLabelTransforms = new HashMap<Node, AffineTransform>();
    private Map<Node, Shape> branchLabelBounds = new HashMap<Node, Shape>();
    private Map<Node, Painter.Justification> branchLabelJustifications = new HashMap<Node, Painter.Justification>();
    private Map<Node, Shape> nodeBars = new HashMap<Node, Shape>();
    private Map<Node, Point2D> tipPoints = new HashMap<Node, Point2D>();
    private Map<Node, Point2D> nodePoints = new HashMap<Node, Point2D>();
    private Map<Node, AffineTransform> nodeShapeTransforms = new HashMap<Node, AffineTransform>();
    private Map<Node, Shape> calloutPaths = new HashMap<Node, Shape>();

    public RootedTree getTree() {
        return this.tree;
    }

    public void setTree(RootedTree rootedTree) {
        if (rootedTree != null) {
            this.originalTree = rootedTree;
            if (!this.originalTree.hasLengths()) {
                this.transformBranchesOn = true;
            }
            this.setupTree();
        } else {
            this.originalTree = null;
            this.tree = null;
            this.invalidate();
            this.repaint();
        }
    }

    private void recalibrate() {
        this.calibrated = false;
    }

    private void setupTree() {
        this.tree = this.constructTransformedTree(this.originalTree);
        this.recalculateCollapsedNodes();
        this.recalibrate();
        this.invalidate();
        this.repaint();
    }

    public RootedTree constructTransformedTree(RootedTree rootedTree) {
        RootedTree rootedTree2 = rootedTree;
        if (this.isRootingOn) {
            Node node;
            if (this.rootingType == RootingType.MID_POINT) {
                rootedTree2 = ReRootedTree.rootTreeAtCenter(rootedTree2);
            } else if (this.rootingType == RootingType.USER_ROOTING && this.rootingNode != null && (node = rootedTree2.getParent(this.rootingNode)) != null) {
                double d = rootedTree2.hasLengths() ? rootedTree2.getLength(this.rootingNode) * this.rootingLength : 1.0;
                try {
                    rootedTree2 = new ReRootedTree(rootedTree2, node, this.rootingNode, d);
                }
                catch (Graph.NoEdgeException noEdgeException) {
                    noEdgeException.printStackTrace();
                }
            }
        }
        if (this.orderBranchesOn) {
            rootedTree2 = new SortedRootedTree(rootedTree2, this.branchOrdering);
        }
        if (this.transformBranchesOn || !rootedTree.hasLengths()) {
            rootedTree2 = new TransformedRootedTree(rootedTree2, this.branchTransform);
        }
        return rootedTree2;
    }

    public TreeLayout getTreeLayout() {
        return this.treeLayout;
    }

    public TreeLayoutCache getTreeLayoutCache() {
        return this.treeLayoutCache;
    }

    public void setTreeLayout(TreeLayout treeLayout) {
        this.treeLayout = treeLayout;
        treeLayout.setCartoonAttributeName("!cartoon");
        treeLayout.setCollapsedAttributeName("!collapse");
        treeLayout.setHilightAttributeName("!hilight");
        treeLayout.setBranchColouringAttributeName(this.branchColouringAttribute);
        treeLayout.addTreeLayoutListener(new TreeLayoutListener(){

            @Override
            public void treeLayoutChanged() {
                TreePane.this.recalibrate();
                TreePane.this.repaint();
            }
        });
        this.recalibrate();
        this.invalidate();
        this.repaint();
    }

    public TimeScale getTimeScale() {
        return this.timeScale;
    }

    public void setTimeScale(TimeScale timeScale) {
        this.timeScale = timeScale;
        this.timeScale.setReversed(this.isAxisReversed());
        this.recalibrate();
        this.repaint();
    }

    public boolean isCrosshairShown() {
        return this.isCrosshairShown;
    }

    public void setCrosshairShown(boolean bl) {
        this.isCrosshairShown = bl;
    }

    public void setCursorPosition(Point point) {
        this.cursorPosition = point;
        if (this.cursorPosition != null) {
            double d = (point.getX() - this.treeBounds.getX()) / this.treeBounds.getWidth();
            d = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
            double d2 = (point.getY() - this.treeBounds.getY()) / this.treeBounds.getHeight();
            d2 = d2 < 0.0 ? 0.0 : (d2 > 1.0 ? 1.0 : d2);
            this.treeLayout.setPointOfInterest(d, d2);
        }
    }

    public void midpointRoot() {
        this.isRootingOn = true;
        this.rootingType = RootingType.MID_POINT;
        this.setupTree();
        this.fireSettingsChanged();
    }

    public void setRootLocation(Node node, double d) {
        RootedTree rootedTree = this.tree;
        if (this.tree instanceof FilteredRootedTree) {
            rootedTree = ((FilteredRootedTree)this.tree).getSource();
        }
        this.rootingNode = rootedTree instanceof ReRootedTree ? ((ReRootedTree)rootedTree).getSourceNode(node) : node;
        this.rootingLength = d;
        this.isRootingOn = true;
        this.rootingType = RootingType.USER_ROOTING;
        this.setupTree();
        this.fireSettingsChanged();
    }

    public void rotateNode(Node node) {
        if (node != null) {
            Boolean bl = (Boolean)node.getAttribute("!rotate");
            bl = bl != null ? Boolean.valueOf(bl == false) : Boolean.valueOf(true);
            node.setAttribute("!rotate", bl);
            this.recalibrate();
            this.invalidate();
            this.repaint();
        }
    }

    public void clearRotation(Node node) {
        if (node != null) {
            Boolean bl = (Boolean)node.getAttribute("!rotate");
            if (bl != null) {
                node.removeAttribute("!rotate");
            }
            this.recalibrate();
            this.invalidate();
            this.repaint();
        }
    }

    public void setBranchDecorator(Decorator decorator, boolean bl) {
        this.branchDecorator = decorator;
        this.branchDecoratorGradient = bl;
        this.repaint();
    }

    public void setBranchColouringDecorator(String string, Decorator decorator) {
        this.branchColouringAttribute = string;
        this.treeLayout.setBranchColouringAttributeName(string);
        this.branchColouringDecorator = decorator;
        this.repaint();
    }

    public boolean isHilightingGradient() {
        return this.hilightingGradient;
    }

    public void setHilightingGradient(boolean bl) {
        this.hilightingGradient = bl;
        this.repaint();
    }

    public void setNodeBackgroundDecorator(Decorator decorator) {
        this.nodeBackgroundDecorator = decorator;
        this.repaint();
    }

    public Rectangle2D getTreeBounds() {
        return this.treeBounds;
    }

    public double getTreeScale() {
        return this.treeScale / this.timeScale.getScaleFactor(this.tree);
    }

    public double scaleOnAxis(double d) {
        double d2 = this.timeScale.getHeight(d, this.tree);
        if (this.isAxisReversed()) {
            return this.treeBounds.getX() + this.treeBounds.getWidth() - d2 * this.treeScale;
        }
        return this.treeBounds.getX() + d2 * this.treeScale;
    }

    public Shape getAxisLine(double d) {
        d = this.isAxisReversed() ? this.maxTreeHeight - d : (d -= this.rootHeightOffset);
        double d2 = this.timeScale.getHeight(d, this.tree);
        Shape shape = this.treeLayout.getAxisLine(d2);
        if (shape != null) {
            return this.transform.createTransformedShape(shape);
        }
        return null;
    }

    public ScaleAxis getScaleAxis() {
        return this.scaleAxis;
    }

    public double getAxisOrigin() {
        return this.axisOrigin;
    }

    public void setAxisOrigin(double d) {
        this.axisOrigin = d;
        this.recalibrate();
        this.repaint();
    }

    public void setAxisReversed(boolean bl) {
        this.isAxisReversed = bl;
        this.timeScale.setReversed(this.isAxisReversed());
        this.recalibrate();
        this.repaint();
    }

    public boolean isAxisReversed() {
        return this.isAxisReversed;
    }

    private void setupScaleAxis() {
        double d;
        double d2 = this.timeScale.getAge(0.0, this.tree);
        if (d2 < (d = this.timeScale.getAge(this.maxTreeHeight, this.tree))) {
            if (this.axisOrigin < d2) {
                d2 = this.axisOrigin;
            }
            this.scaleAxis.setRange(d2, d);
        } else {
            if (this.axisOrigin > d2) {
                d2 = this.axisOrigin;
            }
            this.scaleAxis.setRange(d, d2);
        }
    }

    public void setRootAge(double d) {
        double d2 = this.timeScale.getHeight(d, this.tree) - this.tree.getHeight(this.tree.getRootNode());
        this.treeLayout.setRootLength(d2);
        this.recalibrate();
        this.repaint();
    }

    public double getRootAge() {
        double d = this.tree.getHeight(this.tree.getRootNode()) + this.treeLayout.getRootLength();
        return this.timeScale.getAge(d, this.tree);
    }

    public double getMajorTickSpacing() {
        return this.scaleAxis.getMajorTickSpacing();
    }

    public double getMinorTickSpacing() {
        return this.scaleAxis.getMinorTickSpacing();
    }

    public void setTickSpacing(double d, double d2) {
        this.scaleAxis.setManualAxis(d, d2);
        this.recalibrate();
        this.repaint();
    }

    public void setAutomaticScale() {
        this.scaleAxis.setAutomatic();
        this.recalibrate();
        this.repaint();
    }

    @Override
    public void painterChanged() {
        this.recalibrate();
        this.repaint();
    }

    @Override
    public void painterSettingsChanged() {
        this.recalibrate();
        this.repaint();
    }

    @Override
    public void attributesChanged() {
        this.recalibrate();
        this.repaint();
    }

    public BasicStroke getBranchStroke() {
        return this.branchLineStroke;
    }

    public void setBranchStroke(BasicStroke basicStroke) {
        this.branchLineStroke = basicStroke;
        float f = basicStroke.getLineWidth();
        this.selectionStroke = new BasicStroke(Math.max(f + 4.0f, f * 1.5f), 1, 1);
        this.repaint();
    }

    public BasicStroke getCalloutStroke() {
        return this.calloutStroke;
    }

    public void setCalloutStroke(BasicStroke basicStroke) {
        this.calloutStroke = basicStroke;
    }

    public Paint getSelectionPaint() {
        return this.selectionPaint;
    }

    public void setSelectionColor(Color color) {
        this.selectionPaint = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
    }

    public boolean isTransformBranchesOn() {
        return this.transformBranchesOn;
    }

    public void setTransformBranchesOn(boolean bl) {
        this.transformBranchesOn = bl;
        this.setupTree();
    }

    public TransformedRootedTree.Transform getBranchTransform() {
        return this.branchTransform;
    }

    public void setBranchTransform(TransformedRootedTree.Transform transform) {
        this.branchTransform = transform;
        this.setupTree();
    }

    public boolean isOrderBranchesOn() {
        return this.orderBranchesOn;
    }

    public void setOrderBranchesOn(boolean bl) {
        this.orderBranchesOn = bl;
        this.setupTree();
    }

    public SortedRootedTree.BranchOrdering getBranchOrdering() {
        return this.branchOrdering;
    }

    public void setBranchOrdering(SortedRootedTree.BranchOrdering branchOrdering) {
        this.branchOrdering = branchOrdering;
        this.setupTree();
    }

    public boolean isRootingOn() {
        return this.isRootingOn;
    }

    public RootingType getRootingType() {
        return this.rootingType;
    }

    public void setRootingOn(boolean bl) {
        this.isRootingOn = bl;
        this.setupTree();
    }

    public void setRootingType(RootingType rootingType) {
        this.rootingType = rootingType;
        this.setupTree();
    }

    public RootedTree getOriginalTree() {
        return this.originalTree;
    }

    public boolean isShowingTipCallouts() {
        return this.showingTipCallouts;
    }

    public void setShowingTipCallouts(boolean bl) {
        this.showingTipCallouts = bl;
        this.recalibrate();
        this.repaint();
    }

    public void setSelectedNode(Node node) {
        this.selectedNodes.clear();
        this.selectedTips.clear();
        this.addSelectedNode(node, false, false);
    }

    public void setSelectedTip(Node node) {
        this.selectedNodes.clear();
        this.selectedTips.clear();
        this.addSelectedTip(node, false, false);
    }

    public void setSelectedClade(Node node) {
        this.selectedNodes.clear();
        this.selectedTips.clear();
        this.addSelectedClade(node, false, false);
    }

    public void setSelectedTips(Node node) {
        this.selectedNodes.clear();
        this.selectedTips.clear();
        this.addSelectedTips(node, false);
    }

    private boolean canSelectNode(Node node) {
        return node != null;
    }

    public void addSelectedNode(Node node) {
        this.addSelectedNode(node, false, false);
    }

    public void addSelectedNode(Node node, boolean bl, boolean bl2) {
        this.amendNodeSelection(node, bl, bl2);
        this.fireSelectionChanged();
        this.clearSelectionPaths();
        this.repaint();
    }

    public void addSelectedTip(Node node) {
        this.addSelectedTip(node, false, false);
    }

    public void addSelectedTip(Node node, boolean bl, boolean bl2) {
        this.amendNodeSelection(node, bl, bl2);
        this.selectTipsFromSelectedNodes();
        this.fireSelectionChanged();
        this.clearSelectionPaths();
        this.repaint();
    }

    public void addSelectedClade(Node node) {
        this.addSelectedClade(node, false, false);
    }

    public void addSelectedClade(Node node, boolean bl, boolean bl2) {
        if (this.canSelectNode(node)) {
            this.amendCladeSelection(node, bl, bl2);
        }
        this.fireSelectionChanged();
        this.clearSelectionPaths();
        this.repaint();
    }

    private void amendNodeSelection(Node node, boolean bl, boolean bl2) {
        if (!this.canSelectNode(node)) {
            return;
        }
        if (bl2) {
            HashSet<Node> hashSet = new HashSet<Node>(this.selectedNodes);
            hashSet.add(node);
            Node node2 = RootedTreeUtils.getCommonAncestorNode(this.tree, hashSet);
            for (Node node3 : hashSet) {
                while (node3 != null && node3 != node2) {
                    this.amendNodeSelection(node3, false, false);
                    node3 = this.tree.getParent(node3);
                }
            }
        } else if (bl && this.selectedNodes.contains(node)) {
            this.selectedNodes.remove(node);
        } else {
            this.selectedNodes.add(node);
        }
    }

    private void amendCladeSelection(Node node, boolean bl, boolean bl2) {
        if (!this.canSelectNode(node)) {
            return;
        }
        if (bl2) {
            HashSet<Node> hashSet = new HashSet<Node>(this.selectedNodes);
            hashSet.add(node);
            Node node2 = RootedTreeUtils.getCommonAncestorNode(this.tree, hashSet);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Node node3 = (Node)iterator.next();
                while (node3 != null && node3 != node2) {
                    this.amendCladeSelection(node3, false, false);
                    node3 = this.tree.getParent(node3);
                }
            }
        } else if (bl && this.selectedNodes.contains(node)) {
            this.selectedNodes.remove(node);
        } else {
            this.selectedNodes.add(node);
        }
        for (Node node2 : this.tree.getChildren(node)) {
            this.amendCladeSelection(node2, bl, false);
        }
    }

    public void addSelectedTips(Node node) {
        this.addSelectedTips(node, false);
    }

    public void addSelectedTips(Node node, boolean bl) {
        if (node != null) {
            this.addSelectedChildTips(node, bl);
        }
        this.fireSelectionChanged();
        this.clearSelectionPaths();
        this.repaint();
    }

    private void addSelectedChildTips(Node node, boolean bl) {
        if (this.tree.isExternal(node)) {
            if (bl && this.selectedTips.contains(node)) {
                this.selectedTips.remove(node);
            } else {
                this.selectedTips.add(node);
            }
        } else {
            for (Node node2 : this.tree.getChildren(node)) {
                this.addSelectedChildTips(node2, bl);
            }
        }
    }

    public void selectCladesFromSelectedNodes() {
        HashSet<Node> hashSet = new HashSet<Node>(this.selectedNodes);
        this.selectedNodes.clear();
        for (Node node : hashSet) {
            this.addSelectedClade(node, false, false);
        }
        this.fireSelectionChanged();
        this.clearSelectionPaths();
        this.repaint();
    }

    public void selectTipsFromSelectedNodes() {
        for (Node node : this.selectedNodes) {
            this.addSelectedChildTips(node, false);
        }
        this.selectedNodes.clear();
        this.fireSelectionChanged();
        this.clearSelectionPaths();
        this.repaint();
    }

    public void selectNodesFromSelectedTips() {
        if (this.selectedTips.size() > 0) {
            Node node = RootedTreeUtils.getCommonAncestorNode(this.tree, this.selectedTips);
            this.addSelectedClade(node, false, false);
        }
        this.selectedTips.clear();
        this.fireSelectionChanged();
        this.clearSelectionPaths();
        this.repaint();
    }

    public void selectAllTaxa() {
        this.selectedTips.addAll(this.tree.getExternalNodes());
        this.fireSelectionChanged();
        this.clearSelectionPaths();
        this.repaint();
    }

    public void selectAllNodes() {
        this.selectedNodes.addAll(this.tree.getNodes());
        this.fireSelectionChanged();
        this.clearSelectionPaths();
        this.repaint();
    }

    public void clearSelection() {
        this.selectedNodes.clear();
        this.selectedTips.clear();
        this.fireSelectionChanged();
        this.clearSelectionPaths();
        this.repaint();
    }

    public boolean hasSelection() {
        return this.selectedNodes.size() > 0 || this.selectedTips.size() > 0;
    }

    public void cartoonSelectedNodes() {
        this.cartoonSelectedNodes(this.tree.getRootNode());
    }

    private void cartoonSelectedNodes(Node node) {
        if (!this.tree.isExternal(node)) {
            if (this.selectedNodes.contains(node)) {
                if (node.getAttribute("!cartoon") != null) {
                    node.removeAttribute("!cartoon");
                } else {
                    int n = RootedTreeUtils.getTipCount(this.tree, node);
                    double d = RootedTreeUtils.getMinTipHeight(this.tree, node);
                    Object[] objectArray = new Object[]{n, d};
                    node.setAttribute("!cartoon", objectArray);
                }
                this.recalibrate();
                this.repaint();
            } else {
                for (Node node2 : this.tree.getChildren(node)) {
                    this.cartoonSelectedNodes(node2);
                }
            }
        }
    }

    public void collapseSelectedNodes() {
        this.collapseSelectedNodes(this.tree.getRootNode());
    }

    private void collapseSelectedNodes(Node node) {
        if (!this.tree.isExternal(node)) {
            if (this.selectedNodes.contains(node)) {
                if (node.getAttribute("!collapse") != null) {
                    node.removeAttribute("!collapse");
                } else {
                    String string = "collapsed";
                    double d = RootedTreeUtils.getMinTipHeight(this.tree, node);
                    Object[] objectArray = new Object[]{string, d};
                    node.setAttribute("!collapse", objectArray);
                }
                this.recalibrate();
                this.repaint();
            } else {
                for (Node node2 : this.tree.getChildren(node)) {
                    this.collapseSelectedNodes(node2);
                }
            }
        }
    }

    public void hilightSelectedNodes(Color color) {
        this.hilightSelectedNodes(this.tree.getRootNode(), color);
    }

    private void hilightSelectedNodes(Node node, Color color) {
        if (!this.tree.isExternal(node)) {
            if (this.selectedNodes.contains(node)) {
                int n = RootedTreeUtils.getTipCount(this.tree, node);
                double d = RootedTreeUtils.getMinTipHeight(this.tree, node);
                Object[] objectArray = new Object[]{n, d, color};
                node.setAttribute("!hilight", objectArray);
                this.recalibrate();
                this.repaint();
            } else {
                for (Node node2 : this.tree.getChildren(node)) {
                    this.hilightSelectedNodes(node2, color);
                }
            }
        }
    }

    public void recalculateCollapsedNodes() {
        this.recalculateCollapsedNodes(this.tree.getRootNode());
    }

    private void recalculateCollapsedNodes(Node node) {
        if (!this.tree.isExternal(node)) {
            if (this.selectedNodes.contains(node)) {
                Object[] objectArray;
                Object[] objectArray2;
                double d;
                if (node.getAttribute("!cartoon") != null) {
                    int n = RootedTreeUtils.getTipCount(this.tree, node);
                    d = RootedTreeUtils.getMinTipHeight(this.tree, node);
                    objectArray2 = new Object[]{n, d};
                    node.setAttribute("!cartoon", objectArray2);
                }
                if (node.getAttribute("!collapse") != null) {
                    String string = "collapsed";
                    d = RootedTreeUtils.getMinTipHeight(this.tree, node);
                    objectArray2 = new Object[]{string, d};
                    node.setAttribute("!collapse", objectArray2);
                }
                if ((objectArray = (Object[])node.getAttribute("!hilight")) != null) {
                    int n = RootedTreeUtils.getTipCount(this.tree, node);
                    double d2 = RootedTreeUtils.getMinTipHeight(this.tree, node);
                    Object[] objectArray3 = new Object[]{n, d2, objectArray[2]};
                    node.setAttribute("!hilight", objectArray3);
                }
                this.recalibrate();
                this.repaint();
            } else {
                for (Node node2 : this.tree.getChildren(node)) {
                    this.recalculateCollapsedNodes(node2);
                }
            }
        }
    }

    public void clearCollapsedNodes() {
        if (this.selectedNodes.size() > 0) {
            this.clearSelectedCollapsedNodes(this.tree.getRootNode());
        } else {
            for (Node node : this.tree.getInternalNodes()) {
                if (node.getAttribute("!collapse") != null) {
                    node.removeAttribute("!collapse");
                }
                if (node.getAttribute("!cartoon") == null) continue;
                node.removeAttribute("!cartoon");
            }
            this.recalibrate();
            this.repaint();
        }
    }

    private void clearSelectedCollapsedNodes(Node node) {
        if (!this.tree.isExternal(node)) {
            if (this.selectedNodes.contains(node)) {
                if (node.getAttribute("!collapse") != null) {
                    node.removeAttribute("!collapse");
                }
                if (node.getAttribute("!cartoon") != null) {
                    node.removeAttribute("!cartoon");
                }
                this.recalibrate();
                this.repaint();
            } else {
                for (Node node2 : this.tree.getChildren(node)) {
                    this.clearSelectedCollapsedNodes(node2);
                }
            }
        }
    }

    public void clearHilightedNodes() {
        if (this.selectedNodes.size() > 0) {
            this.clearSelectedHilightedNodes(this.tree.getRootNode());
        } else {
            for (Node node : this.tree.getInternalNodes()) {
                if (node.getAttribute("!hilight") == null) continue;
                node.removeAttribute("!hilight");
            }
            this.recalibrate();
            this.repaint();
        }
    }

    private void clearSelectedHilightedNodes(Node node) {
        if (!this.tree.isExternal(node)) {
            if ((this.selectedNodes.size() == 0 || this.selectedNodes.contains(node)) && node.getAttribute("!hilight") != null) {
                node.removeAttribute("!hilight");
                this.recalibrate();
                this.repaint();
            }
            for (Node node2 : this.tree.getChildren(node)) {
                this.clearSelectedHilightedNodes(node2);
            }
        }
    }

    public void rerootOnSelectedBranch() {
        Iterator<Node> iterator = this.selectedNodes.iterator();
        if (iterator.hasNext()) {
            Node node = iterator.next();
            this.setRootLocation(node, 0.5);
            return;
        }
        this.repaint();
    }

    public void clearRooting() {
        this.rootingNode = null;
        this.setupTree();
        this.fireSettingsChanged();
    }

    public void rotateSelectedNode() {
        for (Node node : this.selectedNodes) {
            this.rotateNode(node);
        }
        this.repaint();
    }

    public void clearSelectedNodeRotations() {
        if (this.selectedNodes.size() > 0) {
            for (Node node : this.selectedNodes) {
                this.clearRotation(node);
            }
        } else {
            for (Node node : this.tree.getInternalNodes()) {
                this.clearRotation(node);
            }
        }
        this.repaint();
    }

    public void annotateSelectedNodes(String string, Object object) {
        for (Node node : this.selectedNodes) {
            node.setAttribute(string, object);
        }
        this.repaint();
    }

    public void annotateSelectedTips(String string, Object object) {
        for (Node node : this.selectedTips) {
            Taxon taxon = this.tree.getTaxon(node);
            taxon.setAttribute(string, object);
        }
        this.repaint();
    }

    public void clearSelectedNodeAnnotation(String string) {
        for (Node node : this.selectedNodes) {
            node.removeAttribute(string);
        }
        this.repaint();
    }

    public void clearSelectedTipAnnotation(String string) {
        for (Node node : this.selectedTips) {
            Taxon taxon = this.tree.getTaxon(node);
            taxon.removeAttribute(string);
        }
        this.repaint();
    }

    public boolean maintainAspectRatio() {
        return this.treeLayout.maintainAspectRatio();
    }

    public void setTipLabelPainter(LabelPainter<Node> labelPainter) {
        labelPainter.setTreePane(this);
        if (this.tipLabelPainter != null) {
            this.tipLabelPainter.removePainterListener(this);
        }
        this.tipLabelPainter = labelPainter;
        if (this.tipLabelPainter != null) {
            this.tipLabelPainter.addPainterListener(this);
        }
        this.recalibrate();
        this.repaint();
    }

    public LabelPainter<Node> getTipLabelPainter() {
        return this.tipLabelPainter;
    }

    public void setNodeLabelPainter(LabelPainter<Node> labelPainter) {
        labelPainter.setTreePane(this);
        if (this.nodeLabelPainter != null) {
            this.nodeLabelPainter.removePainterListener(this);
        }
        this.nodeLabelPainter = labelPainter;
        if (this.nodeLabelPainter != null) {
            this.nodeLabelPainter.addPainterListener(this);
        }
        this.recalibrate();
        this.repaint();
    }

    public LabelPainter<Node> getNodeLabelPainter() {
        return this.nodeLabelPainter;
    }

    public void setBranchLabelPainter(LabelPainter<Node> labelPainter) {
        labelPainter.setTreePane(this);
        if (this.branchLabelPainter != null) {
            this.branchLabelPainter.removePainterListener(this);
        }
        this.branchLabelPainter = labelPainter;
        if (this.branchLabelPainter != null) {
            this.branchLabelPainter.addPainterListener(this);
        }
        this.recalibrate();
        this.repaint();
    }

    public LabelPainter<Node> getBranchLabelPainter() {
        return this.branchLabelPainter;
    }

    public void setNodeBarPainter(NodeBarPainter nodeBarPainter) {
        nodeBarPainter.setTreePane(this);
        if (this.nodeBarPainter != null) {
            this.nodeBarPainter.removePainterListener(this);
        }
        this.nodeBarPainter = nodeBarPainter;
        if (this.nodeBarPainter != null) {
            this.nodeBarPainter.addPainterListener(this);
        }
        this.recalibrate();
        this.repaint();
    }

    public NodeBarPainter getNodeBarPainter() {
        return this.nodeBarPainter;
    }

    public void setTipShapePainter(NodeShapePainter nodeShapePainter) {
        nodeShapePainter.setTreePane(this);
        if (this.tipShapePainter != null) {
            this.tipShapePainter.removePainterListener(this);
        }
        this.tipShapePainter = nodeShapePainter;
        if (this.tipShapePainter != null) {
            this.tipShapePainter.addPainterListener(this);
        }
        this.recalibrate();
        this.repaint();
    }

    public NodeShapePainter getTipShapePainter() {
        return this.tipShapePainter;
    }

    public void setNodeShapePainter(NodeShapePainter nodeShapePainter) {
        nodeShapePainter.setTreePane(this);
        if (this.nodeShapePainter != null) {
            this.nodeShapePainter.removePainterListener(this);
        }
        this.nodeShapePainter = nodeShapePainter;
        if (this.nodeShapePainter != null) {
            this.nodeShapePainter.addPainterListener(this);
        }
        this.recalibrate();
        this.repaint();
    }

    public NodeShapePainter getNodeShapePainter() {
        return this.nodeShapePainter;
    }

    public void addScalePainter(ScalePainter scalePainter) {
        assert (scalePainter != null);
        scalePainter.setTreePane(this);
        scalePainter.addPainterListener(this);
        this.scalePainters.add(scalePainter);
        this.recalibrate();
        this.repaint();
    }

    public void removeScalePainter(ScalePainter scalePainter) {
        assert (scalePainter != null);
        scalePainter.removePainterListener(this);
        this.scalePainters.remove(scalePainter);
        this.recalibrate();
        this.repaint();
    }

    public void setScaleGridPainter(ScaleGridPainter scaleGridPainter) {
        scaleGridPainter.setTreePane(this);
        if (this.scaleGridPainter != null) {
            this.scaleGridPainter.removePainterListener(this);
        }
        this.scaleGridPainter = scaleGridPainter;
        if (this.scaleGridPainter != null) {
            this.scaleGridPainter.addPainterListener(this);
        }
        this.recalibrate();
        this.repaint();
    }

    public void setLegendPainter(LegendPainter legendPainter) {
        legendPainter.setTreePane(this);
        legendPainter.addPainterListener(this);
        this.legendPainter = legendPainter;
        this.recalibrate();
        this.repaint();
    }

    public LegendPainter getLegendPainter() {
        return this.legendPainter;
    }

    public float getLabelSpacing() {
        return this.labelXOffset;
    }

    public void setLabelSpacing(float f) {
        this.labelXOffset = f;
        this.recalibrate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        if (this.treeLayout.maintainAspectRatio()) {
            super.setPreferredSize(new Dimension(dimension.width, dimension.height));
        } else {
            super.setPreferredSize(dimension);
        }
        this.recalibrate();
    }

    public double getHeightAt(Graphics2D graphics2D, Point2D point2D) {
        try {
            point2D = this.transform.inverseTransform(point2D, null);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        return this.treeLayout.getHeightOfPoint(point2D);
    }

    public Node getNodeAt(Graphics2D graphics2D, Point point) {
        Shape shape;
        Rectangle rectangle = new Rectangle(point.x - 1, point.y - 1, 3, 3);
        rectangle.translate(-this.insets.left, -this.insets.top);
        for (Node node : this.tree.getExternalNodes()) {
            shape = this.tipLabelBounds.get(node);
            if (shape == null || !shape.intersects(rectangle.x, rectangle.y, rectangle.height, rectangle.width)) continue;
            return node;
        }
        if (this.transform == null) {
            return null;
        }
        for (Node node : this.tree.getNodes()) {
            shape = this.transform.createTransformedShape(this.treeLayoutCache.getBranchPath(node));
            if (shape != null && shape.intersects(rectangle.x, rectangle.y, rectangle.height, rectangle.width)) {
                return node;
            }
            Shape shape2 = this.transform.createTransformedShape(this.treeLayoutCache.getCollapsedShape(node));
            if (shape2 == null || !shape2.intersects(rectangle.x, rectangle.y, rectangle.height, rectangle.width)) continue;
            return node;
        }
        return null;
    }

    public Set<Node> getNodesAt(Graphics2D graphics2D, Rectangle rectangle) {
        Shape shape;
        HashSet<Node> hashSet = new HashSet<Node>();
        for (Node node : this.tree.getExternalNodes()) {
            shape = this.tipLabelBounds.get(node);
            if (shape == null || !shape.intersects(rectangle.x, rectangle.y, rectangle.height, rectangle.width)) continue;
            hashSet.add(node);
        }
        for (Node node : this.tree.getNodes()) {
            Shape shape2;
            shape = this.transform.createTransformedShape(this.treeLayoutCache.getBranchPath(node));
            if (shape != null && shape.intersects(rectangle.x, rectangle.y, rectangle.height, rectangle.width)) {
                hashSet.add(node);
            }
            if ((shape2 = this.transform.createTransformedShape(this.treeLayoutCache.getCollapsedShape(node))) == null || !shape2.intersects(rectangle.x, rectangle.y, rectangle.height, rectangle.width)) continue;
            hashSet.add(node);
        }
        return hashSet;
    }

    public Set<Node> getSelectedNodes() {
        return this.selectedNodes;
    }

    public Set<Node> getSelectedTips() {
        return this.selectedTips;
    }

    public Set<Taxon> getSelectedTaxa() {
        LinkedHashSet<Taxon> linkedHashSet = new LinkedHashSet<Taxon>();
        for (Node node : this.getSelectedTips()) {
            linkedHashSet.add(this.tree.getTaxon(node));
        }
        return linkedHashSet;
    }

    public RootedTree getSelectedSubtree() {
        if (this.selectedNodes.size() == 0 && this.selectedTips.size() == 0) {
            return this.tree;
        }
        SimpleRootedTree simpleRootedTree = new SimpleRootedTree();
        this.getSelectedSubtree(simpleRootedTree, this.tree.getRootNode(), false);
        if (simpleRootedTree.getRootNode() == null) {
            return null;
        }
        return simpleRootedTree;
    }

    private Node getSelectedSubtree(SimpleRootedTree simpleRootedTree, Node node, boolean bl) {
        Node node2;
        if (this.tree.isExternal(node)) {
            if (bl || this.selectedNodes.contains(node) || this.selectedTips.contains(node)) {
                node2 = simpleRootedTree.createExternalNode(this.tree.getTaxon(node));
                simpleRootedTree.setHeight(node2, this.tree.getHeight(node));
                for (String string : node.getAttributeNames()) {
                    node2.setAttribute(string, node.getAttribute(string));
                }
            } else {
                node2 = null;
            }
        } else {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Node object : this.tree.getChildren(node)) {
                Node node3 = this.getSelectedSubtree(simpleRootedTree, object, bl);
                if (node3 == null) continue;
                arrayList.add(node3);
            }
            if (arrayList.size() == 0) {
                node2 = this.selectedNodes.contains(node) ? this.getSelectedSubtree(simpleRootedTree, node, true) : null;
            } else if (arrayList.size() == 1) {
                node2 = (Node)arrayList.get(0);
            } else {
                node2 = simpleRootedTree.createInternalNode(arrayList);
                simpleRootedTree.setHeight(node2, this.tree.getHeight(node));
                for (String string : node.getAttributeNames()) {
                    node2.setAttribute(string, node.getAttribute(string));
                }
            }
        }
        return node2;
    }

    public Rectangle2D getDragRectangle() {
        return this.dragRectangle;
    }

    public void setDragRectangle(Rectangle2D rectangle2D) {
        this.dragRectangle = rectangle2D;
        this.repaint();
    }

    public void setRuler(double d) {
        this.rulerHeight = d;
    }

    public Point getLocationOfTip(Node node) {
        if (node == null) {
            return new Point(0, 0);
        }
        Shape shape = this.transform.createTransformedShape(this.treeLayoutCache.getTipLabelPath(node));
        return shape.getBounds().getLocation();
    }

    public void scrollPointToVisible(Point point) {
        this.scrollRectToVisible(new Rectangle(point.x, point.y, 0, 0));
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.treeSelectionListeners.add(treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.treeSelectionListeners.remove(treeSelectionListener);
    }

    private void fireSelectionChanged() {
        for (TreeSelectionListener treeSelectionListener : this.treeSelectionListeners) {
            treeSelectionListener.selectionChanged();
        }
    }

    public void addTreePaneListener(TreePaneListener treePaneListener) {
        this.treePaneListeners.add(treePaneListener);
    }

    public void removeTreePaneListener(TreePaneListener treePaneListener) {
        this.treePaneListeners.remove(treePaneListener);
    }

    private void fireSettingsChanged() {
        for (TreePaneListener treePaneListener : this.treePaneListeners) {
            treePaneListener.treePaneSettingsChanged();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Shape shape;
        if (this.tree == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.insets.left, this.insets.top);
        if (!this.calibrated) {
            this.calibrate(graphics2D, this.getWidth(), this.getHeight());
        }
        this.drawTree(graphics2D, this.getWidth(), this.getHeight());
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        if (this.branchSelection == null) {
            this.branchSelection = new GeneralPath();
            for (Node node : this.selectedNodes) {
                Shape shape2;
                shape = this.treeLayoutCache.getBranchPath(node);
                if (shape != null) {
                    shape2 = this.transform.createTransformedShape(shape);
                    this.branchSelection.append(shape2, false);
                }
                if ((shape2 = this.treeLayoutCache.getCollapsedShape(node)) == null) continue;
                Shape shape3 = this.transform.createTransformedShape(shape2);
                this.branchSelection.append(shape3, false);
            }
        }
        if (this.labelSelection == null) {
            this.labelSelection = new GeneralPath();
            for (Node node : this.selectedTips) {
                shape = this.tipLabelBounds.get(node);
                if (shape == null) continue;
                this.labelSelection.append(shape, false);
            }
        }
        graphics2D.setPaint(this.selectionPaint);
        graphics2D.setStroke(this.selectionStroke);
        graphics2D.draw(this.branchSelection);
        graphics2D.fill(this.labelSelection);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        if (this.dragRectangle != null) {
            graphics2D.setPaint(new Color(128, 128, 128, 128));
            graphics2D.fill(this.dragRectangle);
        }
    }

    private void clearSelectionPaths() {
        this.branchSelection = null;
        this.labelSelection = null;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (this.tree == null || n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.recalibrate();
        this.setDoubleBuffered(false);
        this.drawTree(graphics2D, pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        this.setDoubleBuffered(true);
        this.recalibrate();
        return 0;
    }

    public void drawTree(Graphics2D graphics2D, double d, double d2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        boolean bl = renderingHints.containsValue(RenderingHints.VALUE_ANTIALIAS_ON);
        if (!bl) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (!this.calibrated) {
            this.calibrate(graphics2D, d, d2);
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        Font font = graphics2D.getFont();
        if (this.legendPainter != null && this.legendPainter.isVisible()) {
            this.legendPainter.paint(graphics2D, this, Painter.Justification.CENTER, this.legendBounds);
        }
        for (ScalePainter object6 : this.scalePainters) {
            if (!object6.isVisible()) continue;
            object5 = this.scaleBounds.get(object6);
            object6.paint(graphics2D, this, Painter.Justification.CENTER, (Rectangle2D)object5);
        }
        if (this.scaleGridPainter != null && this.scaleGridPainter.isVisible()) {
            Iterator<Node> iterator = new Rectangle2D.Double(this.treeBounds.getX(), 0.0, this.treeBounds.getWidth(), this.treeBounds.getHeight());
            this.scaleGridPainter.paint(graphics2D, this, (Painter.Justification)null, (Rectangle2D)((Object)iterator));
        }
        if (this.nodeBackgroundDecorator != null) {
            for (Node node : this.treeLayoutCache.getNodeAreaMap().keySet()) {
                object5 = this.treeLayoutCache.getNodeArea(node);
                if (object5 == null) continue;
                this.nodeBackgroundDecorator.setItem(node);
                object4 = this.transform.createTransformedShape((Shape)object5);
                object3 = new Color(0, 0, 0, 0);
                object3 = this.nodeBackgroundDecorator.getPaint((Paint)object3);
                graphics2D.setPaint((Paint)object3);
                graphics2D.fill((Shape)object4);
            }
        }
        for (Node node : this.treeLayoutCache.getHilightNodesList()) {
            object5 = (Object[])node.getAttribute("!hilight");
            object4 = this.treeLayoutCache.getHilightShape(node);
            object3 = this.transform.createTransformedShape((Shape)object4);
            object2 = ((Color)object5[2]).darker();
            object = (Color)object5[2];
            BasicStroke basicStroke = new BasicStroke(0.5f);
            if (this.hilightingGradient && object != null) {
                object = new GradientPaint((float)object3.getBounds2D().getMinX(), 0.0f, Color.WHITE, (float)object3.getBounds2D().getMaxX(), 0.0f, (Color)object5[2], false);
                graphics2D.setPaint((Paint)object);
                graphics2D.fill((Shape)object3);
                continue;
            }
            if (object != null) {
                graphics2D.setPaint((Paint)object);
                graphics2D.fill((Shape)object3);
            }
            if (object2 == null) continue;
            graphics2D.setPaint((Paint)object2);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw((Shape)object3);
        }
        for (Node node : this.treeLayoutCache.getCollapsedShapeMap().keySet()) {
            object5 = this.treeLayoutCache.getCollapsedShape(node);
            object4 = this.transform.createTransformedShape((Shape)object5);
            object3 = Color.BLACK;
            object2 = null;
            object = this.branchLineStroke;
            if (this.branchDecorator != null) {
                this.branchDecorator.setItem(node);
                object3 = this.branchDecorator.getPaint((Paint)object3);
                object2 = this.branchDecorator.getFillPaint((Paint)object2);
                object = this.branchDecorator.getStroke((Stroke)object);
            }
            if (object2 != null) {
                graphics2D.setPaint((Paint)object2);
                graphics2D.fill((Shape)object4);
            }
            graphics2D.setPaint((Paint)object3);
            graphics2D.setStroke((Stroke)object);
            graphics2D.draw((Shape)object4);
        }
        for (Node node : this.treeLayoutCache.getBranchPathMap().keySet()) {
            Object object6;
            object5 = this.branchLineStroke;
            if (this.branchDecorator != null) {
                this.branchDecorator.setItem(node);
                object5 = this.branchDecorator.getStroke((Stroke)object5);
            }
            graphics2D.setStroke((Stroke)object5);
            object4 = null;
            if (this.treeLayout.isShowingColouring() && this.branchColouringAttribute != null) {
                object4 = (Object[])node.getAttribute(this.branchColouringAttribute);
            }
            object3 = this.treeLayoutCache.getBranchPath(node);
            if (object4 != null) {
                int n;
                object2 = object3.getPathIterator(this.transform);
                object = new float[2];
                object2.currentSegment((float[])object);
                for (n = 0; n < ((Object[])object4).length - 1; n += 2) {
                    object2.next();
                    object6 = new float[2];
                    object2.currentSegment((float[])object6);
                    int n2 = ((Number)object4[n]).intValue();
                    this.branchColouringDecorator.setItem(n2);
                    graphics2D.setPaint(this.branchColouringDecorator.getPaint(Color.BLACK));
                    graphics2D.draw(new Line2D.Float((float)object[0], (float)object[1], (float)object6[0], (float)object6[1]));
                    object = object6;
                }
                n = ((Number)object4[((Object[])object4).length - 1]).intValue();
                this.branchColouringDecorator.setItem(n);
                graphics2D.setPaint(this.branchColouringDecorator.getPaint(Color.BLACK));
                object6 = new GeneralPath();
                ((Path2D.Float)object6).moveTo((float)object[0], (float)object[1]);
                ((Path2D.Float)object6).append((PathIterator)object2, true);
                graphics2D.draw((Shape)object6);
                continue;
            }
            object2 = this.transform.createTransformedShape((Shape)object3);
            object = Color.BLACK;
            if (this.branchDecorator != null) {
                if (this.branchDecoratorGradient && this.branchDecorator.allowsGradient()) {
                    this.branchDecorator.setItems(node, this.tree.getParent(node));
                    PathIterator pathIterator = object2.getPathIterator(null);
                    object6 = new double[6];
                    pathIterator.currentSegment((double[])object6);
                    Point2D.Double double_ = new Point2D.Double(object6[0], object6[1]);
                    do {
                        pathIterator.currentSegment((double[])object6);
                        pathIterator.next();
                    } while (!pathIterator.isDone());
                    Point2D.Double double_2 = new Point2D.Double((double)object6[0], (double)object6[1]);
                    object = this.branchDecorator.getPaint((Paint)object, double_, double_2);
                } else {
                    this.branchDecorator.setItem(node);
                    object = this.branchDecorator.getPaint((Paint)object);
                }
            }
            graphics2D.setPaint((Paint)object);
            graphics2D.draw((Shape)object2);
        }
        if (!this.isTransformBranchesOn() && this.nodeBarPainter != null && this.nodeBarPainter.isVisible()) {
            for (Node node : this.nodeBars.keySet()) {
                object5 = this.nodeBars.get(node);
                object5 = this.transform.createTransformedShape((Shape)object5);
                this.nodeBarPainter.paint(graphics2D, node, Painter.Justification.CENTER, (Shape)object5);
            }
        }
        if (this.nodeShapePainter != null && this.nodeShapePainter.isVisible()) {
            for (Node node : this.nodePoints.keySet()) {
                object5 = this.nodePoints.get(node);
                object5 = this.transform.transform((Point2D)object5, null);
                this.nodeShapePainter.paint(graphics2D, node, (Point2D)object5, this.nodeShapeTransforms.get(node));
            }
        }
        if (this.tipShapePainter != null && this.tipShapePainter.isVisible()) {
            for (Node node : this.tipPoints.keySet()) {
                object5 = this.tipPoints.get(node);
                object5 = this.transform.transform((Point2D)object5, null);
                this.tipShapePainter.paint(graphics2D, node, (Point2D)object5, this.nodeShapeTransforms.get(node));
            }
        }
        if (this.tipLabelPainter != null && this.tipLabelPainter.isVisible()) {
            for (Node node : this.tipLabelTransforms.keySet()) {
                object5 = this.tipLabelTransforms.get(node);
                object4 = this.tipLabelJustifications.get(node);
                graphics2D.transform((AffineTransform)object5);
                double d3 = this.tipLabelWidths.get(node);
                this.tipLabelPainter.paint(graphics2D, node, (Painter.Justification)((Object)object4), new Rectangle2D.Double(0.0, 0.0, d3, this.tipLabelPainter.getPreferredHeight()));
                graphics2D.setTransform(affineTransform);
                if (!this.showingTipCallouts || (object = this.transform.createTransformedShape(this.treeLayoutCache.getCalloutPath(node))) == null) continue;
                graphics2D.setStroke(this.calloutStroke);
                graphics2D.draw((Shape)object);
            }
        }
        if (this.nodeLabelPainter != null && this.nodeLabelPainter.isVisible()) {
            for (Node node : this.nodeLabelTransforms.keySet()) {
                object5 = this.nodeLabelTransforms.get(node);
                object4 = this.nodeLabelJustifications.get(node);
                graphics2D.transform((AffineTransform)object5);
                this.nodeLabelPainter.paint(graphics2D, node, (Painter.Justification)((Object)object4), new Rectangle2D.Double(0.0, 0.0, this.nodeLabelPainter.getPreferredWidth(), this.nodeLabelPainter.getPreferredHeight()));
                graphics2D.setTransform(affineTransform);
            }
        }
        if (this.branchLabelPainter != null && this.branchLabelPainter.isVisible()) {
            for (Node node : this.branchLabelTransforms.keySet()) {
                object5 = this.branchLabelTransforms.get(node);
                graphics2D.transform((AffineTransform)object5);
                this.branchLabelPainter.calibrate(graphics2D, node);
                double d4 = this.branchLabelPainter.getPreferredWidth();
                double d5 = this.branchLabelPainter.getPreferredHeight();
                this.branchLabelPainter.paint(graphics2D, node, Painter.Justification.CENTER, new Rectangle2D.Double(0.0, 0.0, d4, d5));
                graphics2D.setTransform(affineTransform);
            }
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
    }

    private void calibrate(Graphics2D graphics2D, double d, double d2) {
        AffineTransform affineTransform;
        Shape shape;
        Shape shape2;
        Object object;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        AffineTransform affineTransform2;
        Rectangle2D.Double double_;
        double d9;
        double d10;
        Object object2;
        this.treeLayout.layout(this.tree, this.treeLayoutCache);
        this.maxTreeHeight = this.tree.getHeight(this.tree.getRootNode()) + this.treeLayout.getRootLength();
        this.rootHeightOffset = 0.0;
        this.treeBounds = null;
        for (Shape object4 : this.treeLayoutCache.getBranchPathMap().values()) {
            Rectangle2D rectangle2D = object4.getBounds2D();
            if (this.treeBounds == null) {
                this.treeBounds = rectangle2D;
                continue;
            }
            this.treeBounds.add(rectangle2D);
        }
        for (Shape shape3 : this.treeLayoutCache.getCalloutPathMap().values()) {
            Rectangle2D rectangle2D = shape3.getBounds2D();
            this.treeBounds.add(rectangle2D);
        }
        for (Shape shape4 : this.treeLayoutCache.getCollapsedShapeMap().values()) {
            Rectangle2D rectangle2D = shape4.getBounds2D();
            if (this.treeBounds == null) {
                this.treeBounds = rectangle2D;
                continue;
            }
            this.treeBounds.add(rectangle2D);
        }
        for (Shape shape5 : this.treeLayoutCache.getHilightShapeMap().values()) {
            Rectangle2D rectangle2D = shape5.getBounds2D();
            if (this.treeBounds == null) {
                this.treeBounds = rectangle2D;
                continue;
            }
            this.treeBounds.add(rectangle2D);
        }
        if (!this.isTransformBranchesOn() && this.nodeBarPainter != null && this.nodeBarPainter.isVisible()) {
            this.nodeBars.clear();
            for (Node node : this.tree.getInternalNodes()) {
                Rectangle2D rectangle2D = this.nodeBarPainter.calibrate(graphics2D, node);
                if (rectangle2D == null) continue;
                this.treeBounds.add(rectangle2D);
                this.nodeBars.put(node, this.nodeBarPainter.getNodeBar());
            }
            if (this.nodeBarPainter.getMaxHeight() > this.maxTreeHeight) {
                this.rootHeightOffset = Math.max(this.nodeBarPainter.getMaxHeight() - this.maxTreeHeight, 0.0);
                this.maxTreeHeight = this.nodeBarPainter.getMaxHeight();
            }
        }
        Iterator<Node> iterator = this.treeBounds.getBounds2D();
        this.tipLabelWidths.clear();
        if (this.tipLabelPainter != null && this.tipLabelPainter.isVisible()) {
            this.calibrateTipLabels(graphics2D, this.tree.getRootNode(), (Rectangle2D)((Object)iterator));
        }
        if (this.nodeLabelPainter != null && this.nodeLabelPainter.isVisible()) {
            for (Node node : this.treeLayoutCache.getNodeLabelPathMap().keySet()) {
                object2 = this.treeLayoutCache.getNodeLabelPath(node);
                this.nodeLabelPainter.calibrate(graphics2D, node);
                d10 = this.nodeLabelPainter.getPreferredHeight();
                d9 = this.nodeLabelPainter.getPreferredWidth();
                double_ = new Rectangle2D.Double(0.0, 0.0, d9, d10);
                affineTransform2 = this.calculateTransform(null, (Line2D)object2, d9, d10, true);
                ((Rectangle2D)((Object)iterator)).add(affineTransform2.createTransformedShape(double_).getBounds2D());
            }
        }
        if (this.branchLabelPainter != null && this.branchLabelPainter.isVisible()) {
            for (Node node : this.treeLayoutCache.getBranchLabelPathMap().keySet()) {
                object2 = this.treeLayoutCache.getBranchLabelPath(node);
                this.branchLabelPainter.calibrate(graphics2D, node);
                d10 = this.branchLabelPainter.getHeightBound();
                d9 = this.branchLabelPainter.getPreferredWidth();
                double_ = new Rectangle2D.Double(0.0, 0.0, d9, d10);
                affineTransform2 = this.calculateTransform(null, (Line2D)object2, d9, d10, false);
                ((Rectangle2D)((Object)iterator)).add(affineTransform2.createTransformedShape(double_).getBounds2D());
            }
        }
        if (this.tipShapePainter != null && this.tipShapePainter.isVisible()) {
            this.tipPoints.clear();
            for (Node node : this.tree.getExternalNodes()) {
                object2 = this.tipShapePainter.calibrate(graphics2D, node);
                if (object2 == null) continue;
                ((Rectangle2D)((Object)iterator)).add((Rectangle2D)object2);
                this.tipPoints.put(node, new Point2D.Double(((RectangularShape)object2).getCenterX(), ((RectangularShape)object2).getCenterY()));
            }
        }
        if (this.nodeShapePainter != null && this.nodeShapePainter.isVisible()) {
            this.nodePoints.clear();
            for (Node node : this.tree.getInternalNodes()) {
                object2 = this.nodeShapePainter.calibrate(graphics2D, node);
                if (object2 == null) continue;
                ((Rectangle2D)((Object)iterator)).add((Rectangle2D)object2);
                this.nodePoints.put(node, new Point2D.Double(((RectangularShape)object2).getCenterX(), ((RectangularShape)object2).getCenterY()));
            }
        }
        this.setupScaleAxis();
        this.bottomPanelBounds = new Rectangle2D.Double();
        double d11 = ((RectangularShape)((Object)iterator)).getHeight();
        for (ScalePainter scalePainter : this.scalePainters) {
            if (!scalePainter.isVisible()) continue;
            scalePainter.calibrate(graphics2D, this);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(this.treeBounds.getX(), d11, this.treeBounds.getWidth(), scalePainter.getPreferredHeight());
            d11 += ((RectangularShape)double_2).getHeight();
            this.bottomPanelBounds.add(double_2);
            this.scaleBounds.put(scalePainter, double_2);
        }
        this.leftPanelBounds = new Rectangle2D.Double();
        if (this.legendPainter != null && this.legendPainter.isVisible()) {
            this.legendPainter.calibrate(graphics2D, this);
            double d12 = this.legendPainter.getPreferredWidth();
            this.legendBounds = new Rectangle2D.Double(0.0, 0.0, d12, d2);
            this.leftPanelBounds.add(this.legendBounds);
        }
        double d13 = d - (double)this.insets.left - (double)this.insets.right;
        double d14 = d2 - (double)this.insets.top - (double)this.insets.bottom;
        boolean bl = this.treeLayout.maintainAspectRatio();
        if (bl) {
            d8 = this.treeBounds.getY() - ((RectangularShape)((Object)iterator)).getY();
            d7 = this.treeBounds.getX() - ((RectangularShape)((Object)iterator)).getX();
            d6 = ((RectangularShape)((Object)iterator)).getHeight() + ((RectangularShape)((Object)iterator)).getY() - (this.treeBounds.getHeight() + this.treeBounds.getY());
            d5 = ((RectangularShape)((Object)iterator)).getWidth() + ((RectangularShape)((Object)iterator)).getX() - (this.treeBounds.getWidth() + this.treeBounds.getX());
            assert (d8 >= 0.0 && d7 >= 0.0 && d6 >= 0.0 && d5 >= 0.0);
            d4 = 2.0 * (d7 > d5 ? d7 : d5);
            d3 = 2.0 * (d8 > d6 ? d8 : d6);
        } else {
            d4 = ((RectangularShape)((Object)iterator)).getWidth() - this.treeBounds.getWidth();
            d3 = ((RectangularShape)((Object)iterator)).getHeight() - this.treeBounds.getHeight();
            assert (d4 >= 0.0 && d3 >= 0.0);
        }
        if (d4 >= d13) {
            d4 = Math.min(d13, ((RectangularShape)((Object)iterator)).getWidth()) - this.treeBounds.getWidth();
        }
        if (d3 >= d14) {
            d3 = Math.min(d14, ((RectangularShape)((Object)iterator)).getHeight()) - this.treeBounds.getHeight();
        }
        d8 = d13 - d4 - this.leftPanelBounds.getWidth() - this.rightPanelBounds.getWidth();
        d7 = d14 - d3 - this.topPanelBounds.getHeight() - this.bottomPanelBounds.getHeight();
        double d15 = 0.0;
        double d16 = 0.0;
        if (bl) {
            if (d8 / this.treeBounds.getWidth() < d7 / this.treeBounds.getHeight()) {
                d5 = d6 = d8 / this.treeBounds.getWidth();
            } else {
                d6 = d5 = d7 / this.treeBounds.getHeight();
            }
            this.treeScale = d6;
            assert (this.treeScale > 0.0);
            d15 = (d - this.treeBounds.getWidth() * d6) / 2.0 - this.treeBounds.getX() * d6;
            d16 = (d2 - this.treeBounds.getHeight() * d5) / 2.0 - this.treeBounds.getY() * d5;
        } else {
            d6 = d8 / this.treeBounds.getWidth();
            d5 = d7 / this.treeBounds.getHeight();
            d15 = -this.treeBounds.getX() * d6 + (this.treeBounds.getX() - ((RectangularShape)((Object)iterator)).getX());
            d16 = -this.treeBounds.getY() * d5 + (this.treeBounds.getY() - ((RectangularShape)((Object)iterator)).getY());
            this.treeScale = d6;
        }
        assert (this.treeScale > 0.0);
        this.transform = new AffineTransform();
        this.transform.translate(d15 + this.leftPanelBounds.getWidth(), d16 + this.topPanelBounds.getHeight());
        this.transform.scale(d6, d5);
        this.treeBounds = null;
        for (Shape shape6 : this.treeLayoutCache.getBranchPathMap().values()) {
            object = this.transform.createTransformedShape(shape6).getBounds2D();
            if (this.treeBounds == null) {
                this.treeBounds = object;
                continue;
            }
            this.treeBounds.add((Rectangle2D)object);
        }
        for (Shape shape7 : this.treeLayoutCache.getCollapsedShapeMap().values()) {
            object = this.transform.createTransformedShape(shape7).getBounds2D();
            if (this.treeBounds == null) {
                this.treeBounds = object;
                continue;
            }
            this.treeBounds.add((Rectangle2D)object);
        }
        if (!this.isTransformBranchesOn() && this.nodeBarPainter != null && this.nodeBarPainter.isVisible()) {
            this.nodeBars.clear();
            for (Node node : this.tree.getInternalNodes()) {
                object = this.nodeBarPainter.calibrate(graphics2D, node);
                if (object == null) continue;
                object = this.transform.createTransformedShape((Shape)object).getBounds2D();
                this.treeBounds.add((Rectangle2D)object);
                this.nodeBars.put(node, this.nodeBarPainter.getNodeBar());
            }
        }
        this.tipLabelBounds.clear();
        this.tipLabelTransforms.clear();
        this.tipLabelJustifications.clear();
        if (this.tipLabelPainter != null && this.tipLabelPainter.isVisible()) {
            double d17 = this.tipLabelPainter.getPreferredHeight();
            for (Node node : this.treeLayoutCache.getTipLabelPathMap().keySet()) {
                shape2 = this.treeLayoutCache.getTipLabelPath(node);
                double d18 = this.tipLabelWidths.get(node);
                shape = new Rectangle2D.Double(0.0, 0.0, d18, d17);
                affineTransform = this.calculateTransform(this.transform, (Line2D)shape2, d18, d17, true);
                this.tipLabelBounds.put(node, affineTransform.createTransformedShape(shape));
                this.tipLabelTransforms.put(node, affineTransform);
                Painter.Justification justification = ((Line2D)shape2).getX1() < ((Line2D)shape2).getX2() ? Painter.Justification.LEFT : Painter.Justification.RIGHT;
                this.tipLabelJustifications.put(node, justification);
            }
        }
        this.nodeLabelBounds.clear();
        this.nodeLabelTransforms.clear();
        this.nodeLabelJustifications.clear();
        if (this.nodeLabelPainter != null && this.nodeLabelPainter.isVisible()) {
            double d19 = this.nodeLabelPainter.getPreferredHeight();
            double d20 = this.nodeLabelPainter.getPreferredWidth();
            shape2 = new Rectangle2D.Double(0.0, 0.0, d20, d19);
            for (Node node : this.treeLayoutCache.getNodeLabelPathMap().keySet()) {
                shape = this.treeLayoutCache.getNodeLabelPath(node);
                affineTransform = this.calculateTransform(this.transform, (Line2D)shape, d20, d19, true);
                this.nodeLabelBounds.put(node, affineTransform.createTransformedShape(shape2));
                this.nodeLabelTransforms.put(node, affineTransform);
                if (((Line2D)shape).getX1() < ((Line2D)shape).getX2()) {
                    this.nodeLabelJustifications.put(node, Painter.Justification.LEFT);
                    continue;
                }
                this.nodeLabelJustifications.put(node, Painter.Justification.RIGHT);
            }
        }
        this.branchLabelBounds.clear();
        this.branchLabelTransforms.clear();
        this.branchLabelJustifications.clear();
        if (this.branchLabelPainter != null && this.branchLabelPainter.isVisible()) {
            for (Node node : this.treeLayoutCache.getBranchLabelPathMap().keySet()) {
                Line2D line2D = this.treeLayoutCache.getBranchLabelPath(node);
                double d21 = this.branchLabelPainter.getPreferredHeight();
                double d22 = this.branchLabelPainter.getPreferredWidth();
                shape = new Rectangle2D.Double(0.0, 0.0, d22, d21);
                double d23 = line2D.getP2().getX() - line2D.getP1().getX();
                double d24 = line2D.getP2().getY() - line2D.getP1().getY();
                double d25 = Math.sqrt(d23 * d23 + d24 * d24);
                Painter.Justification justification = line2D.getX1() < line2D.getX2() ? Painter.Justification.LEFT : Painter.Justification.RIGHT;
                AffineTransform affineTransform3 = this.calculateTransform(this.transform, line2D, d22, d21, false);
                double d26 = justification == Painter.Justification.RIGHT ? 1.0 : -1.0;
                affineTransform3.translate(-d26 * d6 * d25 / 2.0, 0.0);
                this.branchLabelBounds.put(node, affineTransform3.createTransformedShape(shape));
                this.branchLabelTransforms.put(node, affineTransform3);
                this.branchLabelJustifications.put(node, justification);
            }
        }
        this.nodeShapeTransforms.clear();
        if (this.nodeShapePainter != null && this.nodeShapePainter.isVisible()) {
            for (Node node : this.nodePoints.keySet()) {
                Line2D line2D = this.getTreeLayoutCache().getNodeShapePath(node);
                if (line2D == null) continue;
                this.nodeShapeTransforms.put(node, this.calculateTransform(this.transform, line2D));
            }
        }
        if (this.tipShapePainter != null && this.tipShapePainter.isVisible()) {
            for (Node node : this.tipPoints.keySet()) {
                Line2D line2D = this.getTreeLayoutCache().getNodeShapePath(node);
                if (line2D == null) continue;
                this.nodeShapeTransforms.put(node, this.calculateTransform(this.transform, line2D));
            }
        }
        d11 = d14;
        for (ScalePainter scalePainter : this.scalePainters) {
            if (!scalePainter.isVisible()) continue;
            scalePainter.calibrate(graphics2D, this);
            d11 -= scalePainter.getPreferredHeight();
        }
        this.bottomPanelBounds = new Rectangle2D.Double(0.0, d11, this.treeBounds.getWidth(), 0.0);
        for (ScalePainter scalePainter : this.scalePainters) {
            if (!scalePainter.isVisible()) continue;
            scalePainter.calibrate(graphics2D, this);
            double d27 = scalePainter.getPreferredHeight();
            shape2 = new Rectangle2D.Double(this.treeBounds.getX(), d11, this.treeBounds.getWidth(), d27);
            d11 += d27;
            this.bottomPanelBounds.add((Rectangle2D)shape2);
            this.scaleBounds.put(scalePainter, (Rectangle2D)shape2);
        }
        this.leftPanelBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        if (this.legendPainter != null && this.legendPainter.isVisible()) {
            this.legendPainter.calibrate(graphics2D, this);
            double d28 = this.legendPainter.getPreferredWidth();
            this.legendBounds = new Rectangle2D.Double(0.0, 0.0, d28, d14);
            this.leftPanelBounds.add(this.legendBounds);
        }
        this.calloutPaths.clear();
        this.clearSelectionPaths();
        this.calibrated = true;
    }

    private void calibrateTipLabels(Graphics2D graphics2D, Node node, Rectangle2D rectangle2D) {
        if (this.tree.isExternal(node) || node.getAttribute("!collapse") != null) {
            this.tipLabelPainter.calibrate(graphics2D, node);
            double d = this.tipLabelPainter.getPreferredWidth();
            double d2 = this.tipLabelPainter.getPreferredHeight();
            this.tipLabelWidths.put(node, d);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d, d2);
            Line2D line2D = this.treeLayoutCache.getTipLabelPath(node);
            if (line2D != null) {
                AffineTransform affineTransform = this.calculateTransform(null, line2D, d, d2, true);
                rectangle2D.add(affineTransform.createTransformedShape(double_).getBounds2D());
            }
        } else {
            for (Node node2 : this.tree.getChildren(node)) {
                this.calibrateTipLabels(graphics2D, node2, rectangle2D);
            }
        }
    }

    private AffineTransform calculateTransform(AffineTransform affineTransform, Line2D line2D, double d, double d2, boolean bl) {
        double d3;
        double d4;
        Point2D point2D = line2D.getP1();
        if (affineTransform != null) {
            affineTransform.transform(point2D, point2D);
        }
        AffineTransform affineTransform2 = new AffineTransform();
        double d5 = line2D.getY2() - line2D.getY1();
        if (d5 != 0.0) {
            d4 = line2D.getX2() - line2D.getX1();
            d3 = d4 != 0.0 ? Math.atan(d5 / d4) : 0.0;
            affineTransform2.rotate(d3, point2D.getX(), point2D.getY());
        }
        d4 = point2D.getY() - d2 / 2.0;
        d3 = point2D.getX();
        if (bl) {
            d3 = line2D.getX2() > line2D.getX1() ? (d3 += (double)this.labelXOffset) : (d3 -= (double)this.labelXOffset + d);
        }
        affineTransform2.translate(d3, d4);
        return affineTransform2;
    }

    private AffineTransform calculateTransform(AffineTransform affineTransform, Line2D line2D) {
        Point2D point2D = line2D.getP1();
        if (affineTransform != null) {
            affineTransform.transform(point2D, point2D);
        }
        AffineTransform affineTransform2 = new AffineTransform();
        double d = line2D.getY2() - line2D.getY1();
        if (d != 0.0) {
            double d2 = line2D.getX2() - line2D.getX1();
            double d3 = d2 != 0.0 ? Math.atan(d / d2) : 0.0;
            affineTransform2.rotate(d3, point2D.getX(), point2D.getY());
        }
        return affineTransform2;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.recalibrate();
        super.setBounds(n, n2, n3, n4);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.recalibrate();
        super.setBounds(rectangle);
    }

    @Override
    public void setSize(Dimension dimension) {
        this.recalibrate();
        super.setSize(dimension);
    }

    @Override
    public void setSize(int n, int n2) {
        this.recalibrate();
        super.setSize(n, n2);
    }

    public static enum RootingType {
        USER_ROOTING("User Selection"),
        MID_POINT("Midpoint");

        private String name;

        private RootingType(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

