/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.TreePane;
import jam.mac.Utils;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import jebl.evolution.graphs.Node;

public class TreePaneSelector
implements MouseListener,
MouseMotionListener,
KeyListener {
    private TreePane treePane;
    private SelectionMode defaultSelectionMode = SelectionMode.NODE;
    private SelectionMode selectionMode = SelectionMode.NODE;
    private ToolMode toolMode = ToolMode.SELECT;
    private DragMode dragMode = DragMode.SELECT;
    private Point2D dragPoint = null;
    private boolean crossHairCursor = false;

    public TreePaneSelector(TreePane treePane) {
        this.treePane = treePane;
        treePane.addMouseListener(this);
        treePane.addMouseMotionListener(this);
        treePane.addKeyListener(this);
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public DragMode getDragMode() {
        return this.dragMode;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.defaultSelectionMode = selectionMode;
        this.selectionMode = selectionMode;
    }

    public void setDragMode(DragMode dragMode) {
        this.dragMode = dragMode;
    }

    public void setToolMode(ToolMode toolMode) {
        this.toolMode = toolMode;
        this.setupCursor();
    }

    public boolean isCrossHairCursor() {
        return this.crossHairCursor;
    }

    public void setCrossHairCursor(boolean bl) {
        this.crossHairCursor = bl;
    }

    private void setupCursor() {
        if (this.toolMode != ToolMode.SELECT) {
            this.treePane.setCursor(Cursor.getPredefinedCursor(1));
            this.treePane.setCrosshairShown(this.crossHairCursor);
        } else if (this.dragMode == DragMode.SELECT) {
            if (this.crossHairCursor) {
                this.treePane.setCursor(Cursor.getPredefinedCursor(1));
            } else {
                this.treePane.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.treePane.setCrosshairShown(this.crossHairCursor);
        } else {
            this.treePane.setCursor(Cursor.getPredefinedCursor(12));
            this.treePane.setCrosshairShown(false);
        }
        this.treePane.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.treePane.getTree() == null) {
            return;
        }
        if (this.toolMode == ToolMode.ROOTING) {
            Node node = this.treePane.getNodeAt((Graphics2D)this.treePane.getGraphics(), mouseEvent.getPoint());
            if (node != null) {
                this.treePane.setRootLocation(node, 0.5);
            }
        } else if (this.toolMode == ToolMode.ROTATING) {
            Node node = this.treePane.getNodeAt((Graphics2D)this.treePane.getGraphics(), mouseEvent.getPoint());
            this.treePane.rotateNode(node);
        } else if (this.dragMode == DragMode.SELECT) {
            boolean bl = this.treePane.isCrosshairShown();
            this.treePane.setCrosshairShown(false);
            Node node = this.treePane.getNodeAt((Graphics2D)this.treePane.getGraphics(), mouseEvent.getPoint());
            boolean bl2 = mouseEvent.isShiftDown();
            boolean bl3 = this.isCommandKeyDown(mouseEvent);
            if (!bl2 && !bl3) {
                this.treePane.clearSelection();
            }
            SelectionMode selectionMode = this.selectionMode;
            if (mouseEvent.isAltDown()) {
                if (selectionMode == SelectionMode.NODE) {
                    selectionMode = SelectionMode.CLADE;
                } else if (selectionMode == SelectionMode.CLADE) {
                    selectionMode = SelectionMode.NODE;
                }
            }
            switch (selectionMode) {
                case NODE: {
                    this.treePane.addSelectedNode(node, bl3, bl2);
                    break;
                }
                case CLADE: {
                    this.treePane.addSelectedClade(node, bl3, bl2);
                    break;
                }
                case TAXA: {
                    this.treePane.addSelectedTip(node, bl3, bl2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown SelectionMode: " + this.selectionMode.name());
                }
            }
            this.treePane.setCrosshairShown(bl);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.treePane.requestFocus();
        this.dragPoint = new Point2D.Double(mouseEvent.getPoint().getX(), mouseEvent.getPoint().getY());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.treePane.getTree() == null) {
            return;
        }
        if (this.dragMode == DragMode.SELECT && this.treePane.getDragRectangle() != null) {
            Set<Node> set = this.treePane.getNodesAt((Graphics2D)this.treePane.getGraphics(), this.treePane.getDragRectangle().getBounds());
            boolean bl = mouseEvent.isShiftDown();
            boolean bl2 = this.isCommandKeyDown(mouseEvent);
            if (!bl && !bl2) {
                this.treePane.clearSelection();
            }
            SelectionMode selectionMode = this.selectionMode;
            if (mouseEvent.isAltDown()) {
                if (selectionMode == SelectionMode.NODE) {
                    selectionMode = SelectionMode.CLADE;
                } else if (selectionMode == SelectionMode.CLADE) {
                    selectionMode = SelectionMode.NODE;
                }
            }
            block5: for (Node node : set) {
                switch (selectionMode) {
                    case NODE: {
                        this.treePane.addSelectedNode(node, bl2, bl);
                        continue block5;
                    }
                    case CLADE: {
                        this.treePane.addSelectedClade(node, bl2, bl);
                        continue block5;
                    }
                    case TAXA: {
                        this.treePane.addSelectedTip(node, bl2, bl);
                        continue block5;
                    }
                }
                throw new IllegalArgumentException("Unknown SelectionMode: " + this.selectionMode.name());
            }
        }
        this.treePane.setDragRectangle(null);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.isCommandKeyDown(mouseEvent)) {
            this.treePane.setCursorPosition(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.isCommandKeyDown(mouseEvent)) {
            this.treePane.setCursorPosition(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.isCommandKeyDown(mouseEvent)) {
            this.treePane.setCursorPosition(mouseEvent.getPoint());
        }
    }

    private boolean isCommandKeyDown(InputEvent inputEvent) {
        return Utils.isMacOSX() ? inputEvent.isMetaDown() : inputEvent.isControlDown();
    }

    private boolean isOptionKeyDown(InputEvent inputEvent) {
        return inputEvent.isAltDown();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.toolMode != ToolMode.SELECT || this.dragPoint == null) {
            return;
        }
        if (this.dragMode == DragMode.SCROLL) {
            int n = (int)((double)mouseEvent.getX() - this.dragPoint.getX());
            int n2 = (int)((double)mouseEvent.getY() - this.dragPoint.getY());
            Rectangle rectangle = this.treePane.getVisibleRect();
            n = n > 0 ? rectangle.x - n : rectangle.x + rectangle.width - n;
            n2 = n2 > 0 ? rectangle.y - n2 : rectangle.y + rectangle.height - n2;
            Rectangle rectangle2 = new Rectangle(n, n2, 1, 1);
            this.treePane.scrollRectToVisible(rectangle2);
        } else {
            double d = Math.min(this.dragPoint.getX(), mouseEvent.getPoint().getX());
            double d2 = Math.min(this.dragPoint.getY(), mouseEvent.getPoint().getY());
            double d3 = Math.max(this.dragPoint.getX(), mouseEvent.getPoint().getX());
            double d4 = Math.max(this.dragPoint.getY(), mouseEvent.getPoint().getY());
            this.treePane.setDragRectangle(new Rectangle2D.Double(d, d2, d3 - d, d4 - d2));
            this.treePane.scrollPointToVisible(mouseEvent.getPoint());
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            this.dragMode = DragMode.SCROLL;
        }
        if (this.isOptionKeyDown(keyEvent)) {
            switch (this.defaultSelectionMode) {
                case NODE: 
                case CLADE: {
                    this.selectionMode = SelectionMode.TAXA;
                    break;
                }
                case TAXA: {
                    this.selectionMode = SelectionMode.NODE;
                }
            }
        } else {
            this.selectionMode = this.defaultSelectionMode;
        }
        this.crossHairCursor = this.isCommandKeyDown(keyEvent);
        this.setupCursor();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            this.dragMode = DragMode.SELECT;
        }
        this.crossHairCursor = this.isCommandKeyDown(keyEvent);
        this.setupCursor();
    }

    public static enum ToolMode {
        SELECT,
        ROOTING,
        CARTOONING,
        COLLAPSING,
        ROTATING,
        ANNOTATING,
        COLOURING;

    }

    public static enum DragMode {
        SELECT,
        SCROLL;

    }

    public static enum SelectionMode {
        NODE,
        CLADE,
        TAXA;

    }
}

