/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer;

import figtree.treeviewer.AttributeColourController;
import figtree.treeviewer.DefaultTreeViewer;
import figtree.treeviewer.TimeScaleController;
import figtree.treeviewer.TreeAppearanceController;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.TreeViewerController;
import figtree.treeviewer.TreesController;
import figtree.treeviewer.painters.BasicLabelPainter;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.painters.LabelPainterController;
import figtree.treeviewer.painters.NodeBarController;
import figtree.treeviewer.painters.NodeBarPainter;
import jam.controlpalettes.BasicControlPalette;
import jam.controlpalettes.ControlPalette;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jebl.evolution.io.NexusImporter;
import jebl.evolution.trees.Tree;

public class TreeViewerPanel
extends JPanel {
    private final TreeViewer treeViewer;
    private final ControlPalette controlPalette;

    public TreeViewerPanel(JFrame jFrame, TreeViewer treeViewer, ControlPalette controlPalette) {
        this.treeViewer = treeViewer;
        this.controlPalette = controlPalette;
        controlPalette.getPanel().setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY));
        controlPalette.getPanel().setBackground(new Color(231, 237, 246));
        controlPalette.getPanel().setOpaque(true);
        controlPalette.addController(new TreeViewerController(treeViewer));
        AttributeColourController attributeColourController = new AttributeColourController(treeViewer, jFrame);
        controlPalette.addController(attributeColourController);
        controlPalette.addController(new TreeAppearanceController(treeViewer, jFrame, attributeColourController));
        controlPalette.addController(new TreesController(treeViewer));
        BasicLabelPainter basicLabelPainter = new BasicLabelPainter(LabelPainter.PainterIntent.TIP);
        controlPalette.addController(new LabelPainterController("Tip Labels", "tipLabels", basicLabelPainter, jFrame, attributeColourController, treeViewer));
        treeViewer.setTipLabelPainter(basicLabelPainter);
        BasicLabelPainter basicLabelPainter2 = new BasicLabelPainter(LabelPainter.PainterIntent.NODE);
        basicLabelPainter2.setVisible(false);
        controlPalette.addController(new LabelPainterController("Node Labels", "nodeLabels", basicLabelPainter2, jFrame, attributeColourController, treeViewer));
        treeViewer.setNodeLabelPainter(basicLabelPainter2);
        NodeBarPainter nodeBarPainter = new NodeBarPainter();
        nodeBarPainter.setForeground(new Color(24, 32, 228, 128));
        nodeBarPainter.setVisible(false);
        controlPalette.addController(new NodeBarController("Node Bars", nodeBarPainter, treeViewer));
        treeViewer.setNodeBarPainter(nodeBarPainter);
        BasicLabelPainter basicLabelPainter3 = new BasicLabelPainter(LabelPainter.PainterIntent.BRANCH);
        basicLabelPainter3.setVisible(false);
        controlPalette.addController(new LabelPainterController("Branch Labels", "branchLabels", basicLabelPainter3, jFrame, attributeColourController, treeViewer));
        treeViewer.setBranchLabelPainter(basicLabelPainter3);
        controlPalette.addController(new TimeScaleController(treeViewer));
        this.setLayout(new BorderLayout());
        this.add((Component)treeViewer, "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)controlPalette.getPanel(), "North");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        this.add((Component)jScrollPane, "West");
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public ControlPalette getControlPalette() {
        return this.controlPalette;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("TreeViewer Test");
        DefaultTreeViewer defaultTreeViewer = new DefaultTreeViewer(jFrame);
        BasicControlPalette basicControlPalette = new BasicControlPalette(200, BasicControlPalette.DisplayMode.ONLY_ONE_OPEN);
        jFrame.getContentPane().add((Component)new TreeViewerPanel(jFrame, defaultTreeViewer, basicControlPalette), "Center");
        try {
            Object object;
            File file = null;
            if (stringArray.length > 0) {
                file = new File(stringArray[0]);
            }
            if (file == null) {
                object = new FileDialog((Frame)jFrame, "Select NEXUS Tree File", 0);
                ((Dialog)object).setVisible(true);
                file = new File(((FileDialog)object).getDirectory(), ((FileDialog)object).getFile());
                ((Window)object).dispose();
            }
            if (file == null) {
                throw new RuntimeException("No file specified");
            }
            object = new BufferedReader(new FileReader(file));
            NexusImporter nexusImporter = new NexusImporter((Reader)object);
            List<Tree> list = nexusImporter.importTrees();
            ((Reader)object).close();
            ((TreeViewer)defaultTreeViewer).setTrees(list);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        jFrame.setSize(640, 480);
        jFrame.setVisible(true);
    }
}

