/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.decorators;

import figtree.treeviewer.decorators.Decorator;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import jebl.util.Attributable;

public class AttributableDecorator
implements Decorator {
    private String paintAttributeName = null;
    private String fontAttributeName = null;
    private String strokeAttributeName = null;
    private Paint paint = null;
    private Paint fillPaint = null;
    private Font font = null;
    private Stroke stroke = null;
    private boolean isGradient;
    private Color colour1 = null;
    private Color colour2 = null;
    private Color fillColour1 = null;
    private Color fillColour2 = null;

    @Override
    public Paint getPaint(Paint paint) {
        if (this.paint == null) {
            return paint;
        }
        return this.paint;
    }

    @Override
    public boolean allowsGradient() {
        return true;
    }

    @Override
    public Paint getFillPaint(Paint paint) {
        if (this.fillPaint == null) {
            return paint;
        }
        return this.fillPaint;
    }

    @Override
    public Paint getPaint(Paint paint, Point2D point2D, Point2D point2D2) {
        if (this.colour1 != null && this.colour2 != null) {
            return new GradientPaint(point2D, this.colour1, point2D2, this.colour2, false);
        }
        return paint;
    }

    @Override
    public Paint getFillPaint(Paint paint, Point2D point2D, Point2D point2D2) {
        if (this.fillColour1 != null && this.fillColour2 != null) {
            return new GradientPaint(point2D, this.fillColour1, point2D2, this.fillColour2, false);
        }
        return paint;
    }

    @Override
    public Stroke getStroke(Stroke stroke) {
        if (this.stroke == null) {
            return stroke;
        }
        return this.stroke;
    }

    @Override
    public Font getFont(Font font) {
        if (this.font == null) {
            return font;
        }
        return this.font;
    }

    public boolean isGradient() {
        return this.isGradient;
    }

    public void setGradient(boolean bl) {
        this.isGradient = bl;
    }

    @Override
    public void setItem(Attributable attributable, Attributable attributable2) {
        this.setAttributableItem(attributable != null ? attributable : attributable2);
    }

    @Override
    public void setItem(Object object) {
        if (object instanceof Attributable) {
            this.setAttributableItem((Attributable)object);
        }
    }

    @Override
    public void setItems(Object object, Object object2) {
        if (object2 == null) {
            this.setItem(object);
            return;
        }
        if (object == null) {
            this.setItem(object2);
            return;
        }
        if (object instanceof Attributable) {
            this.setAttributableItem((Attributable)object);
        }
        if (object2 instanceof Attributable && this.paintAttributeName != null) {
            this.colour2 = this.getColorAttribute(((Attributable)object2).getAttribute(this.paintAttributeName));
            this.fillColour2 = this.colour2 != null ? this.colour2.brighter() : null;
        }
    }

    public String getFontAttributeName() {
        return this.fontAttributeName;
    }

    public void setFontAttributeName(String string) {
        this.fontAttributeName = string;
    }

    public String getPaintAttributeName() {
        return this.paintAttributeName;
    }

    public void setPaintAttributeName(String string) {
        this.paintAttributeName = string;
    }

    public String getStrokeAttributeName() {
        return this.strokeAttributeName;
    }

    public void setStrokeAttributeName(String string) {
        this.strokeAttributeName = string;
    }

    private void setAttributableItem(Attributable attributable) {
        if (this.paintAttributeName != null) {
            this.colour1 = this.getColorAttribute(attributable.getAttribute(this.paintAttributeName));
            if (this.colour1 != null) {
                this.fillColour1 = this.colour1.brighter();
                this.paint = this.colour1;
                this.fillPaint = this.fillColour1;
            } else {
                this.fillColour1 = null;
                this.paint = null;
                this.fillPaint = null;
            }
        }
        if (this.fontAttributeName != null) {
            this.font = this.getFontAttribute(attributable.getAttribute(this.fontAttributeName));
        }
        if (this.strokeAttributeName != null) {
            this.stroke = this.getStrokeAttribute(attributable.getAttribute(this.strokeAttributeName));
        }
    }

    private Color getColorAttribute(Object object) {
        if (object != null) {
            if (object instanceof Color) {
                return (Color)object;
            }
            try {
                return Color.decode(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private Font getFontAttribute(Object object) {
        if (object != null) {
            return Font.decode(object.toString());
        }
        return null;
    }

    private Stroke getStrokeAttribute(Object object) {
        return null;
    }
}

