/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.decorators;

import figtree.treeviewer.decorators.ContinuousColourDecorator;
import figtree.treeviewer.decorators.ContinuousScale;
import java.awt.Color;

public class InterpolatingColourDecorator
extends ContinuousColourDecorator {
    public static final Color DEFAULT_COLOR_1 = Color.getHSBColor(0.01f, 0.7f, 0.85f);
    public static final Color DEFAULT_COLOR_2 = Color.getHSBColor(0.63f, 0.7f, 0.85f);
    public static final Color DEFAULT_COLOR_3 = Color.BLACK;
    private float[] color1;
    private float[] color2;
    private float[] color3;

    public InterpolatingColourDecorator(String string, String string2) {
        super(string);
        this.setup(string2);
    }

    public InterpolatingColourDecorator(ContinuousScale continuousScale) throws NumberFormatException {
        super(continuousScale);
        this.setColours(DEFAULT_COLOR_1, DEFAULT_COLOR_2);
    }

    public InterpolatingColourDecorator(ContinuousScale continuousScale, Color color, Color color2) throws NumberFormatException {
        super(continuousScale);
        this.setColours(color, color2);
    }

    public InterpolatingColourDecorator(ContinuousScale continuousScale, Color color, Color color2, Color color3) throws NumberFormatException {
        super(continuousScale);
        this.setColours(color, color2, color3);
    }

    public void setColours(Color color, Color color2) {
        this.color1 = new float[4];
        color.getRGBComponents(this.color1);
        this.color2 = new float[4];
        color2.getRGBComponents(this.color2);
        this.color3 = null;
    }

    public void setColours(Color color, Color color2, Color color3) {
        this.color1 = new float[4];
        color.getRGBComponents(this.color1);
        this.color2 = new float[4];
        color2.getRGBComponents(this.color2);
        this.color3 = new float[4];
        color3.getRGBComponents(this.color3);
    }

    public Color getColor1() {
        if (this.color1 == null) {
            return null;
        }
        return new Color(this.color1[0], this.color1[1], this.color1[2], this.color1[3]);
    }

    public Color getColor2() {
        if (this.color2 == null) {
            return null;
        }
        return new Color(this.color2[0], this.color2[1], this.color2[2], this.color2[3]);
    }

    public Color getColor3() {
        if (this.color3 == null) {
            return null;
        }
        return new Color(this.color3[0], this.color3[1], this.color3[2], this.color3[3]);
    }

    @Override
    public Color getColourForScaledValue(double d) {
        if (!Double.isNaN(d)) {
            if (this.color3 != null) {
                if (d < 0.5) {
                    float f = (float)d * 2.0f;
                    float f2 = 1.0f - f;
                    return new Color(this.color2[0] * f + this.color1[0] * f2, this.color2[1] * f + this.color1[1] * f2, this.color2[2] * f + this.color1[2] * f2, this.color2[3] * f + this.color1[3] * f2);
                }
                float f = (float)(d - 0.5) * 2.0f;
                float f3 = 1.0f - f;
                return new Color(this.color3[0] * f + this.color2[0] * f3, this.color3[1] * f + this.color2[1] * f3, this.color3[2] * f + this.color2[2] * f3, this.color3[3] * f + this.color2[3] * f3);
            }
            float f = (float)d;
            float f4 = 1.0f - f;
            return new Color(this.color2[0] * f + this.color1[0] * f4, this.color2[1] * f + this.color1[1] * f4, this.color2[2] * f + this.color1[2] * f4, this.color2[3] * f + this.color1[3] * f4);
        }
        return null;
    }

    @Override
    public void setup(String string) {
        if (!string.startsWith("{") || !string.endsWith("}")) {
            throw new IllegalArgumentException("InterpolatingColourDecorator settings string not in correct format");
        }
        String[] stringArray = string.substring(1, string.length() - 1).split("}[, ]+");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("InterpolatingColourDecorator settings string not in correct format");
        }
        String[] stringArray2 = stringArray[1].split("[, ]+");
        if (stringArray2.length != 2 && stringArray2.length != 3) {
            throw new IllegalArgumentException("InterpolatingColourDecorator settings string not in correct format");
        }
        try {
            this.setContinuousScale(new ContinuousScale(stringArray[0]));
            if (stringArray2.length == 3) {
                this.setColours(this.parseColor(stringArray2[0]), this.parseColor(stringArray2[1]), this.parseColor(stringArray2[2]));
            } else {
                this.setColours(this.parseColor(stringArray2[0]), this.parseColor(stringArray2[1]));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("InterpolatingColourDecorator settings string not in correct format");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("InterpolatingColourDecorator settings string not in correct format");
        }
    }

    private Color parseColor(String string) {
        if (string.startsWith("#")) {
            try {
                return Color.decode(string.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append(this.getContinuousScale().toString());
        stringBuilder.append(",#");
        stringBuilder.append(new Color(this.color1[0], this.color1[1], this.color1[2], this.color1[3]).getRGB());
        stringBuilder.append(",#");
        stringBuilder.append(new Color(this.color2[0], this.color2[1], this.color2[2], this.color2[3]).getRGB());
        if (this.color3 != null) {
            stringBuilder.append(",#");
            stringBuilder.append(new Color(this.color3[0], this.color3[1], this.color3[2], this.color3[3]).getRGB());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

