/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.decorators;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import jebl.evolution.alignments.Pattern;
import jebl.evolution.graphs.Node;
import jebl.evolution.parsimony.FitchParsimony;
import jebl.evolution.parsimony.ParsimonyCriterion;
import jebl.evolution.sequences.AminoAcids;
import jebl.evolution.sequences.Nucleotides;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import jebl.evolution.trees.Tree;

public class ParsimonyBranchDecorator {
    private final ParsimonyCriterion parsimony;
    private final Paint[] paints;

    public ParsimonyBranchDecorator(Pattern pattern) {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        arrayList.add(pattern);
        this.parsimony = new FitchParsimony(arrayList, true);
        if (pattern.getSequenceType() == SequenceType.NUCLEOTIDE) {
            this.paints = new Paint[Nucleotides.getStateCount()];
            this.paints[Nucleotides.A_STATE.getIndex()] = Color.RED;
            this.paints[Nucleotides.C_STATE.getIndex()] = Color.BLUE;
            this.paints[Nucleotides.G_STATE.getIndex()] = Color.BLACK;
            this.paints[Nucleotides.T_STATE.getIndex()] = Color.GREEN;
            this.paints[Nucleotides.R_STATE.getIndex()] = Color.MAGENTA;
            this.paints[Nucleotides.Y_STATE.getIndex()] = Color.DARK_GRAY;
            this.paints[Nucleotides.M_STATE.getIndex()] = Color.DARK_GRAY;
            this.paints[Nucleotides.W_STATE.getIndex()] = Color.DARK_GRAY;
            this.paints[Nucleotides.S_STATE.getIndex()] = Color.DARK_GRAY;
            this.paints[Nucleotides.K_STATE.getIndex()] = Color.DARK_GRAY;
            this.paints[Nucleotides.B_STATE.getIndex()] = Color.DARK_GRAY;
            this.paints[Nucleotides.D_STATE.getIndex()] = Color.DARK_GRAY;
            this.paints[Nucleotides.H_STATE.getIndex()] = Color.DARK_GRAY;
            this.paints[Nucleotides.V_STATE.getIndex()] = Color.DARK_GRAY;
            this.paints[Nucleotides.N_STATE.getIndex()] = Color.GRAY;
            this.paints[Nucleotides.UNKNOWN_STATE.getIndex()] = Color.GRAY;
            this.paints[Nucleotides.GAP_STATE.getIndex()] = Color.GRAY;
        } else if (pattern.getSequenceType() == SequenceType.AMINO_ACID) {
            this.paints = new Paint[AminoAcids.getStateCount()];
            this.paints[AminoAcids.A_STATE.getIndex()] = new Color(204, 255, 255);
            this.paints[AminoAcids.C_STATE.getIndex()] = new Color(0, 255, 255);
            this.paints[AminoAcids.D_STATE.getIndex()] = new Color(255, 204, 153);
            this.paints[AminoAcids.E_STATE.getIndex()] = new Color(255, 204, 0);
            this.paints[AminoAcids.F_STATE.getIndex()] = new Color(0, 204, 255);
            this.paints[AminoAcids.G_STATE.getIndex()] = new Color(0, 255, 0);
            this.paints[AminoAcids.H_STATE.getIndex()] = new Color(255, 255, 153);
            this.paints[AminoAcids.I_STATE.getIndex()] = new Color(0, 0, 128);
            this.paints[AminoAcids.K_STATE.getIndex()] = new Color(198, 66, 0);
            this.paints[AminoAcids.L_STATE.getIndex()] = new Color(51, 102, 255);
            this.paints[AminoAcids.M_STATE.getIndex()] = new Color(153, 204, 255);
            this.paints[AminoAcids.N_STATE.getIndex()] = new Color(255, 153, 0);
            this.paints[AminoAcids.P_STATE.getIndex()] = new Color(255, 255, 0);
            this.paints[AminoAcids.Q_STATE.getIndex()] = new Color(255, 102, 0);
            this.paints[AminoAcids.R_STATE.getIndex()] = new Color(230, 6, 6);
            this.paints[AminoAcids.S_STATE.getIndex()] = new Color(204, 255, 153);
            this.paints[AminoAcids.T_STATE.getIndex()] = new Color(0, 255, 153);
            this.paints[AminoAcids.V_STATE.getIndex()] = new Color(0, 0, 255);
            this.paints[AminoAcids.W_STATE.getIndex()] = new Color(204, 153, 255);
            this.paints[AminoAcids.Y_STATE.getIndex()] = new Color(204, 255, 204);
            this.paints[AminoAcids.B_STATE.getIndex()] = Color.DARK_GRAY;
            this.paints[AminoAcids.Z_STATE.getIndex()] = Color.DARK_GRAY;
            this.paints[AminoAcids.X_STATE.getIndex()] = Color.GRAY;
            this.paints[AminoAcids.UNKNOWN_STATE.getIndex()] = Color.GRAY;
            this.paints[AminoAcids.STOP_STATE.getIndex()] = Color.GRAY;
            this.paints[AminoAcids.GAP_STATE.getIndex()] = Color.GRAY;
        } else {
            throw new IllegalArgumentException("Unsupported sequence type");
        }
    }

    public Paint getBranchPaint(Tree tree, Node node) {
        State[] stateArray = this.parsimony.getStates(tree, node);
        return this.paints[stateArray[0].getIndex()];
    }
}

