/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.TimeScale;
import figtree.treeviewer.TreePane;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.painters.LabelPainter;
import figtree.treeviewer.painters.Painter;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;

public class BasicLabelPainter
extends LabelPainter<Node> {
    private double preferredWidth;
    private double preferredHeight;
    private float yOffset;
    protected String displayAttribute = "";
    protected TreePane treePane;
    private Decorator textDecorator = null;
    private Decorator borderDecorator = null;

    public BasicLabelPainter(LabelPainter.PainterIntent painterIntent) {
        super(painterIntent);
    }

    @Override
    public void setTreePane(TreePane treePane) {
        this.treePane = treePane;
    }

    public Decorator getBorderDecorator() {
        return this.borderDecorator;
    }

    public void setBorderDecorator(Decorator decorator) {
        this.borderDecorator = decorator;
        this.firePainterSettingsChanged();
    }

    public Decorator getTextDecorator() {
        return this.textDecorator;
    }

    @Override
    public void setTextDecorator(Decorator decorator) {
        this.textDecorator = decorator;
        this.firePainterSettingsChanged();
    }

    public Tree getTree() {
        return this.treePane.getTree();
    }

    protected String getLabel(Tree tree, Node node) {
        Object object;
        if (this.displayAttribute.equalsIgnoreCase("Names")) {
            if (this.getIntent() == LabelPainter.PainterIntent.TIP) {
                Taxon taxon = tree.getTaxon(node);
                if (taxon != null) {
                    String string;
                    if (this.textDecorator != null) {
                        this.textDecorator.setItem(taxon);
                    }
                    if ((string = (String)taxon.getAttribute("!name")) != null) {
                        return string;
                    }
                    return taxon.getName();
                }
                String string = (String)node.getAttribute("!name");
                if (string != null) {
                    return string;
                }
                return null;
            }
            String string = (String)node.getAttribute("!name");
            if (string != null) {
                return string;
            }
            return null;
        }
        if (tree instanceof RootedTree) {
            object = (RootedTree)tree;
            if (this.textDecorator != null) {
                this.textDecorator.setItem(node);
            }
            if (this.displayAttribute.equalsIgnoreCase("Node ages")) {
                TimeScale timeScale = this.treePane.getTimeScale();
                double d = timeScale.getAge(object.getHeight(node), (RootedTree)object);
                return this.getNumberFormat().format(d);
            }
            if (this.displayAttribute.equalsIgnoreCase("Node heights (raw)")) {
                return this.getNumberFormat().format(object.getHeight(node));
            }
            if (this.displayAttribute.equalsIgnoreCase("Branch times")) {
                TimeScale timeScale = this.treePane.getTimeScale();
                double d = timeScale.getTime(object.getLength(node), (RootedTree)object);
                return this.getNumberFormat().format(d);
            }
            if (this.displayAttribute.equalsIgnoreCase("Branch lengths (raw)")) {
                return this.getNumberFormat().format(object.getLength(node));
            }
        }
        object = null;
        if (this.getIntent() == LabelPainter.PainterIntent.TIP) {
            Taxon taxon = tree.getTaxon(node);
            object = taxon != null ? taxon.getAttribute(this.displayAttribute) : node.getAttribute(this.displayAttribute);
        }
        if (object == null) {
            object = node.getAttribute(this.displayAttribute);
        }
        return this.formatValue(object);
    }

    private String formatValue(Object object) {
        if (object != null) {
            if (object instanceof Double) {
                return this.getNumberFormat().format(object);
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                if (objectArray.length == 0) {
                    return null;
                }
                if (objectArray.length == 1) {
                    return this.formatValue(objectArray[0]);
                }
                StringBuilder stringBuilder = new StringBuilder("[");
                stringBuilder.append(this.formatValue(objectArray[0]));
                for (int i = 1; i < objectArray.length; ++i) {
                    stringBuilder.append(",");
                    stringBuilder.append(this.formatValue(objectArray[i]));
                }
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
            return object.toString();
        }
        return null;
    }

    @Override
    public Rectangle2D calibrate(Graphics2D graphics2D, Node node) {
        RootedTree rootedTree = this.treePane.getTree();
        String string = this.getLabel(rootedTree, node);
        Font font = graphics2D.getFont();
        if (this.textDecorator != null) {
            graphics2D.setFont(this.textDecorator.getFont(this.getFont()));
        } else {
            graphics2D.setFont(this.getFont());
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.preferredHeight = fontMetrics.getHeight();
        this.preferredWidth = 0.0;
        if (string != null) {
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
            this.preferredWidth = rectangle2D.getWidth();
        }
        this.yOffset = fontMetrics.getAscent();
        graphics2D.setFont(font);
        return new Rectangle2D.Double(0.0, 0.0, this.preferredWidth, this.preferredHeight);
    }

    @Override
    public double getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public double getPreferredHeight() {
        return this.preferredHeight;
    }

    @Override
    public double getHeightBound() {
        return this.preferredHeight + (double)this.yOffset;
    }

    @Override
    public void paint(Graphics2D graphics2D, Node node, Painter.Justification justification, Rectangle2D rectangle2D) {
        RootedTree rootedTree = this.treePane.getTree();
        String string = this.getLabel(rootedTree, node);
        Font font = graphics2D.getFont();
        Paint paint = this.getBackground();
        Paint paint2 = this.getBorderPaint();
        Stroke stroke = this.getBorderStroke();
        if (this.borderDecorator != null) {
            paint = this.borderDecorator.getPaint(paint);
            paint2 = this.borderDecorator.getPaint(paint2);
            stroke = this.borderDecorator.getStroke(stroke);
        }
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(rectangle2D);
        }
        if (paint2 != null && stroke != null) {
            graphics2D.setPaint(paint2);
            graphics2D.setStroke(stroke);
            graphics2D.draw(rectangle2D);
        }
        if (this.textDecorator != null) {
            if (this.getIntent() == LabelPainter.PainterIntent.TIP) {
                this.textDecorator.setItem(rootedTree.getTaxon(node), node);
            } else {
                this.textDecorator.setItem(node);
            }
            graphics2D.setPaint(this.textDecorator.getPaint(this.getForeground()));
            graphics2D.setFont(this.textDecorator.getFont(this.getFont()));
        } else {
            graphics2D.setPaint(this.getForeground());
            graphics2D.setFont(this.getFont());
        }
        if (string != null) {
            float f;
            Rectangle2D rectangle2D2 = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            float f2 = this.yOffset + (float)rectangle2D.getY();
            switch (justification) {
                case CENTER: {
                    f = (float)(-rectangle2D2.getWidth() / 2.0);
                    f2 = this.yOffset + (float)rectangle2D2.getY();
                    break;
                }
                case FLUSH: 
                case LEFT: {
                    f = (float)rectangle2D.getX();
                    break;
                }
                case RIGHT: {
                    f = (float)(rectangle2D.getX() + rectangle2D.getWidth() - rectangle2D2.getWidth());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized alignment enum option");
                }
            }
            graphics2D.drawString(string, f, f2);
        }
        graphics2D.setFont(font);
    }

    @Override
    public String getDisplayAttribute() {
        if (this.displayAttribute.equalsIgnoreCase("Names") || this.displayAttribute.equalsIgnoreCase("Node ages") || this.displayAttribute.equalsIgnoreCase("Node heights (raw)") || this.displayAttribute.equalsIgnoreCase("Branch times") || this.displayAttribute.equalsIgnoreCase("Branch lengths (raw)")) {
            return null;
        }
        return this.displayAttribute;
    }

    @Override
    public void setDisplayAttribute(String string) {
        this.displayAttribute = string;
        this.firePainterChanged();
    }
}

