/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.AttributeColourController;
import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.FontDialog;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.decorators.AttributableDecorator;
import figtree.treeviewer.decorators.CompoundDecorator;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.painters.AttributeComboHelper;
import figtree.treeviewer.painters.AttributeComboHelperListener;
import figtree.treeviewer.painters.LabelPainter;
import figtree.ui.PercentFormat;
import figtree.ui.RomanFormat;
import jam.controlpalettes.AbstractController;
import jam.controlpalettes.ControllerListener;
import jam.panels.OptionsPanel;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LabelPainterController
extends AbstractController {
    public static Preferences PREFS = Preferences.userNodeForPackage(TreeViewer.class);
    private static final String USER_SELECTION = "User Selection";
    public static final String FONT_NAME_KEY = "fontName";
    public static final String FONT_SIZE_KEY = "fontSize";
    public static final String FONT_STYLE_KEY = "fontStyle";
    public static final String COLOR_ATTRIBUTE_KEY = "colorAttribute";
    public static final String NUMBER_FORMATTING_KEY = "numberFormatting";
    public static final String DISPLAY_ATTRIBUTE_KEY = "displayAttribute";
    public static final String SIGNIFICANT_DIGITS_KEY = "significantDigits";
    public static String DEFAULT_FONT_NAME = "sansserif";
    public static int DEFAULT_FONT_SIZE = 8;
    public static int DEFAULT_FONT_STYLE = 0;
    public static String DECIMAL_NUMBER_FORMATTING = "#.####";
    public static String SCIENTIFIC_NUMBER_FORMATTING = "0.###E0";
    public static int DEFAULT_SIGNIFICANT_DIGITS = 2;
    public static String DEFAULT_NUMBER_FORMATTING = DECIMAL_NUMBER_FORMATTING;
    private final AttributeColourController colourController;
    private final JCheckBox titleCheckBox;
    private final OptionsPanel optionsPanel;
    private final JComboBox displayAttributeCombo;
    private final JSpinner fontSizeSpinner;
    private FontDialog fontDialog = null;
    private final JComboBox numericalFormatCombo;
    private final JSpinner digitsSpinner;
    private final String title;
    private final String key;
    private final LabelPainter labelPainter;
    private final AttributableDecorator userLabelDecorator;
    private final JComboBox colourAttributeCombo;

    public LabelPainterController(String string, String string2, final LabelPainter labelPainter, final JFrame jFrame, AttributeColourController attributeColourController, TreeViewer treeViewer) {
        this.title = string;
        this.key = string2;
        this.labelPainter = labelPainter;
        LabelPainter.PainterIntent painterIntent = labelPainter.getIntent();
        this.userLabelDecorator = new AttributableDecorator();
        this.userLabelDecorator.setPaintAttributeName("!color");
        this.userLabelDecorator.setFontAttributeName("!font");
        labelPainter.setTextDecorator(this.userLabelDecorator);
        String string3 = PREFS.get(string2 + "." + FONT_NAME_KEY, DEFAULT_FONT_NAME);
        int n = PREFS.getInt(string2 + "." + FONT_STYLE_KEY, DEFAULT_FONT_STYLE);
        int n2 = PREFS.getInt(string2 + "." + FONT_SIZE_KEY, DEFAULT_FONT_SIZE);
        int n3 = PREFS.getInt(string2 + "." + SIGNIFICANT_DIGITS_KEY, DEFAULT_SIGNIFICANT_DIGITS);
        String string4 = PREFS.get(string2 + "." + NUMBER_FORMATTING_KEY, DEFAULT_NUMBER_FORMATTING);
        labelPainter.setFont(new Font(string3, n, n2));
        labelPainter.setNumberFormat(new DecimalFormat(string4));
        this.optionsPanel = new ControllerOptionsPanel(2, 2);
        this.titleCheckBox = new JCheckBox(this.getTitle());
        this.titleCheckBox.setSelected(labelPainter.isVisible());
        this.displayAttributeCombo = new JComboBox<String>(new String[]{"No attributes"});
        new AttributeComboHelper(this.displayAttributeCombo, treeViewer, painterIntent).addListener(new AttributeComboHelperListener(){

            @Override
            public void attributeComboChanged() {
                String string = (String)LabelPainterController.this.displayAttributeCombo.getSelectedItem();
                labelPainter.setDisplayAttribute(string);
            }
        });
        this.colourAttributeCombo = new JComboBox<String>(new String[]{"No attributes"});
        new AttributeComboHelper(this.colourAttributeCombo, treeViewer, "User selection", painterIntent).addListener(new AttributeComboHelperListener(){

            @Override
            public void attributeComboChanged() {
                String string = (String)LabelPainterController.this.colourAttributeCombo.getSelectedItem();
                LabelPainterController.this.setupLabelDecorator();
            }
        });
        JButton jButton = new JButton("Colour");
        this.colourController = attributeColourController;
        attributeColourController.setupControls(this.colourAttributeCombo, jButton);
        attributeColourController.addControllerListener(new ControllerListener(){

            @Override
            public void controlsChanged() {
                LabelPainterController.this.setupLabelDecorator();
            }
        });
        JButton jButton2 = new JButton(new AbstractAction("Font"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                Font font = labelPainter.getFont();
                if (LabelPainterController.this.fontDialog == null) {
                    LabelPainterController.this.fontDialog = new FontDialog(jFrame);
                }
                if ((n = LabelPainterController.this.fontDialog.showDialog(font)) != 2) {
                    labelPainter.setFont(LabelPainterController.this.fontDialog.getFont());
                }
            }
        });
        Font font = labelPainter.getFont();
        this.fontSizeSpinner = new JSpinner(new SpinnerNumberModel((double)font.getSize(), 0.01, 48.0, 1.0));
        this.fontSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)LabelPainterController.this.fontSizeSpinner.getValue()).floatValue();
                Font font = labelPainter.getFont().deriveFont(f);
                labelPainter.setFont(font);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        ControllerOptionsPanel.setComponentLook(jButton);
        ControllerOptionsPanel.setComponentLook(jButton2);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        NumberFormat numberFormat = labelPainter.getNumberFormat();
        int n4 = numberFormat.getMaximumFractionDigits();
        this.numericalFormatCombo = new JComboBox<String>(new String[]{"Decimal", "Scientific", "Percent", "Roman"});
        this.numericalFormatCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)LabelPainterController.this.numericalFormatCombo.getSelectedItem();
                int n = (Integer)LabelPainterController.this.digitsSpinner.getValue();
                NumberFormat numberFormat = null;
                if (string.equals("Decimal")) {
                    numberFormat = new DecimalFormat(DECIMAL_NUMBER_FORMATTING);
                } else if (string.equals("Scientific")) {
                    numberFormat = new DecimalFormat(SCIENTIFIC_NUMBER_FORMATTING);
                } else if (string.equals("Percent")) {
                    numberFormat = new PercentFormat();
                } else if (string.equals("Roman")) {
                    numberFormat = new RomanFormat();
                }
                ((NumberFormat)numberFormat).setMaximumFractionDigits(n);
                labelPainter.setNumberFormat(numberFormat);
            }
        });
        this.digitsSpinner = new JSpinner(new SpinnerNumberModel(n4, n3, 14, 1));
        this.digitsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = (Integer)LabelPainterController.this.digitsSpinner.getValue();
                NumberFormat numberFormat = labelPainter.getNumberFormat();
                numberFormat.setMaximumFractionDigits(n);
                labelPainter.setNumberFormat(numberFormat);
            }
        });
        JLabel jLabel = this.optionsPanel.addComponentWithLabel("Display:", this.displayAttributeCombo);
        JLabel jLabel2 = this.optionsPanel.addComponentWithLabel("Colour by:", this.colourAttributeCombo);
        JLabel jLabel3 = this.optionsPanel.addComponentWithLabel("Font Size:", this.fontSizeSpinner);
        JLabel jLabel4 = this.optionsPanel.addComponentWithLabel("Setup:", jPanel);
        JLabel jLabel5 = this.optionsPanel.addComponentWithLabel("Format:", this.numericalFormatCombo);
        JLabel jLabel6 = this.optionsPanel.addComponentWithLabel("Sig. Digits:", this.digitsSpinner);
        this.addComponent(jLabel);
        this.addComponent(this.displayAttributeCombo);
        this.addComponent(jLabel2);
        this.addComponent(this.colourAttributeCombo);
        this.addComponent(jLabel3);
        this.addComponent(jButton);
        this.addComponent(jButton2);
        this.addComponent(jLabel4);
        this.addComponent(this.fontSizeSpinner);
        this.addComponent(jLabel5);
        this.addComponent(this.numericalFormatCombo);
        this.addComponent(jLabel6);
        this.addComponent(this.digitsSpinner);
        this.enableComponents(this.titleCheckBox.isSelected());
        this.titleCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                LabelPainterController.this.enableComponents(LabelPainterController.this.titleCheckBox.isSelected());
                labelPainter.setVisible(LabelPainterController.this.titleCheckBox.isSelected());
            }
        });
    }

    private void setupLabelDecorator() {
        Decorator decorator = this.colourController.getColourDecorator(this.colourAttributeCombo, this.userLabelDecorator);
        CompoundDecorator compoundDecorator = new CompoundDecorator();
        compoundDecorator.addDecorator(decorator);
        AttributableDecorator attributableDecorator = new AttributableDecorator();
        this.userLabelDecorator.setFontAttributeName("!font");
        compoundDecorator.addDecorator(attributableDecorator);
        this.labelPainter.setTextDecorator(compoundDecorator);
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleCheckBox;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.titleCheckBox.setSelected((Boolean)map.get(this.key + "." + "isShown"));
        this.displayAttributeCombo.setSelectedItem(map.get(this.key + "." + DISPLAY_ATTRIBUTE_KEY));
        this.colourAttributeCombo.setSelectedItem(map.get(this.key + "." + COLOR_ATTRIBUTE_KEY));
        String string = (String)map.get(this.key + "." + FONT_NAME_KEY);
        int n = ((Number)map.get(this.key + "." + FONT_SIZE_KEY)).intValue();
        int n2 = (Integer)map.get(this.key + "." + FONT_STYLE_KEY);
        this.labelPainter.setFont(new Font(string, n2, n));
        this.digitsSpinner.setValue((Integer)map.get(this.key + "." + SIGNIFICANT_DIGITS_KEY));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put(this.key + "." + "isShown", this.titleCheckBox.isSelected());
        map.put(this.key + "." + DISPLAY_ATTRIBUTE_KEY, this.displayAttributeCombo.getSelectedItem().toString());
        map.put(this.key + "." + COLOR_ATTRIBUTE_KEY, this.colourAttributeCombo.getSelectedItem().toString());
        Font font = this.labelPainter.getFont();
        map.put(this.key + "." + FONT_NAME_KEY, font.getName());
        map.put(this.key + "." + FONT_SIZE_KEY, font.getSize());
        map.put(this.key + "." + FONT_STYLE_KEY, font.getStyle());
        map.put(this.key + "." + SIGNIFICANT_DIGITS_KEY, this.digitsSpinner.getValue());
    }

    public String getTitle() {
        return this.title;
    }
}

