/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.AttributeColourController;
import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.decorators.Decorator;
import figtree.treeviewer.painters.AttributeComboHelper;
import figtree.treeviewer.painters.AttributeComboHelperListener;
import figtree.treeviewer.painters.NodeShapePainter;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.awt.Color;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NodeShapeController
extends AbstractController {
    private static Preferences PREFS = Preferences.userNodeForPackage(TreeViewer.class);
    private static final String IS_EXTERNAL = "isExternal";
    private static final String IS_INTERNAL = "isInternal";
    private static final String NODE_SHAPE_KEY = "nodeShape";
    public static final String SHAPE_TYPE_KEY = "shapeType";
    public static final String SCALE_TYPE_KEY = "scaleType";
    public static final String SIZE_ATTRIBUTE_KEY = "sizeAttribute";
    public static final String COLOUR_ATTRIBUTE_KEY = "colourAttribute";
    private static final String SHAPE_SIZE_KEY = "size";
    private static final String SHAPE_MIN_SIZE_KEY = "minSize";
    private final JCheckBox titleCheckBox;
    private final OptionsPanel optionsPanel;
    private final JCheckBox externalNodeCheck;
    private final JCheckBox internalNodeCheck;
    private final JComboBox shapeTypeCombo;
    private final JComboBox scaleTypeCombo;
    private final JComboBox sizeAttributeCombo;
    private final JComboBox colourAttributeCombo;
    private final JSpinner shapeSizeSpinner;
    private final JSpinner shapeMinSizeSpinner;
    private final JComboBox outlineStrokeCombo;
    private final JComboBox outlinePaintCombo;
    private final String title;
    private final NodeType type;

    public NodeShapeController(String string, NodeType nodeType, final NodeShapePainter nodeShapePainter, final AttributeColourController attributeColourController, TreeViewer treeViewer) {
        ControllerOptionsPanel controllerOptionsPanel;
        Object object;
        this.title = string;
        this.type = nodeType;
        float f = PREFS.getFloat(SHAPE_SIZE_KEY, 4.0f);
        this.optionsPanel = new ControllerOptionsPanel(2, 2);
        this.titleCheckBox = new JCheckBox(this.getTitle());
        this.titleCheckBox.setSelected(nodeShapePainter.isVisible());
        this.titleCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = NodeShapeController.this.titleCheckBox.isSelected();
                nodeShapePainter.setVisible(bl);
            }
        });
        if (nodeType == NodeType.BOTH) {
            this.externalNodeCheck = new JCheckBox("external");
            this.internalNodeCheck = new JCheckBox("internal");
            object = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    nodeShapePainter.setNodeType(NodeShapeController.this.externalNodeCheck.isSelected(), NodeShapeController.this.internalNodeCheck.isSelected());
                }
            };
            this.externalNodeCheck.addActionListener((ActionListener)object);
            this.internalNodeCheck.addActionListener((ActionListener)object);
            controllerOptionsPanel = new ControllerOptionsPanel(2, 2);
            controllerOptionsPanel.setBorder(BorderFactory.createEmptyBorder());
            controllerOptionsPanel.addSpanningComponent(this.externalNodeCheck);
            controllerOptionsPanel.addSpanningComponent(this.internalNodeCheck);
            this.externalNodeCheck.setSelected(nodeShapePainter.isExternal());
            this.internalNodeCheck.setSelected(nodeShapePainter.isInternal());
        } else {
            controllerOptionsPanel = null;
            this.externalNodeCheck = null;
            this.internalNodeCheck = null;
            if (nodeType == NodeType.EXTERNAL) {
                nodeShapePainter.setNodeType(true, false);
            } else if (nodeType == NodeType.INTERNAL) {
                nodeShapePainter.setNodeType(false, true);
            }
        }
        this.shapeTypeCombo = new JComboBox<NodeShapePainter.ShapeType>(NodeShapePainter.ShapeType.values());
        this.shapeTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nodeShapePainter.setShapeType((NodeShapePainter.ShapeType)((Object)NodeShapeController.this.shapeTypeCombo.getSelectedItem()));
            }
        });
        this.scaleTypeCombo = new JComboBox<NodeShapePainter.ScaleType>(NodeShapePainter.ScaleType.values());
        this.scaleTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nodeShapePainter.setScaleType((NodeShapePainter.ScaleType)((Object)NodeShapeController.this.scaleTypeCombo.getSelectedItem()));
            }
        });
        this.sizeAttributeCombo = new JComboBox();
        this.colourAttributeCombo = new JComboBox();
        object = new JButton("Colour");
        attributeColourController.setupControls(this.colourAttributeCombo, (JButton)object);
        this.shapeSizeSpinner = new JSpinner(new SpinnerNumberModel(f, 0.0, 100.0, 1.0));
        this.shapeSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)NodeShapeController.this.shapeSizeSpinner.getValue();
                nodeShapePainter.setMaxSize(d);
            }
        });
        this.shapeMinSizeSpinner = new JSpinner(new SpinnerNumberModel(10.0, 0.0, 100.0, 1.0));
        this.shapeMinSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)NodeShapeController.this.shapeMinSizeSpinner.getValue();
                nodeShapePainter.setMinSize(d);
            }
        });
        this.outlineStrokeCombo = new JComboBox<String>(new String[]{"None", "0.25", "0.5", "1.0", "2.0", "3.0", "4.0", "5.0"});
        this.outlineStrokeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nodeShapePainter.setOutline(NodeShapeController.this.outlineStrokeCombo.getSelectedIndex() == 0 ? 0.0f : Float.parseFloat(NodeShapeController.this.outlineStrokeCombo.getSelectedItem().toString()), (Paint)NodeShapeController.this.outlinePaintCombo.getSelectedItem());
            }
        });
        final Paint[] paintArray = new Paint[]{Color.black, Color.white};
        this.outlinePaintCombo = new JComboBox<String>(new String[]{"black", "white"});
        this.outlinePaintCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nodeShapePainter.setOutline(NodeShapeController.this.outlineStrokeCombo.getSelectedIndex() == 0 ? 0.0f : Float.parseFloat(NodeShapeController.this.outlineStrokeCombo.getSelectedItem().toString()), paintArray[NodeShapeController.this.outlinePaintCombo.getSelectedIndex()]);
            }
        });
        JLabel jLabel = nodeType == NodeType.BOTH ? this.optionsPanel.addComponentWithLabel("Show:", controllerOptionsPanel) : null;
        JLabel jLabel2 = this.optionsPanel.addComponentWithLabel("Shape:", this.shapeTypeCombo);
        JLabel jLabel3 = this.optionsPanel.addComponentWithLabel("Max size:", this.shapeSizeSpinner);
        JLabel jLabel4 = this.optionsPanel.addComponentWithLabel("Size by:", this.sizeAttributeCombo);
        final JLabel jLabel5 = this.optionsPanel.addComponentWithLabel("Min size:", this.shapeMinSizeSpinner);
        final JLabel jLabel6 = this.optionsPanel.addComponentWithLabel("Using:", this.scaleTypeCombo);
        this.optionsPanel.addSeparator();
        JLabel jLabel7 = this.optionsPanel.addComponentWithLabel("Colour by:", this.colourAttributeCombo);
        JLabel jLabel8 = this.optionsPanel.addComponentWithLabel("Setup:", (JComponent)object);
        JLabel jLabel9 = this.optionsPanel.addComponentWithLabel("Outline width:", this.outlineStrokeCombo);
        JLabel jLabel10 = this.optionsPanel.addComponentWithLabel("Outline colour:", this.outlinePaintCombo);
        new AttributeComboHelper(this.colourAttributeCombo, treeViewer, "User selection").addListener(new AttributeComboHelperListener(){

            @Override
            public void attributeComboChanged() {
                Decorator decorator = attributeColourController.getColourDecorator(NodeShapeController.this.colourAttributeCombo, null);
                nodeShapePainter.setColourDecorator(decorator);
            }
        });
        new AttributeComboHelper(this.sizeAttributeCombo, treeViewer, "Fixed", true, false).addListener(new AttributeComboHelperListener(){

            @Override
            public void attributeComboChanged() {
                String string = (String)NodeShapeController.this.sizeAttributeCombo.getSelectedItem();
                nodeShapePainter.setSizeAttribute(string);
                if (string != null) {
                    boolean bl = !string.equals("Fixed");
                    jLabel5.setEnabled(bl);
                    NodeShapeController.this.shapeMinSizeSpinner.setEnabled(bl);
                    jLabel6.setEnabled(bl);
                    NodeShapeController.this.scaleTypeCombo.setEnabled(bl);
                }
            }
        });
        this.addComponent(jLabel2);
        this.addComponent(this.shapeTypeCombo);
        if (nodeType == NodeType.BOTH) {
            this.addComponent(jLabel);
            this.addComponent(this.externalNodeCheck);
            this.addComponent(this.internalNodeCheck);
        }
        this.addComponent(jLabel3);
        this.addComponent(this.shapeSizeSpinner);
        this.addComponent(jLabel4);
        this.addComponent(this.sizeAttributeCombo);
        this.addComponent(jLabel5);
        this.addComponent(this.shapeMinSizeSpinner);
        this.addComponent(jLabel6);
        this.addComponent(this.scaleTypeCombo);
        this.addComponent(jLabel7);
        this.addComponent(this.colourAttributeCombo);
        this.addComponent(jLabel8);
        this.addComponent((JComponent)object);
        this.addComponent(jLabel9);
        this.addComponent(this.outlineStrokeCombo);
        this.addComponent(jLabel10);
        this.addComponent(this.outlinePaintCombo);
        this.enableComponents(this.titleCheckBox.isSelected());
        this.titleCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                NodeShapeController.this.enableComponents(NodeShapeController.this.titleCheckBox.isSelected());
            }
        });
    }

    private void setupOptions() {
        this.fireControllerChanged();
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleCheckBox;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        String string = NODE_SHAPE_KEY + (this.type == NodeType.INTERNAL ? "Internal" : (this.type == NodeType.EXTERNAL ? "External" : ""));
        this.titleCheckBox.setSelected((Boolean)map.get(string + "." + "isShown"));
        if (this.type == NodeType.BOTH) {
            this.externalNodeCheck.setSelected((Boolean)map.get(string + "." + IS_EXTERNAL));
            this.internalNodeCheck.setSelected((Boolean)map.get(string + "." + IS_INTERNAL));
        }
        this.shapeTypeCombo.setSelectedItem((Object)NodeShapePainter.ShapeType.valueOf(map.get(string + "." + SHAPE_TYPE_KEY).toString().toUpperCase()));
        this.scaleTypeCombo.setSelectedItem((Object)NodeShapePainter.ScaleType.valueOf(map.get(string + "." + SCALE_TYPE_KEY).toString().toUpperCase()));
        this.colourAttributeCombo.setSelectedItem((String)map.get(string + "." + COLOUR_ATTRIBUTE_KEY));
        this.sizeAttributeCombo.setSelectedItem((String)map.get(string + "." + SIZE_ATTRIBUTE_KEY));
        this.shapeSizeSpinner.setValue((Double)map.get(string + "." + SHAPE_SIZE_KEY));
        this.shapeMinSizeSpinner.setValue((Double)map.get(string + "." + SHAPE_MIN_SIZE_KEY));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        String string = NODE_SHAPE_KEY + (this.type == NodeType.INTERNAL ? "Internal" : (this.type == NodeType.EXTERNAL ? "External" : ""));
        map.put(string + "." + "isShown", this.titleCheckBox.isSelected());
        if (this.type == NodeType.BOTH) {
            map.put(string + "." + IS_EXTERNAL, this.externalNodeCheck.isSelected());
            map.put(string + "." + IS_INTERNAL, this.internalNodeCheck.isSelected());
        }
        map.put(string + "." + SHAPE_TYPE_KEY, this.shapeTypeCombo.getSelectedItem());
        map.put(string + "." + SCALE_TYPE_KEY, this.scaleTypeCombo.getSelectedItem());
        map.put(string + "." + COLOUR_ATTRIBUTE_KEY, this.colourAttributeCombo.getSelectedItem());
        map.put(string + "." + SIZE_ATTRIBUTE_KEY, this.sizeAttributeCombo.getSelectedItem());
        map.put(string + "." + SHAPE_SIZE_KEY, this.shapeSizeSpinner.getValue());
        map.put(string + "." + SHAPE_MIN_SIZE_KEY, this.shapeMinSizeSpinner.getValue());
    }

    public String getTitle() {
        return this.title;
    }

    public static enum NodeType {
        INTERNAL,
        EXTERNAL,
        BOTH;

    }
}

