/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.TreeViewerListener;
import figtree.treeviewer.painters.ScaleAxisPainter;
import figtree.treeviewer.painters.ScaleGridPainter;
import figtree.ui.components.RealNumberField;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.awt.BasicStroke;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScaleAxisPainterController
extends AbstractController {
    private static Preferences PREFS = Preferences.userNodeForPackage(TreeViewer.class);
    private static final String SCALE_AXIS_KEY = "scaleAxis";
    private static final String FONT_NAME_KEY = "fontName";
    private static final String FONT_SIZE_KEY = "fontSize";
    private static final String FONT_STYLE_KEY = "fontStyle";
    private static final String NUMBER_FORMATTING_KEY = "numberFormatting";
    private static final String REVERSE_AXIS_KEY = "reverseAxis";
    private static final String SHOW_GRID_KEY = "showGrid";
    private static final String AUTOMATIC_SCALE_KEY = "automaticScale";
    private static final String MINOR_TICKS_KEY = "minorTicks";
    private static final String MAJOR_TICKS_KEY = "majorTicks";
    private static final String ORIGIN_KEY = "origin";
    private static final String LINE_WIDTH_KEY = "lineWidth";
    private static String DEFAULT_FONT_NAME = "sansserif";
    private static int DEFAULT_FONT_SIZE = 8;
    private static int DEFAULT_FONT_STYLE = 0;
    private static String DEFAULT_NUMBER_FORMATTING = "#.####";
    private static float DEFAULT_LINE_WIDTH = 1.0f;
    private final JCheckBox titleCheckBox;
    private final OptionsPanel optionsPanel;
    private final JCheckBox reverseAxisCheck;
    private final JCheckBox showGridCheck;
    private final JCheckBox autoScaleCheck;
    private final RealNumberField minorTicksText;
    private final RealNumberField majorTicksText;
    private final RealNumberField originText;
    private final JSpinner fontSizeSpinner;
    private final JSpinner lineWeightSpinner;
    private final ScaleAxisPainter scaleAxisPainter;
    private final ScaleGridPainter scaleGridPainter;

    public ScaleAxisPainterController(final ScaleAxisPainter scaleAxisPainter, final ScaleGridPainter scaleGridPainter, TreeViewer treeViewer) {
        this.scaleAxisPainter = scaleAxisPainter;
        this.scaleGridPainter = scaleGridPainter;
        String string = PREFS.get(FONT_NAME_KEY, DEFAULT_FONT_NAME);
        int n = PREFS.getInt(FONT_SIZE_KEY, DEFAULT_FONT_STYLE);
        int n2 = PREFS.getInt(FONT_STYLE_KEY, DEFAULT_FONT_SIZE);
        String string2 = PREFS.get(NUMBER_FORMATTING_KEY, DEFAULT_NUMBER_FORMATTING);
        float f = PREFS.getFloat(LINE_WIDTH_KEY, DEFAULT_LINE_WIDTH);
        scaleAxisPainter.setFont(new Font(string, n, n2));
        scaleAxisPainter.setNumberFormat(new DecimalFormat(string2));
        scaleAxisPainter.setScaleBarStroke(new BasicStroke(f, 1, 1));
        this.optionsPanel = new ControllerOptionsPanel(2, 2);
        this.titleCheckBox = new JCheckBox(this.getTitle());
        this.titleCheckBox.setSelected(scaleAxisPainter.isVisible());
        this.reverseAxisCheck = new JCheckBox("Reverse axis");
        this.reverseAxisCheck.setSelected(false);
        this.showGridCheck = new JCheckBox("Show grid");
        this.showGridCheck.setSelected(true);
        this.optionsPanel.addSpanningComponent(this.showGridCheck);
        this.autoScaleCheck = new JCheckBox("Automatic scale");
        this.autoScaleCheck.setSelected(true);
        this.majorTicksText = new RealNumberField();
        this.majorTicksText.setValue(1.0);
        this.minorTicksText = new RealNumberField();
        this.minorTicksText.setValue(0.5);
        this.originText = new RealNumberField();
        this.originText.setValue(0.0);
        Font font = scaleAxisPainter.getFont();
        this.fontSizeSpinner = new JSpinner(new SpinnerNumberModel((double)font.getSize(), 0.01, 48.0, 1.0));
        this.fontSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)ScaleAxisPainterController.this.fontSizeSpinner.getValue()).floatValue();
                Font font = scaleAxisPainter.getFont().deriveFont(f);
                scaleAxisPainter.setFont(font);
            }
        });
        this.lineWeightSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.01, 48.0, 1.0));
        this.lineWeightSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)ScaleAxisPainterController.this.lineWeightSpinner.getValue()).floatValue();
                scaleAxisPainter.setScaleBarStroke(new BasicStroke(f, 0, 2));
            }
        });
        final JLabel jLabel = this.optionsPanel.addComponentWithLabel("Line Weight:", this.lineWeightSpinner);
        this.optionsPanel.addSpanningComponent(this.reverseAxisCheck);
        this.optionsPanel.addSpanningComponent(this.autoScaleCheck);
        final JLabel jLabel2 = this.optionsPanel.addComponentWithLabel("Label spacing:", this.majorTicksText, true);
        final JLabel jLabel3 = this.optionsPanel.addComponentWithLabel("Tick spacing:", this.minorTicksText, true);
        final JLabel jLabel4 = this.optionsPanel.addComponentWithLabel("Origin value:", this.originText, true);
        final JLabel jLabel5 = this.optionsPanel.addComponentWithLabel("Font Size:", this.fontSizeSpinner);
        boolean bl = this.titleCheckBox.isSelected();
        boolean bl2 = this.autoScaleCheck.isSelected();
        this.showGridCheck.setEnabled(bl);
        this.reverseAxisCheck.setEnabled(bl);
        this.autoScaleCheck.setEnabled(bl);
        jLabel2.setEnabled(bl && !bl2);
        this.majorTicksText.setEnabled(bl && !bl2);
        jLabel3.setEnabled(bl && !bl2);
        this.minorTicksText.setEnabled(bl && !bl2);
        jLabel4.setEnabled(bl && !bl2);
        this.originText.setEnabled(bl && !bl2);
        jLabel5.setEnabled(bl);
        this.fontSizeSpinner.setEnabled(bl);
        jLabel.setEnabled(bl);
        this.lineWeightSpinner.setEnabled(bl);
        this.titleCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = ScaleAxisPainterController.this.titleCheckBox.isSelected();
                boolean bl2 = ScaleAxisPainterController.this.autoScaleCheck.isSelected();
                ScaleAxisPainterController.this.showGridCheck.setEnabled(bl);
                ScaleAxisPainterController.this.reverseAxisCheck.setEnabled(bl);
                ScaleAxisPainterController.this.autoScaleCheck.setEnabled(bl);
                jLabel2.setEnabled(bl && !bl2);
                ScaleAxisPainterController.this.majorTicksText.setEnabled(bl && !bl2);
                jLabel3.setEnabled(bl && !bl2);
                ScaleAxisPainterController.this.minorTicksText.setEnabled(bl && !bl2);
                jLabel4.setEnabled(bl && !bl2);
                ScaleAxisPainterController.this.originText.setEnabled(bl && !bl2);
                jLabel5.setEnabled(bl);
                ScaleAxisPainterController.this.fontSizeSpinner.setEnabled(bl);
                jLabel.setEnabled(bl);
                ScaleAxisPainterController.this.lineWeightSpinner.setEnabled(bl);
                scaleAxisPainter.setVisible(bl);
                scaleGridPainter.setVisible(bl);
            }
        });
        this.reverseAxisCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                scaleAxisPainter.setAxisReversed(ScaleAxisPainterController.this.reverseAxisCheck.isSelected());
            }
        });
        this.showGridCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                scaleGridPainter.setVisible(ScaleAxisPainterController.this.showGridCheck.isSelected());
            }
        });
        this.autoScaleCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ScaleAxisPainterController.this.autoScaleCheck.isSelected()) {
                    scaleAxisPainter.setAutomatic(true);
                    ScaleAxisPainterController.this.majorTicksText.setValue(scaleAxisPainter.getMajorTickSpacing());
                    ScaleAxisPainterController.this.minorTicksText.setValue(scaleAxisPainter.getMinorTickSpacing());
                    ScaleAxisPainterController.this.originText.setValue(scaleAxisPainter.getAxisOrigin());
                    jLabel2.setEnabled(false);
                    ScaleAxisPainterController.this.majorTicksText.setEnabled(false);
                    jLabel3.setEnabled(false);
                    ScaleAxisPainterController.this.minorTicksText.setEnabled(false);
                    jLabel4.setEnabled(false);
                    ScaleAxisPainterController.this.originText.setEnabled(false);
                } else {
                    jLabel2.setEnabled(true);
                    ScaleAxisPainterController.this.minorTicksText.setEnabled(true);
                    jLabel3.setEnabled(true);
                    ScaleAxisPainterController.this.majorTicksText.setEnabled(true);
                    jLabel4.setEnabled(true);
                    ScaleAxisPainterController.this.originText.setEnabled(true);
                    double d = ScaleAxisPainterController.this.getValue(ScaleAxisPainterController.this.majorTicksText, 1.0);
                    double d2 = ScaleAxisPainterController.this.getValue(ScaleAxisPainterController.this.minorTicksText, 0.5);
                    double d3 = ScaleAxisPainterController.this.getValue(ScaleAxisPainterController.this.originText, 0.0);
                    scaleAxisPainter.setAutomatic(false);
                    scaleAxisPainter.setAxisSpacing(d, d2);
                    scaleAxisPainter.setAxisOrigin(d3);
                }
            }
        });
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!ScaleAxisPainterController.this.autoScaleCheck.isSelected()) {
                    double d = ScaleAxisPainterController.this.getValue(ScaleAxisPainterController.this.majorTicksText, 1.0);
                    double d2 = ScaleAxisPainterController.this.getValue(ScaleAxisPainterController.this.minorTicksText, 0.5);
                    scaleAxisPainter.setAxisSpacing(d, d2);
                }
            }
        };
        this.minorTicksText.addChangeListener(changeListener);
        this.majorTicksText.addChangeListener(changeListener);
        this.originText.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!ScaleAxisPainterController.this.autoScaleCheck.isSelected()) {
                    double d = ScaleAxisPainterController.this.getValue(ScaleAxisPainterController.this.originText, 0.0);
                    scaleAxisPainter.setAxisOrigin(d);
                }
            }
        });
        treeViewer.addTreeViewerListener(new TreeViewerListener(){

            @Override
            public void treeChanged() {
                scaleAxisPainter.firePainterChanged();
            }

            @Override
            public void treeSettingsChanged() {
            }
        });
    }

    private double getValue(RealNumberField realNumberField, double d) {
        Double d2 = realNumberField.getValue();
        return d2 != null ? d2 : d;
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleCheckBox;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
        this.autoScaleCheck.setSelected(false);
        this.autoScaleCheck.setSelected(true);
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.titleCheckBox.setSelected((Boolean)map.get("scaleAxis.isShown"));
        this.reverseAxisCheck.setSelected((Boolean)map.get("scaleAxis.reverseAxis"));
        this.showGridCheck.setSelected((Boolean)map.get("scaleAxis.showGrid"));
        this.minorTicksText.setValue((Double)map.get("scaleAxis.minorTicks"));
        this.majorTicksText.setValue((Double)map.get("scaleAxis.majorTicks"));
        this.originText.setValue((Double)map.get("scaleAxis.origin"));
        this.autoScaleCheck.setSelected((Boolean)map.get("scaleAxis.automaticScale"));
        this.fontSizeSpinner.setValue((Double)map.get("scaleAxis.fontSize"));
        this.lineWeightSpinner.setValue((Double)map.get("scaleAxis.lineWidth"));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put("scaleAxis.isShown", this.titleCheckBox.isSelected());
        map.put("scaleAxis.reverseAxis", this.reverseAxisCheck.isSelected());
        map.put("scaleAxis.showGrid", this.showGridCheck.isSelected());
        map.put("scaleAxis.automaticScale", this.autoScaleCheck.isSelected());
        map.put("scaleAxis.minorTicks", this.minorTicksText.getValue());
        map.put("scaleAxis.majorTicks", this.majorTicksText.getValue());
        map.put("scaleAxis.origin", this.originText.getValue());
        map.put("scaleAxis.fontSize", this.fontSizeSpinner.getValue());
        map.put("scaleAxis.lineWidth", this.lineWeightSpinner.getValue());
    }

    public String getTitle() {
        return "Scale Axis";
    }
}

