/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.painters;

import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.TreeViewer;
import figtree.treeviewer.TreeViewerListener;
import figtree.treeviewer.painters.ScaleBarPainter;
import figtree.ui.components.RealNumberField;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.awt.BasicStroke;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScaleBarPainterController
extends AbstractController {
    public static Preferences PREFS = Preferences.userNodeForPackage(TreeViewer.class);
    public static final String CONTROLLER_KEY = "scaleBar";
    public static final String FONT_NAME_KEY = "fontName";
    public static final String FONT_SIZE_KEY = "fontSize";
    public static final String FONT_STYLE_KEY = "fontStyle";
    public static final String NUMBER_FORMATTING_KEY = "numberFormatting";
    public static final String AUTOMATIC_SCALE_KEY = "automaticScale";
    public static final String SCALE_RANGE_KEY = "scaleRange";
    public static final String LINE_WIDTH_KEY = "lineWidth";
    public static String DEFAULT_FONT_NAME = "sansserif";
    public static int DEFAULT_FONT_SIZE = 10;
    public static int DEFAULT_FONT_STYLE = 0;
    public static String DEFAULT_NUMBER_FORMATTING = "#.####";
    public static float DEFAULT_LINE_WIDTH = 1.0f;
    private final JCheckBox titleCheckBox;
    private final OptionsPanel optionsPanel;
    private final JCheckBox autoScaleCheck;
    private final RealNumberField scaleRangeText;
    private final JSpinner fontSizeSpinner;
    private final JSpinner lineWeightSpinner;
    private final ScaleBarPainter scaleBarPainter;

    public ScaleBarPainterController(final ScaleBarPainter scaleBarPainter, TreeViewer treeViewer) {
        this.scaleBarPainter = scaleBarPainter;
        String string = PREFS.get("scaleBar.fontName", DEFAULT_FONT_NAME);
        int n = PREFS.getInt("scaleBar.fontStyle", DEFAULT_FONT_STYLE);
        int n2 = PREFS.getInt("scaleBar.fontSize", DEFAULT_FONT_SIZE);
        String string2 = PREFS.get("scaleBar.numberFormatting", DEFAULT_NUMBER_FORMATTING);
        float f = PREFS.getFloat(LINE_WIDTH_KEY, DEFAULT_LINE_WIDTH);
        scaleBarPainter.setFont(new Font(string, n, n2));
        scaleBarPainter.setNumberFormat(new DecimalFormat(string2));
        scaleBarPainter.setScaleBarStroke(new BasicStroke(f, 1, 1));
        this.optionsPanel = new ControllerOptionsPanel(2, 2);
        this.titleCheckBox = new JCheckBox(this.getTitle());
        this.titleCheckBox.setSelected(scaleBarPainter.isVisible());
        this.autoScaleCheck = new JCheckBox("Automatic scale");
        this.autoScaleCheck.setSelected(true);
        this.optionsPanel.addSpanningComponent(this.autoScaleCheck);
        this.scaleRangeText = new RealNumberField(0.0, Double.MAX_VALUE);
        this.scaleRangeText.setValue(0.0);
        final JLabel jLabel = this.optionsPanel.addComponentWithLabel("Scale Range:", this.scaleRangeText, true);
        jLabel.setEnabled(false);
        this.scaleRangeText.setEnabled(false);
        Font font = scaleBarPainter.getFont();
        this.fontSizeSpinner = new JSpinner(new SpinnerNumberModel((double)font.getSize(), 0.01, 48.0, 1.0));
        final JLabel jLabel2 = this.optionsPanel.addComponentWithLabel("Font Size:", this.fontSizeSpinner);
        this.fontSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)ScaleBarPainterController.this.fontSizeSpinner.getValue()).floatValue();
                Font font = scaleBarPainter.getFont().deriveFont(f);
                scaleBarPainter.setFont(font);
            }
        });
        this.lineWeightSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.01, 48.0, 1.0));
        this.lineWeightSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)ScaleBarPainterController.this.lineWeightSpinner.getValue()).floatValue();
                scaleBarPainter.setScaleBarStroke(new BasicStroke(f, 0, 2));
            }
        });
        final JLabel jLabel3 = this.optionsPanel.addComponentWithLabel("Line Weight:", this.lineWeightSpinner);
        boolean bl = this.titleCheckBox.isSelected();
        boolean bl2 = this.autoScaleCheck.isSelected();
        jLabel.setEnabled(bl && !bl2);
        this.scaleRangeText.setEnabled(bl && !bl2);
        jLabel2.setEnabled(bl);
        this.fontSizeSpinner.setEnabled(bl);
        jLabel3.setEnabled(bl);
        this.lineWeightSpinner.setEnabled(bl);
        this.titleCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = ScaleBarPainterController.this.titleCheckBox.isSelected();
                boolean bl2 = ScaleBarPainterController.this.autoScaleCheck.isSelected();
                ScaleBarPainterController.this.autoScaleCheck.setEnabled(bl);
                jLabel.setEnabled(bl && !bl2);
                ScaleBarPainterController.this.scaleRangeText.setEnabled(bl && !bl2);
                jLabel2.setEnabled(bl);
                ScaleBarPainterController.this.fontSizeSpinner.setEnabled(bl);
                jLabel3.setEnabled(bl);
                ScaleBarPainterController.this.lineWeightSpinner.setEnabled(bl);
                scaleBarPainter.setVisible(bl);
            }
        });
        this.autoScaleCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ScaleBarPainterController.this.autoScaleCheck.isSelected()) {
                    scaleBarPainter.setAutomaticScale(true);
                    double d = scaleBarPainter.getScaleRange();
                    ScaleBarPainterController.this.scaleRangeText.setValue(d);
                    jLabel.setEnabled(false);
                    ScaleBarPainterController.this.scaleRangeText.setEnabled(false);
                } else {
                    jLabel.setEnabled(true);
                    ScaleBarPainterController.this.scaleRangeText.setEnabled(true);
                    scaleBarPainter.setAutomaticScale(false);
                }
            }
        });
        this.scaleRangeText.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Double d = ScaleBarPainterController.this.scaleRangeText.getValue();
                if (d != null) {
                    scaleBarPainter.setScaleRange(d);
                }
            }
        });
        treeViewer.addTreeViewerListener(new TreeViewerListener(){

            @Override
            public void treeChanged() {
                scaleBarPainter.calculateScaleRange();
                scaleBarPainter.firePainterChanged();
            }

            @Override
            public void treeSettingsChanged() {
            }
        });
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleCheckBox;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
        this.autoScaleCheck.setSelected(false);
        this.autoScaleCheck.setSelected(true);
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.titleCheckBox.setSelected((Boolean)map.get("scaleBar.isShown"));
        this.autoScaleCheck.setSelected((Boolean)map.get("scaleBar.automaticScale"));
        this.scaleRangeText.setValue((Double)map.get("scaleBar.scaleRange"));
        this.fontSizeSpinner.setValue((Double)map.get("scaleBar.fontSize"));
        this.lineWeightSpinner.setValue((Double)map.get("scaleBar.lineWidth"));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put("scaleBar.isShown", this.titleCheckBox.isSelected());
        map.put("scaleBar.automaticScale", this.autoScaleCheck.isSelected());
        map.put("scaleBar.scaleRange", this.scaleRangeText.getValue());
        map.put("scaleBar.fontSize", this.fontSizeSpinner.getValue());
        map.put("scaleBar.lineWidth", this.lineWeightSpinner.getValue());
    }

    public String getTitle() {
        return "Scale Bar";
    }
}

