/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.treelayouts;

import figtree.treeviewer.treelayouts.AbstractTreeLayout;
import figtree.treeviewer.treelayouts.TreeLayout;
import figtree.treeviewer.treelayouts.TreeLayoutCache;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.List;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.RootedTree;

public class PolarTreeLayout
extends AbstractTreeLayout {
    private double rootAngle = 180.0;
    private double rootLengthProportion = 0.01;
    private double angularRange = 360.0;
    private double fishEye = 0.0;
    private double pointOfInterest = 0.5;
    private int tipCount = 0;
    private double totalRootLength = 0.0;
    private boolean showingRootBranch = true;
    private TipLabelPosition tipLabelPosition = TipLabelPosition.FLUSH;
    private double yPosition;
    private double yIncrement;
    private double maxXPosition;
    private double constant;

    @Override
    public TreeLayout.AxisType getXAxisType() {
        return TreeLayout.AxisType.CONTINUOUS;
    }

    @Override
    public TreeLayout.AxisType getYAxisType() {
        return TreeLayout.AxisType.CONTINUOUS;
    }

    @Override
    public boolean maintainAspectRatio() {
        return true;
    }

    @Override
    public void setFishEye(double d) {
        this.fishEye = d;
        this.fireTreeLayoutChanged();
    }

    @Override
    public void setPointOfInterest(double d, double d2) {
        this.pointOfInterest = this.getPolarAngle(d, d2);
        this.fireTreeLayoutChanged();
    }

    @Override
    public double getHeightOfPoint(Point2D point2D) {
        throw new UnsupportedOperationException("Method getHeightOfPoint() is not supported in this TreeLayout");
    }

    @Override
    public Shape getAxisLine(double d) {
        double d2 = d;
        return new Ellipse2D.Double(-d2, -d2, d2 * 2.0, d2 * 2.0);
    }

    @Override
    public Shape getHeightArea(double d, double d2) {
        Area area = new Area(new Ellipse2D.Double(0.0, 0.0, d2 * 2.0, d2 * 2.0));
        Area area2 = new Area(new Ellipse2D.Double(0.0, 0.0, d * 2.0, d * 2.0));
        area.subtract(area2);
        return area;
    }

    public double getRootAngle() {
        return this.rootAngle;
    }

    public double getAngularRange() {
        return this.angularRange;
    }

    @Override
    public boolean isShowingRootBranch() {
        return this.showingRootBranch;
    }

    public double getTotalRootLength() {
        return this.totalRootLength;
    }

    public double getRootLengthProportion() {
        return this.rootLengthProportion;
    }

    public TipLabelPosition getTipLabelPosition() {
        return this.tipLabelPosition;
    }

    public void setRootAngle(double d) {
        this.rootAngle = d;
        this.constant = d - (360.0 - this.angularRange) * 0.5;
        this.fireTreeLayoutChanged();
    }

    public void setAngularRange(double d) {
        this.angularRange = d;
        this.constant = this.rootAngle - (360.0 - d) * 0.5;
        this.fireTreeLayoutChanged();
    }

    public void setShowingRootBranch(boolean bl) {
        this.showingRootBranch = bl;
        this.fireTreeLayoutChanged();
    }

    public void setRootLengthProportion(double d) {
        this.rootLengthProportion = d;
        this.fireTreeLayoutChanged();
    }

    public void setTipLabelPosition(TipLabelPosition tipLabelPosition) {
        this.tipLabelPosition = tipLabelPosition;
        this.fireTreeLayoutChanged();
    }

    @Override
    public boolean isShowingColouring() {
        return this.branchColouringAttribute != null;
    }

    @Override
    public void layout(RootedTree rootedTree, TreeLayoutCache treeLayoutCache) {
        treeLayoutCache.clear();
        Node node = rootedTree.getRootNode();
        double d = this.rootLengthProportion * rootedTree.getHeight(node) * 10.0;
        this.maxXPosition = 0.0;
        this.getMaxXPosition(rootedTree, node, d);
        this.yPosition = 0.0;
        this.tipCount = rootedTree.getExternalNodes().size();
        this.yIncrement = 1.0 / (double)this.tipCount;
        Point2D point2D = this.constructNode(rootedTree, node, 0.0, d, treeLayoutCache);
        if (this.showingRootBranch) {
            double d2 = point2D.getY();
            Line2D.Double double_ = new Line2D.Double(this.transform(0.0, d2), this.transform(point2D.getX(), d2));
            treeLayoutCache.branchPaths.put(node, double_);
        }
    }

    private Point2D constructNode(RootedTree rootedTree, Node node, double d, double d2, TreeLayoutCache treeLayoutCache) {
        Point2D point2D;
        if (this.hilightAttributeName != null && node.getAttribute(this.hilightAttributeName) != null) {
            this.constructHilight(rootedTree, node, d, d2, treeLayoutCache);
        }
        if (!rootedTree.isExternal(node)) {
            if (this.collapsedAttributeName != null && node.getAttribute(this.collapsedAttributeName) != null) {
                point2D = this.constructCollapsedNode(rootedTree, node, d2, treeLayoutCache);
            } else if (this.cartoonAttributeName != null && node.getAttribute(this.cartoonAttributeName) != null) {
                point2D = this.constructCartoonNode(rootedTree, node, d2, treeLayoutCache);
            } else {
                double d3 = 0.0;
                List<Node> list = rootedTree.getChildren(node);
                Node[] nodeArray = new Node[list.size()];
                Point2D[] point2DArray = new Point2D[list.size()];
                boolean bl = false;
                if (node.getAttribute("!rotate") != null && ((Boolean)node.getAttribute("!rotate")).booleanValue()) {
                    bl = true;
                }
                for (int i = 0; i < list.size(); ++i) {
                    int n = i;
                    if (bl) {
                        n = list.size() - i - 1;
                    }
                    nodeArray[i] = list.get(n);
                    double d4 = rootedTree.getLength(nodeArray[i]);
                    point2DArray[i] = this.constructNode(rootedTree, nodeArray[i], d2, d2 + d4, treeLayoutCache);
                    d3 += point2DArray[i].getY();
                }
                point2D = new Point2D.Double(d2, d3 /= (double)list.size());
                Point2D point2D2 = this.transform(point2D);
                double d5 = this.getAngle(d3);
                double d6 = 0.0;
                for (int i = 0; i < list.size(); ++i) {
                    int n = i;
                    if (bl) {
                        n = list.size() - i - 1;
                    }
                    GeneralPath generalPath = new GeneralPath();
                    Point2D point2D3 = this.transform(point2DArray[i]);
                    Point2D point2D4 = this.transform(point2D.getX(), point2DArray[i].getY());
                    Object[] objectArray = null;
                    if (this.branchColouringAttribute != null) {
                        objectArray = (Object[])nodeArray[i].getAttribute(this.branchColouringAttribute);
                    }
                    if (objectArray != null) {
                        float f = (float)rootedTree.getHeight(node);
                        float f2 = (float)rootedTree.getHeight(nodeArray[i]);
                        double d7 = point2DArray[i].getX();
                        double d8 = point2D.getX();
                        generalPath.moveTo((float)point2D3.getX(), (float)point2D3.getY());
                        float f3 = (float)d7;
                        for (int j = 0; j < objectArray.length - 1; j += 2) {
                            float f4 = ((Number)objectArray[j + 1]).floatValue();
                            float f5 = f4 / (f - f2);
                            f3 = (float)((double)f3 - (d7 - d8) * (double)f5);
                            Point2D point2D5 = this.transform(f3, point2DArray[n].getY());
                            generalPath.lineTo((float)point2D5.getX(), (float)point2D5.getY());
                        }
                        generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
                    } else {
                        generalPath.moveTo((float)point2D3.getX(), (float)point2D3.getY());
                        generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
                    }
                    double d9 = this.getAngle(point2DArray[n].getY());
                    Arc2D.Double double_ = new Arc2D.Double();
                    double_.setArcByCenter(0.0, 0.0, point2D.getX(), d9, d5 - d9, 0);
                    generalPath.append(double_, true);
                    treeLayoutCache.branchPaths.put(nodeArray[i], generalPath);
                    double d10 = (point2D.getX() + point2DArray[n].getX()) / 2.0;
                    Line2D.Double double_2 = new Line2D.Double(this.transform(d10 - 1.0, point2DArray[n].getY()), this.transform(d10 + 1.0, point2DArray[n].getY()));
                    treeLayoutCache.branchLabelPaths.put(nodeArray[i], double_2);
                }
                Line2D.Double double_ = new Line2D.Double(this.transform(point2D.getX(), d3), this.transform(point2D.getX() + 1.0, d3));
                treeLayoutCache.nodeLabelPaths.put(node, double_);
                Line2D.Double double_3 = new Line2D.Double(this.transform(point2D.getX(), d3), this.transform(point2D.getX() - 1.0, d3));
                treeLayoutCache.nodeShapePaths.put(node, double_3);
                treeLayoutCache.nodePoints.put(node, point2D2);
            }
        } else {
            Line2D.Double double_;
            Line2D.Double double_4;
            point2D = new Point2D.Double(d2, this.yPosition);
            Point2D point2D6 = this.transform(point2D);
            if (this.tipLabelPosition == TipLabelPosition.FLUSH) {
                double_4 = new Line2D.Double(point2D6, this.transform(d2 + 1.0, this.yPosition));
            } else if (this.tipLabelPosition == TipLabelPosition.RADIAL) {
                double_4 = new Line2D.Double(this.transform(this.maxXPosition, this.yPosition), this.transform(this.maxXPosition + 1.0, this.yPosition));
                double_ = new Line2D.Double(point2D6, this.transform(this.maxXPosition, this.yPosition));
                treeLayoutCache.calloutPaths.put(node, double_);
            } else {
                if (this.tipLabelPosition == TipLabelPosition.HORIZONTAL) {
                    throw new UnsupportedOperationException("Not implemented yet");
                }
                throw new IllegalArgumentException("Unrecognized enum value");
            }
            treeLayoutCache.tipLabelPaths.put(node, double_4);
            double_ = new Line2D.Double(this.transform(point2D.getX(), this.yPosition), this.transform(point2D.getX() - 1.0, this.yPosition));
            treeLayoutCache.nodeShapePaths.put(node, double_);
            this.yPosition += this.yIncrement;
            treeLayoutCache.nodePoints.put(node, point2D6);
        }
        return point2D;
    }

    private void constructNodeAreas(RootedTree rootedTree, Node node, Area area, TreeLayoutCache treeLayoutCache) {
        if (!rootedTree.isExternal(node)) {
            List<Node> list = rootedTree.getChildren(node);
            boolean bl = false;
            if (node.getAttribute("!rotate") != null && ((Boolean)node.getAttribute("!rotate")).booleanValue()) {
                bl = true;
            }
            int n = bl ? list.size() - 1 : 0;
            Node node2 = list.get(n);
            Area area2 = new Area();
            this.constructNodeAreas(rootedTree, node2, area2, treeLayoutCache);
            n = bl ? 0 : list.size() - 1;
            Node node3 = list.get(n);
            Area area3 = new Area();
            this.constructNodeAreas(rootedTree, node3, area3, treeLayoutCache);
            GeneralPath generalPath = new GeneralPath();
            PathIterator pathIterator = treeLayoutCache.getBranchPath(node2).getPathIterator(null);
            generalPath.append(pathIterator, false);
        }
    }

    private Point2D constructCartoonNode(RootedTree rootedTree, Node node, double d, TreeLayoutCache treeLayoutCache) {
        Object[] objectArray = (Object[])node.getAttribute(this.cartoonAttributeName);
        int n = (Integer)objectArray[0];
        double d2 = (Double)objectArray[1];
        double d3 = rootedTree.getHeight(node);
        double d4 = d + d3 - d2;
        double d5 = this.yPosition;
        this.yPosition += this.yIncrement * (double)(n - 1);
        double d6 = this.yPosition;
        this.yPosition += this.yIncrement;
        double d7 = (d6 + d5) / 2.0;
        Point2D.Double double_ = new Point2D.Double(d, d7);
        Point2D point2D = this.transform(double_);
        Point2D point2D2 = this.transform(new Point2D.Double(d4, d5));
        Point2D point2D3 = this.transform(new Point2D.Double(d4, d6));
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
        double d8 = this.getAngle(d6);
        double d9 = this.getAngle(d5);
        Arc2D.Double double_2 = new Arc2D.Double();
        double_2.setArcByCenter(0.0, 0.0, d4, d9, d8 - d9, 0);
        generalPath.append(double_2, true);
        generalPath.closePath();
        treeLayoutCache.collapsedShapes.put(node, generalPath);
        Line2D.Double double_3 = new Line2D.Double(this.transform(((Point2D)double_).getX(), d7), this.transform(((Point2D)double_).getX() + 1.0, d7));
        treeLayoutCache.nodeLabelPaths.put(node, double_3);
        Line2D.Double double_4 = new Line2D.Double(this.transform(((Point2D)double_).getX(), d7), this.transform(((Point2D)double_).getX() - 1.0, d7));
        treeLayoutCache.nodeShapePaths.put(node, double_4);
        if (this.showingCartoonTipLabels) {
            this.constructCartoonTipLabelPaths(rootedTree, node, d4, new double[]{d5}, treeLayoutCache);
        }
        treeLayoutCache.nodePoints.put(node, point2D);
        return double_;
    }

    private void constructCartoonTipLabelPaths(RootedTree rootedTree, Node node, double d, double[] dArray, TreeLayoutCache treeLayoutCache) {
        if (!rootedTree.isExternal(node)) {
            for (Node node2 : rootedTree.getChildren(node)) {
                this.constructCartoonTipLabelPaths(rootedTree, node2, d, dArray, treeLayoutCache);
            }
        } else {
            Line2D.Double double_;
            Point2D.Double double_2 = new Point2D.Double(d, dArray[0]);
            Point2D point2D = this.transform(double_2);
            if (this.tipLabelPosition == TipLabelPosition.FLUSH) {
                double_ = new Line2D.Double(point2D, this.transform(d + 1.0, dArray[0]));
            } else if (this.tipLabelPosition == TipLabelPosition.RADIAL) {
                double_ = new Line2D.Double(this.transform(this.maxXPosition, dArray[0]), this.transform(this.maxXPosition + 1.0, dArray[0]));
                Line2D.Double double_3 = new Line2D.Double(point2D, this.transform(this.maxXPosition, dArray[0]));
                treeLayoutCache.calloutPaths.put(node, double_3);
            } else {
                if (this.tipLabelPosition == TipLabelPosition.HORIZONTAL) {
                    throw new UnsupportedOperationException("Not implemented yet");
                }
                throw new IllegalArgumentException("Unrecognized enum value");
            }
            treeLayoutCache.tipLabelPaths.put(node, double_);
            dArray[0] = dArray[0] + this.yIncrement;
        }
    }

    private Point2D constructCollapsedNode(RootedTree rootedTree, Node node, double d, TreeLayoutCache treeLayoutCache) {
        Line2D.Double double_;
        Object[] objectArray = (Object[])node.getAttribute(this.collapsedAttributeName);
        double d2 = (Double)objectArray[1];
        double d3 = rootedTree.getHeight(node);
        double d4 = d + d3 - d2;
        double d5 = this.yPosition - this.yIncrement * 0.5;
        double d6 = d5 + this.yIncrement;
        this.yPosition += this.yIncrement;
        double d7 = (d6 + d5) / 2.0;
        Point2D.Double double_2 = new Point2D.Double(d, d7);
        Point2D point2D = this.transform(double_2);
        Point2D point2D2 = this.transform(new Point2D.Double(d4, d5));
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
        double d8 = this.getAngle(d6);
        double d9 = this.getAngle(d5);
        Arc2D.Double double_3 = new Arc2D.Double();
        double_3.setArcByCenter(0.0, 0.0, d4, d9, d8 - d9, 0);
        generalPath.append(double_3, true);
        generalPath.closePath();
        treeLayoutCache.collapsedShapes.put(node, generalPath);
        Line2D.Double double_4 = new Line2D.Double(this.transform(((Point2D)double_2).getX(), d7), this.transform(((Point2D)double_2).getX() + 1.0, d7));
        treeLayoutCache.nodeLabelPaths.put(node, double_4);
        Line2D.Double double_5 = new Line2D.Double(this.transform(((Point2D)double_2).getX(), d7), this.transform(((Point2D)double_2).getX() - 1.0, d7));
        treeLayoutCache.nodeShapePaths.put(node, double_5);
        Point2D point2D3 = this.transform(d4, d7);
        if (this.tipLabelPosition == TipLabelPosition.FLUSH) {
            double_ = new Line2D.Double(point2D3, this.transform(d4 + 1.0, d7));
        } else if (this.tipLabelPosition == TipLabelPosition.RADIAL) {
            double_ = new Line2D.Double(this.transform(this.maxXPosition, d7), this.transform(this.maxXPosition + 1.0, d7));
            Line2D.Double double_6 = new Line2D.Double(point2D3, this.transform(this.maxXPosition, d7));
            treeLayoutCache.calloutPaths.put(node, double_6);
        } else {
            if (this.tipLabelPosition == TipLabelPosition.HORIZONTAL) {
                throw new UnsupportedOperationException("Not implemented yet");
            }
            throw new IllegalArgumentException("Unrecognized enum value");
        }
        treeLayoutCache.tipLabelPaths.put(node, double_);
        treeLayoutCache.nodePoints.put(node, point2D);
        return double_2;
    }

    private void constructHilight(RootedTree rootedTree, Node node, double d, double d2, TreeLayoutCache treeLayoutCache) {
        Object[] objectArray = (Object[])node.getAttribute(this.hilightAttributeName);
        int n = (Integer)objectArray[0];
        double d3 = (Double)objectArray[1];
        double d4 = rootedTree.getHeight(node);
        GeneralPath generalPath = new GeneralPath();
        double d5 = (d2 + d) / 2.0;
        double d6 = d2 + d4;
        double d7 = this.yPosition - this.yIncrement / 2.0;
        double d8 = this.yPosition + this.yIncrement * (double)n - this.yIncrement / 2.0;
        Point2D point2D = this.transform(new Point2D.Double(d5, d7));
        Point2D point2D2 = this.transform(new Point2D.Double(d6, d7));
        Point2D point2D3 = this.transform(new Point2D.Double(d6, d8));
        Point2D point2D4 = this.transform(new Point2D.Double(d5, d8));
        double d9 = this.getAngle(d7);
        double d10 = this.getAngle(d8);
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
        Arc2D.Double double_ = new Arc2D.Double();
        double_.setArcByCenter(0.0, 0.0, d6, d9, d10 - d9, 0);
        generalPath.append(double_, true);
        generalPath.lineTo((float)point2D3.getX(), (float)point2D3.getY());
        double_ = new Arc2D.Double();
        double_.setArcByCenter(0.0, 0.0, d5, d10, d9 - d10, 0);
        generalPath.append(double_, true);
        generalPath.closePath();
        treeLayoutCache.hilightNodes.add(node);
        treeLayoutCache.hilightShapes.put(node, generalPath);
    }

    private void getMaxXPosition(RootedTree rootedTree, Node node, double d) {
        if (!rootedTree.isExternal(node)) {
            List<Node> list = rootedTree.getChildren(node);
            for (Node node2 : list) {
                double d2 = rootedTree.getLength(node2);
                this.getMaxXPosition(rootedTree, node2, d + d2);
            }
        } else if (d > this.maxXPosition) {
            this.maxXPosition = d;
        }
    }

    private Point2D transform(Point2D point2D) {
        return this.transform(point2D.getX(), point2D.getY());
    }

    private Point2D transform(double d, double d2) {
        double d3 = -Math.toRadians(this.getAngle(d2));
        return new Point2D.Double(d * Math.cos(d3), d * Math.sin(d3));
    }

    private double getPolarAngle(double d, double d2) {
        double d3 = Math.toDegrees(Math.atan(d2 / d));
        return (this.constant - d3) / this.angularRange;
    }

    private double getAngle(double d) {
        if (this.fishEye == 0.0) {
            return this.constant - d * this.angularRange;
        }
        double d2 = 1.0 / (this.fishEye * (double)this.tipCount);
        double d3 = this.pointOfInterest - d;
        double d4 = 1.0 - this.pointOfInterest / (d2 + this.pointOfInterest);
        double d5 = 1.0 - (this.pointOfInterest - 1.0) / (d2 - (this.pointOfInterest - 1.0));
        double d6 = 1.0 - (d3 < 0.0 ? d3 / (d2 - d3) : d3 / (d2 + d3));
        double d7 = (d6 - d4) / (d5 - d4);
        return this.rootAngle - (360.0 - this.angularRange) * 0.5 - d7 * this.angularRange;
    }

    public static enum TipLabelPosition {
        FLUSH,
        RADIAL,
        HORIZONTAL;

    }
}

