/*
 * Decompiled with CFR 0.152.
 */
package figtree.treeviewer.treelayouts;

import figtree.treeviewer.ControllerOptionsPanel;
import figtree.treeviewer.treelayouts.RadialTreeLayout;
import jam.controlpalettes.AbstractController;
import jam.panels.OptionsPanel;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RadialTreeLayoutController
extends AbstractController {
    private static final String RADIAL_LAYOUT_KEY = "radialLayout";
    private static final String SPREAD_KEY = "spread";
    private final JLabel titleLabel;
    private final OptionsPanel optionsPanel;
    private final JSpinner spreadSpinner;
    private final RadialTreeLayout treeLayout;

    public RadialTreeLayoutController(final RadialTreeLayout radialTreeLayout) {
        this.treeLayout = radialTreeLayout;
        this.titleLabel = new JLabel("Radial Layout");
        this.optionsPanel = new ControllerOptionsPanel(0, 0);
        double d = radialTreeLayout.getSpread();
        this.spreadSpinner = new JSpinner(new SpinnerNumberModel(d, 0.0, 100.0, 1.0));
        this.optionsPanel.addComponentWithLabel("Spread:", this.spreadSpinner, true);
        this.spreadSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)RadialTreeLayoutController.this.spreadSpinner.getValue();
                radialTreeLayout.setSpread(d / 100.0);
            }
        });
    }

    @Override
    public JComponent getTitleComponent() {
        return this.titleLabel;
    }

    @Override
    public JPanel getPanel() {
        return this.optionsPanel;
    }

    @Override
    public boolean isInitiallyVisible() {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setSettings(Map<String, Object> map) {
        this.spreadSpinner.setValue((Double)map.get("radialLayout.spread"));
    }

    @Override
    public void getSettings(Map<String, Object> map) {
        map.put("radialLayout.spread", this.spreadSpinner.getValue());
    }
}

