/*
 * Decompiled with CFR 0.152.
 */
package figtree.ui.components;

import figtree.ui.components.RangeSliderUI;
import javax.swing.JSlider;

public class RangeSlider
extends JSlider {
    public RangeSlider() {
        this.initSlider();
    }

    public RangeSlider(int n, int n2) {
        super(n, n2);
        this.initSlider();
    }

    private void initSlider() {
        this.setOrientation(0);
    }

    @Override
    public void updateUI() {
        this.setUI(new RangeSliderUI(this));
        this.updateLabelUIs();
    }

    @Override
    public int getValue() {
        return super.getValue();
    }

    @Override
    public void setValue(int n) {
        int n2 = this.getValue();
        if (n2 == n) {
            return;
        }
        int n3 = this.getExtent();
        int n4 = Math.min(Math.max(this.getMinimum(), n), n2 + n3);
        int n5 = n3 + n2 - n4;
        this.getModel().setRangeProperties(n4, n5, this.getMinimum(), this.getMaximum(), this.getValueIsAdjusting());
    }

    public int getUpperValue() {
        return this.getValue() + this.getExtent();
    }

    public void setUpperValue(int n) {
        int n2 = this.getValue();
        int n3 = Math.min(Math.max(0, n - n2), this.getMaximum() - n2);
        this.setExtent(n3);
    }
}

