/*
 * Decompiled with CFR 0.152.
 */
package figtree.ui.components;

import figtree.ui.components.RangeSlider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;

class RangeSliderUI
extends BasicSliderUI {
    private Color rangeColor = Color.DARK_GRAY;
    private Rectangle upperThumbRect;
    private boolean upperThumbSelected;
    private transient boolean lowerDragging;
    private transient boolean upperDragging;

    public RangeSliderUI(RangeSlider rangeSlider) {
        super(rangeSlider);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.upperThumbRect = new Rectangle();
        super.installUI(jComponent);
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new RangeTrackListener();
    }

    @Override
    protected ChangeListener createChangeListener(JSlider jSlider) {
        return new ChangeHandler();
    }

    @Override
    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.upperThumbRect.setSize(this.thumbRect.width, this.thumbRect.height);
    }

    @Override
    protected void calculateThumbLocation() {
        int n;
        super.calculateThumbLocation();
        if (this.slider.getSnapToTicks()) {
            int n2 = n = this.slider.getValue() + this.slider.getExtent();
            int n3 = this.slider.getMajorTickSpacing();
            int n4 = this.slider.getMinorTickSpacing();
            int n5 = 0;
            if (n4 > 0) {
                n5 = n4;
            } else if (n3 > 0) {
                n5 = n3;
            }
            if (n5 != 0) {
                if ((n - this.slider.getMinimum()) % n5 != 0) {
                    float f = (float)(n - this.slider.getMinimum()) / (float)n5;
                    int n6 = Math.round(f);
                    n2 = this.slider.getMinimum() + n6 * n5;
                }
                if (n2 != n) {
                    this.slider.setExtent(n2 - this.slider.getValue());
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            n = this.xPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.upperThumbRect.x = n - this.upperThumbRect.width / 2;
            this.upperThumbRect.y = this.trackRect.y;
        } else {
            n = this.yPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.upperThumbRect.x = this.trackRect.x;
            this.upperThumbRect.y = n - this.upperThumbRect.height / 2;
        }
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(12, 12);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        Rectangle rectangle = graphics.getClipBounds();
        if (this.upperThumbSelected) {
            if (rectangle.intersects(this.thumbRect)) {
                this.paintLowerThumb(graphics);
            }
            if (rectangle.intersects(this.upperThumbRect)) {
                this.paintUpperThumb(graphics);
            }
        } else {
            if (rectangle.intersects(this.upperThumbRect)) {
                this.paintUpperThumb(graphics);
            }
            if (rectangle.intersects(this.thumbRect)) {
                this.paintLowerThumb(graphics);
            }
        }
    }

    @Override
    public void paintTrack(Graphics graphics) {
        super.paintTrack(graphics);
        Rectangle rectangle = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int n = this.thumbRect.x + this.thumbRect.width / 2;
            int n2 = this.upperThumbRect.x + this.upperThumbRect.width / 2;
            int n3 = rectangle.height / 2 - 2;
            Color color = graphics.getColor();
            graphics.translate(rectangle.x, rectangle.y + n3);
            graphics.setColor(this.rangeColor);
            for (int i = 0; i <= 3; ++i) {
                graphics.drawLine(n - rectangle.x, i, n2 - rectangle.x, i);
            }
            graphics.translate(-rectangle.x, -(rectangle.y + n3));
            graphics.setColor(color);
        } else {
            int n = this.thumbRect.x + this.thumbRect.width / 2;
            int n4 = this.upperThumbRect.x + this.upperThumbRect.width / 2;
            int n5 = rectangle.width / 2 - 2;
            Color color = graphics.getColor();
            graphics.translate(rectangle.x + n5, rectangle.y);
            graphics.setColor(this.rangeColor);
            for (int i = 0; i <= 3; ++i) {
                graphics.drawLine(i, n - rectangle.y, i, n4 - rectangle.y);
            }
            graphics.translate(-(rectangle.x + n5), -rectangle.y);
            graphics.setColor(color);
        }
    }

    @Override
    public void paintThumb(Graphics graphics) {
    }

    private void paintLowerThumb(Graphics graphics) {
        Rectangle rectangle = this.thumbRect;
        int n = rectangle.width;
        int n2 = rectangle.height;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Shape shape = this.createThumbShape(n - 1, n2 - 1, false);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(rectangle.x, rectangle.y);
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fill(shape);
        graphics2D.setColor(Color.GRAY);
        graphics2D.draw(shape);
        graphics2D.dispose();
    }

    private void paintUpperThumb(Graphics graphics) {
        Rectangle rectangle = this.upperThumbRect;
        int n = rectangle.width;
        int n2 = rectangle.height;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Shape shape = this.createThumbShape(n - 1, n2 - 1, true);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(rectangle.x, rectangle.y);
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fill(shape);
        graphics2D.setColor(Color.GRAY);
        graphics2D.draw(shape);
        graphics2D.dispose();
    }

    private Shape createThumbShape(int n, int n2, boolean bl) {
        Path2D.Float float_ = new Path2D.Float();
        if (this.slider.getOrientation() == 0) {
            float f = 0.5f * (float)n;
            ((Path2D)float_).moveTo(f, 0.0);
            ((Path2D)float_).lineTo(bl ? (double)n : 0.0, f);
            ((Path2D)float_).lineTo(bl ? (double)n : 0.0, n2);
            ((Path2D)float_).lineTo(0.5 * (double)n, n2);
        } else {
            float f = 0.5f * (float)n2;
            ((Path2D)float_).moveTo(0.0, f);
            ((Path2D)float_).lineTo(f, bl ? (double)n2 : 0.0);
            ((Path2D)float_).lineTo(n, bl ? (double)n2 : 0.0);
            ((Path2D)float_).lineTo(n2, 0.5 * (double)n2);
        }
        float_.closePath();
        return float_;
    }

    private void setUpperThumbLocation(int n, int n2) {
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(this.upperThumbRect);
        this.upperThumbRect.setLocation(n, n2);
        SwingUtilities.computeUnion(this.upperThumbRect.x, this.upperThumbRect.y, this.upperThumbRect.width, this.upperThumbRect.height, rectangle);
        this.slider.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByBlock(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n2 = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (n2 <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                n2 = 1;
            }
            int n3 = n2 * (n > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int n4 = ((RangeSlider)this.slider).getUpperValue();
                ((RangeSlider)this.slider).setUpperValue(n4 + n3);
            } else {
                int n5 = this.slider.getValue();
                this.slider.setValue(n5 + n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByUnit(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n2 = 1 * (n > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int n3 = ((RangeSlider)this.slider).getUpperValue();
                ((RangeSlider)this.slider).setUpperValue(n3 + n2);
            } else {
                int n4 = this.slider.getValue();
                this.slider.setValue(n4 + n2);
            }
        }
    }

    public class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        public RangeTrackListener() {
            super(RangeSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!RangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (RangeSliderUI.this.slider.isRequestFocusEnabled()) {
                RangeSliderUI.this.slider.requestFocus();
            }
            boolean bl = false;
            boolean bl2 = false;
            Rectangle rectangle = new Rectangle(RangeSliderUI.this.upperThumbRect);
            Rectangle rectangle2 = new Rectangle(RangeSliderUI.this.thumbRect);
            if (RangeSliderUI.this.slider.getOrientation() == 0) {
                rectangle.width = (int)Math.round(0.5 * (double)rectangle.width);
                rectangle.x += rectangle.width;
                rectangle2.width = rectangle.width;
            } else {
                rectangle.height = (int)Math.round(0.5 * (double)rectangle.height);
                rectangle.y += rectangle.height;
                rectangle2.height = rectangle.height;
            }
            if (rectangle.contains(this.currentMouseX, this.currentMouseY)) {
                bl2 = true;
            } else if (rectangle2.contains(this.currentMouseX, this.currentMouseY)) {
                bl = true;
            }
            if (bl) {
                switch (RangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((RangeSliderUI)RangeSliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((RangeSliderUI)RangeSliderUI.this).thumbRect.x;
                    }
                }
                RangeSliderUI.this.upperThumbSelected = false;
                RangeSliderUI.this.lowerDragging = true;
                return;
            }
            RangeSliderUI.this.lowerDragging = false;
            if (bl2) {
                switch (RangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((RangeSliderUI)RangeSliderUI.this).upperThumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((RangeSliderUI)RangeSliderUI.this).upperThumbRect.x;
                    }
                }
                RangeSliderUI.this.upperThumbSelected = true;
                RangeSliderUI.this.upperDragging = true;
                return;
            }
            RangeSliderUI.this.upperDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            RangeSliderUI.this.lowerDragging = false;
            RangeSliderUI.this.upperDragging = false;
            RangeSliderUI.this.slider.setValueIsAdjusting(false);
            super.mouseReleased(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!RangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (RangeSliderUI.this.lowerDragging) {
                RangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveLowerThumb();
            } else if (RangeSliderUI.this.upperDragging) {
                RangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveUpperThumb();
            }
        }

        @Override
        public boolean shouldScroll(int n) {
            return false;
        }

        private void moveLowerThumb() {
            int n = 0;
            switch (RangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n2 = ((RangeSliderUI)RangeSliderUI.this).thumbRect.height / 2;
                    int n3 = this.currentMouseY - this.offset;
                    int n4 = ((RangeSliderUI)RangeSliderUI.this).trackRect.y;
                    int n5 = ((RangeSliderUI)RangeSliderUI.this).trackRect.y + (((RangeSliderUI)RangeSliderUI.this).trackRect.height - 1);
                    int n6 = RangeSliderUI.this.yPositionForValue(RangeSliderUI.this.slider.getValue() + RangeSliderUI.this.slider.getExtent());
                    if (RangeSliderUI.this.drawInverted()) {
                        n5 = n6;
                    } else {
                        n4 = n6;
                    }
                    n3 = Math.max(n3, n4 - n2);
                    n3 = Math.min(n3, n5 - n2);
                    RangeSliderUI.this.setThumbLocation(((RangeSliderUI)RangeSliderUI.this).thumbRect.x, n3);
                    n = n3 + n2;
                    RangeSliderUI.this.slider.setValue(RangeSliderUI.this.valueForYPosition(n));
                    break;
                }
                case 0: {
                    int n7 = ((RangeSliderUI)RangeSliderUI.this).thumbRect.width / 2;
                    int n8 = this.currentMouseX - this.offset;
                    int n9 = ((RangeSliderUI)RangeSliderUI.this).trackRect.x;
                    int n10 = ((RangeSliderUI)RangeSliderUI.this).trackRect.x + (((RangeSliderUI)RangeSliderUI.this).trackRect.width - 1);
                    int n11 = RangeSliderUI.this.xPositionForValue(RangeSliderUI.this.slider.getValue() + RangeSliderUI.this.slider.getExtent());
                    if (RangeSliderUI.this.drawInverted()) {
                        n9 = n11;
                    } else {
                        n10 = n11;
                    }
                    n8 = Math.max(n8, n9 - n7);
                    n8 = Math.min(n8, n10 - n7);
                    RangeSliderUI.this.setThumbLocation(n8, ((RangeSliderUI)RangeSliderUI.this).thumbRect.y);
                    n = n8 + n7;
                    RangeSliderUI.this.slider.setValue(RangeSliderUI.this.valueForXPosition(n));
                    break;
                }
                default: {
                    return;
                }
            }
        }

        private void moveUpperThumb() {
            int n = 0;
            switch (RangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n2 = ((RangeSliderUI)RangeSliderUI.this).thumbRect.height / 2;
                    int n3 = this.currentMouseY - this.offset;
                    int n4 = ((RangeSliderUI)RangeSliderUI.this).trackRect.y;
                    int n5 = ((RangeSliderUI)RangeSliderUI.this).trackRect.y + (((RangeSliderUI)RangeSliderUI.this).trackRect.height - 1);
                    int n6 = RangeSliderUI.this.yPositionForValue(RangeSliderUI.this.slider.getValue());
                    if (RangeSliderUI.this.drawInverted()) {
                        n4 = n6;
                    } else {
                        n5 = n6;
                    }
                    n3 = Math.max(n3, n4 - n2);
                    n3 = Math.min(n3, n5 - n2);
                    RangeSliderUI.this.setUpperThumbLocation(((RangeSliderUI)RangeSliderUI.this).thumbRect.x, n3);
                    n = n3 + n2;
                    RangeSliderUI.this.slider.setExtent(RangeSliderUI.this.valueForYPosition(n) - RangeSliderUI.this.slider.getValue());
                    break;
                }
                case 0: {
                    int n7 = ((RangeSliderUI)RangeSliderUI.this).thumbRect.width / 2;
                    int n8 = this.currentMouseX - this.offset;
                    int n9 = ((RangeSliderUI)RangeSliderUI.this).trackRect.x;
                    int n10 = ((RangeSliderUI)RangeSliderUI.this).trackRect.x + (((RangeSliderUI)RangeSliderUI.this).trackRect.width - 1);
                    int n11 = RangeSliderUI.this.xPositionForValue(RangeSliderUI.this.slider.getValue());
                    if (RangeSliderUI.this.drawInverted()) {
                        n10 = n11;
                    } else {
                        n9 = n11;
                    }
                    n8 = Math.max(n8, n9 - n7);
                    n8 = Math.min(n8, n10 - n7);
                    RangeSliderUI.this.setUpperThumbLocation(n8, ((RangeSliderUI)RangeSliderUI.this).thumbRect.y);
                    n = n8 + n7;
                    RangeSliderUI.this.slider.setExtent(RangeSliderUI.this.valueForXPosition(n) - RangeSliderUI.this.slider.getValue());
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (!RangeSliderUI.this.lowerDragging && !RangeSliderUI.this.upperDragging) {
                RangeSliderUI.this.calculateThumbLocation();
                RangeSliderUI.this.slider.repaint();
            }
        }
    }
}

