/*
 * Decompiled with CFR 0.152.
 */
package jam.console;

import jam.console.ConsoleFrame;
import jam.console.ConsoleMenuBarFactory;
import jam.framework.Application;
import jam.framework.DocumentFrame;
import jam.framework.MenuBarFactory;
import jam.mac.Utils;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JFrame;

public class ConsoleApplication
extends Application {
    private ConsoleFrame consoleFrame = null;
    private boolean dontAskSave;

    public ConsoleApplication(String string, String string2, Icon icon, boolean bl) throws IOException {
        this((MenuBarFactory)new ConsoleMenuBarFactory(), string, string2, icon, bl);
    }

    public ConsoleApplication(String string, String string2, String string3, Icon icon, boolean bl) throws IOException {
        this((MenuBarFactory)new ConsoleMenuBarFactory(), string, string2, string3, icon, bl);
    }

    public ConsoleApplication(MenuBarFactory menuBarFactory, String string, String string2, Icon icon, boolean bl) throws IOException {
        this(menuBarFactory, string, string, string2, icon, bl);
    }

    public ConsoleApplication(MenuBarFactory menuBarFactory, String string, String string2, String string3, Icon icon, boolean bl) throws IOException {
        super(menuBarFactory, string, string2, string3, icon);
        this.dontAskSave = bl;
        this.consoleFrame = new ConsoleFrame();
        this.consoleFrame.initialize();
        this.consoleFrame.setVisible(true);
        this.consoleFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ConsoleApplication.this.thisWindowClosing(windowEvent);
            }
        });
        this.getOpenAction().setEnabled(false);
    }

    @Override
    public void initialize() {
        Utils.registerDesktopApplication(this);
    }

    @Override
    protected JFrame getDefaultFrame() {
        return this.consoleFrame;
    }

    @Override
    public DocumentFrame doNew() {
        throw new RuntimeException("A ConsoleApplication cannot do a New command");
    }

    @Override
    public DocumentFrame doOpenFile(File file) {
        throw new RuntimeException("A ConsoleApplication cannot do an Open command");
    }

    public void doCloseWindow() {
        this.doQuit();
    }

    @Override
    public void doQuit() {
        if (this.dontAskSave || this.consoleFrame.requestClose()) {
            this.consoleFrame.setVisible(false);
            this.consoleFrame.dispose();
            System.exit(0);
        }
    }

    @Override
    public void doPreferences() {
    }

    public void doStop() {
        this.doQuit();
    }

    private void thisWindowClosing(WindowEvent windowEvent) {
        this.doQuit();
    }
}

