/*
 * Decompiled with CFR 0.152.
 */
package jam.controlpalettes;

import jam.util.IconUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JToggleButton;

public class PinnedButton
extends JToggleButton {
    private static Icon pinOutIcon = null;
    private static Icon pinOutRolloverIcon = null;
    private static Icon pinInIcon = null;
    private static Icon pinInRolloverIcon = null;

    public PinnedButton() {
        this.putClientProperty("JButton.buttonType", "toolbar");
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setupIcon();
        this.setRolloverEnabled(true);
        this.setFocusable(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PinnedButton.this.setupIcon();
            }
        });
    }

    private void setupIcon() {
        if (this.isSelected()) {
            this.setIcon(pinInIcon);
            this.setRolloverIcon(pinInRolloverIcon);
        } else {
            this.setIcon(pinOutIcon);
            this.setRolloverIcon(pinOutRolloverIcon);
        }
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        this.setupIcon();
    }

    static {
        pinOutIcon = IconUtils.getIcon(PinnedButton.class, "images/pinOut.png");
        pinOutRolloverIcon = IconUtils.getIcon(PinnedButton.class, "images/pinOutRollover.png");
        pinInIcon = IconUtils.getIcon(PinnedButton.class, "images/pinIn.png");
        pinInRolloverIcon = IconUtils.getIcon(PinnedButton.class, "images/pinInRollover.png");
    }
}

