/*
 * Decompiled with CFR 0.152.
 */
package jam.disclosure;

import jam.disclosure.DisclosureListener;
import jam.util.IconUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.Timer;

public class DisclosureButton
extends JToggleButton {
    private Timer timer = null;
    private boolean opening;
    private final List<DisclosureListener> listeners = new ArrayList<DisclosureListener>();
    private int animationSpeed;
    private boolean mouseInside = false;
    private int current;
    ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DisclosureButton.this.opening) {
                DisclosureButton.this.current++;
            } else {
                DisclosureButton.this.current--;
            }
            if (DisclosureButton.this.current < 0 || DisclosureButton.this.current >= disclosureIcons.length) {
                DisclosureButton.this.stopAnimation();
                return;
            }
            if (DisclosureButton.this.current == 1) {
                if (DisclosureButton.this.opening) {
                    DisclosureButton.this.fireOpening();
                } else {
                    DisclosureButton.this.fireClosing();
                }
            } else if (DisclosureButton.this.opening) {
                DisclosureButton.this.fireOpened();
            } else {
                DisclosureButton.this.fireClosed();
            }
            DisclosureButton.this.setIcon(disclosureIcons[DisclosureButton.this.current]);
            DisclosureButton.this.paintImmediately(0, 0, DisclosureButton.this.getWidth(), DisclosureButton.this.getHeight());
        }
    };
    private static Icon[] disclosureIcons = null;
    private static Icon rightIcon = null;
    private static Icon rightPressedIcon = null;
    private static Icon rightDownIcon = null;
    private static Icon downIcon = null;
    private static Icon downPressedIcon = null;
    private static int width = 0;
    private static int height = 0;

    public DisclosureButton() {
        this(150);
    }

    public DisclosureButton(int n) {
        this.animationSpeed = n;
        this.putClientProperty("JButton.buttonType", "toolbar");
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.setupIcon();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisclosureButton.this.opening = DisclosureButton.this.isSelected();
                DisclosureButton.this.current = DisclosureButton.this.opening ? 0 : 2;
                DisclosureButton.this.startAnimation();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                DisclosureButton.this.mouseInside = true;
                DisclosureButton.this.setupIcon();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                DisclosureButton.this.mouseInside = false;
                DisclosureButton.this.setupIcon();
            }
        });
    }

    public void addDisclosureListener(DisclosureListener disclosureListener) {
        this.listeners.add(disclosureListener);
    }

    public void removeDisclosureListener(DisclosureListener disclosureListener) {
        this.listeners.remove(disclosureListener);
    }

    private void setupIcon() {
        if (this.isSelected()) {
            this.setIcon(this.mouseInside ? downPressedIcon : downIcon);
        } else {
            this.setIcon(this.mouseInside ? rightPressedIcon : rightIcon);
        }
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        this.setupIcon();
    }

    private void startAnimation() {
        if (disclosureIcons == null) {
            return;
        }
        this.timer = new Timer(this.animationSpeed, this.listener);
        this.timer.setCoalesce(false);
        this.timer.start();
    }

    private void stopAnimation() {
        if (this.timer == null) {
            return;
        }
        this.timer.stop();
        this.setupIcon();
    }

    private void fireOpening() {
        Iterator<DisclosureListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().opening(this);
        }
    }

    private void fireOpened() {
        Iterator<DisclosureListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().opened(this);
        }
    }

    private void fireClosing() {
        Iterator<DisclosureListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().closing(this);
        }
    }

    private void fireClosed() {
        Iterator<DisclosureListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().closed(this);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(width + 4, height + 4);
    }

    static {
        try {
            rightIcon = IconUtils.getIcon(DisclosureButton.class, "images/disclosureRightNormal.png");
            rightPressedIcon = IconUtils.getIcon(DisclosureButton.class, "images/disclosureRightPressed.png");
            rightDownIcon = IconUtils.getIcon(DisclosureButton.class, "images/disclosureRightDown.png");
            downIcon = IconUtils.getIcon(DisclosureButton.class, "images/disclosureDownNormal.png");
            downPressedIcon = IconUtils.getIcon(DisclosureButton.class, "images/disclosureDownPressed.png");
            disclosureIcons = new Icon[3];
            DisclosureButton.disclosureIcons[0] = rightPressedIcon;
            DisclosureButton.disclosureIcons[1] = rightDownIcon;
            DisclosureButton.disclosureIcons[2] = downPressedIcon;
            for (Icon icon : disclosureIcons) {
                width = Math.max(width, icon.getIconWidth());
                height = Math.max(height, icon.getIconHeight());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

