/*
 * Decompiled with CFR 0.152.
 */
package jam.disclosure;

import jam.disclosure.DisclosureButton;
import jam.disclosure.DisclosureListener;
import jam.util.IconUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DisclosurePanel
extends JPanel {
    private final DisclosureButton button;
    private final Component titleComponent;
    private final JPanel panel;
    private final List<DisclosureListener> listeners = new ArrayList<DisclosureListener>();
    private static BufferedImage backgroundImage = null;

    public DisclosurePanel(String string, JPanel jPanel, boolean bl) {
        this(new JLabel(string), -1, jPanel, bl, 50);
    }

    public DisclosurePanel(JComponent jComponent, JPanel jPanel, boolean bl, int n) {
        this(jComponent, -1, jPanel, bl, n);
    }

    public DisclosurePanel(JComponent jComponent, int n, JPanel jPanel, boolean bl, int n2) {
        this.setOpaque(false);
        this.panel = jPanel;
        this.panel.setOpaque(false);
        this.button = new DisclosureButton(n2);
        this.titleComponent = jComponent;
        jComponent.setOpaque(false);
        JPanel jPanel2 = new JPanel(new BorderLayout(6, 0)){

            @Override
            public void paint(Graphics graphics) {
                graphics.drawImage(backgroundImage, 0, 0, this.getWidth(), this.getHeight(), null);
                super.paint(graphics);
            }
        };
        jPanel2.setOpaque(false);
        jPanel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DisclosurePanel.this.button.doClick();
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout(6, 0));
        jPanel3.setOpaque(false);
        jPanel3.add((Component)this.button, "West");
        jPanel3.add((Component)jComponent, "Center");
        jPanel2.add((Component)jPanel3, "Center");
        if (n > 0) {
            jPanel2.setPreferredSize(new Dimension(0, n));
        }
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)jPanel2, "North");
        this.add((Component)this.panel, "Center");
        this.setOpen(bl);
        this.button.addDisclosureListener(new DisclosureListener(){

            @Override
            public void opening(Component component) {
                DisclosurePanel.this.fireOpening();
            }

            @Override
            public void opened(Component component) {
                DisclosurePanel.this.panel.setVisible(true);
                DisclosurePanel.this.fireOpened();
            }

            @Override
            public void closing(Component component) {
                DisclosurePanel.this.fireClosing();
            }

            @Override
            public void closed(Component component) {
                DisclosurePanel.this.panel.setVisible(false);
                DisclosurePanel.this.fireClosed();
            }
        });
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getPreferredSize();
        return dimension;
    }

    public void setOpen(boolean bl) {
        this.button.setSelected(bl);
        this.panel.setVisible(bl);
    }

    public void addDisclosureListener(DisclosureListener disclosureListener) {
        this.listeners.add(disclosureListener);
    }

    public void removeDisclosureListener(DisclosureListener disclosureListener) {
        this.listeners.remove(disclosureListener);
    }

    private void fireOpening() {
        for (DisclosureListener disclosureListener : this.listeners) {
            disclosureListener.opening(this);
        }
    }

    private void fireOpened() {
        for (DisclosureListener disclosureListener : this.listeners) {
            disclosureListener.opened(this);
        }
    }

    private void fireClosing() {
        for (DisclosureListener disclosureListener : this.listeners) {
            disclosureListener.closing(this);
        }
    }

    private void fireClosed() {
        for (DisclosureListener disclosureListener : this.listeners) {
            disclosureListener.closed(this);
        }
    }

    public DisclosureButton getDisclosureButton() {
        return this.button;
    }

    public Component getTitleComponent() {
        return this.titleComponent;
    }

    public JPanel getContentsPanel() {
        return this.panel;
    }

    static {
        try {
            backgroundImage = IconUtils.getBufferedImage(DisclosurePanel.class, "images/titleBackground.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

