/*
 * Decompiled with CFR 0.152.
 */
package jam.framework;

import jam.framework.AbstractFrame;
import jam.html.SimpleLinkListener;
import jam.util.IconUtils;
import jam.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutBox
extends AbstractFrame {
    public AboutBox(String string, String string2, Icon icon) {
        if (icon != null) {
            this.setIconImage(IconUtils.getBufferedImageFromIcon(icon));
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AboutBox.this.close();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 10) {
                    AboutBox.this.close();
                }
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setBackground(Color.white);
        JLabel jLabel = new JLabel(string, 0);
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(32.0f).deriveFont(0));
        jLabel.setIcon(icon);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        font = font.deriveFont(11.0f);
        if (string2.startsWith("<html>")) {
            JEditorPane jEditorPane = new JEditorPane("text/html", string2);
            jEditorPane.setOpaque(false);
            jEditorPane.setFont(font);
            jEditorPane.setEditable(false);
            jEditorPane.addHyperlinkListener(new SimpleLinkListener());
            jPanel.add((Component)jEditorPane, gridBagConstraints);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                JLabel jLabel2 = new JLabel(string3, 0);
                jLabel2.setFont(font);
                jPanel.add((Component)jLabel2, gridBagConstraints);
            }
        }
        this.getSaveAction().setEnabled(false);
        this.getSaveAsAction().setEnabled(false);
        this.getPrintAction().setEnabled(false);
        this.getPageSetupAction().setEnabled(false);
        this.getCutAction().setEnabled(false);
        this.getCopyAction().setEnabled(false);
        this.getPasteAction().setEnabled(false);
        this.getDeleteAction().setEnabled(false);
        this.getSelectAllAction().setEnabled(false);
        this.getFindAction().setEnabled(false);
        this.getZoomWindowAction().setEnabled(false);
        this.getMinimizeWindowAction().setEnabled(true);
        this.getCloseWindowAction().setEnabled(true);
        this.getContentPane().add(jPanel);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        Utils.centerComponent(this, null);
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    protected void initializeComponents() {
    }

    @Override
    public boolean requestClose() {
        return false;
    }

    @Override
    public JComponent getExportableComponent() {
        return null;
    }
}

