/*
 * Decompiled with CFR 0.152.
 */
package jam.framework;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.EventListenerList;

public class RecentFileList
implements ActionListener {
    private Vector files;
    private String type;
    private int size;
    private int used;
    private EventListenerList listenerList = new EventListenerList();

    public RecentFileList() {
        this(null);
    }

    public RecentFileList(int n) {
        this(null, n);
    }

    public RecentFileList(String string) {
        this(string, 4);
    }

    public RecentFileList(String string, int n) {
        this.files = new Vector(n);
        this.size = n;
        this.type = string;
        this.used = 0;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fireActionPerformed(actionEvent);
    }

    public void save(Properties properties) {
        String string = "RecentFile_" + (this.type != null ? this.type + "_" : "");
        for (int i = 0; i < this.used; ++i) {
            properties.put(string + i, this.files.elementAt(i).toString());
        }
        properties.put(string + "Used", String.valueOf(this.used));
    }

    public void load(Properties properties) {
        String string;
        String string2 = "RecentFile_" + (this.type != null ? this.type + "_" : "");
        this.files.removeAllElements();
        this.used = Integer.parseInt(properties.getProperty(string2 + "Used", "0"));
        for (int i = 0; i < this.used && (string = properties.getProperty(string2 + i)) != null; ++i) {
            this.files.addElement(string);
        }
    }

    public void add(File file) {
        try {
            this.add(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            this.add(file.getAbsolutePath());
        }
    }

    public void remove(File file) {
        this.remove(file.getName());
    }

    public void add(String string) {
        int n = this.files.indexOf(string);
        if (n > 0) {
            this.files.removeElementAt(n);
            this.files.insertElementAt(string, 0);
        } else if (n != 0) {
            if (this.used == this.size) {
                this.files.removeElementAt(this.size - 1);
            } else {
                ++this.used;
            }
            this.files.insertElementAt(string, 0);
        }
    }

    public void remove(String string) {
        if (this.files.removeElement(string)) {
            --this.used;
        }
    }

    public void buildMenu(JMenu jMenu) {
        if (this.used > 0) {
            jMenu.addSeparator();
            for (int i = 0; i < this.used; ++i) {
                JMenuItem jMenuItem = new JMenuItem(String.valueOf(i + 1) + " " + this.files.elementAt(i));
                jMenuItem.setActionCommand(this.files.elementAt(i).toString());
                if (this.size < 9) {
                    jMenuItem.setMnemonic(Character.forDigit(i + 1, 10));
                }
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
            }
        }
    }
}

