/*
 * Decompiled with CFR 0.152.
 */
package jam.java9only;

import jam.framework.Application;
import jam.framework.DocumentFrame;
import java.awt.Desktop;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.PrintFilesEvent;
import java.awt.desktop.PrintFilesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.io.File;
import javax.swing.JMenuBar;

public class ApplicationAdapter
implements AboutHandler,
PreferencesHandler,
OpenFilesHandler,
PrintFilesHandler,
QuitHandler {
    private static ApplicationAdapter theAdapter;
    private Application application;

    private ApplicationAdapter(Application application) {
        this.application = application;
    }

    public static void registerApplication(Application application) {
        if (theAdapter == null) {
            theAdapter = new ApplicationAdapter(application);
        }
        Desktop.getDesktop().setAboutHandler(theAdapter);
        Desktop.getDesktop().setOpenFileHandler(theAdapter);
        Desktop.getDesktop().setPreferencesHandler(theAdapter);
        Desktop.getDesktop().setPrintFileHandler(theAdapter);
        Desktop.getDesktop().setQuitHandler(theAdapter);
        JMenuBar jMenuBar = new JMenuBar();
        if (Application.getMenuBarFactory() != null) {
            Application.getMenuBarFactory().populateMenuBar(jMenuBar, null);
            Desktop.getDesktop().setDefaultMenuBar(jMenuBar);
        }
    }

    @Override
    public void handleAbout(AboutEvent aboutEvent) {
        if (this.application == null) {
            throw new IllegalStateException("handleAbout: Application instance detached from listener");
        }
        this.application.doAbout();
    }

    @Override
    public void openFiles(OpenFilesEvent openFilesEvent) {
        for (File file : openFilesEvent.getFiles()) {
            this.application.doOpenFile(file);
        }
    }

    @Override
    public void handlePreferences(PreferencesEvent preferencesEvent) {
        if (this.application == null) {
            throw new IllegalStateException("handlePreferences: Application instance detached from listener");
        }
        this.application.doPreferences();
    }

    @Override
    public void printFiles(PrintFilesEvent printFilesEvent) {
        for (File file : printFilesEvent.getFiles()) {
            DocumentFrame documentFrame = this.application.doOpenFile(file);
            if (documentFrame == null) continue;
            documentFrame.doPrint();
        }
    }

    @Override
    public void handleQuitRequestWith(QuitEvent quitEvent, QuitResponse quitResponse) {
        if (this.application == null) {
            throw new IllegalStateException("handleQuit: Application instance detached from listener");
        }
        this.application.doQuit();
    }
}

