/*
 * Decompiled with CFR 0.152.
 */
package jam.mac;

import jam.framework.Application;
import java.lang.reflect.Method;

public class Utils {
    private static boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private static String MAC_OS_X_VERSION = MAC_OS_X ? System.getProperty("os.version") : null;

    public static boolean isMacOSX() {
        return MAC_OS_X;
    }

    public static String getMacOSXVersion() {
        return MAC_OS_X_VERSION;
    }

    public static int getMacOSXMajorVersionNumber() {
        String[] stringArray = Utils.getMacOSXVersion().split("\\.");
        if (stringArray.length >= 2 && stringArray[0].equals("10")) {
            return Integer.parseInt(stringArray[1]);
        }
        return -1;
    }

    public static void registerDesktopApplication(Application application) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("jam.java9only.ApplicationAdapter");
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null && MAC_OS_X) {
            try {
                Class.forName("com.apple.eawt.AboutHandler");
                clazz = Class.forName("jam.maconly.NewOSXAdapter");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                Class[] classArray = new Class[]{Application.class};
                Method method = clazz.getDeclaredMethod("registerApplication", classArray);
                if (method != null) {
                    Object[] objectArray = new Object[]{application};
                    method.invoke(clazz, objectArray);
                }
            }
            catch (Exception exception) {
                System.err.println("Exception while loading the ApplicationAdapter:");
                exception.printStackTrace();
            }
        }
    }
}

