/*
 * Decompiled with CFR 0.152.
 */
package jam.panels;

import jam.util.IconUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class AddRemovePanel
extends JPanel {
    private Icon addIcon = null;
    private Icon addRolloverIcon = null;
    private Icon addPressedIcon = null;
    private Icon removeIcon = null;
    private Icon removeRolloverIcon = null;
    private Icon removePressedIcon = null;
    AbstractAction removeAction = new AbstractAction("-"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    };
    private ArrayList panels = new ArrayList();

    public AddRemovePanel() {
        this((JPanel[])null);
    }

    public AddRemovePanel(JPanel[] jPanelArray) {
        Serializable serializable;
        try {
            this.addIcon = IconUtils.getIcon(AddRemovePanel.class, "images/plusminus/plus.png");
            this.addRolloverIcon = IconUtils.getIcon(AddRemovePanel.class, "images/plusminus/plusRollover.png");
            this.addPressedIcon = IconUtils.getIcon(AddRemovePanel.class, "images/plusminus/plusPressed.png");
            this.removeIcon = IconUtils.getIcon(AddRemovePanel.class, "images/plusminus/minus.png");
            this.removeRolloverIcon = IconUtils.getIcon(AddRemovePanel.class, "images/plusminus/minusRollover.png");
            this.removePressedIcon = IconUtils.getIcon(AddRemovePanel.class, "images/plusminus/minusPressed.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        BoxLayout boxLayout = new BoxLayout(this, 3);
        this.setLayout(boxLayout);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setOpaque(false);
        if (jPanelArray != null && jPanelArray.length > 0) {
            serializable = null;
            for (int i = 0; i < jPanelArray.length; ++i) {
                JPanel jPanel = jPanelArray[i];
                this.addPanel((JPanel)serializable, jPanel);
                serializable = jPanel;
            }
        } else {
            this.addPanel(null);
        }
        serializable = super.getPreferredSize();
        serializable.height = (int)((double)serializable.height + this.getComponent(0).getPreferredSize().getHeight());
        this.setMinimumSize((Dimension)serializable);
        this.setPreferredSize((Dimension)serializable);
    }

    public List getPanels() {
        return Collections.unmodifiableList(this.panels);
    }

    protected abstract JPanel createPanel();

    private void addPanel(JPanel jPanel) {
        this.addPanel(jPanel, this.createPanel());
    }

    private void addPanel(JPanel jPanel, JPanel jPanel2) {
        RowPanel rowPanel = new RowPanel(jPanel2);
        if (jPanel != null) {
            int n = this.panels.indexOf(jPanel);
            this.add((Component)rowPanel, n + 1);
            this.panels.add(n + 1, jPanel2);
        } else {
            this.add((Component)rowPanel, 0);
            this.panels.add(0, jPanel2);
        }
        this.removeAction.setEnabled(this.panels.size() > 1);
        this.validate();
        this.repaint();
    }

    private void removePanel(JPanel jPanel) {
        int n = this.panels.indexOf(jPanel);
        this.remove(n);
        this.panels.remove(n);
        this.removeAction.setEnabled(this.panels.size() > 1);
        this.validate();
        this.repaint();
    }

    class RowPanel
    extends JPanel {
        RowPanel(final JPanel jPanel) {
            this.setLayout(new GridBagLayout());
            this.setOpaque(true);
            this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.lightGray));
            this.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.05f));
            JButton jButton = new JButton("+");
            jButton.putClientProperty("JButton.buttonType", "toolbar");
            jButton.setOpaque(false);
            if (AddRemovePanel.this.addIcon != null) {
                jButton.setIcon(AddRemovePanel.this.addIcon);
                jButton.setPressedIcon(AddRemovePanel.this.addPressedIcon);
                jButton.setRolloverIcon(AddRemovePanel.this.addRolloverIcon);
                jButton.setRolloverEnabled(true);
                jButton.setText(null);
            }
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddRemovePanel.this.addPanel(jPanel);
                }
            });
            jButton.setEnabled(true);
            JButton jButton2 = new JButton(AddRemovePanel.this.removeAction);
            jButton2.putClientProperty("JButton.buttonType", "toolbar");
            jButton2.setOpaque(false);
            if (AddRemovePanel.this.removeIcon != null) {
                jButton2.setIcon(AddRemovePanel.this.removeIcon);
                jButton2.setPressedIcon(AddRemovePanel.this.removePressedIcon);
                jButton2.setRolloverIcon(AddRemovePanel.this.removeRolloverIcon);
                jButton2.setRolloverEnabled(true);
                jButton2.setText(null);
            }
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddRemovePanel.this.removePanel(jPanel);
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(1, 2, 0, 2);
            gridBagConstraints.gridx = -1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            this.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)jButton, gridBagConstraints);
            this.add((Component)jButton2, gridBagConstraints);
        }
    }
}

