/*
 * Decompiled with CFR 0.152.
 */
package jam.panels;

import jam.panels.RuleModel;
import jam.util.IconUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RulesPanel
extends JPanel {
    private Icon addIcon = null;
    private Icon addRolloverIcon = null;
    private Icon addPressedIcon = null;
    private Icon removeIcon = null;
    private Icon removeRolloverIcon = null;
    private Icon removePressedIcon = null;
    AbstractAction removeAction = new AbstractAction("-"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    };
    private RuleModel ruleModel;
    private ArrayList rules = new ArrayList();

    public RulesPanel(RuleModel ruleModel) {
        this.ruleModel = ruleModel;
        try {
            this.addIcon = IconUtils.getIcon(RulesPanel.class, "images/plusminus/plus.png");
            this.addRolloverIcon = IconUtils.getIcon(RulesPanel.class, "images/plusminus/plusRollover.png");
            this.addPressedIcon = IconUtils.getIcon(RulesPanel.class, "images/plusminus/plusPressed.png");
            this.removeIcon = IconUtils.getIcon(RulesPanel.class, "images/plusminus/minus.png");
            this.removeRolloverIcon = IconUtils.getIcon(RulesPanel.class, "images/plusminus/minusRollover.png");
            this.removePressedIcon = IconUtils.getIcon(RulesPanel.class, "images/plusminus/minusPressed.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        BoxLayout boxLayout = new BoxLayout(this, 3);
        this.setLayout(boxLayout);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setOpaque(false);
        this.addRule(null);
        Dimension dimension = super.getPreferredSize();
        dimension.height = (int)((double)dimension.height + this.getComponent(0).getPreferredSize().getHeight());
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
    }

    public List getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    private void addRule(Rule rule) {
        DefaultRule defaultRule = new DefaultRule();
        RulePanel rulePanel = new RulePanel(defaultRule);
        if (rule != null) {
            int n = this.rules.indexOf(rule);
            this.add((Component)rulePanel, n + 1);
            this.rules.add(n + 1, defaultRule);
        } else {
            this.add((Component)rulePanel, 0);
            this.rules.add(0, defaultRule);
        }
        this.removeAction.setEnabled(this.rules.size() > 1);
        this.validate();
        this.repaint();
    }

    private void removeRule(Rule rule) {
        int n = this.rules.indexOf(rule);
        this.remove(n);
        this.rules.remove(n);
        this.removeAction.setEnabled(this.rules.size() > 1);
        this.validate();
        this.repaint();
    }

    class RulePanel
    extends JPanel {
        RulePanel(final DefaultRule defaultRule) {
            this.setLayout(new GridBagLayout());
            this.setOpaque(true);
            this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.lightGray));
            this.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.05f));
            defaultRule.fieldCombo = new JComboBox<Object>(RulesPanel.this.ruleModel.getFields());
            defaultRule.conditionCombo = new JComboBox<Object>(RulesPanel.this.ruleModel.getConditions(defaultRule.getField()));
            defaultRule.fieldCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    defaultRule.conditionCombo.setModel(new DefaultComboBoxModel<Object>(RulesPanel.this.ruleModel.getConditions(defaultRule.getField())));
                }
            });
            defaultRule.valueText = new JTextField("");
            defaultRule.valueText.setColumns(12);
            JButton jButton = new JButton("+");
            jButton.putClientProperty("JButton.buttonType", "toolbar");
            jButton.setOpaque(false);
            if (RulesPanel.this.addIcon != null) {
                jButton.setIcon(RulesPanel.this.addIcon);
                jButton.setPressedIcon(RulesPanel.this.addPressedIcon);
                jButton.setRolloverIcon(RulesPanel.this.addRolloverIcon);
                jButton.setRolloverEnabled(true);
                jButton.setText(null);
            }
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RulesPanel.this.addRule(defaultRule);
                }
            });
            jButton.setEnabled(true);
            JButton jButton2 = new JButton(RulesPanel.this.removeAction);
            jButton2.putClientProperty("JButton.buttonType", "toolbar");
            jButton2.setOpaque(false);
            if (RulesPanel.this.removeIcon != null) {
                jButton2.setIcon(RulesPanel.this.removeIcon);
                jButton2.setPressedIcon(RulesPanel.this.removePressedIcon);
                jButton2.setRolloverIcon(RulesPanel.this.removeRolloverIcon);
                jButton2.setRolloverEnabled(true);
                jButton2.setText(null);
            }
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RulesPanel.this.removeRule(defaultRule);
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(1, 2, 0, 2);
            gridBagConstraints.gridx = -1;
            this.add((Component)defaultRule.fieldCombo, gridBagConstraints);
            this.add((Component)defaultRule.conditionCombo, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            this.add((Component)defaultRule.valueText, gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)jButton, gridBagConstraints);
            this.add((Component)jButton2, gridBagConstraints);
        }
    }

    class DefaultRule
    implements Rule {
        JComboBox fieldCombo;
        JComboBox conditionCombo;
        JTextField valueText;

        DefaultRule() {
        }

        @Override
        public Object getField() {
            return this.fieldCombo.getSelectedItem();
        }

        @Override
        public Object getCondition() {
            return this.conditionCombo.getSelectedItem();
        }

        @Override
        public Object getValue() {
            return this.valueText.getText();
        }
    }

    public static interface Rule {
        public Object getField();

        public Object getCondition();

        public Object getValue();
    }
}

