/*
 * Decompiled with CFR 0.152.
 */
package jam.panels;

import jam.panels.StatusListener;
import java.util.ArrayList;
import java.util.List;

public interface StatusProvider {
    public void addStatusListener(StatusListener var1);

    public void removeStatusListener(StatusListener var1);

    public void fireStatusChanged(int var1, String var2);

    public void statusButtonPressed();

    public String getStatusText();

    public int getStatus();

    public void fireStatusButtonPressed();

    public void addOverrideProvider(StatusProvider var1);

    public void removeOverrideProvider(StatusProvider var1);

    public static class Helper
    implements StatusProvider {
        private int lastStatus = 0;
        private String lastStatusText = "";
        private List listeners = new ArrayList();
        private List overrideListeners = new ArrayList();
        private List overrideProviders = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addStatusListener(StatusListener statusListener) {
            Helper helper = this;
            synchronized (helper) {
                this.listeners.add(statusListener);
            }
            statusListener.statusChanged(this.lastStatus, this.lastStatusText);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void removeStatusListener(StatusListener statusListener) {
            Helper helper = this;
            synchronized (helper) {
                this.listeners.remove(statusListener);
            }
            statusListener.statusChanged(0, "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void realFireStatusChanged() {
            ArrayList arrayList;
            String string;
            int n;
            StatusProvider statusProvider = null;
            Object object = this;
            synchronized (object) {
                n = this.lastStatus;
                string = this.lastStatusText;
                int n2 = this.overrideProviders.size() - 1;
                if (n2 >= 0) {
                    statusProvider = (StatusProvider)this.overrideProviders.get(n2);
                }
                arrayList = new ArrayList(this.listeners);
            }
            if (statusProvider != null) {
                n = statusProvider.getStatus();
                string = statusProvider.getStatusText();
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                ((StatusListener)object.next()).statusChanged(n, string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fireStatusChanged(int n, String string) {
            Helper helper = this;
            synchronized (helper) {
                this.lastStatus = n;
                this.lastStatusText = string;
            }
            this.realFireStatusChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addOverrideProvider(final StatusProvider statusProvider) {
            StatusListener statusListener = new StatusListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void statusChanged(int n, String string) {
                    boolean bl;
                    Helper helper = Helper.this;
                    synchronized (helper) {
                        bl = Helper.this.overrideProviders.size() > 0 && Helper.this.overrideProviders.get(Helper.this.overrideProviders.size() - 1) == statusProvider;
                    }
                    if (bl) {
                        Helper.this.realFireStatusChanged();
                    }
                }
            };
            Helper helper = this;
            synchronized (helper) {
                statusProvider.addStatusListener(statusListener);
                this.overrideProviders.add(statusProvider);
                this.overrideListeners.add(statusListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeOverrideProvider(StatusProvider statusProvider) {
            Helper helper = this;
            synchronized (helper) {
                for (int i = 0; i < this.overrideProviders.size(); ++i) {
                    if (this.overrideProviders.get(i) != statusProvider) continue;
                    this.overrideProviders.remove(i);
                    StatusListener statusListener = (StatusListener)this.overrideListeners.get(i);
                    statusProvider.removeStatusListener(statusListener);
                    this.overrideListeners.remove(i);
                    break;
                }
            }
            this.realFireStatusChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fireStatusButtonPressed() {
            StatusProvider statusProvider = null;
            Helper helper = this;
            synchronized (helper) {
                int n = this.overrideProviders.size();
                if (n > 0) {
                    statusProvider = (StatusProvider)this.overrideProviders.get(n - 1);
                }
            }
            if (statusProvider != null) {
                statusProvider.fireStatusButtonPressed();
            } else {
                this.statusButtonPressed();
            }
        }

        @Override
        public void statusButtonPressed() {
        }

        @Override
        public synchronized int getStatus() {
            return this.lastStatus;
        }

        @Override
        public synchronized String getStatusText() {
            return this.lastStatusText;
        }

        public synchronized boolean hasOverrideProvider() {
            return !this.overrideProviders.isEmpty();
        }
    }
}

