/*
 * Decompiled with CFR 0.152.
 */
package jam.preferences;

import jam.preferences.PreferencesSection;
import jam.toolbar.Toolbar;
import jam.toolbar.ToolbarAction;
import jam.toolbar.ToolbarButton;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class PreferencesDialog {
    private JFrame frame;
    private CardLayout cardLayout;
    private JPanel sectionsPanel;
    String currentSection = null;
    private List<PreferencesSection> sections = new ArrayList<PreferencesSection>();
    private Map<String, JPanel> buttons = new HashMap<String, JPanel>();

    public PreferencesDialog(JFrame jFrame) {
        this.frame = jFrame;
    }

    public void showDialog() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Toolbar toolbar = new Toolbar(null);
        toolbar.setFloatable(false);
        this.cardLayout = new CardLayout();
        this.sectionsPanel = new JPanel(this.cardLayout);
        this.sectionsPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        jPanel.add((Component)toolbar, "North");
        jPanel.add((Component)this.sectionsPanel, "Center");
        JOptionPane jOptionPane = new JOptionPane(jPanel, -1, -1, null, new String[]{"Done"}, null);
        jOptionPane.setBorder(new EmptyBorder(0, 0, 12, 0));
        final JDialog jDialog = jOptionPane.createDialog(this.frame, this.currentSection);
        for (PreferencesSection preferencesSection : this.sections) {
            final String string = preferencesSection.getTitle();
            if (this.currentSection == null) {
                this.currentSection = string;
            }
            ToolbarButton toolbarButton = new ToolbarButton(new ToolbarAction(string, string, preferencesSection.getIcon()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PreferencesDialog.this.showSection(string);
                    PreferencesDialog.this.currentSection = string;
                    jDialog.setTitle(PreferencesDialog.this.currentSection);
                }
            });
            toolbarButton.setFocusable(false);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
            jPanel2.add((Component)toolbarButton, "Center");
            toolbar.addComponent(jPanel2);
            this.sectionsPanel.add((Component)preferencesSection.getPanel(), string);
            this.buttons.put(string, jPanel2);
            preferencesSection.retrievePreferences();
        }
        toolbar.addFlexibleSpace();
        this.showSection(this.currentSection);
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PreferencesDialog.this.storePreferences();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                PreferencesDialog.this.storePreferences();
            }
        });
        jDialog.pack();
        jDialog.setVisible(true);
    }

    public void storePreferences() {
        for (PreferencesSection preferencesSection : this.sections) {
            preferencesSection.storePreferences();
        }
    }

    public void showSection(String string) {
        this.cardLayout.show(this.sectionsPanel, string);
        JPanel jPanel = this.buttons.get(this.currentSection);
        if (jPanel != null) {
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
            jPanel.setOpaque(false);
            jPanel = this.buttons.get(string);
            jPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 1, Color.gray));
            jPanel.setBackground(new Color(0.85f, 0.85f, 0.85f, 0.5f));
            jPanel.setOpaque(true);
            jPanel.repaint();
        }
    }

    public void addSection(PreferencesSection preferencesSection) {
        this.sections.add(preferencesSection);
    }
}

