/*
 * Decompiled with CFR 0.152.
 */
package jam.table;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class HeaderRenderer
extends DefaultTableCellRenderer {
    public HeaderRenderer(int n, Insets insets) {
        this.setHorizontalAlignment(n);
        this.setOpaque(true);
        Border border = UIManager.getBorder("TableHeader.cellBorder");
        this.setBorder(new CompoundBorder(border, new EmptyBorder(insets)));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JTableHeader jTableHeader;
        if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
            this.setEnabled(jTableHeader.isEnabled());
            this.setComponentOrientation(jTableHeader.getComponentOrientation());
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            this.setFont(jTableHeader.getFont());
        } else {
            this.setEnabled(true);
            this.setComponentOrientation(ComponentOrientation.UNKNOWN);
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.setFont(UIManager.getFont("TableHeader.font"));
        }
        this.setValue(object);
        return this;
    }
}

