/*
 * Decompiled with CFR 0.152.
 */
package jam.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.plaf.BorderUIResource;
import javax.swing.table.DefaultTableCellRenderer;

public class TableRenderer
extends DefaultTableCellRenderer {
    protected Color bg1 = new Color(237, 243, 254);
    protected Color bg2 = Color.white;
    protected boolean striped;

    public TableRenderer(int n, Insets insets) {
        this(true, n, insets);
    }

    public TableRenderer(boolean bl, int n, Insets insets) {
        this.striped = bl;
        this.setOpaque(true);
        this.setHorizontalAlignment(n);
        if (insets != null) {
            this.setBorder(new BorderUIResource.EmptyBorderUIResource(insets));
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object != null) {
            this.setText(object.toString());
        }
        this.setEnabled(jTable.isEnabled());
        this.setFont(jTable.getFont());
        if (bl) {
            this.setBackground(jTable.getSelectionBackground());
            this.setForeground(jTable.getSelectionForeground());
        } else {
            if (this.striped) {
                if (n % 2 == 0) {
                    this.setBackground(this.bg1);
                } else {
                    this.setBackground(this.bg2);
                }
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setForeground(jTable.getForeground());
        }
        return this;
    }
}

