/*
 * Decompiled with CFR 0.152.
 */
package jam.toolbar;

import jam.toolbar.ToolbarItem;
import jam.toolbar.ToolbarOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Toolbar
extends JToolBar {
    private ToolbarOptions options;
    private final JRadioButtonMenuItem iconTextMenuItem;
    private final JRadioButtonMenuItem iconOnlyMenuItem;
    private final JRadioButtonMenuItem textOnlyMenuItem;
    private final JCheckBoxMenuItem smallSizeMenuItem;
    private List<ToolbarItem> toolbarItems = new ArrayList<ToolbarItem>();

    public Toolbar() {
        this(new ToolbarOptions(0, false));
    }

    public Toolbar(ToolbarOptions toolbarOptions) {
        this.options = toolbarOptions;
        this.putClientProperty("Quaqua.ToolBar.isDividerDrawn", Boolean.TRUE);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.setLayout(new GridBagLayout());
        if (toolbarOptions != null) {
            final JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.setLightWeightPopupEnabled(false);
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    Toolbar.this.toolbarOptionsChanged();
                }
            };
            ButtonGroup buttonGroup = new ButtonGroup();
            this.iconTextMenuItem = new JRadioButtonMenuItem("Icon & Text");
            this.iconTextMenuItem.addChangeListener(changeListener);
            buttonGroup.add(this.iconTextMenuItem);
            jPopupMenu.add(this.iconTextMenuItem);
            this.iconOnlyMenuItem = new JRadioButtonMenuItem("Icon Only");
            this.iconOnlyMenuItem.addChangeListener(changeListener);
            buttonGroup.add(this.iconOnlyMenuItem);
            jPopupMenu.add(this.iconOnlyMenuItem);
            this.textOnlyMenuItem = new JRadioButtonMenuItem("Text Only");
            this.textOnlyMenuItem.addChangeListener(changeListener);
            buttonGroup.add(this.textOnlyMenuItem);
            jPopupMenu.add(this.textOnlyMenuItem);
            jPopupMenu.add(new JSeparator());
            this.smallSizeMenuItem = new JCheckBoxMenuItem("Small Size");
            this.smallSizeMenuItem.addChangeListener(changeListener);
            jPopupMenu.add(this.smallSizeMenuItem);
            jPopupMenu.add(new JSeparator());
            JMenuItem jMenuItem = new JMenuItem("Customize Toolbar...");
            jMenuItem.setEnabled(false);
            jPopupMenu.add(jMenuItem);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            this.iconTextMenuItem.setSelected(toolbarOptions.getDisplay() == 0);
            this.iconOnlyMenuItem.setSelected(toolbarOptions.getDisplay() == 1);
            this.textOnlyMenuItem.setSelected(toolbarOptions.getDisplay() == 2);
            this.smallSizeMenuItem.setSelected(toolbarOptions.getSmallSize());
        } else {
            this.iconTextMenuItem = null;
            this.iconOnlyMenuItem = null;
            this.textOnlyMenuItem = null;
            this.smallSizeMenuItem = null;
        }
    }

    public void addComponent(JComponent jComponent) {
        if (jComponent instanceof ToolbarItem) {
            ToolbarItem toolbarItem = (ToolbarItem)((Object)jComponent);
            this.toolbarItems.add(toolbarItem);
            toolbarItem.setToolbarOptions(this.options);
        }
        this.addItem(jComponent);
    }

    @Override
    public void addSeparator() {
        super.addSeparator();
    }

    public void addSpace() {
        this.addItem(new JToolBar.Separator());
    }

    private void addItem(JComponent jComponent) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)jComponent, gridBagConstraints);
    }

    public void addFlexibleSpace() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new JToolBar.Separator(), gridBagConstraints);
    }

    private void toolbarOptionsChanged() {
        int n = this.iconTextMenuItem.isSelected() ? 0 : (this.iconOnlyMenuItem.isSelected() ? 1 : 2);
        boolean bl = this.smallSizeMenuItem.isSelected();
        this.setToolbarOptions(new ToolbarOptions(n, bl));
    }

    private void setToolbarOptions(ToolbarOptions toolbarOptions) {
        this.options = toolbarOptions;
        for (ToolbarItem toolbarItem : this.toolbarItems) {
            toolbarItem.setToolbarOptions(this.options);
        }
        this.validate();
        this.repaint();
    }
}

