# How to Delete Your Netdata Account

:::note

Account deletion is permanent and cannot be undone. All user preferences will be lost.

:::

## Step-by-Step Guide

### Step 1: Access Your Profile Settings

Navigate to the Netdata UI and locate your **user profile icon** in the bottom-left corner of the interface. Click on it to open the profile menu.

### Step 2: Open Settings

From the profile menu, click on **"Settings"** to access your account settings page.

![settings](https://raw.githubusercontent.com/netdata/docs-images/refs/heads/master/netdata-cloud/account-management/delete-account/profile-menu-settings.png)

### Step 3: Locate the Delete Account Option

Once in the Settings page, your profile information will appear in a pop-up window on the right side of the screen. Scroll to the bottom of this pop-up where you'll find the **"Delete account"** option in red text.

### Step 4: Confirm Account Deletion

Click on **"Delete account"**. A confirmation dialog will appear with the following warning:

![delete dialog](https://raw.githubusercontent.com/netdata/docs-images/refs/heads/master/netdata-cloud/account-management/delete-account/delete-confirmation-dialog.png)

### Step 5: Final Confirmation

You have two options:

| Action | Button | Result |
|--------|--------|--------|
| **Cancel** | Green button | Returns you to settings without deleting account |
| **Yes, delete** | Red button | Permanently deletes your account immediately |

## Important Considerations

Before deleting your account, consider:

- **Team access**: If you're part of a team Space, ensure you've transferred any necessary permissions
- **No recovery**: There is no grace period or recovery option once deletion is confirmed

## Alternative Options

Before deleting your account, consider these alternatives:

1. **Pause Monitoring** - Temporarily disable monitoring without losing configurations
2. **Sign Out** - Simply sign out if you need a break from the platform
3. **Contact Support** - Reach out to [Netdata support](https://www.netdata.cloud/support/) if you're experiencing resolvable issues
4. **Disable Notifications** - Turn off alerts if they're overwhelming

## FAQ

<details>
<summary><strong>Can I recover my account after deletion?</strong></summary>

No. Account deletion is permanent and cannot be reversed under any circumstances.

</details>

<details>
<summary><strong>What happens to my connected agents?</strong></summary>

Agents will continue collecting data locally, but will lose their connection to deleted account.
</details>

<details>
<summary><strong>How long does deletion take?</strong></summary>

Account deletion is immediate.

</details>

<details>
<summary><strong>Will my historical data be saved anywhere?</strong></summary>

Yes, all historical data will be safely stored and another active user in the Space can still access that data. 

</details>

<details>
<summary><strong>Can someone else in my Space prevent my account deletion?</strong></summary>

No. Account deletion is a personal action that only you can initiate and complete. Other Space members cannot prevent or reverse your account deletion.

</details>

:::note

Once you confirm deletion, there is no undo button or recovery process.

:::
