<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/snmp/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/snmp/metadata.yaml"
sidebar_label: "SNMP devices"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Generic Collecting Metrics"
most_popular: True
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# SNMP devices


<img src="https://netdata.cloud/img/snmp.png" width="150"/>


Plugin: go.d.plugin
Module: snmp

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This SNMP collector discovers and gathers statistics for network interfaces on SNMP-enabled devices:

- Traffic
- Packets (unicast, multicast, broadcast)
- Errors
- Discards
- Administrative and operational status

Additionally, it collects overall device uptime.

It is compatible with all SNMP versions (v1, v2c, and v3) and uses the [gosnmp](https://github.com/gosnmp/gosnmp) package.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

SNMP service discovery is a dedicated component that automatically scans configured networks to find SNMP-enabled devices. 

- This feature is disabled by default and requires explicit user configuration to activate.
- When enabled, it discovers devices using customizable credentials, supports various IP range formats (single IPs, ranges, CIDR) with a limit of 512 IPs per subnet, and optimizes network traffic through configurable caching of discovery results.
- Discovered devices are automatically made available to the SNMP collector for monitoring.

The configuration file name is [go.d/sd/snmp.conf](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/config/go.d/sd/snmp.conf).

You can edit the configuration file using the edit-config script from the Netdata [config directory](https://learn.netdata.cloud/docs/netdata-agent/configuration#the-netdata-config-directory).

```bash
 cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
 sudo ./edit-config go.d/sd/snmp.conf
 ```


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

**Device limitations**: Many SNMP switches and routers have limited processing power. They might not be able to report data as frequently as desired. You can monitor response times using go.d.plugin in debug mode to identify potential bottlenecks.

**Concurrent access**: If multiple collectors or tools access the same SNMP device simultaneously, data points might be skipped. This is a limitation of the device itself, not this collector. To mitigate this, consider increasing the collection interval (update_every) to reduce the frequency of requests.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.

The metrics that will be collected are defined in the configuration file.

### Per snmp device

These metrics refer to the SNMP device.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| sysName | SNMP device's system name (OID: [1.3.6.1.2.1.1.5](https://oidref.com/1.3.6.1.2.1.1.5)). |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| snmp.device_uptime | uptime | seconds |

### Per network interface

Network interfaces of the SNMP device being monitored. These metrics refer to each interface.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| sysName | SNMP device's system name (OID: [1.3.6.1.2.1.1.5](https://oidref.com/1.3.6.1.2.1.1.5)). |
| ifDescr | Network interface description (OID: [1.3.6.1.2.1.2.2.1.2](https://cric.grenoble.cnrs.fr/Administrateurs/Outils/MIBS/?oid=1.3.6.1.2.1.2.2.1.2)). |
| ifName | Network interface name (OID: [1.3.6.1.2.1.2.2.1.2](https://cric.grenoble.cnrs.fr/Administrateurs/Outils/MIBS/?oid=1.3.6.1.2.1.31.1.1.1.1)). |
| ifType | Network interface type (OID: [1.3.6.1.2.1.2.2.1.2](https://cric.grenoble.cnrs.fr/Administrateurs/Outils/MIBS/?oid=1.3.6.1.2.1.2.2.1.3)). |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| snmp.device_net_interface_traffic | received, sent | kilobits/s |
| snmp.device_net_interface_unicast | received, sent | packets/s |
| snmp.device_net_interface_multicast | received, sent | packets/s |
| snmp.device_net_interface_broadcast | received, sent | packets/s |
| snmp.device_net_interface_errors | inbound, outbound | errors/s |
| snmp.device_net_interface_discards | inbound, outbound | discards/s |
| snmp.device_net_interface_admin_status | up, down, testing | status |
| snmp.device_net_interface_oper_status | up, down, testing, unknown, dormant, not_present, lower_layer_down | status |



## Alerts

There are no alerts configured by default for this integration.


## Setup


You can configure the **snmp** collector in two ways:

| Method                | Best for                                                                                 | How to                                                                                                                                 |
|-----------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| [**UI**](#via-ui)     | Fast setup without editing files                                                         | Go to **Nodes → Configure this node → Collectors → Jobs**, search for **snmp**, then click **+** to add a job. |
| [**File**](#via-file) | If you prefer configuring via file, or need to automate deployments (e.g., with Ansible) | Edit `go.d/snmp.conf` and add a job.                                                                        |

:::important

UI configuration requires paid Netdata Cloud plan.

:::


### Prerequisites

#### Prepare the SNMP device

Before configuring the collector:
- Enable the SNMP service on the target device (through its management interface).
- Make sure the device is reachable from the Netdata node on port 161/UDP.
- Have ready the required connection details: IP address, SNMP version, and either a community string (v1/v2c) or user credentials (v3).



### Configuration

#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>



| Group | Option | Description | Default | Required |
|:------|:-----|:------------|:--------|:---------:|
| **Collection** | update_every | Data collection frequency. | 10 | no |
|  | autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| **Target** | hostname | Target host (IP or DNS name, IPv4/IPv6). |  | yes |
| **SNMPv1/2** | community | SNMPv1/2 community string. | public | no |
| **SNMPv3** | user.name | SNMPv3 user name. |  | no |
|  | user.level | Security level of SNMPv3 messages. |  | no |
|  | user.auth_proto | Authentication protocol for SNMPv3 messages. |  | no |
|  | user.auth_key | Authentication protocol pass phrase for SNMPv3 messages. |  | no |
|  | user.priv_proto | Privacy protocol for SNMPv3 messages. |  | no |
|  | user.priv_key | Privacy protocol pass phrase for SNMPv3 messages. |  | no |
| **SNMP transport** | options.version | SNMP version. Available versions: 1, 2, 3. | 2 | no |
|  | options.port | Target port. | 161 | no |
|  | options.retries | Retries to attempt. | 1 | no |
|  | options.timeout | SNMP request/response timeout. | 5 | no |
|  | options.max_repetitions | Controls how many SNMP variables to retrieve in a single GETBULK request. | 25 | no |
|  | options.max_request_size | Maximum number of OIDs allowed in a single GET request. | 60 | no |
| **Profiles** | manual_profiles | Profiles to apply if automatic detection cannot be used. | [] | no |
|  | disable_legacy_collection | Disable the legacy SNMP collection method, forcing the collector to use only SNMP profiles (YAML-based configuration). When enabled, the collector will ignore any non-profile based collection logic. | true | no |
| **Virtual node** | create_vnode | If set, the collector will create a Netdata Virtual Node for this SNMP device, which will appear as a separate Node in Netdata. | true | no |
|  | vnode_device_down_threshold | Number of consecutive failed data collections before marking the device as down. | 3 | no |
|  | vnode.guid | A unique identifier for the Virtual Node. If not set, a GUID will be automatically generated from the device's IP address. |  | no |
|  | vnode.hostname | The hostname that will be used for the Virtual Node. If not set, the device's hostname will be used. |  | no |
|  | vnode.labels | Additional key-value pairs to associate with the Virtual Node. |  | no |

##### user.level

The security of an SNMPv3 message as per RFC 3414 (`user.level`):

| String value | Int value | Description                              |
|:------------:|:---------:|------------------------------------------|
|     none     |     1     | no message authentication or encryption  |
|  authNoPriv  |     2     | message authentication and no encryption |
|   authPriv   |     3     | message authentication and encryption    |


##### user.auth_proto

The digest algorithm for SNMPv3 messages that require authentication (`user.auth_proto`):

| String value | Int value | Description                               |
|:------------:|:---------:|-------------------------------------------|
|     none     |     1     | no message authentication                 |
|     md5      |     2     | MD5 message authentication (HMAC-MD5-96)  |
|     sha      |     3     | SHA message authentication (HMAC-SHA-96)  |
|    sha224    |     4     | SHA message authentication (HMAC-SHA-224) |
|    sha256    |     5     | SHA message authentication (HMAC-SHA-256) |
|    sha384    |     6     | SHA message authentication (HMAC-SHA-384) |
|    sha512    |     7     | SHA message authentication (HMAC-SHA-512) |


##### user.priv_proto

The encryption algorithm for SNMPv3 messages that require privacy (`user.priv_proto`):

| String value | Int value | Description                                                             |
|:------------:|:---------:|-------------------------------------------------------------------------|
|     none     |     1     | no message encryption                                                   |
|     des      |     2     | ES encryption (CBC-DES)                                                 |
|     aes      |     3     | 128-bit AES encryption (CFB-AES-128)                                    |
|    aes192    |     4     | 192-bit AES encryption (CFB-AES-192) with "Blumenthal" key localization |
|    aes256    |     5     | 256-bit AES encryption (CFB-AES-256) with "Blumenthal" key localization |
|   aes192c    |     6     | 192-bit AES encryption (CFB-AES-192) with "Reeder" key localization     |
|   aes256c    |     7     | 256-bit AES encryption (CFB-AES-256) with "Reeder" key localization     |



</details>


#### via UI

Configure the **snmp** collector from the Netdata web interface:

1. Go to **Nodes**.
2. Select the node **where you want the snmp data-collection job to run** and click the :gear: (**Configure this node**). That node will run the data collection.
3. The **Collectors → Jobs** view opens by default.
4. In the Search box, type _snmp_ (or scroll the list) to locate the **snmp** collector.
5. Click the **+** next to the **snmp** collector to add a new job.
6. Fill in the job fields, then click **Test** to verify the configuration and **Submit** to save.
    - **Test** runs the job with the provided settings and shows whether data can be collected.
    - If it fails, an error message appears with details (for example, connection refused, timeout, or command execution errors), so you can adjust and retest.


#### via File

The configuration file name for this integration is `go.d/snmp.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name2
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/snmp.conf
```

##### Examples

###### SNMPv1/2

In this example:

- the SNMP device is `192.0.2.1`.
- the SNMP version is `2`.
- the SNMP community is `public`.
- we will update the values every 10 seconds.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: switch
    update_every: 10
    hostname: 192.0.2.1
    community: public
    options:
      version: 2

```
</details>

###### SNMPv3

To use SNMPv3:

- use `user` instead of `community`.
- set `options.version` to 3.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: switch
    update_every: 10
    hostname: 192.0.2.1
    options:
      version: 3
    user:
      name: username
      level: authPriv
      auth_proto: sha256
      auth_key: auth_protocol_passphrase
      priv_proto: aes256
      priv_key: priv_protocol_passphrase

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `snmp` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m snmp
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m snmp -j jobName
  ```

### Getting Logs

If you're encountering problems with the `snmp` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep snmp
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep snmp /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep snmp
```


