// Triple-DES, CBC mode, test vectors

struct TV_TDES_CBC {
    size_t  size;
    uint8_t key[24];
    uint8_t iv[8];
    uint8_t plain[512];
    uint8_t cipher[512];
};

static const TV_TDES_CBC tv_tdes_cbc [] = {
    {
        24,
        {
            0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19,
            0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20, 0x21,
            0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29,
        },
        {
            0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
        },
        {
            0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11,
            0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19,
            0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20, 0x21,
        },
        {
            0xB6, 0x9C, 0x7C, 0x78, 0x81, 0xE5, 0xF3, 0x07,
            0x92, 0x28, 0x1E, 0x9A, 0x1C, 0xEB, 0xEE, 0xFE,
            0xE0, 0x22, 0x68, 0x49, 0x58, 0x72, 0x1A, 0xF9,
        },
    },
    {
        72,
        {
            0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D,
            0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35,
            0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D,
        },
        {
            0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29,
        },
        {
            0x1E, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25,
            0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D,
            0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35,
            0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D,
            0x3E, 0x3F, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45,
            0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D,
            0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55,
            0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D,
            0x5E, 0x5F, 0x60, 0x61, 0x62, 0x63, 0x64, 0x65,
        },
        {
            0xD0, 0x22, 0x7B, 0x4C, 0x0A, 0x7A, 0xED, 0x1B,
            0x1D, 0x39, 0x24, 0xBF, 0x11, 0x7A, 0x03, 0xF8,
            0x57, 0x6D, 0xF6, 0x85, 0x7D, 0xAC, 0x63, 0x63,
            0xCD, 0xB6, 0xC3, 0xC6, 0xC8, 0x93, 0xE6, 0x41,
            0xAC, 0xF3, 0x27, 0xB6, 0x3A, 0xCE, 0xF6, 0x47,
            0x38, 0x7C, 0x4F, 0x8B, 0xA3, 0x2C, 0xD8, 0x5C,
            0x5B, 0x7C, 0x5A, 0x07, 0x42, 0xF7, 0x4A, 0x88,
            0xBD, 0x56, 0x31, 0x16, 0xB4, 0xF7, 0x7B, 0xD7,
            0xEB, 0x1E, 0x36, 0xAF, 0xBC, 0xD0, 0x30, 0x93,
        },
    },
    {
        504,
        {
            0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x84, 0x85,
            0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D,
            0x8E, 0x8F, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95,
        },
        {
            0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81,
        },
        {
            0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D,
            0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x84, 0x85,
            0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D,
            0x8E, 0x8F, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95,
            0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D,
            0x9E, 0x9F, 0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5,
            0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD,
            0xAE, 0xAF, 0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5,
            0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD,
            0xBE, 0xBF, 0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5,
            0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD,
            0xCE, 0xCF, 0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5,
            0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD,
            0xDE, 0xDF, 0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5,
            0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED,
            0xEE, 0xEF, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5,
            0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD,
            0xFE, 0xFF, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05,
            0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D,
            0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
            0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D,
            0x1E, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25,
            0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D,
            0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35,
            0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D,
            0x3E, 0x3F, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45,
            0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D,
            0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55,
            0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D,
            0x5E, 0x5F, 0x60, 0x61, 0x62, 0x63, 0x64, 0x65,
            0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D,
            0x6E, 0x6F, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75,
            0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D,
            0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x84, 0x85,
            0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D,
            0x8E, 0x8F, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95,
            0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D,
            0x9E, 0x9F, 0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5,
            0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD,
            0xAE, 0xAF, 0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5,
            0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD,
            0xBE, 0xBF, 0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5,
            0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD,
            0xCE, 0xCF, 0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5,
            0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD,
            0xDE, 0xDF, 0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5,
            0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED,
            0xEE, 0xEF, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5,
            0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD,
            0xFE, 0xFF, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05,
            0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D,
            0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
            0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D,
            0x1E, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25,
            0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D,
            0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35,
            0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D,
            0x3E, 0x3F, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45,
            0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D,
            0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55,
            0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D,
            0x5E, 0x5F, 0x60, 0x61, 0x62, 0x63, 0x64, 0x65,
            0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D,
        },
        {
            0x21, 0x69, 0x9D, 0xA2, 0xF8, 0x15, 0xAA, 0x3A,
            0xDF, 0x7E, 0x68, 0xF4, 0x5A, 0xD5, 0xC2, 0xF8,
            0x17, 0x43, 0xE1, 0x0D, 0x57, 0x14, 0x3B, 0xA4,
            0x83, 0xA7, 0x03, 0xC8, 0x50, 0xFF, 0xE9, 0x45,
            0x86, 0x0F, 0xA2, 0xAA, 0x25, 0x26, 0x63, 0x63,
            0x1D, 0x47, 0xD8, 0xBD, 0xBF, 0xEB, 0xE5, 0x09,
            0x55, 0xE9, 0x8B, 0xCA, 0x7E, 0xBC, 0x70, 0xB4,
            0x5B, 0x4F, 0xDD, 0x1F, 0xB9, 0x9D, 0x4C, 0x72,
            0x3B, 0x4A, 0xCF, 0x46, 0xD4, 0xCA, 0x6D, 0xD1,
            0x6A, 0x44, 0xD0, 0x2F, 0xDF, 0xFF, 0x55, 0x76,
            0x79, 0x2D, 0x2C, 0x38, 0x43, 0x80, 0xF3, 0x0F,
            0x04, 0x45, 0x08, 0x16, 0xF8, 0x42, 0x39, 0xE8,
            0xBD, 0x80, 0x8B, 0x78, 0x3B, 0xAA, 0xB7, 0x3B,
            0x29, 0xB0, 0x7C, 0xC3, 0x9E, 0x59, 0x78, 0x89,
            0xC2, 0x0F, 0xDE, 0x72, 0x73, 0x0C, 0xBF, 0x61,
            0xEF, 0xE1, 0x71, 0x87, 0x01, 0x53, 0x50, 0x0E,
            0x86, 0xE7, 0x2D, 0x40, 0x1B, 0x89, 0xEC, 0x1D,
            0xCB, 0x88, 0xE2, 0x25, 0xEC, 0x6E, 0x76, 0x1D,
            0x2E, 0xC4, 0xE7, 0x8E, 0x0E, 0x0E, 0xE9, 0x6E,
            0x73, 0x3E, 0x4C, 0x05, 0x94, 0xBF, 0x58, 0xB2,
            0xAF, 0x5F, 0xFA, 0xB2, 0xFD, 0x56, 0x85, 0x1F,
            0xC5, 0x19, 0xFC, 0x81, 0x76, 0x73, 0x8F, 0xD9,
            0x9B, 0x9D, 0x0C, 0x2B, 0xB5, 0x30, 0x4D, 0x82,
            0xEF, 0xBE, 0xE2, 0x57, 0x8B, 0xF4, 0x6F, 0x46,
            0x3F, 0xA4, 0xC9, 0xD7, 0x8E, 0x35, 0x11, 0x82,
            0x3E, 0x5F, 0x69, 0xCC, 0xB9, 0x7E, 0xE8, 0x8F,
            0xD8, 0xDA, 0x4B, 0xD0, 0xFE, 0xFD, 0xC7, 0x03,
            0x44, 0x5C, 0xB3, 0xAF, 0xCC, 0xB7, 0x34, 0xBE,
            0x04, 0xBF, 0x05, 0x5D, 0x1F, 0xA6, 0x97, 0x58,
            0x87, 0x4E, 0xFF, 0xB2, 0xE0, 0xFD, 0x87, 0x8D,
            0xB6, 0x67, 0x4B, 0x24, 0x2E, 0xC0, 0x9E, 0xE5,
            0x1A, 0x9B, 0xBD, 0x8D, 0x2B, 0xAE, 0xB5, 0xF8,
            0xC5, 0x56, 0x07, 0x2A, 0xAC, 0x48, 0x94, 0x49,
            0x01, 0xF9, 0x19, 0xE9, 0x0B, 0x94, 0x20, 0xB3,
            0x35, 0x62, 0xCB, 0xAD, 0x61, 0x9D, 0x59, 0x85,
            0x6E, 0x90, 0x2C, 0x1F, 0xE2, 0x0A, 0x4F, 0x6D,
            0x14, 0x88, 0xEF, 0xF4, 0x64, 0xAA, 0xD7, 0xA9,
            0x88, 0xFD, 0x72, 0x28, 0x83, 0xEE, 0xC9, 0x5B,
            0xDD, 0x4E, 0x4A, 0xF5, 0x9D, 0x89, 0xB8, 0x52,
            0x97, 0x60, 0x3C, 0xF2, 0xFE, 0x06, 0xA1, 0x29,
            0x0C, 0x2C, 0xEF, 0xA9, 0x29, 0x2A, 0x03, 0x88,
            0x27, 0xF9, 0x65, 0xB6, 0xD4, 0x11, 0xD8, 0x48,
            0x89, 0xF3, 0x5F, 0xA4, 0x79, 0xC8, 0x4E, 0xF6,
            0x2B, 0x22, 0xEB, 0x25, 0xC4, 0x80, 0x02, 0x61,
            0xD8, 0x9D, 0xFC, 0xC8, 0x53, 0xB3, 0x83, 0x68,
            0x55, 0xA7, 0x7D, 0xBC, 0x75, 0x11, 0xFD, 0xAB,
            0x1B, 0xBA, 0xB0, 0x7F, 0xE9, 0xBB, 0x62, 0x73,
            0xCD, 0xA0, 0xCB, 0xD5, 0x24, 0xE4, 0xD3, 0x7C,
            0xD0, 0x59, 0x38, 0x0D, 0xAF, 0x9B, 0x1A, 0x4B,
            0xFC, 0x44, 0x81, 0x6D, 0xC0, 0x18, 0xAA, 0xF2,
            0xA6, 0x11, 0x92, 0x79, 0x33, 0x94, 0xF9, 0xD0,
            0x51, 0xFC, 0x4A, 0x60, 0x56, 0x7B, 0xC6, 0x8F,
            0x10, 0x72, 0xA2, 0xC5, 0xC9, 0x4D, 0xAD, 0x41,
            0x12, 0x40, 0x89, 0x60, 0x66, 0x97, 0x6A, 0x81,
            0x46, 0x16, 0x8C, 0xA2, 0x7A, 0x85, 0xCC, 0x1C,
            0xA5, 0xAB, 0x6E, 0xEA, 0xFB, 0xE9, 0x74, 0x70,
            0x0F, 0xFC, 0x73, 0x0A, 0x83, 0xE3, 0x96, 0x1B,
            0x8E, 0x9B, 0xEE, 0x58, 0x25, 0x2E, 0x81, 0x4A,
            0xCA, 0xC6, 0x9E, 0x5B, 0x62, 0xB9, 0x8B, 0xFC,
            0xD2, 0x1D, 0x29, 0x7C, 0xD9, 0xEB, 0x6B, 0x2F,
            0xD8, 0xCD, 0xBF, 0x1A, 0x6D, 0x3D, 0x96, 0x0B,
            0xBC, 0x90, 0x04, 0xF0, 0x12, 0x04, 0x6C, 0x24,
            0x93, 0xC8, 0xF1, 0xC3, 0x81, 0xA8, 0x49, 0xE8,
        },
    },
};
