/*  wmbday
 *  Copyright (C) 2003-2005 astratis <steffen@x-berg.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MAIN_H
#define MAIN_H

#include <X11/Xlib.h>
#include <limits.h>


/* some definitions */
#ifndef PATH_MAX
  #define PATH_MAX      4096
#endif
#define PACKAGE       "wmbday"
#define VERSION       "0.3"

#define GUI_TEXT      1
#define GUI_GUI       2
#define LIGHT_ON      1
#define LIGHT_OFF     0

#define WMBDAY_HEIGHT 64
#define WMBDAY_WIDTH  64


/* copies homedir of current user to mySettings.datafile */
void get_user_homedir(void);

/* parses parameters given at command line */
void ParseCMDLine(int argc, char **argv);



/* creates the main window */
Window CreateWindow(void);

/* creates graphics context for our window */
int CreateWindowGC(void);

/* sets the window's background */
void SetBackground(Pixmap pix_bg);

/* handler for some signals we are interested in */
void signal_handler(int sig);

/* redraws window... */
void RedrawWindow(XEvent* theevent);

XColor GetColor(char* name);
void StartTimer(void);
void StopTimer(void);


struct settings {
  char datafile[PATH_MAX];
  char* color_bg;
  char* color_font;
  char* color_hilight;
  int gui_style;
  int backlight;
  Display* display;
  int screen;
};

#endif /* MAIN_H */
