/* Swfdec
 * Copyright (C) 2008 Benjamin Otte <otte@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifndef _SWFDEC_DISPLAY_OBJECT_CONTAINER_H_
#define _SWFDEC_DISPLAY_OBJECT_CONTAINER_H_

#include <swfdec/swfdec_interactive_object.h>

G_BEGIN_DECLS

//typedef struct _SwfdecDisplayObjectContainer SwfdecDisplayObjectContainer;
typedef struct _SwfdecDisplayObjectContainerClass SwfdecDisplayObjectContainerClass;

#define SWFDEC_TYPE_DISPLAY_OBJECT_CONTAINER                    (swfdec_display_object_container_get_type())
#define SWFDEC_IS_DISPLAY_OBJECT_CONTAINER(obj)                 (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWFDEC_TYPE_DISPLAY_OBJECT_CONTAINER))
#define SWFDEC_IS_DISPLAY_OBJECT_CONTAINER_CLASS(klass)         (G_TYPE_CHECK_CLASS_TYPE ((klass), SWFDEC_TYPE_DISPLAY_OBJECT_CONTAINER))
#define SWFDEC_DISPLAY_OBJECT_CONTAINER(obj)                    (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWFDEC_TYPE_DISPLAY_OBJECT_CONTAINER, SwfdecDisplayObjectContainer))
#define SWFDEC_DISPLAY_OBJECT_CONTAINER_CLASS(klass)            (G_TYPE_CHECK_CLASS_CAST ((klass), SWFDEC_TYPE_DISPLAY_OBJECT_CONTAINER, SwfdecDisplayObjectContainerClass))
#define SWFDEC_DISPLAY_OBJECT_CONTAINER_GET_CLASS(obj)          (G_TYPE_INSTANCE_GET_CLASS ((obj), SWFDEC_TYPE_DISPLAY_OBJECT_CONTAINER, SwfdecDisplayObjectContainerClass))

struct _SwfdecDisplayObjectContainer
{
  SwfdecInteractiveObject	interactive_object;
};

struct _SwfdecDisplayObjectContainerClass
{
  SwfdecInteractiveObjectClass	interactive_object_class;
};

GType			swfdec_display_object_container_get_type	(void);


G_END_DECLS
#endif
