#line 2 "vivi_parser_scanner_lex.c"
#line 2 "vivi_parser_scanner_lex.l"
/* Vivified
 * Copyright (C) 2008 Pekka Lampila <pekka.lampila@iki.fi>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#include "vivi_parser_scanner.h"

#define YY_DECL int vivi_parser_scanner_lex (void *yyscanner, ViviParserValue *value)
extern YY_DECL;

#define YY_EXTRA_TYPE ViviParserScanner *

/* stupid lex can't define it to not throw an unused_result error */
#define ECHO 



#line 35 "vivi_parser_scanner_lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE vivi_parser_scanner_restart(yyin ,yyscanner )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE vivi_parser_scanner_lex. 
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via vivi_parser_scanner_restart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void vivi_parser_scanner_restart (FILE *input_file ,yyscan_t yyscanner );
void vivi_parser_scanner__switch_to_buffer (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
YY_BUFFER_STATE vivi_parser_scanner__create_buffer (FILE *file,int size ,yyscan_t yyscanner );
void vivi_parser_scanner__delete_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void vivi_parser_scanner__flush_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void vivi_parser_scanner_push_buffer_state (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
void vivi_parser_scanner_pop_buffer_state (yyscan_t yyscanner );

static void vivi_parser_scanner_ensure_buffer_stack (yyscan_t yyscanner );
static void vivi_parser_scanner__load_buffer_state (yyscan_t yyscanner );
static void vivi_parser_scanner__init_buffer (YY_BUFFER_STATE b,FILE *file ,yyscan_t yyscanner );

#define YY_FLUSH_BUFFER vivi_parser_scanner__flush_buffer(YY_CURRENT_BUFFER ,yyscanner)

YY_BUFFER_STATE vivi_parser_scanner__scan_buffer (char *base,yy_size_t size ,yyscan_t yyscanner );
YY_BUFFER_STATE vivi_parser_scanner__scan_string (yyconst char *yy_str ,yyscan_t yyscanner );
YY_BUFFER_STATE vivi_parser_scanner__scan_bytes (yyconst char *bytes,int len ,yyscan_t yyscanner );

void *vivi_parser_scanner_alloc (yy_size_t ,yyscan_t yyscanner );
void *vivi_parser_scanner_realloc (void *,yy_size_t ,yyscan_t yyscanner );
void vivi_parser_scanner_free (void * ,yyscan_t yyscanner );

#define yy_new_buffer vivi_parser_scanner__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        vivi_parser_scanner_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            vivi_parser_scanner__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        vivi_parser_scanner_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            vivi_parser_scanner__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define vivi_parser_scanner_wrap(n) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state (yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  ,yyscan_t yyscanner);
static int yy_get_next_buffer (yyscan_t yyscanner );
static void yy_fatal_error (yyconst char msg[] ,yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 137
#define YY_END_OF_BUFFER 138
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[383] =
    {   0,
        0,    0,    0,    0,    0,    0,  138,  136,    6,    7,
        7,   36,  118,  135,   29,   33,  119,   12,   13,   27,
       25,   16,   26,   14,   28,  116,  116,   41,   15,   17,
       44,   18,   40,   10,   11,   35,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,    8,   34,    9,   37,  134,  122,  120,
      121,  137,    3,    4,    3,   22,  135,   47,   42,   53,
       45,   38,   48,   39,   49,  117,    1,    5,   46,  116,
        0,    0,  116,   30,   19,   21,   20,   31,   54,  135,
      135,  135,  135,  135,  135,  135,  135,  135,   62,  135,

      135,  135,  135,  135,  135,  135,  135,  135,   67,  135,
       68,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,   55,   43,  134,  133,  123,  124,  127,  128,
      129,  130,  131,  133,  132,  133,    2,   24,    0,    5,
      116,    0,  116,  115,   50,   23,   51,   32,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,   65,  135,
      135,  135,  135,  135,  135,  135,   70,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,

      135,  135,   75,  135,  135,   77,  135,  135,  135,  135,
      123,  124,    0,    0,    0,  117,   52,  135,  135,  135,
       83,   57,  135,   84,  135,  135,  135,  135,  135,  135,
      135,   63,   89,  135,  135,  135,  135,  135,  135,   93,
      135,  135,  135,  135,   96,  135,  112,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,   73,  135,  135,
      113,  135,  135,   78,  135,  135,   80,  123,    0,  125,
      135,  135,   56,   58,   85,   86,  135,  135,  135,  135,
      135,  135,  135,  114,   91,   92,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  102,  135,  104,

      135,  135,   74,  135,  135,  135,  135,   79,    0,  135,
      135,  135,  135,  135,   61,   88,   90,  135,  135,  135,
      135,   94,  135,  135,   97,  135,  135,  135,  101,   71,
      103,   72,  135,  106,  135,   76,  135,  135,  126,  135,
       82,  135,  135,   60,  109,   64,  135,  135,  135,  135,
       98,   99,  135,  135,  135,  135,  135,   81,   59,   87,
       66,  135,  135,  135,  135,  135,  135,  135,  108,  135,
      135,   95,  100,  135,  107,  111,  110,   69,  135,  135,
      105,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    1,    7,    8,    9,   10,   11,
       12,   13,   14,   15,   16,   17,   18,   19,   20,   20,
       20,   20,   20,   20,   20,   21,   21,   22,   23,   24,
       25,   26,   27,    1,   28,   28,   28,   28,   29,   28,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,   30,    7,    7,
       31,   32,   33,   34,    7,    1,   35,   36,   37,   38,

       39,   40,   41,   42,   43,    7,   44,   45,   46,   47,
       48,   49,    7,   50,   51,   52,   53,   54,   55,   56,
       57,   58,   59,   60,   61,   62,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[63] =
    {   0,
        1,    1,    2,    3,    1,    4,    5,    1,    1,    4,
        1,    1,    1,    1,    1,    1,    1,    1,    6,    6,
        6,    1,    1,    1,    1,    1,    1,    6,    6,    5,
        1,    4,    1,    1,    6,    6,    6,    6,    6,    6,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    1,    1,
        1,    1
    } ;

static yyconst flex_int16_t yy_base[396] =
    {   0,
        0,    0,   60,   61,   62,   65,  473,  474,  474,  474,
      474,  447,  474,    0,  446,   60,  474,  474,  474,  445,
       58,  474,   57,   60,   71,   69,   83,  474,  474,   52,
      444,   62,  474,  474,  474,  443,  431,   57,   71,   62,
       64,   83,  418,   77,  417,   94,   92,  425,   96,   93,
      416,   86,   48,  474,   70,  474,  474,    0,  474,  474,
      474,  135,  474,  474,  444,  436,    0,  474,  474,  474,
      474,  474,  474,  474,  474,  138,  474,    0,  474,  141,
      176,    0,  181,  435,  474,  434,  474,  114,  474,  407,
      409,  417,  403,  112,  419,  418,  405,  101,  398,  399,

      396,   45,  403,  400,  398,  395,  397,  391,    0,  393,
      114,  394,  388,  384,  393,  400,  125,  400,  383,  386,
      398,  383,  388,  383,  126,  146,  380,  390,  377,  129,
      383,  373,  474,  474,    0,  474,  185,  188,  474,  474,
      474,  474,  474,    0,  474,    0,  474,  474,  197,    0,
      202,  205,  208,    0,  474,  474,  474,  399,  371,  377,
      386,  381,  380,  381,  367,  365,  127,  362,  379,  374,
      376,  372,  364,  361,  369,  356,  371,  370,    0,  367,
      355,  138,  350,  362,  359,  356,    0,  353,  353,  342,
      343,  349,  340,  342,  339,  351,  337,  351,  336,  338,

      338,  345,    0,  344,  343,    0,  343,  345,  334,  336,
      213,  216,    0,    0,  219,  223,  474,  327,  337,  331,
        0,    0,  332,    0,  322,  320,  328,  329,  316,  316,
      322,    0,    0,  316,  318,  325,  318,  310,  309,    0,
      321,  309,  323,  307,    0,  302,    0,  320,  319,  314,
      309,  301,  298,  306,  298,  310,  304,    0,  290,  293,
        0,  295,  302,    0,  289,  301,    0,  226,    0,  474,
      304,  303,    0,    0,    0,    0,  290,  295,  290,  295,
      294,  280,  293,    0,  285,    0,  286,  282,  275,  279,
      285,  285,  282,  270,  284,  283,  272,    0,  281,    0,

      275,  266,  264,  271,  273,  269,  268,    0,    0,  273,
      262,  255,  268,  254,    0,    0,    0,  254,  247,  255,
      263,    0,  264,  265,    0,  260,  259,  245,    0,    0,
        0,    0,  248,    0,  256,    0,  247,  248,  474,  240,
        0,  252,  240,    0,    0,    0,  242,  241,  248,  249,
        0,    0,  246,  237,  236,  243,  242,    0,    0,    0,
        0,  228,  228,  236,  231,  222,  211,  192,    0,  168,
      175,    0,    0,  156,    0,    0,    0,    0,  173,  156,
        0,  474,  247,  253,  255,  261,  267,  273,  187,  178,
      146,  138,  126,  109,   68

    } ;

static yyconst flex_int16_t yy_def[396] =
    {   0,
      382,    1,  383,  383,  384,  384,  382,  382,  382,  382,
      382,  382,  382,  385,  382,  382,  382,  382,  382,  382,
      382,  382,  382,  382,  382,  382,  382,  382,  382,  382,
      382,  382,  382,  382,  382,  382,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  382,  382,  382,  382,  386,  382,  382,
      382,  387,  382,  382,  382,  382,  385,  382,  382,  382,
      382,  382,  382,  382,  382,  382,  382,  388,  382,  382,
      382,  389,  382,  382,  382,  382,  382,  382,  382,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,

      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  382,  382,  386,  382,  382,  382,  382,  382,
      382,  382,  382,  390,  382,  391,  382,  382,  382,  388,
      382,  382,  382,  389,  382,  382,  382,  382,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,

      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      382,  382,  392,  393,  382,  382,  382,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  382,  394,  382,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,

      385,  385,  385,  385,  385,  385,  385,  385,  395,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  382,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,  385,  385,  385,  385,  385,  385,  385,  385,  385,
      385,    0,  382,  382,  382,  382,  382,  382,  382,  382,
      382,  382,  382,  382,  382

    } ;

static yyconst flex_int16_t yy_nxt[537] =
    {   0,
        8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
       18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
       27,   28,   29,   30,   31,   32,   33,   14,   14,   14,
       34,    8,   35,   36,   37,   38,   39,   40,   41,   42,
       43,   14,   44,   14,   45,   14,   46,   14,   47,   48,
       49,   50,   51,   52,   53,   14,   14,   14,   54,   55,
       56,   57,   59,   59,   64,   60,   60,   64,   69,   61,
       61,   72,   74,  339,   65,   84,   85,   65,   76,   76,
       76,   75,   73,   77,   70,   80,   87,   88,   78,  131,
      132,   62,   62,  174,  133,   79,  175,   81,   82,   80,

       98,   83,   83,   83,   91,   94,   92,   81,  100,   99,
      101,   81,   95,   93,  309,   96,  109,  103,   97,  102,
      129,   81,  110,  111,   82,  104,  116,  105,  113,  134,
      106,  270,  114,  130,  125,  107,  168,  120,  157,  158,
      169,  117,  126,  269,  118,  170,  115,  121,  122,  127,
      123,  214,  124,  137,  137,  138,   76,   76,   76,  151,
      151,  151,  163,  164,  183,  184,  149,  190,  199,   81,
      139,  207,  191,  208,  140,  200,  149,  226,  227,   81,
      201,  141,  241,  213,  142,  242,  143,  144,  145,  152,
      146,  152,  154,  381,  153,  153,  153,   80,  202,   83,

       83,   83,  203,  211,  211,  212,  212,  212,  212,   81,
      215,  380,  215,  379,  378,  216,  216,  216,  377,   81,
      151,  151,  151,  153,  153,  153,  153,  153,  153,  376,
       81,  268,  268,  212,  212,  212,  212,  216,  216,  216,
       81,  216,  216,  216,  212,  212,  212,   58,   58,   58,
       58,   58,   58,   63,   63,   63,   63,   63,   63,   67,
       67,  135,  375,  135,  374,  135,  135,  136,  373,  136,
      136,  136,  136,  150,  372,  371,  150,  150,  150,  370,
      369,  368,  367,  366,  365,  364,  363,  362,  361,  360,
      359,  358,  357,  356,  355,  354,  353,  352,  351,  350,

      349,  348,  347,  346,  345,  344,  343,  342,  341,  340,
      338,  337,  336,  335,  334,  333,  332,  331,  330,  329,
      328,  327,  326,  325,  324,  323,  322,  321,  320,  319,
      318,  317,  316,  315,  314,  313,  312,  311,  310,  308,
      307,  306,  305,  304,  303,  302,  301,  300,  299,  298,
      297,  296,  295,  294,  293,  292,  291,  290,  289,  288,
      287,  286,  285,  284,  283,  282,  281,  280,  279,  278,
      277,  276,  275,  274,  273,  272,  271,  267,  266,  265,
      264,  263,  262,  261,  260,  259,  258,  257,  256,  255,
      254,  253,  252,  251,  250,  249,  248,  247,  246,  245,

      244,  243,  240,  239,  238,  237,  236,  235,  234,  233,
      232,  231,  230,  229,  228,  225,  224,  223,  222,  221,
      220,  219,  218,  217,  210,  209,  206,  205,  204,  198,
      197,  196,  195,  194,  193,  192,  189,  188,  187,  186,
      185,  182,  181,  180,  179,  178,  177,  176,  173,  172,
      171,  167,  166,  165,  162,  161,  160,  159,  156,  155,
      148,  147,  128,  119,  112,  108,   90,   89,   86,   71,
       68,   66,  382,    7,  382,  382,  382,  382,  382,  382,
      382,  382,  382,  382,  382,  382,  382,  382,  382,  382,
      382,  382,  382,  382,  382,  382,  382,  382,  382,  382,

      382,  382,  382,  382,  382,  382,  382,  382,  382,  382,
      382,  382,  382,  382,  382,  382,  382,  382,  382,  382,
      382,  382,  382,  382,  382,  382,  382,  382,  382,  382,
      382,  382,  382,  382,  382,  382
    } ;

static yyconst flex_int16_t yy_chk[537] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    3,    4,    5,    3,    4,    6,   16,    3,
        4,   21,   23,  395,    5,   30,   30,    6,   24,   24,
       24,   23,   21,   25,   16,   26,   32,   32,   25,   53,
       53,    3,    4,  102,   55,   25,  102,   26,   26,   27,

       40,   27,   27,   27,   38,   39,   38,   26,   41,   40,
       41,   27,   39,   38,  394,   39,   44,   42,   39,   41,
       52,   27,   44,   44,   26,   42,   47,   42,   46,   55,
       42,  393,   46,   52,   50,   42,   98,   49,   88,   88,
       98,   47,   50,  392,   47,   98,   46,   49,   49,   50,
       49,  391,   49,   62,   62,   62,   76,   76,   76,   80,
       80,   80,   94,   94,  111,  111,   76,  117,  125,   80,
       62,  130,  117,  130,   62,  125,   76,  167,  167,   80,
      126,   62,  182,  390,   62,  182,   62,   62,   62,   81,
       62,   81,  389,  380,   81,   81,   81,   83,  126,   83,

       83,   83,  126,  137,  137,  137,  138,  138,  138,   83,
      149,  379,  149,  374,  371,  149,  149,  149,  370,   83,
      151,  151,  151,  152,  152,  152,  153,  153,  153,  368,
      151,  211,  211,  211,  212,  212,  212,  215,  215,  215,
      151,  216,  216,  216,  268,  268,  268,  383,  383,  383,
      383,  383,  383,  384,  384,  384,  384,  384,  384,  385,
      385,  386,  367,  386,  366,  386,  386,  387,  365,  387,
      387,  387,  387,  388,  364,  363,  388,  388,  388,  362,
      357,  356,  355,  354,  353,  350,  349,  348,  347,  343,
      342,  340,  338,  337,  335,  333,  328,  327,  326,  324,

      323,  321,  320,  319,  318,  314,  313,  312,  311,  310,
      307,  306,  305,  304,  303,  302,  301,  299,  297,  296,
      295,  294,  293,  292,  291,  290,  289,  288,  287,  285,
      283,  282,  281,  280,  279,  278,  277,  272,  271,  266,
      265,  263,  262,  260,  259,  257,  256,  255,  254,  253,
      252,  251,  250,  249,  248,  246,  244,  243,  242,  241,
      239,  238,  237,  236,  235,  234,  231,  230,  229,  228,
      227,  226,  225,  223,  220,  219,  218,  210,  209,  208,
      207,  205,  204,  202,  201,  200,  199,  198,  197,  196,
      195,  194,  193,  192,  191,  190,  189,  188,  186,  185,

      184,  183,  181,  180,  178,  177,  176,  175,  174,  173,
      172,  171,  170,  169,  168,  166,  165,  164,  163,  162,
      161,  160,  159,  158,  132,  131,  129,  128,  127,  124,
      123,  122,  121,  120,  119,  118,  116,  115,  114,  113,
      112,  110,  108,  107,  106,  105,  104,  103,  101,  100,
       99,   97,   96,   95,   93,   92,   91,   90,   86,   84,
       66,   65,   51,   48,   45,   43,   37,   36,   31,   20,
       15,   12,    7,  382,  382,  382,  382,  382,  382,  382,
      382,  382,  382,  382,  382,  382,  382,  382,  382,  382,
      382,  382,  382,  382,  382,  382,  382,  382,  382,  382,

      382,  382,  382,  382,  382,  382,  382,  382,  382,  382,
      382,  382,  382,  382,  382,  382,  382,  382,  382,  382,
      382,  382,  382,  382,  382,  382,  382,  382,  382,  382,
      382,  382,  382,  382,  382,  382
    } ;

/* Table of booleans, true if rule could match eol. */
static yyconst flex_int32_t yy_rule_can_match_eol[138] =
    {   0,
0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,     };

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "vivi_parser_scanner_lex.l"

#line 33 "vivi_parser_scanner_lex.l"
static char begin_char;

#define RESET_POSITION value->position = G_MAXSIZE

#define ERROR(...) vivi_parser_scanner_error (yyextra, yylineno, yycolumn, __VA_ARGS__)

#define LINE_TERMINATOR G_STMT_START {\
  value->line_terminator = TRUE; \
  RESET_POSITION; \
}G_STMT_END

#define YY_USER_ACTION \
  if (value->position == G_MAXSIZE) { \
    value->line_number = yylineno; \
    value->column = 0; \
    /* FIXME: is this supportable? */ \
    value->position = yytext - YY_CURRENT_BUFFER_LVALUE->yy_ch_buf; \
  }


#line 759 "vivi_parser_scanner_lex.c"

#define INITIAL 0
#define str 1
#define comment 2

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    }; /* end struct yyguts_t */

static int yy_init_globals (yyscan_t yyscanner );

int vivi_parser_scanner_lex_init (yyscan_t* scanner);

int vivi_parser_scanner_lex_init_extra (YY_EXTRA_TYPE user_defined,yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int vivi_parser_scanner_lex_destroy (yyscan_t yyscanner );

int vivi_parser_scanner_get_debug (yyscan_t yyscanner );

void vivi_parser_scanner_set_debug (int debug_flag ,yyscan_t yyscanner );

YY_EXTRA_TYPE vivi_parser_scanner_get_extra (yyscan_t yyscanner );

void vivi_parser_scanner_set_extra (YY_EXTRA_TYPE user_defined ,yyscan_t yyscanner );

FILE *vivi_parser_scanner_get_in (yyscan_t yyscanner );

void vivi_parser_scanner_set_in  (FILE * in_str ,yyscan_t yyscanner );

FILE *vivi_parser_scanner_get_out (yyscan_t yyscanner );

void vivi_parser_scanner_set_out  (FILE * out_str ,yyscan_t yyscanner );

int vivi_parser_scanner_get_leng (yyscan_t yyscanner );

char *vivi_parser_scanner_get_text (yyscan_t yyscanner );

int vivi_parser_scanner_get_lineno (yyscan_t yyscanner );

void vivi_parser_scanner_set_lineno (int line_number ,yyscan_t yyscanner );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int vivi_parser_scanner_wrap (yyscan_t yyscanner );
#else
extern int vivi_parser_scanner_wrap (yyscan_t yyscanner );
#endif
#endif

    static void yyunput (int c,char *buf_ptr  ,yyscan_t yyscanner);
    
#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int ,yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * ,yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (yyscan_t yyscanner );
#else
static int input (yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int vivi_parser_scanner_lex (yyscan_t yyscanner);

#define YY_DECL int vivi_parser_scanner_lex (yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

#line 69 "vivi_parser_scanner_lex.l"


#line 985 "vivi_parser_scanner_lex.c"

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			vivi_parser_scanner_ensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				vivi_parser_scanner__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
		}

		vivi_parser_scanner__load_buffer_state(yyscanner );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yyg->yy_last_accepting_state = yy_current_state;
				yyg->yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 383 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 382 );
		yy_cp = yyg->yy_last_accepting_cpos;
		yy_current_state = yyg->yy_last_accepting_state;

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					   
    do{ yylineno++;
        yycolumn=0;
    }while(0)
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yyg->yy_hold_char;
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 71 "vivi_parser_scanner_lex.l"
{ BEGIN(comment); }
	YY_BREAK

case 2:
YY_RULE_SETUP
#line 73 "vivi_parser_scanner_lex.l"
{ 
			  BEGIN(INITIAL);
			  /* FIXME: use the comment somehow */
			  RESET_POSITION;
			}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 78 "vivi_parser_scanner_lex.l"
{ /* skip */ }
	YY_BREAK
case 4:
/* rule 4 can match eol */
YY_RULE_SETUP
#line 79 "vivi_parser_scanner_lex.l"
{ LINE_TERMINATOR; }
	YY_BREAK
case YY_STATE_EOF(comment):
#line 80 "vivi_parser_scanner_lex.l"
{
			  BEGIN(INITIAL);
			  ERROR ("Unterminated comment");
			  RESET_POSITION;
			}
	YY_BREAK

case 5:
YY_RULE_SETUP
#line 87 "vivi_parser_scanner_lex.l"
{ /* skip - the newline will reset the position */ }
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(str):
#line 89 "vivi_parser_scanner_lex.l"
{ 
			  /* wtf? no user action on EOF? */
			  YY_USER_ACTION;
			  return TOKEN_NONE;
			}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 95 "vivi_parser_scanner_lex.l"
{ RESET_POSITION; }
	YY_BREAK
case 7:
/* rule 7 can match eol */
YY_RULE_SETUP
#line 97 "vivi_parser_scanner_lex.l"
{ LINE_TERMINATOR; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 99 "vivi_parser_scanner_lex.l"
{ return TOKEN_BRACE_LEFT; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 100 "vivi_parser_scanner_lex.l"
{ return TOKEN_BRACE_RIGHT; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 101 "vivi_parser_scanner_lex.l"
{ return TOKEN_BRACKET_LEFT; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 102 "vivi_parser_scanner_lex.l"
{ return TOKEN_BRACKET_RIGHT; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 103 "vivi_parser_scanner_lex.l"
{ return TOKEN_PARENTHESIS_LEFT; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 104 "vivi_parser_scanner_lex.l"
{ return TOKEN_PARENTHESIS_RIGHT; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 106 "vivi_parser_scanner_lex.l"
{ return TOKEN_DOT; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 107 "vivi_parser_scanner_lex.l"
{ return TOKEN_SEMICOLON; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 108 "vivi_parser_scanner_lex.l"
{ return TOKEN_COMMA; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 110 "vivi_parser_scanner_lex.l"
{ return TOKEN_LESS_THAN; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 111 "vivi_parser_scanner_lex.l"
{ return TOKEN_GREATER_THAN; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 112 "vivi_parser_scanner_lex.l"
{ return TOKEN_LESS_THAN_OR_EQUAL; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 113 "vivi_parser_scanner_lex.l"
{ return TOKEN_GREATER_THAN_OR_EQUAL; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 115 "vivi_parser_scanner_lex.l"
{ return TOKEN_EQUAL; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 116 "vivi_parser_scanner_lex.l"
{ return TOKEN_NOT_EQUAL; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 117 "vivi_parser_scanner_lex.l"
{ return TOKEN_STRICT_EQUAL; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 118 "vivi_parser_scanner_lex.l"
{ return TOKEN_NOT_STRICT_EQUAL; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 120 "vivi_parser_scanner_lex.l"
{ return TOKEN_PLUS; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 121 "vivi_parser_scanner_lex.l"
{ return TOKEN_MINUS; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 122 "vivi_parser_scanner_lex.l"
{ return TOKEN_MULTIPLY; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 123 "vivi_parser_scanner_lex.l"
{ return TOKEN_DIVIDE; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 124 "vivi_parser_scanner_lex.l"
{ return TOKEN_REMAINDER; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 126 "vivi_parser_scanner_lex.l"
{ return TOKEN_SHIFT_LEFT; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 127 "vivi_parser_scanner_lex.l"
{ return TOKEN_SHIFT_RIGHT; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 128 "vivi_parser_scanner_lex.l"
{ return TOKEN_SHIFT_RIGHT_UNSIGNED; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 130 "vivi_parser_scanner_lex.l"
{ return TOKEN_BITWISE_AND; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 131 "vivi_parser_scanner_lex.l"
{ return TOKEN_BITWISE_OR; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 132 "vivi_parser_scanner_lex.l"
{ return TOKEN_BITWISE_XOR; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 134 "vivi_parser_scanner_lex.l"
{ return TOKEN_LOGICAL_NOT; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 135 "vivi_parser_scanner_lex.l"
{ return TOKEN_BITWISE_NOT; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 136 "vivi_parser_scanner_lex.l"
{ return TOKEN_INCREASE; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 137 "vivi_parser_scanner_lex.l"
{ return TOKEN_DESCREASE; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 139 "vivi_parser_scanner_lex.l"
{ return TOKEN_QUESTION_MARK; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 140 "vivi_parser_scanner_lex.l"
{ return TOKEN_COLON; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 142 "vivi_parser_scanner_lex.l"
{ return TOKEN_LOGICAL_AND; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 143 "vivi_parser_scanner_lex.l"
{ return TOKEN_LOGICAL_OR; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 145 "vivi_parser_scanner_lex.l"
{ return TOKEN_ASSIGN; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 146 "vivi_parser_scanner_lex.l"
{ return TOKEN_ASSIGN_MULTIPLY; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 147 "vivi_parser_scanner_lex.l"
{ return TOKEN_ASSIGN_DIVIDE; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 148 "vivi_parser_scanner_lex.l"
{ return TOKEN_ASSIGN_REMAINDER; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 149 "vivi_parser_scanner_lex.l"
{ return TOKEN_ASSIGN_ADD; }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 150 "vivi_parser_scanner_lex.l"
{ return TOKEN_ASSIGN_MINUS; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 151 "vivi_parser_scanner_lex.l"
{ return TOKEN_ASSIGN_SHIFT_LEFT; }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 152 "vivi_parser_scanner_lex.l"
{ return TOKEN_ASSIGN_SHIFT_RIGHT; }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 153 "vivi_parser_scanner_lex.l"
{ return TOKEN_ASSIGN_SHIFT_RIGHT_ZERO; }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 154 "vivi_parser_scanner_lex.l"
{ return TOKEN_ASSIGN_BITWISE_AND; }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 155 "vivi_parser_scanner_lex.l"
{ return TOKEN_ASSIGN_BITWISE_XOR; }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 156 "vivi_parser_scanner_lex.l"
{ return TOKEN_ASSIGN_BITWISE_OR; }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 158 "vivi_parser_scanner_lex.l"
{ return TOKEN_BREAK; }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 159 "vivi_parser_scanner_lex.l"
{ return TOKEN_CASE; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 160 "vivi_parser_scanner_lex.l"
{ return TOKEN_CATCH; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 161 "vivi_parser_scanner_lex.l"
{ return TOKEN_CONTINUE; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 162 "vivi_parser_scanner_lex.l"
{ return TOKEN_DEFAULT; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 163 "vivi_parser_scanner_lex.l"
{ return TOKEN_DELETE; }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 164 "vivi_parser_scanner_lex.l"
{ return TOKEN_DO; }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 165 "vivi_parser_scanner_lex.l"
{ return TOKEN_ELSE; }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 166 "vivi_parser_scanner_lex.l"
{ return TOKEN_FINALLY; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 167 "vivi_parser_scanner_lex.l"
{ return TOKEN_FOR; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 168 "vivi_parser_scanner_lex.l"
{ return TOKEN_FUNCTION; }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 169 "vivi_parser_scanner_lex.l"
{ return TOKEN_IF; }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 170 "vivi_parser_scanner_lex.l"
{ return TOKEN_IN; }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 171 "vivi_parser_scanner_lex.l"
{ return TOKEN_INSTANCEOF; }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 172 "vivi_parser_scanner_lex.l"
{ return TOKEN_NEW; }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 173 "vivi_parser_scanner_lex.l"
{ return TOKEN_RETURN; }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 174 "vivi_parser_scanner_lex.l"
{ return TOKEN_SWITCH; }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 175 "vivi_parser_scanner_lex.l"
{ return TOKEN_THIS; }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 176 "vivi_parser_scanner_lex.l"
{ return TOKEN_THROW; }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 177 "vivi_parser_scanner_lex.l"
{ return TOKEN_TRY; }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 178 "vivi_parser_scanner_lex.l"
{ return TOKEN_TYPEOF; }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 179 "vivi_parser_scanner_lex.l"
{ return TOKEN_VAR; }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 180 "vivi_parser_scanner_lex.l"
{ return TOKEN_VOID; }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 181 "vivi_parser_scanner_lex.l"
{ return TOKEN_WHILE; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 182 "vivi_parser_scanner_lex.l"
{ return TOKEN_WITH; }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 184 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 185 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 186 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 187 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 188 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 189 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 190 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 191 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 192 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 193 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 194 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 195 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 196 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 197 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
/*"int"			{ return TOKEN_RESERVED_KEYWORD; }*/
case 95:
YY_RULE_SETUP
#line 199 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 200 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 201 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 202 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 203 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 204 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 205 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 206 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 207 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 208 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 209 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 210 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 211 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 212 "vivi_parser_scanner_lex.l"
{ return TOKEN_RESERVED_KEYWORD; }
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 214 "vivi_parser_scanner_lex.l"
{ return TOKEN_EXTENDS; }
	YY_BREAK
case 110:
YY_RULE_SETUP
#line 215 "vivi_parser_scanner_lex.l"
{ return TOKEN_IMPLEMENTS; }
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 216 "vivi_parser_scanner_lex.l"
{ return TOKEN_UNDEFINED; }
	YY_BREAK
case 112:
YY_RULE_SETUP
#line 218 "vivi_parser_scanner_lex.l"
{ return TOKEN_NULL; }
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 219 "vivi_parser_scanner_lex.l"
{
			  value->value.v_boolean = 1;
			  return TOKEN_BOOLEAN;
			}
	YY_BREAK
case 114:
YY_RULE_SETUP
#line 223 "vivi_parser_scanner_lex.l"
{
			  value->value.v_boolean = 0;
			  return TOKEN_BOOLEAN;
			}
	YY_BREAK
case 115:
YY_RULE_SETUP
#line 228 "vivi_parser_scanner_lex.l"
{
			  value->value.v_number =
			    g_ascii_strtoull (yytext, NULL, 16);
			  return TOKEN_NUMBER;
			}
	YY_BREAK
case 116:
YY_RULE_SETUP
#line 234 "vivi_parser_scanner_lex.l"
{
			  value->value.v_number = g_ascii_strtod (yytext, NULL);
			  return TOKEN_NUMBER;
			}
	YY_BREAK
case 117:
YY_RULE_SETUP
#line 239 "vivi_parser_scanner_lex.l"
{
			  value->value.v_number = g_ascii_strtod (yytext, NULL);
			  return TOKEN_NUMBER;
			}
	YY_BREAK
case 118:
YY_RULE_SETUP
#line 244 "vivi_parser_scanner_lex.l"
{
			  begin_char = '"';
			  value->value.v_string = g_string_new ("");
			  BEGIN(str);
			}
	YY_BREAK
case 119:
YY_RULE_SETUP
#line 250 "vivi_parser_scanner_lex.l"
{
			  begin_char = '\'';
			  value->value.v_string = g_string_new ("");
			  BEGIN(str);
			}
	YY_BREAK

case 120:
YY_RULE_SETUP
#line 257 "vivi_parser_scanner_lex.l"
{
			  if (begin_char == '"') {
			    BEGIN(INITIAL);
			    return TOKEN_STRING;
			  } else {
			    g_string_append_c (value->value.v_string, '"');
			  }
			}
	YY_BREAK
case 121:
YY_RULE_SETUP
#line 265 "vivi_parser_scanner_lex.l"
{
			  if (begin_char == '\'') {
			    BEGIN(INITIAL);
			    return TOKEN_STRING;
			  } else {
			    g_string_append_c (value->value.v_string, '\'');
			  }
			}
	YY_BREAK
case 122:
/* rule 122 can match eol */
YY_RULE_SETUP
#line 273 "vivi_parser_scanner_lex.l"
{
			  BEGIN(INITIAL);
			  g_string_free (value->value.v_string, TRUE);
			  ERROR ("Unterminated string constant");
			  RESET_POSITION;
			}
	YY_BREAK
case 123:
YY_RULE_SETUP
#line 279 "vivi_parser_scanner_lex.l"
{
			  guint64 result;
			  result = g_ascii_strtoull (yytext + 1, NULL, 8);
			  if (result > 0xff || result == 0) {
			    ERROR ("Invalid escape sequence %s", yytext);
			  } else {
			    g_string_append_unichar (value->value.v_string,
				result);
			  }
			}
	YY_BREAK
case 124:
YY_RULE_SETUP
#line 289 "vivi_parser_scanner_lex.l"
{ ERROR ("Invalid escape sequence %s", yytext); }
	YY_BREAK
case 125:
YY_RULE_SETUP
#line 290 "vivi_parser_scanner_lex.l"
{
			  guint64 result;
			  result = g_ascii_strtoull (yytext + 2, NULL, 16);
			  if (result == 0) {
			    ERROR ("Invalid escape sequence %s", yytext);
			  } else {
			    g_string_append_unichar (value->value.v_string,
				result);
			  }
			}
	YY_BREAK
case 126:
YY_RULE_SETUP
#line 300 "vivi_parser_scanner_lex.l"
{
			  guint64 result;
			  result = g_ascii_strtoull (yytext + 2, NULL, 16);
			  if (result == 0) {
			    ERROR ("Invalid escape sequence %s", yytext);
			  } else {
			    g_string_append_unichar (value->value.v_string, result);
			  }
			}
	YY_BREAK
case 127:
YY_RULE_SETUP
#line 309 "vivi_parser_scanner_lex.l"
{ g_string_append_c (value->value.v_string, '\b'); }
	YY_BREAK
case 128:
YY_RULE_SETUP
#line 310 "vivi_parser_scanner_lex.l"
{ g_string_append_c (value->value.v_string, '\f'); }
	YY_BREAK
case 129:
YY_RULE_SETUP
#line 311 "vivi_parser_scanner_lex.l"
{ g_string_append_c (value->value.v_string, '\n'); }
	YY_BREAK
case 130:
YY_RULE_SETUP
#line 312 "vivi_parser_scanner_lex.l"
{ g_string_append_c (value->value.v_string, '\r'); }
	YY_BREAK
case 131:
YY_RULE_SETUP
#line 313 "vivi_parser_scanner_lex.l"
{ g_string_append_c (value->value.v_string, '\t'); }
	YY_BREAK
case 132:
YY_RULE_SETUP
#line 314 "vivi_parser_scanner_lex.l"
{ g_string_append_c (value->value.v_string, '\v'); }
	YY_BREAK
case 133:
YY_RULE_SETUP
#line 315 "vivi_parser_scanner_lex.l"
{ g_string_append_c (value->value.v_string, yytext[1]); }
	YY_BREAK
case 134:
YY_RULE_SETUP
#line 316 "vivi_parser_scanner_lex.l"
{
			  char *p;
			  for (p = yytext; *p != '\0'; p++) {
			    g_string_append_c (value->value.v_string, *p);
			  }
			}
	YY_BREAK

case 135:
YY_RULE_SETUP
#line 324 "vivi_parser_scanner_lex.l"
{
			  value->value.v_identifier = g_strdup (yytext);
			  return TOKEN_IDENTIFIER;
			}
	YY_BREAK
case 136:
YY_RULE_SETUP
#line 329 "vivi_parser_scanner_lex.l"
{ 
			  ERROR ("Unknown character '%c'", yytext[0]); 
			  RESET_POSITION;
			}
	YY_BREAK
case 137:
YY_RULE_SETUP
#line 334 "vivi_parser_scanner_lex.l"
ECHO;
	YY_BREAK
#line 1870 "vivi_parser_scanner_lex.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * vivi_parser_scanner_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_last_accepting_cpos;
				yy_current_state = yyg->yy_last_accepting_state;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( vivi_parser_scanner_wrap(yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of vivi_parser_scanner_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = yyg->yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					vivi_parser_scanner_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2 ,yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			vivi_parser_scanner_restart(yyin  ,yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) (yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) vivi_parser_scanner_realloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size ,yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yyg->yy_last_accepting_state = yy_current_state;
			yyg->yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 383 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	register int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */
	register char *yy_cp = yyg->yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yyg->yy_last_accepting_state = yy_current_state;
		yyg->yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 383 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 382);

	return yy_is_jam ? 0 : yy_current_state;
}

    static void yyunput (int c, register char * yy_bp , yyscan_t yyscanner)
{
	register char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yy_cp = yyg->yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yyg->yy_hold_char;

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yyg->yy_n_chars + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --yylineno;
    }

	yyg->yytext_ptr = yy_bp;
	yyg->yy_hold_char = *yy_cp;
	yyg->yy_c_buf_p = yy_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yyg->yy_c_buf_p - yyg->yytext_ptr;
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					vivi_parser_scanner_restart(yyin ,yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( vivi_parser_scanner_wrap(yyscanner ) )
						return EOF;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	if ( c == '\n' )
		   
    do{ yylineno++;
        yycolumn=0;
    }while(0)
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void vivi_parser_scanner_restart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        vivi_parser_scanner_ensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            vivi_parser_scanner__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
	}

	vivi_parser_scanner__init_buffer(YY_CURRENT_BUFFER,input_file ,yyscanner);
	vivi_parser_scanner__load_buffer_state(yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void vivi_parser_scanner__switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		vivi_parser_scanner_pop_buffer_state();
	 *		vivi_parser_scanner_push_buffer_state(new_buffer);
     */
	vivi_parser_scanner_ensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	vivi_parser_scanner__load_buffer_state(yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (vivi_parser_scanner_wrap()) processing, but the only time this flag
	 * is looked at is after vivi_parser_scanner_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void vivi_parser_scanner__load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE vivi_parser_scanner__create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) vivi_parser_scanner_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in vivi_parser_scanner__create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) vivi_parser_scanner_alloc(b->yy_buf_size + 2 ,yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in vivi_parser_scanner__create_buffer()" );

	b->yy_is_our_buffer = 1;

	vivi_parser_scanner__init_buffer(b,file ,yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with vivi_parser_scanner__create_buffer()
 * @param yyscanner The scanner object.
 */
    void vivi_parser_scanner__delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		vivi_parser_scanner_free((void *) b->yy_ch_buf ,yyscanner );

	vivi_parser_scanner_free((void *) b ,yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a vivi_parser_scanner_restart() or at EOF.
 */
    static void vivi_parser_scanner__init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	vivi_parser_scanner__flush_buffer(b ,yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then vivi_parser_scanner__init_buffer was _probably_
     * called from vivi_parser_scanner_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void vivi_parser_scanner__flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		vivi_parser_scanner__load_buffer_state(yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void vivi_parser_scanner_push_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	vivi_parser_scanner_ensure_buffer_stack(yyscanner);

	/* This block is copied from vivi_parser_scanner__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from vivi_parser_scanner__switch_to_buffer. */
	vivi_parser_scanner__load_buffer_state(yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void vivi_parser_scanner_pop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	vivi_parser_scanner__delete_buffer(YY_CURRENT_BUFFER ,yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		vivi_parser_scanner__load_buffer_state(yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void vivi_parser_scanner_ensure_buffer_stack (yyscan_t yyscanner)
{
	int num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)vivi_parser_scanner_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in vivi_parser_scanner_ensure_buffer_stack()" );
								  
		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)vivi_parser_scanner_realloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in vivi_parser_scanner_ensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE vivi_parser_scanner__scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) vivi_parser_scanner_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in vivi_parser_scanner__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	vivi_parser_scanner__switch_to_buffer(b ,yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to vivi_parser_scanner_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       vivi_parser_scanner__scan_bytes() instead.
 */
YY_BUFFER_STATE vivi_parser_scanner__scan_string (yyconst char * yystr , yyscan_t yyscanner)
{
    
	return vivi_parser_scanner__scan_bytes(yystr,strlen(yystr) ,yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to vivi_parser_scanner_lex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE vivi_parser_scanner__scan_bytes  (yyconst char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) vivi_parser_scanner_alloc(n ,yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in vivi_parser_scanner__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = vivi_parser_scanner__scan_buffer(buf,n ,yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in vivi_parser_scanner__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg , yyscan_t yyscanner)
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE vivi_parser_scanner_get_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int vivi_parser_scanner_get_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int vivi_parser_scanner_get_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *vivi_parser_scanner_get_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *vivi_parser_scanner_get_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int vivi_parser_scanner_get_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *vivi_parser_scanner_get_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void vivi_parser_scanner_set_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void vivi_parser_scanner_set_lineno (int  line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           yy_fatal_error( "vivi_parser_scanner_set_lineno called with no buffer" , yyscanner); 
    
    yylineno = line_number;
}

/** Set the current column.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void vivi_parser_scanner_set_column (int  column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           yy_fatal_error( "vivi_parser_scanner_set_column called with no buffer" , yyscanner); 
    
    yycolumn = column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see vivi_parser_scanner__switch_to_buffer
 */
void vivi_parser_scanner_set_in (FILE *  in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = in_str ;
}

void vivi_parser_scanner_set_out (FILE *  out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = out_str ;
}

int vivi_parser_scanner_get_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void vivi_parser_scanner_set_debug (int  bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = bdebug ;
}

/* Accessor methods for yylval and yylloc */

/* User-visible API */

/* vivi_parser_scanner_lex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */

int vivi_parser_scanner_lex_init(yyscan_t* ptr_yy_globals)

{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) vivi_parser_scanner_alloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* vivi_parser_scanner_lex_init_extra has the same functionality as vivi_parser_scanner_lex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to vivi_parser_scanner_alloc in
 * the yyextra field.
 */

int vivi_parser_scanner_lex_init_extra(YY_EXTRA_TYPE yy_user_defined,yyscan_t* ptr_yy_globals )

{
    struct yyguts_t dummy_yyguts;

    vivi_parser_scanner_set_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }
	
    *ptr_yy_globals = (yyscan_t) vivi_parser_scanner_alloc ( sizeof( struct yyguts_t ), &dummy_yyguts );
	
    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }
    
    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));
    
    vivi_parser_scanner_set_extra (yy_user_defined, *ptr_yy_globals);
    
    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from vivi_parser_scanner_lex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = 0;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = (char *) 0;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * vivi_parser_scanner_lex_init()
     */
    return 0;
}

/* vivi_parser_scanner_lex_destroy is for both reentrant and non-reentrant scanners. */
int vivi_parser_scanner_lex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		vivi_parser_scanner__delete_buffer(YY_CURRENT_BUFFER ,yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		vivi_parser_scanner_pop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	vivi_parser_scanner_free(yyg->yy_buffer_stack ,yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        vivi_parser_scanner_free(yyg->yy_start_stack ,yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * vivi_parser_scanner_lex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    vivi_parser_scanner_free ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n , yyscan_t yyscanner)
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s , yyscan_t yyscanner)
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *vivi_parser_scanner_alloc (yy_size_t  size , yyscan_t yyscanner)
{
	return (void *) malloc( size );
}

void *vivi_parser_scanner_realloc  (void * ptr, yy_size_t  size , yyscan_t yyscanner)
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void vivi_parser_scanner_free (void * ptr , yyscan_t yyscanner)
{
	free( (char *) ptr );	/* see vivi_parser_scanner_realloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 334 "vivi_parser_scanner_lex.l"




