#ifndef MAIN_H
#define MAIN_H	1

#include "common.h"

/* Settings for various rtlsdr functions */
#define	TUNER_GAIN_MANUAL	1
#define	TUNER_GAIN_AUTO		0
#define	RTL_DAGC_ON			1
#define	RTL_DAGC_OFF		0

/* These are actually the default settings of
 * rtlsdr_read_async() but I need them to define
 * the size of the working rtl_buf, which must
 * be the same as the async buffers */
#define	NUM_ASYNC_BUF	15
#define	ASYNC_BUF_LEN	65536

#define	STANDBY_DELAY	10000

/* Sampling rate of rtlsdr device Samples/sec */
#define	RTL_DSP_RATE	288000

/* The number of RTLSDR samples per one subcarrier
 * amplitude sample. This is the ratio between the
 * RTLSDR device sampling rate (1008000 S/s) and
 * the sound card DSP sampling rate (48000 S/s) */
#define	RTLSDR_OVERSAMPLING		6

/* The length of the ring buffer used in the FM demodulator.
 * Should be less than 1/2 cycle of highest frequency to
 * detect, in 2 * DSPSamples. For 20 kHz max FM deviation,
 * 2 * DSP_RATE = 2 * 1008000 / MAxFreq = 20000 / 2 = 50.
 * I use less to be on the safe side */
#define	FMDET_RINGBUF_LEN	6

/* Factor to scale O/P of RTLSDR
 * demodulator to required level */
#define RTL_SCALE_FACTOR	1.8

/* Max Doppler correction in Hz */
#define MAX_DOPPLER_CORR	5000

#define	TUNER_TYPES \
  "UNKNOWN", \
  "E4000", \
  "FC0012", \
  "FC0013", \
  "FC2580", \
  "R820T", \
  "R828D"

#endif

