#ifndef __RFM_CONSTANTS_H__
#define __RFM_CONSTANTS_H__
#include "errors.h"
#include "types.h"
//#define NO_THREADS

#ifdef ENABLE_NLS
# include <libintl.h>
# define _(String) dgettext(GETTEXT_PACKAGE,String)
# define N_(String)  String

#else
# define _(String) String
# define N_(String) String
# define ngettext(Format1,Format2,N) Format1
# define textdomain(String) 
# define bindtextdomain(Domain,Directory)
#endif

#include "debug.h"
#include "files.h"

#define DEFAULT_WIDTH 540
#define DEFAULT_HEIGHT 450


#define FULL_LOAD_COUNT 104

// this defines the maximum number of auto command elements in popup menu: 
// and also the maximum number of up directories in the bookmarks submenu
#define DEEPEST_DIR_MENU_LEVELS 9
#define DEEPEST_HISTORY_MENU_LEVELS 6
// this defines the maximum number of bookmarks in the bookmarks submenu: 
#define DEEPEST_BOOK_MENU_LEVELS 9
// This defines the maximun number of goto module elements in popup menu:
#define DEEPEST_MODULE_MENU_LEVELS 13

// This specifies what the path count should be greater 
// than or equal to, to default to tiny icons.
#define TINY_ICONS_PATHC 256

#define STATUS_IDLE		0
#define STATUS_EXIT		0x01
#define STATUS_RELOAD		0x02

#define MONITOR_THREAD_DONE 0x02


enum {
    ICONVIEW_TYPE,
    DESKVIEW_TYPE
};
enum {
    TYPE_SORT,
    NAME_SORT,
    SIZE_SORT,
    DATE_SORT,
    OWNER_SORT,
    GROUP_SORT,
    MODE_SORT
};
enum {
    TR_COPY,
    TR_MOVE,
    TR_LINK,
    TR_COPY_REMOTE,
    TR_MOVE_REMOTE,
    TR_LINK_REMOTE
};
enum {
    TARGET_URI_LIST,
    TARGET_PLAIN,
    TARGET_UTF8,
    TARGET_STRING,
    TARGET_ROOTWIN,
    TARGET_MOZ_URL,
    TARGET_XDS,
    TARGET_RAW,
    TARGETS
};

// population_flags:
//
			// normal_tip	
#define POPULATION_NORMAL_TIP	0x01 // ok
			// preview_done		
#define POPULATION_PREVIEW_DONE	0x02 // not used yet
			// preview_busy		
#define POPULATION_PREVIEW_BUSY	0x04 // ok
			// selected		
#define POPULATION_SELECTED	0x08 // ok
			// saturated		
#define POPULATION_SATURATED	0x10 // ok
			// label saturated
#define LABEL_SATURATED		0x20 // ok
			// thumbnailed		
#define POPULATION_THUMBNAILED	0x40 // ok
			// cut			
#define POPULATION_CUT		0x80 // ok
			// copied		
#define POPULATION_COPIED	0x100 // ok
#define POPULATION_TIP_BUSY	0x200 // ok
#define POPULATION_PIXBUF_CLEAN	0x400 // ok
#define POPULATION_IS_IMAGE	0x800 // ok
#define POPULATION_ICON_CACHE	0x1000 // ok
#define POPULATION_THUMBNAIL_ON_EXPOSE	0x2000 // ok


#define PREVIEW_IMAGE_SIZE 400
#define MAX_PIXBUF_HASH_SIZE 128

/* for preview threads, this limits the number of threads which are
 * spawn concurrently. Increase this number with efective core count */
#define    PREVIEW_THREAD_LIMIT   4    

/* icon parameters: */
#define BIG_ICON_SIZE 		96 
#define MEDIUM_ICON_SIZE 	72 
#define SMALL_ICON_SIZE 	48 
#define TINY_ICON_SIZE 		24 
#define LIST_ICON_SIZE  	0

#define SIZE_BUTTON	20
#define SIZE_DIALOG	36
#define SIZE_ICON	48
#define SIZE_PREVIEW	96
#define SIZE_TIP	128

#define MAX_COMMAND_ARGS 2048

#define TEXTSPACING 6
//#define TEXTSPACING 0

#define MINIMUM_ICON_COLUMNS 1
#define MINIMUM_VISIBLE_ROWS 1

#define PARENT_MODULE(x) ((x)->view_p->module) 
#define CHILD_MODULE(x) ((x)->module) 
#define POPULATION_MODULE(x) ((x)?((PARENT_MODULE(x))?\
			    PARENT_MODULE(x):\
			    CHILD_MODULE(x)):NULL)


#define CUT_BUFFER 0

#define BACKGROUND_COLOR 0
#define TEXT_COLOR 1
#define SATURATE_TEXT_COLOR 2
#define SATURATE_LABEL_COLOR 3
#define SELECT_TEXT_COLOR 4
#define INVALID_UTF8_TEXT_COLOR 5
#define SHADOW_COLOR 7


/***** end mime ****/

#define GETWD (g_get_home_dir()?g_get_home_dir():g_get_tmp_dir())
#define SETWD(x) \
if (chdir(GETWD)<0){ \
    g_warning("chdir %s: %s",GETWD, strerror (errno));\
}
						 


#define COMM_IGNORE_RELEASE   0x01
    


#define __MASK		0xffffffff  // 32bit only for compatibility with old processors

// Ad hoc types (not determined by stat, mainly by fstab plugin)
// __DUMMY_TYPE
// __ROOT_TYPE
// __UP_TYPE
// __PROC_TYPE
// __CDFS_TYPE
// __USER_TYPE
// __NFS_TYPE
// __SMB_TYPE
// __FSTAB_TYPE
// __MTAB_TYPE
// __PARTITION_TYPE
// __DOTDESKTOP


#define __DTYPE (__SFIFO|__SCHR|__SDIR|__SBLK|__SREG|__SLNK|__SSOCK|__LOCAL_TYPE)

#define KEEP_TYPE (__MONITOR_TYPE|__SBLK|__DUMMY_TYPE|__ROOT_TYPE|__UP_TYPE|__PROC_TYPE|__CDFS_TYPE|__USER_TYPE|__NFS_TYPE|__SMB_TYPE|__FSTAB_TYPE|__MTAB_TYPE|__PARTITION_TYPE|__DOTDESKTOP)
	
// XXX: These are no longer in en->type and should be separated from this group to
//      free up the bit flags for other use.
// __SHOWS_HIDDEN (this is now a view preferences item)
// __SHOWS_IMAGES (this is now a view preferences item)
// __SHOWS_ASCENDING (this is now a view preferences item)
// __CASE_INSENSITIVE (this is now a view preferences item)
// __INVALIDATE_ICONS (this is now a view preferences item)
// __USER_PREFERENCES (this is now a view preferences item)
#define __INVALIDATE_ICONS 	(0x1)

#define __SHOWS_BACKUP		(0x1<<24)
#define SHOWS_BACKUP(x)		((x) & __SHOWS_BACKUP)
#define SET_SHOWS_BACKUP(x)	(x) |= __SHOWS_BACKUP
#define UNSET_SHOWS_BACKUP(x)	(x) &= (__SHOWS_BACKUP ^ __MASK )

#define __SHOWS_HIDDEN		(0x1<<25)
#define SHOWS_HIDDEN(x)		((x) & __SHOWS_HIDDEN)
#define SET_SHOWS_HIDDEN(x)	(x) |= __SHOWS_HIDDEN
#define UNSET_SHOWS_HIDDEN(x)	(x) &= (__SHOWS_HIDDEN ^ __MASK )

#define __CASE_INSENSITIVE		(0x1<<26)
#define IS_CASE_INSENSITIVE(x)		((x) & __CASE_INSENSITIVE)
#define SET_CASE_INSENSITIVE(x)		(x) |= __CASE_INSENSITIVE
#define UNSET_CASE_INSENSITIVE(x)	(x) &= (__CASE_INSENSITIVE ^ __MASK )

#define __SHOWS_IMAGES		(0x1<<27)
#define SHOWS_IMAGES(x)		((x) & __SHOWS_IMAGES)
#define SET_SHOWS_IMAGES(x)	(x) |= __SHOWS_IMAGES
#define UNSET_SHOWS_IMAGES(x)	(x) &= (__SHOWS_IMAGES ^ __MASK )

#define __SHOWS_ASCENDING	(0x1<<28)
#define SHOWS_ASCENDING(x)	((x) & __SHOWS_ASCENDING)
#define SET_SHOWS_ASCENDING(x)	(x) |= __SHOWS_ASCENDING
#define UNSET_SHOWS_ASCENDING(x) (x) &= (__SHOWS_ASCENDING ^ __MASK )

#define __USER_PREFERENCES	(0x1<<29)
#define IS_USER_PREFERENCES(x)	((x) & __USER_PREFERENCES)
#define SET_USER_PREFERENCES(x)	(x) |= __USER_PREFERENCES
#define UNSET_USER_PREFERENCES(x) (x) &= (__USER_PREFERENCES ^ __MASK )


/**  Basic stat types (not necesarily exclusive)  **/
// (0x1<<0) not used

#define __SFIFO		(0x1<<1)
#define IS_SFIFO(x)	((x) & __SFIFO)
#define SET_SFIFO(x)	((x) |= __SFIFO)
#define UNSET_SFIFO(x)	(x) &= (__SFIFO ^ __MASK )

#define __SCHR		(0x1<<2)
#define IS_SCHR(x)	((x) & __SCHR)
#define SET_SCHR(x)	((x) |= __SCHR)
#define UNSET_SCHR(x)	(x) &= (__SCHR ^ __MASK )

#define __SDIR		(0x1<<3)
#define IS_SDIR(x)	((x) & __SDIR)
#define SET_SDIR(x)	((x) |= __SDIR)
#define UNSET_SDIR(x)	(x) &= (__SDIR ^ __MASK )

#define __SBLK		(0x1<<4)
#define IS_SBLK(x)	((x) & __SBLK)
#define SET_SBLK(x)	((x) |= __SBLK)
#define UNSET_SBLK(x)	(x) &= (__SBLK ^ __MASK )

#define __SREG		(0x1<<5)
#define IS_SREG(x)	((x) & __SREG)
#define SET_SREG(x)	((x) |= __SREG)
#define UNSET_SREG(x)	(x) &= (__SREG ^ __MASK )

#define __SLNK		(0x1<<6)
#define IS_SLNK(x)	((x) & __SLNK)
#define SET_SLNK(x)	((x) |= __SLNK)
#define UNSET_SLNK(x)	(x) &= (__SLNK ^ __MASK )

#define __SSOCK		(0x1<<7)
#define IS_SSOCK(x)	((x) & __SSOCK)
#define SET_SSOCK(x)	((x) |= __SSOCK)
#define UNSET_SSOCK(x)	(x) &= (__SSOCK ^ __MASK )

/** higher level types **/

#define __MONITOR_TYPE		(0x1<<8)
#define IS_MONITOR_TYPE(x)	((x) & __MONITOR_TYPE)
#define SET_MONITOR_TYPE(x)	(x) |=  __MONITOR_TYPE
#define UNSET_MONITOR_TYPE(x)	(x) &= (__MONITOR_TYPE ^ __MASK )

#define __LOCAL_TYPE		(0x1<<9)
#define IS_LOCAL_TYPE(x)	((x) & __LOCAL_TYPE)
#define SET_LOCAL_TYPE(x)	(x) |=  __LOCAL_TYPE
#define UNSET_LOCAL_TYPE(x)	(x) &= (__LOCAL_TYPE ^ __MASK )

#define __DUMMY_TYPE		(0x1<<10)
#define IS_DUMMY_TYPE(x)	((x) & __DUMMY_TYPE)
#define SET_DUMMY_TYPE(x)	(x) |= __DUMMY_TYPE
#define UNSET_DUMMY_TYPE(x)	(x) &= (__DUMMY_TYPE ^ __MASK )

#define __ROOT_TYPE		(0x1<<11)
#define IS_ROOT_TYPE(x)		((x) & __ROOT_TYPE)
#define SET_ROOT_TYPE(x)	(x) |= __ROOT_TYPE
#define UNSET_ROOT_TYPE(x)	(x) &= (__ROOT_TYPE ^ __MASK )

#define __UP_TYPE		(0x1<<12)
#define IS_UP_TYPE(x)		((x) & __UP_TYPE)
#define SET_UP_TYPE(x)		(x) |= __UP_TYPE
#define UNSET_UP_TYPE(x)	(x) &= (__UP_TYPE ^ __MASK )

#define __PROC_TYPE		(0x1<<13)
#define IS_PROC_TYPE(x)		((x) & __PROC_TYPE)
#define SET_PROC_TYPE(x)	(x) |= __PROC_TYPE
#define UNSET_PROC_TYPE(x)	(x) &= (__PROC_TYPE ^ __MASK )

#define __CDFS_TYPE		(0x1<<14)
#define IS_CDFS_TYPE(x)		((x) & __CDFS_TYPE)
#define SET_CDFS_TYPE(x)	(x) |= __CDFS_TYPE
#define UNSET_CDFS_TYPE(x)	(x) &= (__CDFS_TYPE ^ __MASK )

#define __USER_TYPE		(0x1<<15)
#define IS_USER_TYPE(x)		((x) & __USER_TYPE)
#define SET_USER_TYPE(x)	(x) |= __USER_TYPE
#define UNSET_USER_TYPE(x)	(x) &= (__USER_TYPE ^ __MASK )

#define __NFS_TYPE		(0x1<<16)
#define IS_NFS_TYPE(x)		((x) & __NFS_TYPE)
#define SET_NFS_TYPE(x)		(x) |= __NFS_TYPE
#define UNSET_NFS_TYPE(x)	(x) &= (__NFS_TYPE ^ __MASK )

#define __SMB_TYPE		(0x1<<17)
#define IS_SMB_TYPE(x)		((x) & __SMB_TYPE)
#define SET_SMB_TYPE(x)		(x) |= __SMB_TYPE
#define UNSET_SMB_TYPE(x)	(x) &= (__SMB_TYPE ^ __MASK )

#define __FSTAB_TYPE		(0x1<<18)
#define IS_FSTAB_TYPE(x)	((x) & __FSTAB_TYPE)
#define SET_FSTAB_TYPE(x)	(x) |= __FSTAB_TYPE
#define UNSET_FSTAB_TYPE(x)	(x) &= (__FSTAB_TYPE ^ __MASK )

#define __MTAB_TYPE		(0x1<<19)
#define IS_MTAB_TYPE(x)		((x) & __MTAB_TYPE)
#define SET_MTAB_TYPE(x)	(x) |= __MTAB_TYPE
#define UNSET_MTAB_TYPE(x)	(x) &= (__MTAB_TYPE ^ __MASK )

#define __PARTITION_TYPE	(0x1<<20)
#define IS_PARTITION_TYPE(x)	((x) & __PARTITION_TYPE)
#define SET_PARTITION_TYPE(x)	(x) |= __PARTITION_TYPE
#define UNSET_PARTITION_TYPE(x)	(x) &= (__PARTITION_TYPE ^ __MASK )

#define __EXE_TYPE		(0x1<<21)
#define IS_EXE_TYPE(x)		((x) & __EXE_TYPE)
#define SET_EXE_TYPE(x)		(x) |= __EXE_TYPE
#define UNSET_EXE_TYPE(x)	(x) &= (__EXE_TYPE ^ __MASK )

#define __NOWRITE_TYPE		(0x1<<22)
#define IS_NOWRITE_TYPE(x)	((x) & __NOWRITE_TYPE)
#define SET_NOWRITE_TYPE(x)	(x) |= __NOWRITE_TYPE
#define UNSET_NOWRITE_TYPE(x)	(x) &= (__NOWRITE_TYPE ^ __MASK )

#define __NOACCESS_TYPE		(0x1<<23)
#define IS_NOACCESS_TYPE(x)	((x) & __NOACCESS_TYPE)
#define SET_NOACCESS_TYPE(x)	(x) |= __NOACCESS_TYPE
#define UNSET_NOACCESS_TYPE(x)	(x) &= (__NOACCESS_TYPE ^ __MASK )

#define __BROKEN_LNK		(0x1<<24)
#define IS_BROKEN_LNK(x)	((x) & __BROKEN_LNK)
#define SET_BROKEN_LNK(x)	(x) |= __BROKEN_LNK
#define UNSET_BROKEN_LNK(x)	(x) &= (__BROKEN_LNK ^ __MASK )

#define __MOUNTED_TYPE		(0x1<<25)
#define IS_MOUNTED_TYPE(x)	((x) & __MOUNTED_TYPE)
#define SET_MOUNTED_TYPE(x)	(x) |= __MOUNTED_TYPE
#define UNSET_MOUNTED_TYPE(x)	(x) &= (__MOUNTED_TYPE ^ __MASK )

#define __DOTDESKTOP		(0x1<<26)
#define IS_DOTDESKTOP(x)	((x) & __DOTDESKTOP)
#define SET_DOTDESKTOP(x)	(x) |= __DOTDESKTOP
#define UNSET_DOTDESKTOP(x)	(x) &= (__DOTDESKTOP ^ __MASK )

#define __PLUGIN_TYPE1		(0x1<<27)
#define IS_PLUGIN_TYPE1(x)	((x) & __PLUGIN_TYPE1)
#define SET_PLUGIN_TYPE1(x)	(x) |= __PLUGIN_TYPE1
#define UNSET_PLUGIN_TYPE1(x)	(x) &= (__PLUGIN_TYPE1 ^ __MASK )

#define __PLUGIN_TYPE2		(0x1<<28)
#define IS_PLUGIN_TYPE2(x)	((x) & __PLUGIN_TYPE2)
#define SET_PLUGIN_TYPE2(x)	(x) |= __PLUGIN_TYPE2
#define UNSET_PLUGIN_TYPE2(x)	(x) &= (__PLUGIN_TYPE2 ^ __MASK )

#define __PLUGIN_TYPE3		(0x1<<29)
#define IS_PLUGIN_TYPE3(x)	((x) & __PLUGIN_TYPE3)
#define SET_PLUGIN_TYPE3(x)	(x) |= __PLUGIN_TYPE3
#define UNSET_PLUGIN_TYPE3(x)	(x) &= (__PLUGIN_TYPE3 ^ __MASK )




/******************************************************/



// IS_FILE excludes directories and symlinks to directories
#define IS_FILE(x) \
( \
	!IS_SDIR(x) \
	     && \
	(  \
	   (x) | __SREG | __SCHR | __SBLK | __SFIFO | __SSOCK  \
	       || \
	   IS_BROKEN_LNK(x)  \
	)  \
)
#define SINGLE_CLICK_MODE \
    (!getenv("RFM_DOUBLE_CLICK_NAVIGATION") || \
       strlen(getenv("RFM_DOUBLE_CLICK_NAVIGATION"))==0)

/****  preferences flag (view and preferences) *****/
#define __SHOW_HIDDEN		__SHOWS_HIDDEN
#define __SHOW_IMAGES		__SHOWS_IMAGES 
// show images, and sort descending
#define DEFAULT_PREFERENCES    (__SHOW_IMAGES | __SHOWS_ASCENDING | __SHOWS_BACKUP)
//#define DEFAULT_PREFERENCES    (__SHOW_IMAGES)
#define DEFAULT_VIEW_PREFERENCES DEFAULT_PREFERENCES
#define DEFAULT_REMOTE_PREFERENCES (__SHOWS_ASCENDING)
#define DEFAULT_SORT_COLUMN (TYPE_SORT)
#define SORT_ASCENDING		__SHOWS_ASCENDING

#define BIT_MASK	0xffffffff

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    g_object_ref (widget), (GDestroyNotify) g_object_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

  
# define LOCK_DISPLAY XLockDisplay(gdk_x11_display_get_xdisplay(gdk_display_get_default()))

# define UNLOCK_DISPLAY XUnlockDisplay(gdk_x11_display_get_xdisplay(gdk_display_get_default()))


#endif /*__CONSTANTS__*/
