#ifndef PRIMARY_MISC_H
#define PRIMARY_MISC_H
#include <X11/Xlib.h>
// this split routine only allocates memory for gchar **, and populates
// it with pointers to the original locations, substituting the token
// for 0.

enum color_e {
    GREEN,
    RED,
    YELLOW,
    BLUE,
    MAGENTA,
    CYAN,
    WHITE,
    BLACK,
    BOLD,
    ITALIC
};
void rfm_set_box_gradient(GtkWidget *wbox);

GtkWidget *
rfm_create_checkmenuitem(const gchar *label, gboolean state);

GtkWidget *
rfm_create_radiomenuitem(const gchar *label, GSList *group);

GtkWidget *
rfm_dialog_button (const char *icon_id, const char *text);

GtkWidget *
rfm_toggle_button (const char *icon_id, const char *text);

void 
rfm_set_bin_markup(GtkWidget *bin, const char *text);

void
rfm_set_bin_image(GtkWidget *bin, const gchar *icon_id, gint size);


GtkWidget *
rfm_pathbar_button (const char *icon_id, const char *text);

void rfm_update_pathbar(GtkWidget *pathbar, const gchar *path);


gboolean rfm_tooltip_is_mapped(void);

void
rfm_reset_tooltip(GtkWidget * widget);

void 
rfm_add_custom_tooltip(GtkWidget *widget, GdkPixbuf *pixbuf, const gchar *text);

void
rfm_null_function (void *user_data);

void
rfm_markup_stdout_f (void *user_data, void *stream, int childFD);

void *
rfm_scroll(widgets_t *widgets_p, gboolean up, gboolean page);

void *
rfm_scroll_to_top(void *data);

record_entry_t *
rfm_find_in_selection_list(view_t *view_p, record_entry_t *population_en);

void
rfm_select_pixbuf (view_t * view_p, const population_t * population_p);

void
rfm_unselect_pixbuf (view_t * view_p, const population_t * population_p);


GtkWidget *
rfm_create_tooltip_window(GtkWidget *widget, GtkWidget *tooltip_window, const GdkPixbuf *pixbuf, const gchar *markup, const gchar *label_text);

const gchar *
rfm_lp_color(enum color_e color);

gint
rfm_dialog_run_response(GtkWidget *dialog);

void 
rfm_set_store_data_from_list(GtkListStore *list_store, GSList **list);

GtkWidget *
  rfm_mk_little_button (const gchar * icon_id, 
	  void *callback, void *callback_data, const gchar * tooltip_text);

gboolean 
rfm_threaded_get_visible(GtkWidget *widget);

gboolean 
rfm_get_visible(GtkWidget *widget);

void *
  rfm_hide_text (gpointer data);

void *
  rfm_show_text (gpointer data);

void *
  rfm_cursor_wait (gpointer data);

void *
  rfm_cursor_reset (gpointer data);

#define rfm_threaded_cursor_wait(X)  rfm_context_function(rfm_cursor_wait,X)
#define rfm_threaded_cursor_reset(X) rfm_context_function(rfm_cursor_reset,X)
#define rfm_threaded_show_text(X)    rfm_context_function(rfm_show_text,X)
#define rfm_threaded_hide_text(X)    rfm_context_function(rfm_hide_text,X)

GtkWidget *
  rfm_create_diagnostics_window (widgets_t * widgets_p);

gboolean 
  rfm_confirm (widgets_t * widgets_p, 
	// type: GTK_MESSAGE_INFO, GTK_MESSAGE_WARNING, GTK_MESSAGE_QUESTION, GTK_MESSAGE_ERROR, GTK_MESSAGE_OTHER
	gint type,
	const gchar * text, 
        const gchar * action_false, // if NULL, button not shown
	const gchar * action_true   // if NULL, "Ok" button shown
	);
void
rfm_clear_text (widgets_t * widgets_p);

void
  rfm_clear_text_window (GtkButton * button, gpointer user_data);

void
  rfm_update_status_line (view_t * view_p);

void
  rfm_clear_sh_command_history (view_t * view_p, gboolean disk_too);

gboolean 
rfm_diagnostics_is_visible (widgets_t * widgets_p);

gboolean 
rfm_threaded_diagnostics_is_visible(widgets_t *widgets_p);

void
rfm_threaded_status(widgets_t *widgets_p, 
	const gchar *icon, 
	gchar *string);

void
  rfm_status (widgets_t * widgets_p, const gchar * id, ... );

void
rfm_threaded_diagnostics(widgets_t *widgets_p, 
	const gchar *icon, 
	gchar *string);

void
  rfm_diagnostics (widgets_t * widgets_p, const gchar * id, ... );

void
  rfm_dump_output (void *user_data, void *stream, int childFD);

void
  rfm_operate_stdout (void *user_data, void *stream, int childFD);

void
  rfm_operate_stderr (void *user_data, void *stream, int childFD);

void
  rfm_progress_generic (widgets_t * widgets_p, int count, int total, int caso);


void
rfm_set_font_family (GtkWidget * widget, const gchar *in_family);

gboolean rfm_confirm_sudo(widgets_t *widgets_p,
       const gchar *tgt, 
       const gchar *failed, 
       const gchar *operation);

gchar *
rfm_get_response (widgets_t * widgets_p, const gchar * ptext, const gchar *default_value, gboolean hidden);

gchar *
rfm_diagnostics_start_string(gchar *command, pid_t controller, gboolean with_shell);

gchar *
rfm_diagnostics_start_string_argv(gchar **argv, pid_t controller);

gchar *
rfm_diagnostics_exit_string(gchar *tubo_string);


#endif
